<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package     mod_lanebs
 * @category    Client
 * @copyright   2024 Mazitov Artem
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

declare(strict_types=1);

namespace mod_lanebs\tests\Support\Client;

use advanced_testcase;
use mod_lanebs\Support\Client\BaseClientService;
use mod_lanebs\Support\Client\ClientLoggerInterface;

final class BaseClientService_test extends advanced_testcase
{
    protected string $url;

    protected ClientLoggerInterface $logger;

    protected function setUp(): void
    {
        if (!defined('TEST_MOD_LANEBS_BASE_CLIENT_SERVICE_URL')
            || !TEST_MOD_LANEBS_BASE_CLIENT_SERVICE_URL) {
            $this->markTestSkipped('TEST_MOD_LANEBS_BASE_CLIENT_SERVICE_URL is empty');
        }
        $this->url = (string)TEST_MOD_LANEBS_BASE_CLIENT_SERVICE_URL;

        $this->logger = new class implements ClientLoggerInterface {
            public function log($result, string $url, array $params = [], array $options = [], $info = []): void
            {
            }
        };

        parent::setUp();
    }

    public function test_get(): void
    {
        $service = new BaseClientService($this->logger);

        $assertParam = ['maz' => 'testTrue'];
        $assertHeadName = 'maz-header';
        $assertHeadValue = 'assert_true';
        $options = [
            'CURLOPT_HTTPHEADER' => [
                $assertHeadName . ':' . $assertHeadValue
            ]
        ];
        $result = $service->get($this->url, $assertParam, $options);
        $result = json_decode($result, true);

        $this->assertTrue(isset($result['_GET']));
        $this->assertEquals($assertParam, $result['_GET']);

        $this->assertTrue(isset($result['head'][$assertHeadName]));
        $this->assertEquals($assertHeadValue, $result['head'][$assertHeadName]);
    }

    public function test_post(): void
    {
        $service = new BaseClientService($this->logger);

        $assertParam = ['maz' => 'testTrue'];
        $assertHeadName = 'maz-header';
        $assertHeadValue = 'assert_true';
        $options = [
            'CURLOPT_HTTPHEADER' => [
                $assertHeadName . ':' . $assertHeadValue
            ]
        ];
        $result = $service->post($this->url, $assertParam, $options);
        $result = json_decode($result, true);

        $this->assertTrue(isset($result['_POST']));
        $this->assertEquals($assertParam, $result['_POST']);

        $this->assertTrue(isset($result['head'][$assertHeadName]));
        $this->assertEquals($assertHeadValue, $result['head'][$assertHeadName]);
    }

    public function test_setOptional(): void
    {
        $service = new BaseClientService($this->logger);
        $assertParam = ['maz' => 'testTrue'];
        $assertHeadName = 'maz-header';
        $assertHeadValue = 'assert_true';
        $options = [
            'CURLOPT_HTTPHEADER' => [
                $assertHeadName . ':' . $assertHeadValue
            ]
        ];
        $service->setOptional($options);

        $result = $service->get($this->url, $assertParam);
        $result = json_decode($result, true);

        $this->assertTrue(isset($result['head'][$assertHeadName]));
        $this->assertEquals($assertHeadValue, $result['head'][$assertHeadName]);
    }
}