<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package     mod_lanebs
 * @category    Support
 * @copyright   2024 Mazitov Artem
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

declare(strict_types=1);

namespace mod_lanebs\tests\Support;

use advanced_testcase;
use mod_lanebs\Support\Config;

final class Config_test extends advanced_testcase
{
    protected function setUp(): void
    {
        $this->resetAfterTest();
    }

    public function test_CRU_Config(): void
    {
        $name = 'test';
        $value = 'assert value';
        $value2 = 'assert value2';

        $test = Config::get('test');
        $this->assertEmpty($test);

        set_config($name, $value, 'mod_lanebs');
        $test = Config::get($name);
        $this->assertEquals($value, $test);

        Config::set($name, $value2);
        $test = Config::get($name);
        $this->assertEquals($value2, $test);
    }

    public function test_install(): void
    {
        Config::installConfig();
        foreach (Config::DEFAULT as $name => $value) {
            $test = Config::get($name);
            $this->assertEquals($value, $test);
        }
    }

    public function test_version(): void
    {
        $test = Config::version();
        $this->assertNotEmpty($test);
    }
}