<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Prints an instance of mod_lanebs.
 *
 * @package     mod_lanebs
 * @copyright   2020 Senin Yurii <katorsi@mail.ru>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require(__DIR__.'/../../config.php');
require_once(__DIR__.'/lib.php');
require_once(__DIR__ . '/locallib.php');

// Course_module ID, or
$id = optional_param('id', 0, PARAM_INT);

// ... module instance id.
$l  = optional_param('l', 0, PARAM_INT);

if ($id) {
    $cm             = get_coursemodule_from_id('lanebs', $id, 0, false, MUST_EXIST);
    $course         = $DB->get_record('course', array('id' => $cm->course), '*', MUST_EXIST);
    $moduleinstance = $DB->get_record('lanebs', array('id' => $cm->instance), '*', MUST_EXIST);
} else if ($l) {
    $moduleinstance = $DB->get_record('lanebs', array('id' => $l), '*', MUST_EXIST);
    $course         = $DB->get_record('course', array('id' => $moduleinstance->course), '*', MUST_EXIST);
    $cm             = get_coursemodule_from_instance('lanebs', $moduleinstance->id, $course->id, false, MUST_EXIST);
} else {
    throw new moodle_exception('missingidandcmid', 'mod_lanebs');
}

require_login($course, true, $cm);
$context = context_module::instance($cm->id);
require_capability('mod/page:view', $context);

$modulecontext = context_module::instance($cm->id);

$event = \mod_lanebs\event\course_module_viewed::create_from_lanebs($moduleinstance, $modulecontext);
$event->add_record_snapshot('course', $course);
$event->add_record_snapshot('lanebs', $moduleinstance);
$event->trigger();

$settings = get_config("lanebs");
if (isset($settings->token) && !empty($settings->token)) {
    $_SESSION['mod_lanebs_subscriberToken'] = $settings->token;
}
else if (isset($USER->profile['mod_lanebs_token']) && !empty($USER->profile['mod_lanebs_token'])) {
    $_SESSION['mod_lanebs_subscriberToken'] = $USER->profile['mod_lanebs_token'];
}

$PAGE->requires->js_call_amd('mod_lanebs/modal_search_handle', 'init');

$PAGE->requires->css('/mod/lanebs/css/modal_book.css');
$PAGE->requires->css('/mod/lanebs/css/lanebs_modal.css');

$PAGE->requires->js_call_amd('mod_lanebs/view_button', 'init', array('id' => $moduleinstance->content, 'page' => $moduleinstance->page_number, 'type' => $moduleinstance->type));

$PAGE->requires->js_call_amd('mod_lanebs/player_button', 'init');

$creator = get_course_creator($course->id);
if ($creator) {
    $PAGE->requires->js_call_amd('mod_lanebs/log', 'init', array(
            'type' => $moduleinstance->type,
            'resourceid' => $moduleinstance->content,
            'coursename' => $course->shortname,
            'email' => $creator->email,
            'fio' => fullname($creator),
            'trigger' => $USER->email,
            'course_date' => $creator->course_date
        )
    );
}

$PAGE->set_url('/mod/lanebs/view.php', array('id' => $cm->id));
$PAGE->set_title(format_string($moduleinstance->name));
$PAGE->set_heading(format_string($course->fullname));
$PAGE->set_context($modulecontext);

$videos = $moduleinstance->videos;
$videos = json_decode($videos);

echo $OUTPUT->header();

$moduleinstance->css_hidden = '';
if ($moduleinstance->type === 'video') {
    $moduleinstance->css_hidden = 'display:none!important';
}
$moduleinstance->cover = format_string($moduleinstance->cover);
$moduleinstance->cover_string = get_string('lanebs_cover', 'mod_lanebs');
$moduleinstance->read_string = get_string('lanebs_read', 'mod_lanebs');
$moduleinstance->page_number = format_string($moduleinstance->page_number);
$moduleinstance->page_number_string = get_string('lanebs_read_page', 'mod_lanebs');
$moduleinstance->content = format_string($moduleinstance->content);
$moduleinstance->type = format_string($moduleinstance->type);
$moduleinstance->name = format_string($moduleinstance->name);
$moduleinstance->intro = format_string($moduleinstance->intro);
$moduleinstance->biblio_record = format_string(str_replace($moduleinstance->name,'', $moduleinstance->biblio_record));

echo $OUTPUT->render_from_template('mod_lanebs/view_block', array('videos' => $videos, 'moduleinstance' => $moduleinstance));

echo $OUTPUT->footer();
