define("tiny_cloze/ui",["exports","core/modal_events","core/modal","core/modal_factory","core/mustache","core/str","./common","./options","./cloze"],(function(_exports,_modal_events,_modal2,_modal_factory,_mustache,_str,_common,_options,_cloze){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Plugin tiny_cloze for TinyMCE v6 in Moodle.
   *
   * @module      tiny_cloze/ui
   * @copyright   2023 MoodleDACH
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.resolveSubquestion=_exports.onSubmit=_exports.onInit=_exports.onBeforeGetContent=_exports.displayDialogueForEdit=_exports.displayDialogue=void 0,_modal_events=_interopRequireDefault(_modal_events),_modal2=_interopRequireDefault(_modal2),_modal_factory=_interopRequireDefault(_modal_factory),_mustache=_interopRequireDefault(_mustache);const STR={};let _editor=null,_form=null,_answerdata=[],_qtype=null,_selectedOffset=-1,_marks=1,_modal=null,_firstAnswer=null,_selectedPrefixAndSuffix=0;_exports.onInit=function(ed){_editor=ed,_addMarkers(),_getStr()};const _getRegexQtype=editor=>{const extQtypes=(0,_options.hasQtypeMultianswerrgx)(editor)?"|REGEXP(_C)?|RXC?":"";return new RegExp("\\{([0-9]*):(MULTICHOICE(_H|_V|_S|_HS|_VS)?|MULTIRESPONSE(_H|_S|_HS)?|NUMERICAL|SHORTANSWER(_C)?|SAC?|NM|MWC?|M[CR](V|H|VS|HS)?"+extQtypes+"):(.*?)(?<!\\\\)\\}","g")},_getStr=async()=>{let strToFetch=[{key:"answer",component:"question"},{key:"chooseqtypetoadd",component:"question"},{key:"defaultmark",component:"question"},{key:"feedback",component:"question"},{key:"correct",component:"question"},{key:"incorrect",component:"question"},{key:"addmoreanswerblanks",component:"qtype_calculated"},{key:"delete",component:"core"},{key:"up",component:"core"},{key:"down",component:"core"},{key:"tolerance",component:"qtype_calculated"},{key:"gradenoun",component:"core"},{key:"caseno",component:"mod_quiz"},{key:"caseyes",component:"mod_quiz"},{key:"answersingleno",component:"qtype_multichoice"},{key:"answersingleyes",component:"qtype_multichoice"},{key:"layoutselectinline",component:"qtype_multianswer"},{key:"layouthorizontal",component:"qtype_multianswer"},{key:"layoutvertical",component:"qtype_multianswer"},{key:"shufflewithin",component:"mod_quiz"},{key:"layoutmultiple_horizontal",component:"qtype_multianswer"},{key:"layoutmultiple_vertical",component:"qtype_multianswer"},{key:"pluginnamesummary",component:"qtype_multichoice"},{key:"pluginnamesummary",component:"qtype_shortanswer"},{key:"pluginnamesummary",component:"qtype_numerical"},{key:"multichoice",component:_common.component},{key:"multiresponse",component:_common.component},{key:"numerical",component:"mod_quiz"},{key:"shortanswer",component:"mod_quiz"},{key:"cancel",component:"core"},{key:"select",component:_common.component},{key:"insert",component:_common.component},{key:"pluginname",component:_common.component},{key:"customgrade",component:_common.component},{key:"err_custom_rate",component:_common.component},{key:"err_empty_answer",component:_common.component},{key:"err_none_correct",component:_common.component},{key:"err_not_numeric",component:_common.component},{key:"err_invalid_chars",component:_common.component},{key:"err_invalid_brackets",component:_common.component}],langKeys=["answer","chooseqtypetoadd","defaultmark","feedback","correct","incorrect","addmoreanswerblanks","delete","up","down","tolerance","grade","caseno","caseyes","singleno","singleyes","selectinline","horizontal","vertical","shuffle","multi_horizontal","multi_vertical","summary_multichoice","summary_shortanswer","summary_numerical","multichoice","multiresponse","numerical","shortanswer","btn_cancel","btn_select","btn_insert","title","custom_grade","err_custom_rate","err_empty_answer","err_none_correct","err_not_numeric","err_invalid_chars","err_invalid_brackets"];(0,_options.hasQtypeMultianswerrgx)(_editor)&&(strToFetch.push({key:"regexp",component:"qtype_regexp"}),strToFetch.push({key:"pluginnamesummary",component:"qtype_regexp"}),langKeys.push("regexp"),langKeys.push("summary_regexp")),(0,_str.get_strings)(strToFetch).then((function(){const args=Array.from(arguments);return langKeys.map(((l,i)=>((0,_cloze.setStr)(l,args[0][i]),STR[l]=args[0][i],""))),""})).catch((()=>""))},_createModal=async function(){const cfg={title:STR.title,templateContext:{elementid:_editor.id},removeOnClose:!0,large:!0};_modal="function"==typeof _modal2.default.create?await _modal2.default.create(cfg):await _modal_factory.default.create(cfg)};_exports.displayDialogue=async function(){await _createModal();const subquestion=resolveSubquestion();subquestion?(_firstAnswer=null,_selectedOffset=(0,_cloze.indexOfNode)(_editor.dom.select("."+_cloze.markerClass),subquestion),_parseSubquestion(subquestion.innerHTML),_setDialogueContent(_qtype)):(_selectedOffset=-1,_firstAnswer=_editor.selection.getContent(),_selectedPrefixAndSuffix=0," "===_firstAnswer[0]&&(_selectedPrefixAndSuffix=1)," "===_firstAnswer[_firstAnswer.length-1]&&(_selectedPrefixAndSuffix+=2),_firstAnswer=_firstAnswer.trim(),_setDialogueContent())};_exports.displayDialogueForEdit=async function(target){const subquestion=resolveSubquestion(target);subquestion&&(await _createModal(),_selectedOffset=(0,_cloze.indexOfNode)(_editor.dom.select("."+_cloze.markerClass),subquestion),_parseSubquestion(subquestion.innerHTML),_setDialogueContent(_qtype))};const _addMarkers=function(){let m,content=_editor.getContent(),newContent="";if(-1===content.indexOf(_cloze.markerClass)){do{if(m=content.match(_getRegexQtype(_editor)),!m){newContent+=content;break}const pos=content.indexOf(m[0]);newContent+=content.substring(0,pos)+_cloze.markerSpan+content.substring(pos,pos+m[0].length),content=content.substring(pos+m[0].length);let level=(m[0].match(/\{/g)||[]).length;if(1!==level){for(;level>1;){const a=content.indexOf("{"),b=content.indexOf("}");a>-1&&b>-1&&a<b?(level++,newContent=content.substring(0,a),content=content.substring(a+1)):b>-1?(newContent=content.substring(0,b),content=content.substring(b+1),level--):level=1}newContent+="</span>"}else newContent+="</span>"}while(m);_editor.setContent(newContent)}},_removeMarkers=function(){for(const span of _editor.dom.select("span."+_cloze.markerClass))_editor.dom.setOuterHTML(span,span.classList.contains("new")?"":span.innerHTML)};_exports.onBeforeGetContent=function(content){if(!(0,_cloze.isNull)(content.source_view)&&!0===content.source_view){var onClose=function(){_editor.off("close",onClose),_addMarkers()};_editor.on("CloseWindow",(()=>{onClose()})),_modal||_removeMarkers()}};_exports.onSubmit=function(){_removeMarkers()};const _setDialogueContent=function(qtype,nomodalevents){const footer=_mustache.default.render(_cloze.TEMPLATE.FOOTER,{cancel:STR.btn_cancel,submit:qtype?STR.btn_insert:STR.btn_select});let contentText;contentText=qtype?_mustache.default.render(_cloze.TEMPLATE.FORM,{CSS:_cloze.CSS,STR:STR,SRC:{ADD:M.util.image_url("t/add","core"),DEL:M.util.image_url("t/delete","core"),UP:M.util.image_url("t/up","core"),DOWN:M.util.image_url("t/down","core")},answerdata:_answerdata,elementid:(0,_cloze.getUuid)(),qtype:_qtype,name:(0,_cloze.getQuestionTypes)((0,_options.hasQtypeMultianswerrgx)(_editor)).filter((q=>_qtype===q.type))[0].name,marks:_marks,numerical:"NUMERICAL"===_qtype||"NM"===_qtype}):_mustache.default.render(_cloze.TEMPLATE.TYPE,{CSS:_cloze.CSS,STR:STR,qtype:_qtype,types:(0,_cloze.getQuestionTypes)((0,_options.hasQtypeMultianswerrgx)(_editor))}),_modal.setBody(contentText),_modal.setFooter(footer),_modal.show();const $root=_modal.getRoot();if(_form=$root.get(0).querySelector("form"),_toggleDeleteIcon(),!nomodalevents){if(_modal.registerEventListeners(),_modal.registerCloseOnSave(),_modal.registerCloseOnCancel(),$root.on(_modal_events.default.cancel,_cancel),!qtype)return void $root.on(_modal_events.default.save,_choiceHandler);$root.on(_modal_events.default.save,_setSubquestion)}const getTarget=e=>{let p=e.target;for(;!(0,_cloze.isNull)(p)&&1===p.nodeType&&"A"!==p.tagName;)p=p.parentNode;return(0,_cloze.isNull)(p.classList)?null:p};_form.addEventListener("click",(e=>{const p=getTarget(e);if(!(0,_cloze.isNull)(p))return p.classList.contains(_cloze.CSS.DELETE)?(e.preventDefault(),void _deleteAnswer(p)):p.classList.contains(_cloze.CSS.ADD)?(e.preventDefault(),void _addAnswer(p)):p.classList.contains(_cloze.CSS.LOWER)?(e.preventDefault(),void _lowerAnswer(p)):void(p.classList.contains(_cloze.CSS.RAISE)&&(e.preventDefault(),_raiseAnswer(p)))})),_form.addEventListener("keyup",(e=>{const p=getTarget(e);(0,_cloze.isNull)(p)||(p.classList.contains(_cloze.CSS.ANSWER)||p.classList.contains(_cloze.CSS.FEEDBACK))&&(e.preventDefault(),_addAnswer(p))})),_form.querySelectorAll("."+_cloze.CSS.FRACTION).forEach((sel=>{sel.addEventListener("change",(e=>{const id=e.target.getAttribute("id");e.target.value===_cloze.selectCustomPercent?document.getElementById(id+"_custom").parentNode.classList.remove("hidden"):document.getElementById(id+"_custom").parentNode.classList.add("hidden")}))}))},_toggleDeleteIcon=function(){const deleteIcons=_form.querySelectorAll("."+_cloze.CSS.DELETE);if(1!==deleteIcons.length)for(let i=0;i<deleteIcons.length;i++)deleteIcons[i].classList.remove("hidden");else deleteIcons[0].classList.add("hidden")},_choiceHandler=function(e){e.preventDefault();let qtype=_form.querySelector("input[name=qtype]:checked");qtype&&(_qtype=qtype.value);const max=-1!==_qtype.indexOf("SHORTANSWER")||"NUMERICAL"===_qtype||-1!==_qtype.indexOf("REGEXP")?1:3,blankAnswer={id:(0,_cloze.getUuid)(),answer:"",feedback:"",fraction:100,fractionOptions:(0,_cloze.getFractionOptions)(""),tolerance:0,isCustomGrade:!1};_answerdata=[];for(let x=0;x<max;x++)_answerdata.push({...blankAnswer,id:(0,_cloze.getUuid)()});_answerdata[0].fractionOptions=(0,_cloze.getFractionOptions)("="),_firstAnswer&&(_answerdata[0].answer=_firstAnswer),_modal.destroy(),_createModal().then((()=>(_setDialogueContent(_qtype),_form.querySelector("."+_cloze.CSS.ANSWER).focus(),""))).catch((()=>""))},_parseSubquestion=function(question){_answerdata=[];const regexQtype=_getRegexQtype(_editor),parts=regexQtype.exec(question);if(regexQtype.lastIndex=0,!parts)return;_marks=parts[1],_qtype=parts[2],_qtype.length<5&&(0,_cloze.getQuestionTypes)((0,_options.hasQtypeMultianswerrgx)(_editor)).forEach((l=>{for(const a of l.abbr)if(a===_qtype)return void(_qtype=l.type)}));const answers=parts[(0,_options.hasQtypeMultianswerrgx)(_editor)?8:7].match(/(\\.|[^~])*/g);answers&&answers.forEach((function(answer){const options=/^(%(-?[.0-9]+)%|(=?))((\\.|[^#])*)#?(.*)/.exec(answer);if(options&&options[4]){let frac="";if(options[3]?frac="="===options[3]?"=":100:options[2]&&(frac=options[2]),"NUMERICAL"===_qtype||"NM"===_qtype){const tolerance=/^([^:]*):?(.*)/.exec(options[4])[2]||0;return void _answerdata.push({id:(0,_cloze.getUuid)(),answer:(0,_cloze.strdecode)(options[4].replace(/:.*/,"")),feedback:(0,_cloze.strdecode)(options[6]),tolerance:tolerance,fraction:frac,fractionOptions:(0,_cloze.getFractionOptions)(frac),isCustomGrade:(0,_cloze.isCustomGrade)(frac)})}_answerdata.push({answer:(0,_cloze.strdecode)(options[4]),id:(0,_cloze.getUuid)(),feedback:(0,_cloze.strdecode)(options[6]),fraction:frac,fractionOptions:(0,_cloze.getFractionOptions)(frac),isCustomGrade:(0,_cloze.isCustomGrade)(frac)})}}))},_addAnswer=function(a){let index=(0,_cloze.indexOfNode)(_form.querySelectorAll("."+_cloze.CSS.ADD),a);-1===index&&(index=0);let fraction="",answer="",feedback="",tolerance=0;a.closest("li")&&(fraction=a.closest("li").querySelector("."+_cloze.CSS.FRACTION).value,fraction===_cloze.selectCustomPercent&&(fraction=a.closest("li").querySelector("."+_cloze.CSS.FRAC_CUSTOM).value),answer=a.closest("li").querySelector("."+_cloze.CSS.ANSWER).value,feedback=a.closest("li").querySelector("."+_cloze.CSS.FEEDBACK).value,a.closest("li").querySelector("."+_cloze.CSS.TOLERANCE)&&(tolerance=a.closest("li").querySelector("."+_cloze.CSS.TOLERANCE).value)),_processFormData(),_answerdata.splice(index,0,{id:(0,_cloze.getUuid)(),answer:answer,feedback:feedback,fraction:fraction,fractionOptions:(0,_cloze.getFractionOptions)(fraction),tolerance:tolerance,isCustomGrade:(0,_cloze.isCustomGrade)(fraction)}),_setDialogueContent(_qtype,!0),_toggleDeleteIcon(),_form.querySelectorAll("."+_cloze.CSS.ANSWER).item(index).focus()},_deleteAnswer=function(a){let index=(0,_cloze.indexOfNode)(_form.querySelectorAll("."+_cloze.CSS.DELETE),a);-1===index&&(index=(0,_cloze.indexOfNode)(_form.querySelectorAll("li"),a.closest("li"))),_processFormData(),_answerdata.splice(index,1),_setDialogueContent(_qtype,!0);const answers=_form.querySelectorAll("."+_cloze.CSS.ANSWER);index=Math.min(index,answers.length-1),answers.item(index).focus(),_toggleDeleteIcon()},_lowerAnswer=function(a){const li=a.closest("li");li.before(li.nextSibling),li.querySelector("."+_cloze.CSS.ANSWER).focus()},_raiseAnswer=function(a){const li=a.closest("li");li.after(li.previousSibling),li.querySelector("."+_cloze.CSS.ANSWER).focus()},_cancel=function(e){e.preventDefault();for(const span of _editor.dom.select("."+_cloze.markerClass+".new"))span.remove();_modal.destroy(),_editor.focus(),_modal=null},_setSubquestion=function(e){e.preventDefault();const errMsg=_form.querySelector(".msg-error"),formErrors=_processFormData(!0);if(formErrors.length>0)return errMsg.innerHTML="<ul><li>"+formErrors.join("</li><li>")+"</li></ul>",void errMsg.classList.remove("hidden");errMsg.classList.add("hidden");let question="{"+_marks+":"+_qtype+":";for(let i=0;i<_answerdata.length;i++)""!==_answerdata[i].raw&&(question+=_answerdata[i].fraction&&!isNaN(_answerdata[i].fraction)?"%"+_answerdata[i].fraction+"%":_answerdata[i].fraction,question+=(0,_cloze.strencode)(_answerdata[i].answer),"NM"!==_qtype&&"NUMERICAL"!==_qtype||(question+=":"+_answerdata[i].tolerance),_answerdata[i].feedback&&(question+="#"+(0,_cloze.strencode)(_answerdata[i].feedback)),i<_answerdata.length-1&&(question+="~"));"~"===question.slice(-1)&&(question=question.substring(0,question.length-1)),question+="}",1&_selectedPrefixAndSuffix&&(question=" "+question),2&_selectedPrefixAndSuffix&&(question+=" "),_modal.destroy(),_modal=null,_editor.focus(),_selectedOffset>-1?_editor.dom.select("."+_cloze.markerClass)[_selectedOffset].innerHTML=question:_editor.insertContent(_cloze.markerSpan+question+"</span>")},_processFormData=function(validate){_answerdata=[];let globalErrors=[];const answers=_form.querySelectorAll("."+_cloze.CSS.ANSWER),feedbacks=_form.querySelectorAll("."+_cloze.CSS.FEEDBACK),fractions=_form.querySelectorAll("."+_cloze.CSS.FRACTION),customGrades=_form.querySelectorAll("."+_cloze.CSS.FRAC_CUSTOM),tolerances=_form.querySelectorAll("."+_cloze.CSS.TOLERANCE);for(let i=0;i<answers.length;i++){answers.item(i).classList.remove("error"),customGrades.item(i).classList.remove("error");const currentAnswer={raw:answers.item(i).value.trim(),answer:answers.item(i).value.trim(),id:(0,_cloze.getUuid)(),feedback:feedbacks.item(i).value,fraction:fractions.item(i).value===_cloze.selectCustomPercent?customGrades.item(i).value:fractions.item(i).value,fractionOptions:(0,_cloze.getFractionOptions)(fractions.item(i).value),tolerance:tolerances.length>0?tolerances.item(i).value:0,isCustomGrade:fractions.item(i).value===_cloze.selectCustomPercent};"NM"!==_qtype&&"NUMERICAL"!==_qtype||(tolerances.item(i).classList.remove("error"),currentAnswer.answer=Number(currentAnswer.answer),currentAnswer.tolerance=Number(currentAnswer.tolerance)),_answerdata.push(currentAnswer)}if(_marks=_form.querySelector("."+_cloze.CSS.MARKS).value,validate){const{hasCorrectAnswer:hasCorrectAnswer,errors:errors}=_validateAnswers();for(let i=0;i<_answerdata.length;i++)for(const err of _answerdata[i].hasErrors){if(hasCorrectAnswer&&("empty_answer"===err||"correct_but_empty"===err))break;"answer_not_numeric"===err||"empty_answer"===err||"correct_but_empty"===err||"answer_invalid_chars"===err||"answer_odd_bracket_count"===err?answers.item(i).classList.add("error"):"tolerance_not_numeric"===err?tolerances.item(i).classList.add("error"):"error_custom_rate"===err&&customGrades.item(i).classList.add("error")}globalErrors=_translateGlobalErrors(hasCorrectAnswer,errors),globalErrors.length>0&&_form.querySelector("input.error").focus()}return globalErrors},_validateAnswers=function(){let errors=[],hasCorrect=!1;for(let i=0;i<_answerdata.length;i++)_answerdata[i].hasErrors=[],""===_answerdata[i].raw&&_answerdata[i].hasErrors.push("empty_answer"),"100"!==_answerdata[i].fraction&&"="!==_answerdata[i].fraction||(""!==_answerdata[i].raw?(_answerdata[i].isCorrect=!0,hasCorrect=!0):_answerdata[i].hasErrors.push("correct_but_empty")),_answerdata[i].isCustomGrade&&(isNaN(_answerdata[i].fraction)||_answerdata[i].fraction<-100||_answerdata[i].fraction>100||""===_answerdata[i].fraction.trim())&&_answerdata[i].hasErrors.push("error_custom_rate"),"NM"!==_qtype&&"NUMERICAL"!==_qtype||_validateAnswersNumeric(i),"REGEXP"!==_qtype&&"REGEXP_C"!==_qtype||_validateAnswersRegexp(i),errors=errors.concat(_answerdata[i].hasErrors);return{hasCorrectAnswer:hasCorrect,errors:_combineGlobalErrors(hasCorrect,errors)}},_validateAnswersNumeric=function(i){isNaN(_answerdata[i].answer)&&""!==_answerdata[i].raw&&_answerdata[i].hasErrors.push("answer_not_numeric"),isNaN(_answerdata[i].tolerance)&&_answerdata[i].hasErrors.push("tolerance_not_numeric")},_validateAnswersRegexp=function(i){(_answerdata[i].isCorrect||_answerdata[i].isCustomGrade&&_answerdata[i].fraction>0)&&(0,_cloze.hasInvalidChars)(_answerdata[i].raw)&&_answerdata[i].hasErrors.push("answer_invalid_chars"),(0,_cloze.hasOddBracketCount)(_answerdata[i].raw)&&_answerdata[i].hasErrors.push("answer_odd_bracket_count")},_translateGlobalErrors=function(hasCorrectAnswer,errors){const errTranslated=[],trMsg={emptyanswer:STR.err_empty_answer,answernotnumeric:STR.err_not_numeric,tolerancenotnumeric:STR.err_not_numeric,errorcustomrate:STR.err_custom_rate,nonecorrect:STR.err_none_correct,answerinvalidchars:STR.err_invalid_chars,answeroddbracketcount:STR.err_invalid_brackets};for(const err of errors){if(hasCorrectAnswer&&"empty_answer"===err||"correct_but_empty"===err)continue;const key=err.replace(/_/g,"");errTranslated.push(trMsg[key])}return errTranslated},_combineGlobalErrors=function(hasCorrectAnswer,errors){const errUnique=errors.filter(((value,index,array)=>array.indexOf(value)===index));if(hasCorrectAnswer){const i=errUnique.indexOf("empty_answer");i>-1&&errUnique.splice(i,1)}else errUnique.includes("correct_but_empty")||errUnique.push("none_correct");return errUnique},resolveSubquestion=function(element){let span=element||_editor.selection.getStart();return!(0,_cloze.isNull)(span.classList)&&span.classList.contains(_cloze.markerClass)?span:(_editor.dom.getParents(span,(elm=>!((0,_cloze.isNull)(elm.classList)||!elm.classList.contains(_cloze.markerClass))&&elm)),!1)};_exports.resolveSubquestion=resolveSubquestion}));

//# sourceMappingURL=ui.min.js.map