<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Upgrade code for the feedback_helixfeedback
 *
 * @package   assignfeedback_helixfeedback
 * @copyright 2014 Streaming LTD http://www.streaming.co.uk
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @author    Tim Williams (tmw@autotrain.org) for Streaming LTD
 */

/**
 * Stub for upgrade code
 * @param int $oldversion
 * @return bool
 */
function xmldb_assignfeedback_helixfeedback_upgrade($oldversion) {
    global $DB;

    if ($oldversion < 2025021701) {
        // Define field custom to be added to assignfeedback_helixfeedback.
        $table = new xmldb_table('assignfeedback_helixfeedback');
        $field = new xmldb_field('custom', XMLDB_TYPE_TEXT, null, null, null, null, null, 'servicesalt');

        $dbman = $DB->get_manager();
        // Conditionally launch add field custom.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Helixfeedback savepoint reached.
        upgrade_plugin_savepoint(true, 2025021701, 'assignfeedback', 'helixfeedback');
    }
    return true;
}
