<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This file contains helixmedia mobile config
 *
 * @package    assignsubmission_helixassign
 * @subpackage assign/helixassign
 * @author     Tim Williams (For Streaming LTD)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @copyright  MEDIAL
 */

defined('MOODLE_INTERNAL') || die();

$addons = [
    'assignsubmission_helixassign' => [
        'handlers' => [
            'courseassignsubmission_helixmedia' => [
                'displaydata' => [
                    'title' => 'helixmedia submission',
                    'icon' => $CFG->wwwroot . '/mod/helixmedia/pix/icon.png',
                    'class' => '',
                ],
                'delegate' => 'AddonModAssignSubmissionDelegate',
                'method' => 'mobile_get_helixmedia',
                'styles' => [
                    'url' => 'mod/assign/submission/helixassign/mobile/styles_app.css',
                    'version' => '1.02',
                ],
            ],
        ],
        'lang' => [
            ['pluginname', 'assignsubmission_helixassign'],
            ['mobilesub', 'assignsubmission_helixassign'],
            ['mobilelink', 'assignsubmission_helixassign'],
        ],
    ],
];
