/*
 * Control the element in comment area.
 *
 * @module    mod_studentquiz/comment_area
 * @copyright 2020 The Open University
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_studentquiz/comment_area",["jquery","core/str","core/ajax","core/modal_factory","core/templates","core/fragment","core/modal_events","tiny_autosave/repository"],(function($,str,ajax,ModalFactory,Templates,fragment,ModalEvents,TinyRepository){var t={EMPTY_CONTENT:["<br><p><br></p>","<p><br></p>","<br>",""],ROOT_COMMENT_VALUE:0,GET_ALL_VALUE:0,TEMPLATE_COMMENTS:"mod_studentquiz/comments",TEMPLATE_COMMENT:"mod_studentquiz/comment",ACTION_CREATE:"mod_studentquiz_create_comment",ACTION_CREATE_REPLY:"mod_studentquiz_create_reply",ACTION_GET_ALL:"mod_studentquiz_get_comments",ACTION_EXPAND:"mod_studentquiz_expand_comment",ACTION_DELETE:"mod_studentquiz_delete_comment",ACTION_EDIT:"mod_studentquiz_edit_comment",ACTION_LOAD_FRAGMENT_FORM:"mod_studentquiz_load_fragment_form",ACTION_LOAD_FRAGMENT_EDIT_FORM:"mod_studentquiz_load_fragment_edit_form",ACTION_EXPAND_ALL:"action_expand_all",ACTION_COLLAPSE_ALL:"action_collapse_all",ACTION_RENDER_COMMENT:"action_render_comment",ACTION_APPEND_COMMENT:"action_append_comment",ACTION_EDITOR_INIT:"action_editor_init",ACTION_INIT:"action_init",ACTION_UPDATE_COMMENT_COUNT:"action_update_comment_count",ACTION_CLEAR_FORM:"action_clear_form",ACTION_SHOW_ERROR:"action_show_error",FRAGMENT_FORM_CALLBACK:"commentform",FRAGMENT_EDIT_FORM_CALLBACK:"commenteditform",HAS_COMMENT_CLASS:"has-comment",ATTO_CONTENT_TYPE:{HAS_CONTENT:"has-content",NO_CONTENT:"no-content"},SELECTOR:{CONTAINER:".studentquiz-comment-container",EXPAND_ALL:".studentquiz-comment-expand",COLLAPSE_ALL:".studentquiz-comment-collapse",SUBMIT_BUTTON:"#id_submitbutton",CONTAINER_REPLIES:".studentquiz-container-replies",COMMENT_REPLIES_CONTAINER:".studentquiz-comment-replies",COMMENT_COUNT:".studentquiz-comment-postcount",COMMENT_TEXT_CONTAINER:".studentquiz-comment-text",COMMENT_TEXT:".studentquiz-comment-text-inside",COMMENT_HISTORY:".studentquiz-comment-history",COMMENT_REPLIES_TEXT:".studentquiz-comment-replies .studentquiz-comment-text .studentquiz-comment-text-inside",LOADING_ICON:".studentquiz-comment-loading",COMMENT_AREA_FORM:"div.comment-area-form",FORM_SELECTOR:".studentquiz-comment-postform > div.comment-area-form",NO_COMMENT:".no-comment",COLLAPSE_LINK:".studentquiz-comment-collapselink",EXPAND_LINK:".studentquiz-comment-expandlink",COMMENT_ITEM:".studentquiz-comment-item",COMMENT_REPLIES_CONTAINER_TO_ITEM:".studentquiz-comment-replies .studentquiz-comment-item",FRAGMENT_FORM:".studentquiz-comment-postfragmentform",BTN_DELETE:".studentquiz-comment-btndelete",BTN_REPLY:".studentquiz-comment-btnreply",BTN_DELETE_REPLY:".studentquiz-comment-btndeletereply",ATTO_EDITOR_WRAP:".editor_atto_wrap",TEXTAREA:'textarea[id^="id_editor_question_"]',COMMENT_COUNT_NUMBER:".studentquiz-comment-count-number",COMMENT_COUNT_TEXT:".studentquiz-comment-count-text",ATTO:{CONTENT_WRAP:".editor_atto_content_wrap",CONTENT:".editor_atto_content",TOOLBAR:".editor_atto_toolbar"},TINYMCE:{CONTENT:".tox-edit-area"},COMMENT_ID:"#comment_",SPAN_COMMENT_ID:"#c",TOTAL_REPLY:".studentquiz-comment-totalreply",COMMENT_FILTER:".studentquiz-comment-filter",COMMENT_FILTER_HIDE:".hide-comment-filter",COMMENT_ERROR:".studentquiz-comment-container .comment-error",BTN_REPORT:".studentquiz-comment-btnreport",COMMENT_FILTER_ITEM:".studentquiz-comment-filter-item",COMMENT_FILTER_NAME:".studentquiz-comment-filter-name",COMMENT_FILTER_TYPE:".studentquiz-comment-filter-type",BTN_EDIT:".studentquiz-comment-btnedit",BTN_EDIT_REPLY:".studentquiz-comment-btneditreply",ATTO_HTML_BUTTON:"button.atto_html_button",POST_FOOTER:".studentquiz-comment-postfooter"},EDITOR:{ATTO:{TYPE:"atto"},TINYMCE:{TYPE:"tiny"},TEXTAREA:{TYPE:"textarea"}},get:function(){return{elementSelector:null,btnExpandAll:null,btnCollapseAll:null,addComment:null,containerSelector:null,studentQuizQuestionId:null,dialogue:null,loadingIcon:null,lastFocusElement:null,formSelector:null,contextId:null,userId:null,string:{},deleteDialog:null,deleteTarget:null,numberToShow:5,cmId:null,countServerData:[],lastCurrentCount:0,lastTotal:0,expand:!1,forceCommenting:!1,canViewDeleted:!1,hasComment:!1,referer:null,highlight:0,sortFeature:null,sortable:[],workingState:!1,isNoComment:!1,type:0,init:function(params){M.util.js_pending(t.ACTION_INIT);this.elementSelector=$("#"+$.escapeSelector(params.id));var el=this.elementSelector;this.btnExpandAll=el.find(t.SELECTOR.EXPAND_ALL),this.btnCollapseAll=el.find(t.SELECTOR.COLLAPSE_ALL),this.addComment=el.find(t.SELECTOR.SUBMIT_BUTTON),this.containerSelector=el.find(t.SELECTOR.CONTAINER_REPLIES),this.loadingIcon=el.find(t.SELECTOR.LOADING_ICON),this.formSelector=el.find(t.SELECTOR.FORM_SELECTOR),this.studentQuizQuestionId=parseInt(el.data("studentquizquestionid")),this.contextId=parseInt(el.data("contextid")),this.userId=parseInt(el.data("userid")),this.numberToShow=parseInt(el.data("numbertoshow")),this.cmId=parseInt(el.data("cmid")),this.countServerData={count:params.count,total:params.total},this.expand=params.expand||!1,this.referer=el.data("referer"),this.sortFeature=params.sortfeature,this.sortable=el.data("sortable"),this.type=params.type,this.string=el.data("strings"),this.forceCommenting=params.forcecommenting,this.canViewDeleted=params.canviewdeleted,this.isNoComment=params.isnocomment,this.allowSelfCommentRating=params.allowselfcommentrating,this.isusingtinymce=params.isusingtinymce,this.initServerRender(),params.allowselfcommentrating&&this.initBindEditor(),this.bindEvents(),M.util.js_complete(t.ACTION_INIT)},initServerRender:function(){var self=this;self.changeWorkingState(!0),self.elementSelector.find(t.SELECTOR.COMMENT_ITEM).each((function(){var id=$(this).data("id"),attrs=$(this).find(t.SELECTOR.SPAN_COMMENT_ID+id),replies=[];self.expand&&(replies=attrs.data("replies")||[]);var comment={id:$(this).data("id"),deleted:attrs.data("deleted"),numberofreply:attrs.data("numberofreply"),expanded:self.expand,replies:replies,root:!0,type:self.type};self.bindCommentEvent(comment)}));var commentcount=self.expand?self.countServerData.total:self.countServerData.count.commentcount;self.updateCommentCount(commentcount,self.countServerData.total),self.expand?(self.btnExpandAll.hide(),self.btnCollapseAll.show()):(self.btnExpandAll.show(),self.btnCollapseAll.hide());var query=window.location.search.substring(1),getParams=self.parseQueryString(query);if(self.highlight=parseInt(getParams.highlight)||0,0!==self.highlight){var target=$(t.SELECTOR.COMMENT_ID+self.highlight);target.length&&self.scrollToElement(target)}self.changeWorkingState(!1)},initBindEditor:function(){var self=this,isEditorLoaded=!1;M.util.js_pending(t.ACTION_EDITOR_INIT);var interval=setInterval((function(){var _window,_window$tinyMCE,_self$formSelector$fi,_self$formSelector,_self$formSelector$fi2,editor=self.isusingtinymce?null===(_window=window)||void 0===_window||null===(_window$tinyMCE=_window.tinyMCE)||void 0===_window$tinyMCE?void 0:_window$tinyMCE.get(null!==(_self$formSelector$fi=null===(_self$formSelector=self.formSelector)||void 0===_self$formSelector||null===(_self$formSelector$fi2=_self$formSelector.find(t.SELECTOR.TEXTAREA))||void 0===_self$formSelector$fi2?void 0:_self$formSelector$fi2.attr("id"))&&void 0!==_self$formSelector$fi?_self$formSelector$fi:""):null;(!self.isusingtinymce||editor&&null!=editor&&editor.getBody())&&(self.bindEditorEvent(self.formSelector),isEditorLoaded=!0,clearInterval(interval),M.util.js_complete(t.ACTION_EDITOR_INIT))}),500),editorWaiting=setInterval((function(){if(isEditorLoaded){if(self.isusingtinymce){const tinyEditorId=self.formSelector.find(t.SELECTOR.TEXTAREA).attr("id"),editor=window.tinyMCE.get(tinyEditorId);self.checkEditorContent(self.formSelector,editor.getBody(),t.EDITOR.TINYMCE.TYPE)}else self.checkEditorContent(self.formSelector);clearInterval(editorWaiting)}}),1e3)},bindEvents:function(){var self=this;self.btnExpandAll.click((function(e){e.preventDefault(),M.util.js_pending(t.ACTION_EXPAND_ALL),self.changeWorkingState(!0),self.containerSelector.empty(),self.btnExpandAll.hide(),self.btnCollapseAll.show(),self.loadingIcon.show(),self.getComments(t.GET_ALL_VALUE).then((function(response){var total=self.countCommentAndReplies(response.data).total;return self.updateCommentCount(total,response.total),self.renderComment(response.data,!0),M.util.js_complete(t.ACTION_EXPAND_ALL),!0})).fail((function(err){return M.util.js_complete(t.ACTION_EXPAND_ALL),self.showError(err.message),!1}))})),self.btnCollapseAll.click((function(e){e.preventDefault(),M.util.js_pending(t.ACTION_COLLAPSE_ALL),self.changeWorkingState(!0),self.loadingIcon.show(),self.btnCollapseAll.hide(),self.btnExpandAll.show(),self.containerSelector[0].innerHTML="",self.getComments(self.numberToShow).then((function(response){var count=self.countCommentAndReplies(response.data),commentCount=count.commentCount,deletedComments=count.totalDelete;return 0!==commentCount||0!==deletedComments?(self.btnExpandAll.show(),self.updateCommentCount(commentCount,response.total),self.renderComment(response.data,!1)):(self.loadingIcon.hide(),self.changeWorkingState(!1),self.updateCommentCount(0,0)),M.util.js_complete(t.ACTION_COLLAPSE_ALL),!0})).fail((function(err){return M.util.js_complete(t.ACTION_COLLAPSE_ALL),self.showError(err.message),!1}))})),self.addComment.click((function(e){e.preventDefault(),M.util.js_pending(t.ACTION_CREATE),self.changeWorkingState(!0),self.loadingIcon.show(),$(t.SELECTOR.COMMENT_ERROR).addClass("hide"),$(t.SELECTOR.NO_COMMENT).hide();var rootId=t.ROOT_COMMENT_VALUE,unique=self.studentQuizQuestionId+"_"+self.type+"_"+rootId,formSelector=self.formSelector,formData=self.convertFormToJson(formSelector);if(0===formData["message[text]"].length){var attoWrap=formSelector.find(t.SELECTOR.ATTO_EDITOR_WRAP);return 0===attoWrap.length||attoWrap.hasClass("error")||(attoWrap.addClass("error"),attoWrap.prepend('<span class="error" tabindex="0">'+self.string.required+"</span>")),M.util.js_complete(t.ACTION_CREATE),!1}var params={replyto:rootId,message:{text:formData["message[text]"],format:formData["message[format]"]}};return self.createComment(params).then((function(response){var _self$formSelector$fi3,_self$formSelector2,_self$formSelector2$f;self.removeTinyAutoSaveSession(null!==(_self$formSelector$fi3=null===(_self$formSelector2=self.formSelector)||void 0===_self$formSelector2||null===(_self$formSelector2$f=_self$formSelector2.find(t.SELECTOR.TEXTAREA))||void 0===_self$formSelector2$f?void 0:_self$formSelector2$f.attr("id"))&&void 0!==_self$formSelector$fi3?_self$formSelector$fi3:""),M.util.js_pending(t.ACTION_CLEAR_FORM),setTimeout((function(){self.isusingtinymce?self.resetContent(formSelector,t.EDITOR.TINYMCE.TYPE):0!==self.formSelector.find(t.SELECTOR.ATTO.CONTENT).length?(self.formSelector.trigger("reset"),formSelector.find("#id_editor_question_"+unique+"editable").is(":visible")||self.elementSelector.find(t.SELECTOR.ATTO_HTML_BUTTON).trigger("click"),formSelector.find("#id_editor_question_"+unique+"editable").empty(),formSelector.find(t.SELECTOR.TEXTAREA).trigger("change")):self.resetContent(formSelector,t.EDITOR.TEXTAREA.TYPE),M.util.js_complete(t.ACTION_CLEAR_FORM)}));var data=self.convertForTemplate(response,!0);return formSelector.find(t.SELECTOR.SUBMIT_BUTTON).addClass("disabled"),self.appendComment(data,self.elementSelector.find(t.SELECTOR.CONTAINER_REPLIES),!1),M.util.js_complete(t.ACTION_CREATE),!0})).fail((function(e){self.handleFailWhenCreateComment(e,params),M.util.js_complete(t.ACTION_CREATE)})),!0})),self.elementSelector.find(t.SELECTOR.COMMENT_FILTER_ITEM).on("click",(function(e){if(e.preventDefault(),!self.workingState){var asc=self.string.sort.asc,desc=self.string.sort.desc,nameSelector=$(this).find(t.SELECTOR.COMMENT_FILTER_NAME),iconSelector=$(this).find(t.SELECTOR.COMMENT_FILTER_TYPE),type=$(this).data("type"),orderBy=$(this).attr("data-order"),isCurrent=$(this).hasClass("current"),ascString=$(this).attr("data-asc-string"),descString=$(this).attr("data-desc-string");orderBy="desc"===orderBy?"asc":"desc",$(this).attr("data-order",orderBy),isCurrent||$(this).addClass("current"),"desc"===orderBy?(nameSelector.attr("title",ascString),nameSelector.attr("alt",ascString),iconSelector.attr("title",desc),iconSelector.attr("alt",desc)):(nameSelector.attr("title",descString),nameSelector.attr("alt",descString),iconSelector.attr("title",asc),iconSelector.attr("alt",asc)),self.elementSelector.find(t.SELECTOR.COMMENT_FILTER_ITEM).not(this).each((function(){var each=$(this),eachName=$(this).find(t.SELECTOR.COMMENT_FILTER_NAME),eachType=$(this).find(t.SELECTOR.COMMENT_FILTER_TYPE),defaultString=$(this).attr("data-asc-string");each.attr("data-order","desc"),each.removeClass("filter-asc"),each.removeClass("filter-desc"),each.removeClass("current"),eachName.attr("title",defaultString),eachName.attr("alt",defaultString),eachType.attr("title",asc),eachType.attr("alt",asc)})),"desc"===orderBy?($(this).removeClass("filter-asc"),$(this).addClass("filter-desc")):($(this).removeClass("filter-desc"),$(this).addClass("filter-asc"));var sortType=type+"_"+orderBy;self.setSort(sortType),self.expand?self.btnExpandAll.trigger("click"):self.btnCollapseAll.trigger("click")}}))},getComments:function(numberToShow){var params=this.getParamsBeforeCallApi({numbertoshow:numberToShow,sort:this.sortFeature,type:this.type});return ajax.call([{methodname:t.ACTION_GET_ALL,args:params}])[0]},getParamsBeforeCallApi:function(params){return params.studentquizquestionid=this.studentQuizQuestionId,params.cmid=this.cmId,params.type=this.type,params},showError:function(message){var self=this;M.util.js_pending(t.ACTION_SHOW_ERROR),$.when(self.string.error).done((function(string){self.showDialog(string,message),self.changeWorkingState(!1),M.util.js_complete(t.ACTION_SHOW_ERROR)}))},showDialog:function(title,body){var dialogue=this.dialogue;if(dialogue)return dialogue.title.html(title),dialogue.body.html(body),void dialogue.show();ModalFactory.create({type:ModalFactory.types.CANCEL,title:title,body:body}).done((function(modal){(dialogue=modal).show(),dialogue.getRoot().on(ModalEvents.hidden,{},(function(){location.reload()}))}))},updateCommentCount:function(current,total){M.util.js_pending(t.ACTION_UPDATE_COMMENT_COUNT);var self=this;-1===total?total=self.lastTotal:self.lastTotal=total,-1===current?current=self.lastCurrentCount:self.lastCurrentCount=current;var s=str.get_string("current_of_total","studentquiz",{current:current,total:total}),noCommentSelector=self.elementSelector.find(t.SELECTOR.NO_COMMENT),filter=self.elementSelector.find(t.SELECTOR.COMMENT_FILTER),emptyReplies=self.checkEmptyElement(self.elementSelector.find(t.SELECTOR.CONTAINER_REPLIES));0===self.lastCurrentCount&&emptyReplies&&self.isNoComment?(self.elementSelector.find(t.SELECTOR.CONTAINER_REPLIES).hide(),filter.hide(),noCommentSelector.show()):(self.elementSelector.find(t.SELECTOR.CONTAINER_REPLIES).show(),noCommentSelector.hide(),filter.show()),$.when(s).done((function(text){self.elementSelector.find(t.SELECTOR.COMMENT_COUNT).text(text),M.util.js_complete(t.ACTION_UPDATE_COMMENT_COUNT)}))},renderComment:function(comments,expanded){var self=this;M.util.js_pending(t.ACTION_RENDER_COMMENT),comments=self.convertForTemplate(comments,expanded),Templates.render(t.TEMPLATE_COMMENTS,{comments:comments}).done((function(html){self.containerSelector[0].innerHTML=html,self.loadingIcon.hide();for(var i=0;i<comments.length;i++)self.bindCommentEvent(comments[i]);self.changeWorkingState(!1),M.util.js_complete(t.ACTION_RENDER_COMMENT)}))},bindCommentEvent:function(data){var self=this,el=self.containerSelector.find(t.SELECTOR.COMMENT_ID+data.id),i=0;if(data.root&&data.hasOwnProperty("replies"))for(;i<data.replies.length;i++){var reply=data.replies[i];reply.hasOwnProperty("expand")||(reply.expand=!0),reply.hasOwnProperty("root")||(reply.root=!1),self.bindReplyEvent(reply,el)}el.find(t.SELECTOR.BTN_DELETE).click((function(e){self.bindDeleteEvent(data),e.preventDefault()})),el.find(t.SELECTOR.BTN_REPLY).click((function(e){e.preventDefault(),self.getFragmentFormReplyEvent(data)})),el.find(t.SELECTOR.EXPAND_LINK).click((function(e){e.preventDefault(),self.bindExpandEvent(data)})),el.find(t.SELECTOR.COLLAPSE_LINK).click((function(e){e.preventDefault(),self.bindCollapseEvent(data)})),el.find(t.SELECTOR.BTN_REPORT).click((function(e){e.preventDefault(),window.location=$(this).data("href")})),el.find(t.SELECTOR.BTN_EDIT).click((function(e){e.preventDefault(),self.getFragmentEditFormEvent(data)}))},bindReplyEvent:function(reply,el){var self=this,replySelector=el.find(t.SELECTOR.COMMENT_ID+reply.id);replySelector.find(t.SELECTOR.BTN_DELETE_REPLY).click((function(e){self.bindDeleteEvent(reply),e.preventDefault()})),replySelector.find(t.SELECTOR.BTN_REPORT).click((function(e){e.preventDefault(),window.location=$(this).data("href")})),replySelector.find(t.SELECTOR.BTN_EDIT_REPLY).click((function(e){e.preventDefault(),self.getFragmentEditFormEvent(reply)}))},changeWorkingState:function(boolean){let elementToHide=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;var visibility=boolean?"hidden":"visible",self=this;self.workingState=boolean,self.btnExpandAll.prop("disabled",boolean),self.btnCollapseAll.prop("disabled",boolean),self.elementSelector.find(t.SELECTOR.BTN_REPLY).prop("disabled",boolean),self.elementSelector.find(t.SELECTOR.BTN_DELETE).prop("disabled",boolean),self.elementSelector.find(t.SELECTOR.BTN_DELETE_REPLY).prop("disabled",boolean),self.elementSelector.find(t.SELECTOR.BTN_REPORT).prop("disabled",boolean),self.elementSelector.find(t.SELECTOR.EXPAND_LINK).css("visibility",visibility),self.elementSelector.find(t.SELECTOR.COLLAPSE_LINK).css("visibility",visibility),self.elementSelector.find(t.SELECTOR.BTN_EDIT).prop("disabled",boolean),self.elementSelector.find(t.SELECTOR.BTN_EDIT_REPLY).prop("disabled",boolean),self.deleteDialog&&self.deleteDialog.getFooter().find('button[data-action="yes"]').prop("disabled",boolean),boolean?(self.addComment.prop("disabled",boolean),null!==elementToHide&&elementToHide instanceof $&&elementToHide.hide()):(self.lastFocusElement&&(self.lastFocusElement.focus(),self.lastFocusElement=null),self.elementSelector.find(t.SELECTOR.POST_FOOTER).show())},countCommentAndReplies:function(data){var commentCount=0,deleteCommentCount=0,replyCount=0,deleteReplyCount=0;data.constructor!==Array&&(data=[data]);for(var i=0;i<data.length;i++){var item=data[i];0==item.deletedtime?commentCount++:deleteCommentCount++;for(var j=0;j<item.replies.length;j++){0==item.replies[j].deletedtime?replyCount++:deleteReplyCount++}}return{total:commentCount+replyCount,totalDelete:deleteCommentCount+deleteReplyCount,commentCount:commentCount,deleteCommentCount:deleteCommentCount,replyCount:replyCount,deleteReplyCount:deleteReplyCount}},expandComment:function(id){var params=this.getParamsBeforeCallApi({commentid:id,type:this.type});return ajax.call([{methodname:t.ACTION_EXPAND,args:params}])[0]},bindExpandEvent:function(item){var self=this,itemSelector=self.elementSelector.find(t.SELECTOR.COMMENT_ID+item.id),key=t.ACTION_EXPAND;M.util.js_pending(key),self.changeWorkingState(!0);var loadingIcon=self.loadingIcon.clone().show();itemSelector.find(t.SELECTOR.COMMENT_REPLIES_CONTAINER).append(loadingIcon),$(self).hide(),self.expandComment(item.id).then((function(response){var convertedItem=self.convertForTemplate(response,!0),currentDisplayComment=itemSelector.find(t.SELECTOR.COMMENT_REPLIES_CONTAINER_TO_ITEM).length,total=self.countCommentAndReplies(convertedItem).replyCount,newCount=self.lastCurrentCount+total-currentDisplayComment,newTotalCount=self.lastTotal+(convertedItem.numberofreply-item.numberofreply);return item.deleted&&!convertedItem.deleted&&(newCount++,newTotalCount++),!item.deleted&&convertedItem.deleted&&(newCount--,newTotalCount--),newCount===newTotalCount&&(self.btnExpandAll.hide(),self.btnCollapseAll.show()),self.updateCommentCount(newCount,newTotalCount),Templates.render(t.TEMPLATE_COMMENT,convertedItem).done((function(html){var el=$(html);return itemSelector.replaceWith(el),self.lastFocusElement=el.find(t.SELECTOR.COLLAPSE_LINK),self.bindCommentEvent(response),self.changeWorkingState(!1),M.util.js_complete(key),!0}))})).fail((function(e){M.util.js_complete(key),self.showError(e.message)}))},bindCollapseEvent:function(item){var el=this.elementSelector.find(t.SELECTOR.COMMENT_ID+item.id),commentCount=el.find(t.SELECTOR.COMMENT_REPLIES_TEXT).length;this.updateCommentCount(this.lastCurrentCount-commentCount,-1),item.numberofreply=commentCount,el.find(t.SELECTOR.COMMENT_REPLIES_CONTAINER).empty(),item.deleted?el.find(".studentquiz-comment-delete-content").html(item.shortcontent):el.find(t.SELECTOR.COMMENT_TEXT).html(item.shortcontent),el.find(t.SELECTOR.COLLAPSE_LINK).hide(),el.find(t.SELECTOR.EXPAND_LINK).show().focus(),item.expanded=!1},convertForTemplate:function(data,expanded){var single=!1;data.constructor!==Array&&(data=[data],single=!0);for(var i=0;i<data.length;i++){var item=data[i];if(item.expanded=expanded,item.canviewdeleted=this.canViewDeleted,item.hasOwnProperty("replies")||(item.replies=[]),this.setHasComment(item.hascomment),item.highlight=item.id===this.highlight,this.referer&&item.reportlink&&(item.reportlink=this.buildRefererReportLink(item.reportlink,item.id)),item.root)for(var j=0;j<item.replies.length;j++){var reply=item.replies[j];reply.expanded=!0,reply.canviewdeleted=this.canViewDeleted,reply.hasOwnProperty("replies")||(reply.replies=[]),reply.highlight=reply.id===this.highlight,this.referer&&reply.reportlink&&(reply.reportlink=this.buildRefererReportLink(reply.reportlink,reply.id))}item.allowselfcommentrating=this.allowSelfCommentRating}return single?data[0]:data},convertFormToJson:function(form){var data={};return form.find(":input").each((function(){var type=$(this).prop("type"),name=$(this).attr("name");(("checkbox"===type||"radio"===type)&&this.checked||"button"!==type&&"submit"!==type)&&(data[name]=$(this).val())})),data},createComment:function(data){return data=this.getParamsBeforeCallApi(data),ajax.call([{methodname:t.ACTION_CREATE,args:data}])[0]},appendComment:function(item,target,isReply){var self=this;M.util.js_pending(t.ACTION_APPEND_COMMENT),Templates.render(t.TEMPLATE_COMMENT,item).done((function(html){var el=$(html);target.append(el),self.lastCurrentCount?self.updateCommentCount(self.lastCurrentCount+1,self.lastTotal+1):(self.elementSelector.find(t.SELECTOR.COMMENT_FILTER).removeClass(t.SELECTOR.COMMENT_FILTER_HIDE),self.updateCommentCount(1,1),self.btnExpandAll.prop("disabled",!0),self.btnExpandAll.hide(),self.btnCollapseAll.prop("disabled",!1),self.btnCollapseAll.show(),self.expand=!0,self.isNoComment=!1),isReply?self.bindReplyEvent(item,el.parent()):self.bindCommentEvent(item),self.loadingIcon.hide(),self.changeWorkingState(!1),M.util.js_complete(t.ACTION_APPEND_COMMENT)}))},loadFragmentForm:function(fragmentForm,item){var self=this;M.util.js_pending(t.ACTION_LOAD_FRAGMENT_FORM);var params=self.getParamsBeforeCallApi({replyto:item.id,cancelbutton:!0,forcecommenting:self.forceCommenting,type:self.type}),attoWrap=self.formSelector.find(t.SELECTOR.ATTO_EDITOR_WRAP);0!==attoWrap.length&&attoWrap.hasClass("error")&&(attoWrap.removeClass("error"),attoWrap.find("#id_error_message_5btext_5d").remove()),fragment.loadFragment("mod_studentquiz",t.FRAGMENT_FORM_CALLBACK,self.contextId,params).done((function(html,js){Templates.replaceNodeContents(fragmentForm,html,js);var textFragmentFormId="#id_editor_question_"+self.studentQuizQuestionId+"_"+self.type+"_"+item.id+"editable";fragmentForm.find(textFragmentFormId).focus(),self.triggerAttoNoContent(fragmentForm),self.bindFragmentFormEvent(fragmentForm,item),M.util.js_complete(t.ACTION_LOAD_FRAGMENT_FORM)}))},bindFragmentFormEvent:function(fragmentForm,item){var self=this,formFragmentSelector=fragmentForm.find(t.SELECTOR.COMMENT_AREA_FORM);fragmentForm.find(t.SELECTOR.SUBMIT_BUTTON).click((function(e){e.preventDefault(),self.changeWorkingState(!0);var data=self.convertFormToJson(formFragmentSelector);return 0===data["message[text]"].length||(self.loadingIcon.clone().show().appendTo(fragmentForm),formFragmentSelector.hide(),self.createReplyComment(fragmentForm,item,formFragmentSelector,data)),!0})),self.fragmentFormCancelEvent(formFragmentSelector,!1),self.bindEditorEvent(fragmentForm)},createReplyComment:function(replyContainer,item,formSelector,formData){var self=this,params={replyto:item.id,message:{text:formData["message[text]"],format:formData["message[format]"]}};M.util.js_pending(t.ACTION_CREATE_REPLY),self.createComment(params).then((function(response){var _formSelector$find;self.removeTinyAutoSaveSession(null==formSelector||null===(_formSelector$find=formSelector.find(t.SELECTOR.TEXTAREA))||void 0===_formSelector$find?void 0:_formSelector$find.attr("id")),$(t.SELECTOR.COMMENT_ERROR).addClass("hide");var el=self.elementSelector.find(t.SELECTOR.COMMENT_ID+item.id),repliesEl=el.find(t.SELECTOR.COMMENT_REPLIES_CONTAINER);item.numberofreply++;var numReply=parseInt(el.find(t.SELECTOR.COMMENT_COUNT_NUMBER).text())+1;el.find(t.SELECTOR.COMMENT_COUNT_NUMBER).text(numReply),el.find(t.SELECTOR.COMMENT_COUNT_TEXT).html(1===numReply?self.string.reply:self.string.replies),replyContainer.empty();var data=self.convertForTemplate(response,!0);return self.appendComment(data,repliesEl,!0),M.util.js_complete(t.ACTION_CREATE_REPLY),!0})).fail((function(e){self.handleFailWhenCreateComment(e,params),M.util.js_complete(t.ACTION_CREATE_REPLY)}))},handleFailWhenCreateComment:function(e,params){this.showError(e.message);var fragmentFormSelector=t.SELECTOR.COMMENT_ID+params.replyto+" "+t.SELECTOR.FRAGMENT_FORM;this.elementSelector.find(fragmentFormSelector).empty()},getFragmentFormReplyEvent:function(item){var el=this.elementSelector.find(t.SELECTOR.COMMENT_ID+item.id),fragmentForm=el.find(t.SELECTOR.FRAGMENT_FORM).first(),postFooter=el.find(t.SELECTOR.POST_FOOTER).first(),clone=this.loadingIcon.clone().show();fragmentForm.append(clone),fragmentForm.removeClass("edit"),fragmentForm.addClass("reply"),this.loadFragmentForm(fragmentForm,item),this.changeWorkingState(!0,postFooter)},fragmentFormCancelEvent:function(formSelector,isEdit){var self=this;formSelector.find("#id_cancel").click((function(e){e.preventDefault();var commentSelector=formSelector.closest(t.SELECTOR.COMMENT_ITEM);self.lastFocusElement=isEdit?commentSelector.find(t.SELECTOR.BTN_EDIT):commentSelector.find(t.SELECTOR.BTN_REPLY),self.changeWorkingState(!1),formSelector.parent().empty()}))},bindDeleteEvent:function(data){var self=this;self.deleteTarget=data,self.deleteDialog?self.deleteDialog.show():(self.changeWorkingState(!0),ModalFactory.create({type:ModalFactory.types.DEFAULT,title:self.string.deletecomment,body:self.string.confirmdeletecomment,footer:'<button class="btn btn-primary" type="button" data-action="yes" title="'+self.string.deletecomment+'">'+self.string.deletetext+'</button><button class="btn btn-secondary" type="button" data-action="no" title="'+self.string.cancel+'">'+self.string.cancel+"</button>"}).done((function(modal){self.deleteDialog=modal,modal.getFooter().find('button[data-action="no"]').click((function(e){e.preventDefault(),modal.hide()})),modal.getFooter().find('button[data-action="yes"]').click((function(e){e.preventDefault(),M.util.js_pending(t.ACTION_DELETE),self.changeWorkingState(!0),self.deleteComment(self.deleteTarget.id).then((function(response){if(!response.success)return self.showError(response.message),!0;var convertedCommentData=self.convertForTemplate(response.data,self.deleteTarget.expanded),commentSelector=self.elementSelector.find(t.SELECTOR.COMMENT_ID+convertedCommentData.id);return self.updateCommentCount(self.lastCurrentCount-1,self.lastTotal-1),convertedCommentData.root||(convertedCommentData.expanded=!0),Templates.render(t.TEMPLATE_COMMENT,convertedCommentData).done((function(html){var el=$(html);if(!convertedCommentData.root){var parentCountSelector=commentSelector.parent().closest(t.SELECTOR.COMMENT_ITEM).find(t.SELECTOR.TOTAL_REPLY),countSelector=parentCountSelector.find(t.SELECTOR.COMMENT_COUNT_NUMBER),newCount=parseInt(countSelector.text())-1;parentCountSelector.find(t.SELECTOR.COMMENT_COUNT_NUMBER).text(newCount),parentCountSelector.find(t.SELECTOR.COMMENT_COUNT_TEXT).html(1===newCount?self.string.reply:self.string.replies)}var oldReplies=commentSelector.find(t.SELECTOR.COMMENT_REPLIES_CONTAINER).clone(!0);commentSelector.replaceWith(el),el.find(t.SELECTOR.COMMENT_REPLIES_CONTAINER).replaceWith(oldReplies),self.deleteTarget.root?self.bindCommentEvent(response.data):self.bindReplyEvent(response.data,el.parent()),self.changeWorkingState(!1),M.util.js_complete(t.ACTION_DELETE)})),modal.hide(),!0})).fail((function(err){return self.showError(err.message),!1}))})),modal.getRoot().on(ModalEvents.hidden,(function(){var el=self.elementSelector.find(t.SELECTOR.COMMENT_ID+self.deleteTarget.id);self.deleteTarget.root?el.find(t.SELECTOR.BTN_DELETE).first().focus():el.find(t.SELECTOR.BTN_DELETE_REPLY).first().focus()})),modal.getRoot().on(ModalEvents.shown,(function(){self.changeWorkingState(!1)})),modal.show(),self.changeWorkingState(!1)})))},deleteComment:function(id){var params=this.getParamsBeforeCallApi({commentid:id});return ajax.call([{methodname:t.ACTION_DELETE,args:params}])[0]},bindHandleTinyEditor:function(formSelector){var self=this;const tinyEditorId=formSelector.find(t.SELECTOR.TEXTAREA).attr("id"),intervalID=setInterval((function(){if(window.tinyMCE){const editor=window.tinyMCE.get(tinyEditorId);editor.on("input",(function(){self.checkEditorContent(formSelector,editor.getBody(),t.EDITOR.TINYMCE.TYPE)})),editor.on("SetContent",(function(){self.checkEditorContent(formSelector,editor.getBody(),t.EDITOR.TINYMCE.TYPE)})),editor.on("change",(function(){self.checkEditorContent(formSelector,editor.getBody(),t.EDITOR.TINYMCE.TYPE)})),clearInterval(intervalID)}}),100)},bindHandleAttoEditor:function(formSelector){var self=this;M.util.js_pending("init_editor"),self.triggerAttoNoContent(formSelector),self.setPlaceholder(formSelector,formSelector.attr("data-textarea-placeholder")),formSelector.find(t.SELECTOR.ATTO.TOOLBAR).fadeIn();var textareaSelector=formSelector.find(t.SELECTOR.TEXTAREA),attoEditableId=textareaSelector.attr("id")+"editable",attoEditable=document.getElementById(attoEditableId);new MutationObserver((function(mutationsList){mutationsList.forEach((function(mutation){"childList"!==mutation.type&&("attributes"!==mutation.type||"style"!==mutation.attributeName&&"hidden"!==mutation.attributeName)||self.checkEditorContent(formSelector)}))})).observe(attoEditable,{attributes:!0,childList:!0,subtree:!0}),textareaSelector.change((function(){self.checkEditorContent(formSelector)})),M.util.js_complete("init_editor");var interval=setInterval((function(){formSelector.find('textarea[id^="id_message"]').trigger("change")}),350);setTimeout((function(){clearInterval(interval)}),5e3)},bindHandleTextareaEditor:function(formSelector){var self=this;const textareaSelector=formSelector.find(t.SELECTOR.TEXTAREA);textareaSelector&&textareaSelector.on("input",(function(){self.checkEditorContent(formSelector,textareaSelector[0],t.EDITOR.TEXTAREA.TYPE)}))},bindEditorEvent:function(formSelector){this.isusingtinymce?this.bindHandleTinyEditor(formSelector):0!==this.formSelector.find(t.SELECTOR.ATTO.CONTENT).length?this.bindHandleAttoEditor(formSelector):this.bindHandleTextareaEditor(formSelector)},resetContent:function(formSelector,type){const textareaSelector=formSelector.find(t.SELECTOR.TEXTAREA);if(type===t.EDITOR.TINYMCE.TYPE){const tinyEditorId=textareaSelector.attr("id");window.tinyMCE.get(tinyEditorId).setContent("")}else textareaSelector[0].value=""},checkEmptyElement:function(el){return 0===el.children().length},setHasComment:function(value){var container=this.elementSelector,hasCommentClass=t.HAS_COMMENT_CLASS;this.forceCommenting?(this.hasComment=value,this.hasComment?container.addClass(hasCommentClass):container.removeClass(hasCommentClass)):(this.hasComment=!0,container.addClass(hasCommentClass))},parseQueryString:function(query){for(var vars=query.split("&"),queryString={},i=0;i<vars.length;i++){var pair=vars[i].split("="),key=decodeURIComponent(pair[0]),value=decodeURIComponent(pair[1]);void 0===queryString[key]?queryString[key]=decodeURIComponent(value):"string"==typeof queryString[key]?queryString[key]=[queryString[key],decodeURIComponent(value)]:queryString[key].push(decodeURIComponent(value))}return queryString},scrollToElement:function(target,speed){if(target.length){void 0===speed&&(speed=1e3);var top=target.offset().top;$("html,body").animate({scrollTop:top},speed)}},buildRefererReportLink:function(link,id){var referer=decodeURIComponent(this.referer);return link+="&referer="+encodeURIComponent(referer+"&highlight="+id)},triggerAttoHasContent:function(formSelector){var editorContentWrap=formSelector.find(t.SELECTOR.ATTO.CONTENT_WRAP),submitBtn=formSelector.find(t.SELECTOR.SUBMIT_BUTTON);submitBtn.removeClass("disabled"),submitBtn.prop("disabled",!1),editorContentWrap.addClass(t.ATTO_CONTENT_TYPE.HAS_CONTENT),editorContentWrap.removeClass(t.ATTO_CONTENT_TYPE.NO_CONTENT)},triggerAttoNoContent:function(formSelector){var editorContentWrap=formSelector.find(t.SELECTOR.ATTO.CONTENT_WRAP),submitBtn=formSelector.find(t.SELECTOR.SUBMIT_BUTTON);submitBtn.addClass("disabled"),submitBtn.prop("disabled",!0),editorContentWrap.addClass(t.ATTO_CONTENT_TYPE.NO_CONTENT),editorContentWrap.removeClass(t.ATTO_CONTENT_TYPE.HAS_CONTENT)},setPlaceholder:function(formSelector,placeholder){formSelector.find(t.SELECTOR.ATTO.CONTENT_WRAP).attr("data-placeholder",placeholder)},setSort:function(string){-1!==$.inArray(string,this.sortable)&&(this.sortFeature=string)},getFragmentEditFormEvent:function(item){var el=this.elementSelector.find(t.SELECTOR.COMMENT_ID+item.id),fragmentForm=el.find(t.SELECTOR.FRAGMENT_FORM).first(),postFooter=el.find(t.SELECTOR.POST_FOOTER).first(),clone=this.loadingIcon.clone().show();fragmentForm.append(clone),fragmentForm.removeClass("reply"),fragmentForm.addClass("edit"),this.loadFragmentEditForm(fragmentForm,item),this.changeWorkingState(!0,postFooter)},loadFragmentEditForm:function(fragmentForm,item){var self=this;M.util.js_pending(t.ACTION_LOAD_FRAGMENT_EDIT_FORM);var params=self.getParamsBeforeCallApi({cancelbutton:!0,forcecommenting:self.forceCommenting,commentid:item.id}),attoWrap=self.formSelector.find(t.SELECTOR.ATTO_EDITOR_WRAP);0!==attoWrap.length&&attoWrap.hasClass("error")&&(attoWrap.removeClass("error"),attoWrap.find("#id_error_message_5btext_5d").remove()),fragment.loadFragment("mod_studentquiz",t.FRAGMENT_EDIT_FORM_CALLBACK,self.contextId,params).done((function(html,js){Templates.replaceNodeContents(fragmentForm,html,js);var textFragmentFormId="#id_editor_question_"+self.studentQuizQuestionId+"_"+self.type+"_"+item.id+"editable";fragmentForm.find(textFragmentFormId).focus(),self.bindFragmentEditFormEvent(fragmentForm,item),M.util.js_complete(t.ACTION_LOAD_FRAGMENT_EDIT_FORM)}))},bindFragmentEditFormEvent:function(fragmentForm,item){var self=this,formFragmentSelector=fragmentForm.find(t.SELECTOR.COMMENT_AREA_FORM);fragmentForm.find(t.SELECTOR.SUBMIT_BUTTON).click((function(e){e.preventDefault(),self.changeWorkingState(!0);var data=self.convertFormToJson(formFragmentSelector);return 0===data["message[text]"].length||(self.loadingIcon.clone().show().appendTo(fragmentForm),formFragmentSelector.hide(),self.editCommentEvent(fragmentForm,item,formFragmentSelector,data)),!0})),self.fragmentFormCancelEvent(formFragmentSelector,!0),self.bindEditorEvent(fragmentForm)},editCommentEvent:function(container,item,formSelector,formData){var self=this;M.util.js_pending(t.ACTION_EDIT);var params={commentid:item.id,message:{text:formData["message[text]"],format:formData["message[format]"]}};self.editComment(params).then((function(response){self.elementSelector.find(t.SELECTOR.COMMENT_ERROR).addClass("hide");var el=self.elementSelector.find(t.SELECTOR.COMMENT_ID+item.id);return self.lastFocusElement=el.find(t.SELECTOR.BTN_EDIT),0===self.lastFocusElement.length&&(self.lastFocusElement=el.find(t.SELECTOR.BTN_EDIT_REPLY)),item.shortcontent=response.shortcontent,response.expanded=item.expanded,Templates.render(t.TEMPLATE_COMMENT,response).done((function(html){var el=$(html),commentTextSelector=t.SELECTOR.COMMENT_ID+response.id+" "+t.SELECTOR.COMMENT_TEXT_CONTAINER;self.elementSelector.find(commentTextSelector).first().html(el.find(t.SELECTOR.COMMENT_TEXT_CONTAINER).html())})),container.empty(),self.changeWorkingState(!1),M.util.js_complete(t.ACTION_EDIT),!0})).fail((function(e){self.handleFailWhenCreateComment(e,params),M.util.js_complete(t.ACTION_EDIT)}))},editComment:function(data){return data=this.getParamsBeforeCallApi(data),ajax.call([{methodname:t.ACTION_EDIT,args:data}])[0]},checkEditorContent:function(formSelector){let bodyContent=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,type=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"";const key="text_change_"+Date.now();M.util.js_pending(key);const textareaSelector=formSelector.find(t.SELECTOR.TEXTAREA);let editorBodyContent,contenthtml,condition;switch(type){case t.EDITOR.TINYMCE.TYPE:editorBodyContent=$(bodyContent),contenthtml=editorBodyContent.html(),condition=t.EMPTY_CONTENT.indexOf(contenthtml)>-1||editorBodyContent.text().trim().length<1;break;case t.EDITOR.ATTO.TYPE:case"":editorBodyContent=$("#"+textareaSelector.attr("id")+"editable"),contenthtml=editorBodyContent.html(),condition=t.EMPTY_CONTENT.indexOf(contenthtml)>-1||editorBodyContent.text().trim().length<1;break;case t.EDITOR.TEXTAREA.TYPE:editorBodyContent=$(bodyContent),contenthtml=editorBodyContent[0].value,condition=contenthtml.trim().length<1}const regex=/^(<(?:p)[^>]*>)+(<br>)?(<\/p>)+$/,match=regex.exec(contenthtml);if(condition){const isEmptyContent=match||t.EMPTY_CONTENT.indexOf(contenthtml)>-1;this.setPlaceholder(formSelector,isEmptyContent?formSelector.attr("data-textarea-placeholder"):""),this.triggerAttoNoContent(formSelector)}else this.setPlaceholder(formSelector,""),this.triggerAttoHasContent(formSelector);M.util.js_complete(key)},removeTinyAutoSaveSession:function(editorID){if(this.isusingtinymce){var _window2,_window2$tinyMCE;const editor=null===(_window2=window)||void 0===_window2||null===(_window2$tinyMCE=_window2.tinyMCE)||void 0===_window2$tinyMCE?void 0:_window2$tinyMCE.get(editorID);editor&&TinyRepository.removeAutosaveSession(editor)}}}},generate:function(params){t.get().init(params)}};return t}));

//# sourceMappingURL=comment_area.min.js.map