/**
 * JavaScript class for Camera
 *
 * @subpackage quizproctoring
 * @copyright  2020 Mahendra Soni <ms@taketwotechnologies.com> {@link https://taketwotechnologies.com}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
window.addEventListener("beforeunload",(function(event){event.stopImmediatePropagation(),event.returnValue=""})),define("quizaccess_quizproctoring/add_camera",["jquery","core/str","core/modal_factory"],(function($,str,ModalFactory){var Camera=function(cmid){let mainimage=arguments.length>1&&void 0!==arguments[1]&&arguments[1],attemptid=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null,quizid=arguments.length>3?arguments[3]:void 0;var docElement=$(document);this.video=document.getElementById(this.videoid),this.canvas=document.getElementById(this.canvasid),this.cmid=cmid,this.quizid=quizid,this.mainimage=mainimage,this.attemptid=attemptid,$("#id_submitbutton").prop("disabled",!0),docElement.on("popup",this.showpopup.bind(this)),navigator.mediaDevices.getUserMedia({video:!0,audio:!0}).then((function(stream){return!this.video||(this.video.srcObject=stream,this.video.muted=!0,localMediaStream=stream,this.video.play(),!0)})).catch((function(){}))};Camera.prototype.video=!1,Camera.prototype.videoid="video",Camera.prototype.canvas=!1,Camera.prototype.canvasid="canvas",Camera.prototype.width=320,Camera.prototype.height=240,Camera.prototype.takepictureid="takepicture",Camera.prototype.retakeid="retake",Camera.prototype.cmid=!1,Camera.prototype.mainimage=!1,Camera.prototype.attemptid=!1,Camera.prototype.quizid=!1,Camera.prototype.takepicture=function(){this.canvas.getContext("2d").drawImage(this.video,0,0,this.width,this.height);var data=this.canvas.toDataURL("image/png");$("#"+this.videoid).hide(),$("#"+this.takepictureid).hide(),$("#"+this.canvasid).show(),$("#"+this.retakeid).show(),$("input[name='userimg']").val(data),$("#id_submitbutton").prop("disabled",!0),$.ajax({url:M.cfg.wwwroot+"/mod/quiz/accessrule/quizproctoring/ajax.php",method:"POST",data:{imgBase64:data,cmid:this.cmid,attemptid:this.attemptid,mainimage:this.mainimage},success:function(response){response&&response.errorcode?($("input[name='userimg']").val(""),$(document).trigger("popup",response.error)):$("#id_submitbutton").prop("disabled",!1)}})},Camera.prototype.proctoringimage=function(){this.canvas.getContext("2d").drawImage(this.video,0,0,this.width,this.height);var data=this.canvas.toDataURL("image/png");$.ajax({url:M.cfg.wwwroot+"/mod/quiz/accessrule/quizproctoring/ajax.php",method:"POST",data:{imgBase64:data,cmid:this.cmid,attemptid:this.attemptid,mainimage:this.mainimage},success:function(response){response&&response.errorcode?$(document).trigger("popup",response.error):response.redirect&&response.url&&(window.onbeforeunload=null,window.location.href=encodeURI(response.url))}})};var signalingSocket=null,localMediaStream=null,peers={},peerId=null,peerMediaElements={},connectedPeers={},attachMediaStream=null,ICE_SERVERS=[{urls:"stun:stun.l.google.com:19302"}];Camera.prototype.retake=function(){$("input[name='userimg']").val(""),$("#"+this.videoid).show(this.cmid),$("#"+this.takepictureid).show(),$("#"+this.canvasid).hide(),$("#"+this.retakeid).hide()},Camera.prototype.showpopup=function(event,message){return ModalFactory.create({body:message}).then((function(modal){return modal.show(),null}))};return{init:function(cmid,mainimage){let verifyduringattempt=!(arguments.length>2&&void 0!==arguments[2])||arguments[2],attemptid=arguments.length>3&&void 0!==arguments[3]?arguments[3]:null,teacher=arguments.length>4?arguments[4]:void 0,quizid=arguments.length>5?arguments[5]:void 0,serviceoption=arguments.length>6?arguments[6]:void 0,setinterval=arguments.length>7&&void 0!==arguments[7]?arguments[7]:300;var camera;verifyduringattempt?((signalingSocket=io("https://proctoring.taketwotechnologies.com")).on("connect",(function(){var storedSession=localStorage.getItem("sessionState"),sessionState=storedSession?JSON.parse(storedSession):null;setupLocalMedia(cmid,mainimage,verifyduringattempt,attemptid,teacher,setinterval,serviceoption,quizid,(function(){var typet={type:"teacher"===getTeacherroom()?"teacher":"student"};signalingSocket.emit("join",{room:quizid,userdata:{quizid:quizid,type:typet}}),sessionState&&restoreSessionState(sessionState)}))})),signalingSocket.on("disconnect",(function(){for(peerId in peerMediaElements)peerMediaElements[peerId].remove();for(peerId in peers)peers[peerId].close();peers={},peerMediaElements={}})),signalingSocket.on("addPeer",(function(config){var peerId=config.peer_id;if(!(peerId in peers)){var peerConnection=new RTCPeerConnection({iceServers:ICE_SERVERS},{optional:[{DtlsSrtpKeyAgreement:!0}]});peers[peerId]=peerConnection,connectedPeers[peerId]={stream:new MediaStream},peerConnection.onicecandidate=function(event){event.candidate&&signalingSocket.emit("relayICECandidate",{peer_id:peerId,ice_candidate:{sdpMLineIndex:event.candidate.sdpMLineIndex,candidate:event.candidate.candidate}})},peerConnection.ontrack=function(event){var remoteMedia;(connectedPeers[peerId].stream.addTrack(event.track),peerMediaElements[peerId])?remoteMedia=peerMediaElements[peerId]:((remoteMedia=$("<video>")).attr("autoplay","autoplay"),remoteMedia.attr("muted","true"),remoteMedia.attr("controls",""),remoteMedia.attr("class","quizaccess_quizproctoring"),remoteMedia.attr("muted","true"),remoteMedia.attr("controls",""),peerMediaElements[peerId]=remoteMedia,"teacher"===getTeacherroom()&&($("#region-main-box").append(remoteMedia),attachMediaStream(remoteMedia[0],connectedPeers[peerId].stream)))},peerConnection.addStream(localMediaStream),config.should_create_offer&&peerConnection.createOffer((function(localDescription){peerConnection.setLocalDescription(localDescription,(function(){signalingSocket.emit("relaySessionDescription",{peer_id:peerId,session_description:localDescription})}))}),(function(){}))}})),signalingSocket.on("sessionDescription",(function(config){var peerId=config.peer_id,peer=peers[peerId],remoteDescription=config.session_description,desc=new RTCSessionDescription(remoteDescription);peer.setRemoteDescription(desc).then((function(){return"offer"===remoteDescription.type?peer.createAnswer():null})).then((function(localDescription){return localDescription?peer.setLocalDescription(localDescription):null})).then((function(){return peer.localDescription&&signalingSocket.emit("relaySessionDescription",{peer_id:peerId,session_description:peer.localDescription}),null})).catch((function(error){throw error}))})),signalingSocket.on("iceCandidate",(function(config){var peer=peers[config.peer_id],iceCandidate=config.ice_candidate;peer.addIceCandidate(new RTCIceCandidate(iceCandidate))})),signalingSocket.on("removePeer",(function(config){var peerId=config.peer_id;if(peerId in peers){peers[peerId].removeStream(connectedPeers[peerId].stream),peers[peerId].close(),delete connectedPeers[peerId];var remoteMedia=peerMediaElements[peerId];remoteMedia&&remoteMedia.remove(),delete peers[peerId],delete peerMediaElements[peerId]}}))):(camera=new Camera(cmid,mainimage,attemptid,quizid),$("#"+camera.takepictureid).on("click",(function(e){e.preventDefault(),camera.takepicture()})),$("#"+camera.retakeid).on("click",(function(e){e.preventDefault(),camera.retake()})))}};function setupLocalMedia(cmid,mainimage,verifyduringattempt,attemptid,teacher,setinterval,serviceoption,quizid,callback){require(["core/ajax"],(function(){null===localMediaStream?(navigator.getUserMedia=navigator.getUserMedia||navigator.webkitGetUserMedia||navigator.mozGetUserMedia||navigator.msGetUserMedia,attachMediaStream=function(element,stream){element.srcObject=stream},navigator.mediaDevices.getUserMedia({audio:true,video:true}).then((function(stream){if((localMediaStream=stream,verifyduringattempt)&&"teacher"!==getTeacherroom()){$("<canvas>").attr({id:"canvas",width:"280",height:"240",style:"display: none;"}).appendTo("body"),$("<video>").attr({id:"video",class:"quizaccess_quizproctoring-video",width:"280",height:"240",autoplay:"autoplay"}).appendTo("body");var camera=new Camera(cmid,mainimage,attemptid,quizid);setInterval(camera.proctoringimage.bind(camera),1e3*setinterval)}return stream})).catch((function(error){throw error})).finally((function(){callback&&callback()}))):callback&&callback()}))}function getTeacherroom(){return new URLSearchParams(window.location.search).get("teacher")}function restoreSessionState(sessionState){for(var peerId in sessionState.connectedPeers)if(sessionState.connectedPeers.hasOwnProperty(peerId)){var peer=sessionState.connectedPeers[peerId],peerConnection=new RTCPeerConnection({iceServers:ICE_SERVERS},{optional:[{DtlsSrtpKeyAgreement:!0}]});peers[peerId]=peerConnection,setupPeerConnection(peerConnection,peerId,peer)}}function setupPeerConnection(peerConnection,peerId,peer){for(var track of(peerConnection.onicecandidate=function(event){event.candidate&&signalingSocket.emit("relayICECandidate",{peer_id:peerId,ice_candidate:{sdpMLineIndex:event.candidate.sdpMLineIndex,candidate:event.candidate.candidate}})},peerConnection.ontrack=function(event){var remoteMedia;(peer.stream.addTrack(event.track),peerMediaElements[peerId])?remoteMedia=peerMediaElements[peerId]:((remoteMedia=$("<video>")).attr("autoplay","autoplay"),remoteMedia.attr("muted","true"),remoteMedia.attr("controls",""),peerMediaElements[peerId]=remoteMedia,"teacher"===getTeacherroom()&&($("#region-main-box").append(remoteMedia),attachMediaStream(remoteMedia[0],null)));attachMediaStream(remoteMedia[0],peer.stream)},peerConnection.addStream(localMediaStream),peer.stream.getTracks()))peerConnection.addTrack(track,peer.stream);peerConnection.createOffer((function(localDescription){peerConnection.setLocalDescription(localDescription,(function(){signalingSocket.emit("relaySessionDescription",{peer_id:peerId,session_description:localDescription})}))}))}}));

//# sourceMappingURL=add_camera.min.js.map