/**
 * JavaScript class for Camera
 *
 * @subpackage quizproctoring
 * @copyright  2020 Mahendra Soni <ms@taketwotechnologies.com> {@link https://taketwotechnologies.com}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
window.addEventListener("beforeunload",(function(event){event.stopImmediatePropagation(),event.returnValue=""})),define("quizaccess_quizproctoring/add_camera",["jquery","core/str","core/modal_factory"],(function($,str,ModalFactory){$(".quizstartbuttondiv [type=submit]").prop("disabled",!0);var Camera=function(cmid){let mainimage=arguments.length>1&&void 0!==arguments[1]&&arguments[1],attemptid=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null,quizid=arguments.length>3?arguments[3]:void 0;var docElement=$(document);this.video=document.getElementById(this.videoid),this.canvas=document.getElementById(this.canvasid),this.cmid=cmid,this.quizid=quizid,this.mainimage=mainimage,this.attemptid=attemptid,$("#id_submitbutton").prop("disabled",!0),docElement.on("popup",this.showpopup.bind(this))};$("#id_consentcheckbox").on("change",(function(){$(this).is(":checked")?$(this).is(":checked")&&0==$("#userimageset").val()?$("#id_submitbutton").prop("disabled",!0):$(this).is(":checked")&&1==$("#userimageset").val()&&$("#id_submitbutton").prop("disabled",!1):$("#id_submitbutton").prop("disabled",!0)})),Camera.prototype.video=!1,Camera.prototype.videoid="video",Camera.prototype.canvas=!1,Camera.prototype.canvasid="canvas",Camera.prototype.width=320,Camera.prototype.height=240,Camera.prototype.takepictureid="takepicture",Camera.prototype.retakeid="retake",Camera.prototype.cmid=!1,Camera.prototype.mainimage=!1,Camera.prototype.attemptid=!1,Camera.prototype.quizid=!1,Camera.prototype.startcamera=function(){const takePictureButton=$("#"+this.takepictureid);return takePictureButton.prop("disabled",!0),navigator.mediaDevices.getUserMedia({video:!0,audio:!0}).then((function(stream){const videoElement=document.getElementById("video");if(videoElement){videoElement.srcObject=stream,videoElement.muted=!0,videoElement.setAttribute("playsinline","true"),localMediaStream=stream,videoElement.play(),videoElement.addEventListener("contextmenu",(function(e){e.preventDefault()})),stream.getVideoTracks()[0].onended=function(){takePictureButton.prop("disabled",!0),$(document).trigger("popup",M.util.get_string("nocameradetectedm","quizaccess_quizproctoring"))};const audioTrack=stream.getAudioTracks()[0];audioTrack?audioTrack.onended=function(){$(document).trigger("popup",M.util.get_string("nocameradetectedm","quizaccess_quizproctoring"))}:$(document).trigger("popup",M.util.get_string("nocameradetectedm","quizaccess_quizproctoring")),this.attemptid&&(restoreVideoPosition(videoElement),makeDraggable(videoElement)),takePictureButton.prop("disabled",!1)}return videoElement})).catch((function(){takePictureButton.prop("disabled",!0)}))},Camera.prototype.takepicture=function(){const video=this.video,canvas=this.canvas,vw=video.videoWidth||video.clientWidth,vh=video.videoHeight||video.clientHeight;let sx=0,sy=0,sw=vw,sh=vh;vw/vh>1.3333333333333333?(sh=vh,sw=1.3333333333333333*vh,sx=(vw-sw)/2):(sw=vw,sh=vw/1.3333333333333333,sy=(vh-sh)/2),canvas.width=320,canvas.height=240;canvas.getContext("2d").drawImage(video,sx,sy,sw,sh,0,0,320,240);const data=canvas.toDataURL("image/png");$("#"+this.videoid).hide(),$("#"+this.takepictureid).hide(),$("#"+this.canvasid).show(),$("#"+this.retakeid).show(),$("#id_submitbutton").prop("disabled",!0);let requestData={imgBase64:data,cmid:this.cmid,attemptid:this.attemptid,mainimage:this.mainimage};this.mainimage&&(requestData.deviceinfo=function(){const useragent=navigator.userAgent||"";if(!useragent)return"Unknown";const ua=useragent.toLowerCase();if(/ipad/i.test(ua))return"Mac iPad";if(/iphone|ipod/i.test(ua))return"Mobile";if(/macintosh|mac os x|mac_powerpc/i.test(ua))return"Mac Desktop";if(/android/i.test(ua)&&/tablet/i.test(ua)||/android/i.test(ua)&&!/mobile/i.test(ua))return"Mobile";if(/blackberry|windows phone|opera mini/i.test(ua)||/android/i.test(ua)&&/mobile/i.test(ua))return"Mobile";if(/windows|win32|win64|wow64/i.test(ua))return"Windows";if(/cros/i.test(ua))return"Chrome OS";if(/linux/i.test(ua)&&!/android/i.test(ua))return"Linux";if(/x11|unix|bsd/i.test(ua)&&!/android|linux/i.test(ua))return"Unix";return"Unknown"}()),$.ajax({url:M.cfg.wwwroot+"/mod/quiz/accessrule/quizproctoring/ajax.php",method:"POST",data:requestData,success:function(response){response&&response.errorcode?($("#userimageset").val(0),$(document).trigger("popup",response.error)):($("#userimageset").val(1),$("#id_consentcheckbox").is(":checked")&&$("#id_submitbutton").prop("disabled",!1))}})},Camera.prototype.proctoringimage=function(){var requestData={cmid:this.cmid,attemptid:this.attemptid,mainimage:this.mainimage};if(this.canvas){const video=this.video,canvas=this.canvas,outputWidth=280,outputHeight=240,targetRatio=outputWidth/outputHeight,vw=video.videoWidth||video.clientWidth,vh=video.videoHeight||video.clientHeight;let sx=0,sy=0,sw=vw,sh=vh;vw/vh>targetRatio?(sh=vh,sw=vh*targetRatio,sx=(vw-sw)/2):(sw=vw,sh=vw/targetRatio,sy=(vh-sh)/2),canvas.width=outputWidth,canvas.height=outputHeight;canvas.getContext("2d").drawImage(video,sx,sy,sw,sh,0,0,outputWidth,outputHeight);const data=canvas.toDataURL("image/png");requestData.imgBase64=data}$.ajax({url:M.cfg.wwwroot+"/mod/quiz/accessrule/quizproctoring/ajax.php",method:"POST",data:requestData,success:function(response){if(response&&response.errorcode){var warningsl=JSON.parse(localStorage.getItem("warningThreshold"))||0,leftwarnings=Math.max(warningsl-1,0);localStorage.setItem("warningThreshold",JSON.stringify(leftwarnings)),$(document).trigger("popup",response.error)}else response.redirect&&response.url&&(window.onbeforeunload=null,$(document).trigger("popup",response.msg),setTimeout((function(){window.location.href=encodeURI(response.url)}),3e3))}})},Camera.prototype.resetcamera=function(){this.canvas.getContext("2d").clearRect(0,0,this.canvas.width,this.canvas.height),$("#"+this.canvasid).hide(),$("#"+this.retakeid).hide(),$("#"+this.videoid).show(),$("#"+this.takepictureid).show(),$("#userimageset").val(0),$("#id_submitbutton").prop("disabled",!0)};var externalserver="https://stream.proctorlink.com",localMediaStream=null;let hiddenCloseButton=null;Camera.prototype.retake=function(){$("#userimageset").val(0),$("#"+this.videoid).show(this.cmid),$("#"+this.takepictureid).show(),$("#"+this.canvasid).hide(),$("#"+this.retakeid).hide(),$("#id_submitbutton").prop("disabled",!0)},Camera.prototype.showpopup=function(event,message){return this.activeModal&&(this.activeModal.hide(),this.activeModal.destroy()),ModalFactory.create({body:message}).then((modal=>(this.activeModal=modal,modal.show(),null))).catch((()=>{!function(message){$(".custom-modal").remove();const modalHtml='\n        <div class="custom-modal show" role="dialog" aria-modal="true" tabindex="-1">\n            <div class="custom-modal-dialog modal-dialog-scrollable">\n                <div class="custom-modal-content">\n                    <div class="custom-modal-header">\n                        <h5 class="custom-modal-title"></h5>\n                        <button type="button" class="custom-close-btn" aria-label="Close">&times;</button>\n                    </div>\n                    <div class="custom-modal-body">\n                        '.concat(message,"\n                    </div>\n                </div>\n            </div>\n        </div>\n    ");$("body").append(modalHtml),$(".custom-modal").fadeIn(),$(".custom-close-btn").click((function(){closeCustomModal()})),$(document).on("click",(function(e){const $modalContent=$(".custom-modal-content");$modalContent.is(e.target)||0!==$modalContent.has(e.target).length||closeCustomModal()})),$(document).on("keydown",(function(e){"Escape"===e.key&&closeCustomModal()}))}(message)}))},Camera.prototype.stopcamera=function(){localMediaStream&&(localMediaStream.getTracks().forEach((function(track){track.stop()})),localMediaStream=null)};return{init:function(cmid,mainimage){let camera,verifyduringattempt=!(arguments.length>2&&void 0!==arguments[2])||arguments[2],attemptid=arguments.length>3&&void 0!==arguments[3]?arguments[3]:null,teacher=arguments.length>4?arguments[4]:void 0,quizid=arguments.length>5?arguments[5]:void 0,enableeyecheckreal=arguments.length>6?arguments[6]:void 0,studenthexstring=arguments.length>7?arguments[7]:void 0,onlinestudent=arguments.length>8&&void 0!==arguments[8]?arguments[8]:0,securewindow=arguments.length>9&&void 0!==arguments[9]?arguments[9]:null,userfullname=arguments.length>10?arguments[10]:void 0,enablestudentvideo=arguments.length>11&&void 0!==arguments[11]?arguments[11]:1,enablerecordaudio=arguments.length>12&&void 0!==arguments[12]?arguments[12]:0,setinterval=arguments.length>13&&void 0!==arguments[13]?arguments[13]:300,warnings=arguments.length>14&&void 0!==arguments[14]?arguments[14]:0,userid=arguments.length>15?arguments[15]:void 0,usergroup=arguments.length>16&&void 0!==arguments[16]?arguments[16]:"",detectionval=arguments.length>17&&void 0!==arguments[17]?arguments[17]:null;if(verifyduringattempt){localStorage.setItem("quizid",JSON.stringify(quizid)),localStorage.setItem("warningThreshold",JSON.stringify(warnings)),document.addEventListener("keydown",(function(event){!event.ctrlKey&&!event.metaKey||"c"!==event.key&&"v"!==event.key||event.preventDefault()})),document.addEventListener("dragstart",(function(event){event.preventDefault()})),document.addEventListener("drop",(function(event){event.preventDefault()})),document.addEventListener("contextmenu",(function(event){event.preventDefault()}));var room="".concat(studenthexstring,"_").concat(quizid);if(""!=usergroup&&(room="".concat(studenthexstring,"_").concat(quizid,"_").concat(usergroup)),onlinestudent){const iframeContainer=$("<div>").addClass("student-iframe-container").css({display:"block"}),baseUrl="".concat(externalserver,"/student"),params=new URLSearchParams({id:studenthexstring,name:userfullname,examId:quizid,attemptid:attemptid,room:room}),iframeUrl="".concat(baseUrl,"?").concat(params.toString()),iframe=$("<iframe>").attr({src:iframeUrl,width:"100%",height:"480",frameborder:"0",allow:"camera; microphone",style:"position: absolute; bottom: 20px; right: 20px; z-index: 9999; width: 230px; height: 173px; border-radius: 3px; "}).on("load",(function(){iframe[0].contentWindow.postMessage({type:"init",timestamp:Date.now()},externalserver)}));if(iframeContainer.append(iframe),$("body").append(iframeContainer),$("<video>").attr({id:"video",class:"quizaccess_quizproctoring-video",width:"280",height:"240",autoplay:"autoplay"}).css("display",enablestudentvideo?"block":"none").appendTo("body"),$("<canvas>").attr({id:"canvas",width:"280",height:"240",style:"display: none;"}).appendTo("body"),verifyduringattempt){document.addEventListener("visibilitychange",(function(){"visible"===document.visibilityState&&visibilitychange(cmid,attemptid,mainimage)})),camera=new Camera(cmid,mainimage,attemptid,quizid);let iframeReady=!1,responseReceived=!0;window.addEventListener("message",(function(event){if(event.origin===externalserver){const data=event.data;if("ready"===data.type){iframeReady=!0;const waitForElements=setInterval((()=>{const vElement=document.getElementById("video"),cElement=document.getElementById("canvas");if(vElement&&cElement&&(navigator.mediaDevices.getUserMedia({video:!0,audio:!0}).then((stream=>(vElement.srcObject=stream,vElement.play(),vElement.muted=!0,restoreVideoPosition(vElement),makeDraggable(vElement),enablerecordaudio&&useraudiorecord(stream),$(".student-iframe-container").css({display:"none"}),stream))).catch((err=>{if("NotAllowedError"===err.name||"PermissionDeniedError"===err.name)throw $(".student-iframe-container").css({display:"none"}),$.ajax({url:M.cfg.wwwroot+"/mod/quiz/accessrule/quizproctoring/ajax.php",method:"POST",data:{cmid:cmid,attemptid:attemptid,mainimage:mainimage},success:function(response){if(response&&response.errorcode){const warningsl=JSON.parse(localStorage.getItem("warningThreshold"))||0,leftwarnings=Math.max(warningsl-1,0);localStorage.setItem("warningThreshold",JSON.stringify(leftwarnings)),$(document).trigger("popup",response.error)}else response.redirect&&response.url&&(window.onbeforeunload=null,$(document).trigger("popup",response.msg),setTimeout((function(){window.location.href=encodeURI(response.url)}),3e3))}}),err})),clearInterval(waitForElements),enableeyecheckreal)){const faceMesh=new FaceMesh({locateFile:file=>"https://cdn.jsdelivr.net/npm/@mediapipe/face_mesh@0.4/".concat(file)});"undefined"!=typeof setupFaceMesh&&setupFaceMesh(vElement,cElement,faceMesh,detectionval,(function(result){result.status&&realtimeDetection(cmid,attemptid,mainimage,result.status,result.data)}))}}),500)}else if("proctoring_image"===data.type){if(responseReceived=!0,ismobiledevice()&&"hidden"===document.visibilityState)return;var context=camera.canvas.getContext("2d"),img=new Image;img.onload=function(){const canvas=camera.canvas,iw=img.naturalWidth,ih=img.naturalHeight;let sx=0,sy=0,sw=iw,sh=ih;iw/ih>1.1666666666666667?(sh=ih,sw=1.1666666666666667*ih,sx=(iw-sw)/2):(sw=iw,sh=iw/1.1666666666666667,sy=(ih-sh)/2),canvas.width=280,canvas.height=240,context.drawImage(img,sx,sy,sw,sh,0,0,280,240);var imageData=canvas.toDataURL("image/png");$.ajax({url:M.cfg.wwwroot+"/mod/quiz/accessrule/quizproctoring/ajax.php",method:"POST",data:{imgBase64:imageData,cmid:camera.cmid,attemptid:camera.attemptid,mainimage:camera.mainimage},success:function(response){if(response&&response.errorcode){var warningsl=JSON.parse(localStorage.getItem("warningThreshold"))||0,leftwarnings=Math.max(warningsl-1,0);localStorage.setItem("warningThreshold",JSON.stringify(leftwarnings)),$(document).trigger("popup",response.error)}else response.redirect&&response.url&&(window.onbeforeunload=null,$(document).trigger("popup",response.msg),setTimeout((function(){window.location.href=encodeURI(response.url)}),3e3))}})},img.src=data.imageData}else"proctoring-alert"===data.type?$.ajax({url:M.cfg.wwwroot+"/mod/quiz/accessrule/quizproctoring/ajax_sendalert.php",method:"POST",data:{quizid:quizid,userid:userid,attemptid:attemptid,alertmessage:data.text,teacherid:data.teacherid},success:function(response){response&&response.errorcode?$(document).trigger("popup",response.error):response.success&&$(document).trigger("popup",data.text)}}):"disable-eye-tracking"===data.type?$.ajax({url:M.cfg.wwwroot+"/mod/quiz/accessrule/quizproctoring/ajax_realtime.php",method:"POST",data:{cmid:camera.cmid,attemptid:attemptid,teachersub:1,validate:"eyecheckoff"},success:function(response){"eyecheckoff"===response.status&&$(document).trigger("eye-tracking-disabled")}}):"terminate-quiz"===data.type&&$.ajax({url:M.cfg.wwwroot+"/mod/quiz/accessrule/quizproctoring/ajax_sendalert.php",method:"POST",data:{quizid:quizid,userid:userid,attemptid:attemptid,quizsubmit:1},success:function(response){response&&response.errorcode?$(document).trigger("popup",response.error):response.success&&(window.onbeforeunload=null,$(document).trigger("popup",response.msg),setTimeout((function(){window.location.href=encodeURI(response.url)}),3e3))}})}})),setInterval((function(){if(iframeReady){if(!responseReceived){if(ismobiledevice()&&"hidden"===document.visibilityState)return;$.ajax({url:M.cfg.wwwroot+"/mod/quiz/accessrule/quizproctoring/ajax.php",method:"POST",data:{cmid:cmid,attemptid:attemptid,mainimage:mainimage},success:function(response){if(response&&response.errorcode){const warningsl=JSON.parse(localStorage.getItem("warningThreshold"))||0,leftwarnings=Math.max(warningsl-1,0);localStorage.setItem("warningThreshold",JSON.stringify(leftwarnings)),$(document).trigger("popup",response.error)}else response.redirect&&response.url&&(window.onbeforeunload=null,$(document).trigger("popup",response.msg),setTimeout((function(){window.location.href=encodeURI(response.url)}),3e3))}})}responseReceived=!1;try{iframe[0].contentWindow.postMessage({type:"get_proctoring_image",timestamp:Date.now()},externalserver)}catch(error){iframeReady=!1}}else iframe[0].contentWindow.postMessage({type:"init",timestamp:Date.now(),lang:$("html").attr("lang")||"en"},externalserver)}),1e3*setinterval)}}else{if(enableeyecheckreal){const waitForElements=setInterval((()=>{const vElement=document.getElementById("video"),cElement=document.getElementById("canvas");if(vElement&&cElement){const faceMesh=new FaceMesh({locateFile:file=>"https://cdn.jsdelivr.net/npm/@mediapipe/face_mesh@0.4/".concat(file)});clearInterval(waitForElements),"undefined"!=typeof setupFaceMesh&&setupFaceMesh(vElement,cElement,faceMesh,detectionval,(function(result){result.status&&realtimeDetection(cmid,attemptid,mainimage,result.status,result.data)}))}}),500)}setupLocalMedia(cmid,mainimage,verifyduringattempt,attemptid,teacher,enablestudentvideo,enablerecordaudio,setinterval,quizid)}}else if(localStorage.removeItem("eyecheckoff"),"complete"===document.readyState?$(".quizstartbuttondiv [type=submit]").prop("disabled",!1):$(window).on("load",(function(){$(".quizstartbuttondiv [type=submit]").prop("disabled",!1)})),camera=new Camera(cmid,mainimage,attemptid,quizid),$(".quizstartbuttondiv [type=submit]").on("click",(function(){localStorage.removeItem("videoPosition"),camera.startcamera()})),$("#"+camera.takepictureid).on("click",(function(e){e.preventDefault(),camera.takepicture()})),$("#"+camera.retakeid).on("click",(function(e){e.preventDefault(),camera.retake()})),$("#id_cancel").on("click",(function(){camera.stopcamera(),camera.resetcamera(),$("#id_submitbutton").prop("disabled",!0),localStorage.removeItem("videoPosition")})),$(document).on("click",".filemanager",(function(e){e.preventDefault(),hiddenCloseButton=$(this).closest(".moodle-dialogue-base").find(".closebutton"),hiddenCloseButton.hide()})),$(document).on("click",".mod_quiz_preflight_popup .closebutton",(function(){void 0!==camera&&"function"==typeof camera.stopcamera&&(camera.stopcamera(),camera.resetcamera(),$("#id_submitbutton").prop("disabled",!0),localStorage.removeItem("videoPosition"))})),$(document).on("click",".closebutton",(function(){hiddenCloseButton&&(hiddenCloseButton.show(),hiddenCloseButton=null)})),document.addEventListener("keydown",(function(event){"Escape"===event.key&&(camera.stopcamera(),camera.resetcamera(),$("#id_submitbutton").prop("disabled",!0),localStorage.removeItem("videoPosition"))})),"securewindow"===securewindow){window.location.href.includes("startattempt.php")&&camera.startcamera()}}};function setupLocalMedia(cmid,mainimage,verifyduringattempt,attemptid,teacher,enablestudentvideo,enablerecordaudio,setinterval,quizid,callback){require(["core/ajax"],(function(){null===localMediaStream?"teacher"!==getTeacherroom()?(navigator.getUserMedia=navigator.getUserMedia||navigator.webkitGetUserMedia||navigator.mozGetUserMedia||navigator.msGetUserMedia,navigator.mediaDevices.getUserMedia({audio:true,video:true}).then((function(stream){localMediaStream=stream,verifyduringattempt&&($("<canvas>").attr({id:"canvas",width:"280",height:"240",style:"display: none;"}).appendTo("body"),$("<video>").attr({id:"video",class:"quizaccess_quizproctoring-video",width:"280",height:"240",autoplay:"autoplay"}).css("display",enablestudentvideo?"block":"none").appendTo("body"),enablerecordaudio&&useraudiorecord(stream));let allowproctoring=!0;document.addEventListener("visibilitychange",(function(){ismobiledevice()?"hidden"===document.visibilityState?allowproctoring=!1:(allowproctoring=!0,visibilitychange(cmid,attemptid,mainimage)):"visible"===document.visibilityState&&visibilitychange(cmid,attemptid,mainimage)}));var camera=new Camera(cmid,mainimage,attemptid,quizid);camera.startcamera();let intervalinms=1e3*setinterval,randomdelayms=Math.floor(Math.random()*intervalinms)+1;return setTimeout((function(){setInterval((function(){allowproctoring&&camera.proctoringimage()}),intervalinms)}),randomdelayms),stream})).catch((function(error){if(verifyduringattempt){if("teacher"!==getTeacherroom()){var camera=new Camera(cmid,mainimage,attemptid,quizid);camera.startcamera(),setInterval(camera.proctoringimage.bind(camera),1e3*setinterval)}document.addEventListener("visibilitychange",(function(){"visible"===document.visibilityState&&visibilitychange(cmid,attemptid,mainimage)}))}throw error})).finally((function(){callback&&callback()}))):(localMediaStream=function(){const dummyAudio=(new AudioContext).createMediaStreamDestination(),dummyVideo=document.createElement("canvas").captureStream(0),dummyStream=new MediaStream;return dummyStream.addTrack(dummyAudio.stream.getAudioTracks()[0]),dummyStream.addTrack(dummyVideo.getVideoTracks()[0]),dummyStream}(),callback&&callback()):callback&&callback()}))}function ismobiledevice(){return/Mobi|Android|iPhone|iPad|iPod|Opera Mini|IEMobile|WPDesktop/i.test(navigator.userAgent)}function visibilitychange(cmid,attemptid,mainimage){var warningsl=JSON.parse(localStorage.getItem("warningThreshold"))||0,leftwarnings=Math.max(warningsl-1,0);localStorage.setItem("warningThreshold",JSON.stringify(leftwarnings));let message=M.util.get_string("tabwarning","quizaccess_quizproctoring");1===leftwarnings?message=M.util.get_string("tabwarningoneleft","quizaccess_quizproctoring"):leftwarnings>1&&(message=M.util.get_string("tabwarningmultiple","quizaccess_quizproctoring",leftwarnings)),$(document).trigger("popup",message),$.ajax({url:M.cfg.wwwroot+"/mod/quiz/accessrule/quizproctoring/ajax.php",method:"POST",data:{cmid:cmid,attemptid:attemptid,mainimage:mainimage,tab:!0},success:function(response){response.redirect&&response.url&&(window.onbeforeunload=null,$(document).trigger("popup",response.msg),setTimeout((function(){window.location.href=encodeURI(response.url)}),3e3))}})}function getTeacherroom(){return new URLSearchParams(window.location.search).get("teacher")}function restoreVideoPosition(element){const savedPosition=localStorage.getItem("videoPosition");if(savedPosition){const{left:left,top:top}=JSON.parse(savedPosition);element.style.left="".concat(left,"px"),element.style.top="".concat(top,"px")}}function makeDraggable(element){let offsetX=0,offsetY=0,isDragging=!1;function moveElement(clientX,clientY){let newLeft=clientX-offsetX,newTop=clientY-offsetY;const maxLeft=window.innerWidth-element.offsetWidth,maxTop=window.innerHeight-element.offsetHeight;newLeft=Math.max(0,Math.min(newLeft,maxLeft)),newTop=Math.max(0,Math.min(newTop,maxTop)),"fixed"!==element.style.position&&(element.style.position="fixed"),element.style.left="".concat(newLeft,"px"),element.style.top="".concat(newTop,"px")}function endDrag(){isDragging&&(isDragging=!1,element.style.cursor="grab",localStorage.setItem("videoPosition",JSON.stringify({left:parseInt(element.style.left,10),top:parseInt(element.style.top,10)})))}element.addEventListener("mousedown",(function(e){isDragging=!0,offsetX=e.clientX-element.getBoundingClientRect().left,offsetY=e.clientY-element.getBoundingClientRect().top,element.style.cursor="grabbing"})),document.addEventListener("mousemove",(function(e){isDragging&&requestAnimationFrame((()=>{moveElement(e.clientX,e.clientY)}))})),document.addEventListener("mouseup",(function(){endDrag()})),element.addEventListener("touchstart",(function(e){isDragging=!0;const touch=e.touches[0];offsetX=touch.clientX-element.getBoundingClientRect().left,offsetY=touch.clientY-element.getBoundingClientRect().top})),document.addEventListener("touchmove",(function(e){if(!isDragging)return;const touch=e.touches[0];requestAnimationFrame((()=>{moveElement(touch.clientX,touch.clientY)}))})),document.addEventListener("touchend",(function(){endDrag()}))}function realtimeDetection(cmid,attemptid,mainimage,face,data){var requestData={cmid:cmid,attemptid:attemptid,mainimage:mainimage,validate:face,imgBase64:data};$.ajax({url:M.cfg.wwwroot+"/mod/quiz/accessrule/quizproctoring/ajax_realtime.php",method:"POST",data:requestData,success:function(response){if(response&&"eyecheckoff"===response.status)$(document).trigger("eye-tracking-disabled");else if(response&&"eyecheckon"===response.status){if($(document).trigger("eye-tracking-enabled"),response.errorcode){const warningsl=JSON.parse(localStorage.getItem("warningThreshold"))||0,leftwarnings=Math.max(warningsl-1,0);localStorage.setItem("warningThreshold",JSON.stringify(leftwarnings)),$(document).trigger("popup",response.error)}}else if(response&&response.errorcode){const warningsl=JSON.parse(localStorage.getItem("warningThreshold"))||0,leftwarnings=Math.max(warningsl-1,0);localStorage.setItem("warningThreshold",JSON.stringify(leftwarnings)),$(document).trigger("popup",response.error)}else response.redirect&&response.url&&(window.onbeforeunload=null,$(document).trigger("popup",response.msg),setTimeout((function(){window.location.href=encodeURI(response.url)}),3e3))}})}function closeCustomModal(){$(".custom-modal").fadeOut((function(){$(this).remove()})),$(document).off("click"),$(document).off("keydown")}}));

//# sourceMappingURL=add_camera.min.js.map