<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This file contains the Activity modules block.
 *
 * @package    block_blc_modules
 * @copyright  1999 onwards Martin Dougiamas (http://dougiamas.com)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
 
defined('MOODLE_INTERNAL') || die();

class block_blc_modules_edit_form extends block_edit_form {
    /**
     * The definition of the fields to use.
     *
     * @param MoodleQuickForm $mform
     */
    protected function specific_definition($mform) {
        global $DB;

        // Load defaults.
        $blockconfig = get_config('block_blc_modules');

        // Fields for editing blc_modules block title and contents.
        $mform->addElement('header', 'configheader', get_string('blocksettings', 'block'));

        if (has_capability('moodle/site:config', context_system::instance())) {
            $mform->addElement('text', 'api_key',
                    get_string('api_key', 'block_blc_modules'));
            $mform->setDefault('api_key', $blockconfig->api_key);
            $mform->setType('api_key', PARAM_TEXT);
        }
   
    }
}
