<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Themes Almondb lang file.
 *
 * @package   theme_almondb
 * @copyright 2022 ThemesAlmond  - http://themesalmond.com
 * @author    ThemesAlmond - Developer Team
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advancedsettings'] = 'Advanced settings';
$string['backgroundimage'] = 'Background image';
$string['backgroundimage_desc'] = 'The image to display as a background of the site. The background image you upload here will override the background image in your theme preset files.';
$string['brandcolor'] = 'Brand colour';
$string['brandcolor_desc'] = 'The accent colour.';
$string['bootswatch'] = 'Bootswatch';
$string['bootswatch_desc'] = 'A bootswatch is a set of Bootstrap variables and css to style Bootstrap';
$string['choosereadme'] = 'Almondb is a modern highly-customisable theme. This theme is intended to be used directly, or as a parent theme when creating new themes utilising Bootstrap 4.';
$string['configtitle'] = 'Almondb';
$string['generalsettings'] = 'General settings';
$string['loginbackgroundimage'] = 'Login page background image';
$string['loginbackgroundimage_desc'] = 'The image to display as a background for the login page.';
$string['nobootswatch'] = 'None';
$string['pluginname'] = 'Almondb';
$string['presetfiles'] = 'Additional theme preset files';
$string['presetfiles_desc'] = 'Preset files can be used to dramatically alter the appearance of the theme. See <a href="https://docs.moodle.org/dev/Almondb_Presets">Almondb presets</a> for information on creating and sharing your own preset files, and see the <a href="https://moodle.net/search?q=boost+presets">Presets repository</a> for presets that others have shared.';
$string['preset'] = 'Theme preset';
$string['preset_desc'] = 'Pick a preset to broadly change the look of the theme.';
$string['privacy:metadata'] = 'The Almondb theme does not store any personal data about any user.';
$string['rawscss'] = 'Raw SCSS';
$string['rawscss_desc'] = 'Use this field to provide SCSS or CSS code which will be injected at the end of the style sheet.';
$string['rawscsspre'] = 'Raw initial SCSS';
$string['rawscsspre_desc'] = 'In this field you can provide initialising SCSS code, it will be injected before everything else. Most of the time you will use this setting to define variables.';
$string['region-side-pre'] = 'Right';
$string['showfooter'] = 'Show footer';
$string['unaddableblocks'] = 'Unneeded blocks';
$string['unaddableblocks_desc'] = 'The blocks specified are not needed when using this theme and will not be listed in the \'Add a block\' menu.';
$string['privacy:metadata:preference:draweropenblock'] = 'The user\'s preference for hiding or showing the drawer with blocks.';
$string['privacy:metadata:preference:draweropenindex'] = 'The user\'s preference for hiding or showing the drawer with course index.';
$string['privacy:metadata:preference:draweropennav'] = 'The user\'s preference for hiding or showing the drawer menu navigation.';
$string['privacy:drawerindexclosed'] = 'The current preference for the index drawer is closed.';
$string['privacy:drawerindexopen'] = 'The current preference for the index drawer is open.';
$string['privacy:drawerblockclosed'] = 'The current preference for the block drawer is closed.';
$string['privacy:drawerblockopen'] = 'The current preference for the block drawer is open.';
$string['themesettings'] = 'Theme settings';
$string['backcolor'] = 'Back colour';
$string['backcolor_desc'] = 'Background colour';
$string['navbarcolor'] = 'Navbar back colour';
$string['navbarcolor_desc'] = 'Navbar Background colour';
$string['imgloginbackground'] = 'Login background image';
$string['imgloginbackground_desc'] = 'Login background image desc';
$string['loginposition'] = 'Login form position';
$string['loginpositiondesc'] = 'Select the login form screen position';
$string['loggedinnot'] = 'log in.';
$string['footerselect'] = 'Dashboard footer';
$string['footerselectdesc'] = 'Select the dashboard form footer style';
$string['over'] = 'Over';
// Slider start !DO NOT DELETE !DO NOT CHANGE.
$string['slideshowstart'] = 'Home Page Slider Settings';
$string['slideshowstartdesc'] = '';
$string['slideshowend'] = '--*/*--';
$string['slideshowenddesc'] = '';
// Slider.
$string['slideshow'] = 'Slider';
$string['slideshowheading'] = ': Home Page Slider';
$string['slideshowheadingdesc'] = 'This creates a slide show of up to six slides for you to promote important elements of your site.  The show is responsive where image height is set according to screen size.If no image is selected for a slide, then the default images in the pix folder is used.';
$string['sliderdesign'] = 'Slider design';
$string['sliderdesigndesc'] = 'Select the slide design you want to add';
$string['sliderenabled'] = 'Enable slider';
$string['sliderenableddesc'] = 'Enable a slider at the top of your home page';
$string['slidercount'] = 'Slider count';
$string['slidercountdesc'] = 'Select how many slides you want to add <strong>then click SAVE</strong> to load the input fields.';
$string['slideno'] = '! Slide-{$a->slide}';
$string['slidenodesc'] = 'Enter the settings for slide {$a->slide}.';
$string['sliderimage'] = 'Slider picture';
$string['sliderimagedesc'] = 'Add an image for your slide. Recommended size is 1500px x 500px or higher.';
$string['slidertitle'] = 'Slide title';
$string['slidertitledesc'] = 'Add the slide\'s title.';
$string['slidercaption'] = 'Slider caption';
$string['slidercaptiondesc'] = 'Add a caption for your slide';
$string['sliderbutton'] = 'Slider button';
$string['sliderbuttondesc'] = 'Enter the target destination of the slide\'s image button text,
either language key or Text.For ex: lang:display or Display';
$string['sliderbuttonurl'] = 'Slide button link';
$string['sliderbuttonurldesc'] = 'Enter the target destination of the slide\'s image button link';
$string['slidershowheight'] = 'Slidershow Height';
$string['slidershowheight_desc'] = 'Adjust the height of the slideshow on the Site Home pages.';
$string['slideropacity'] = 'Slider opacity';
$string['slideropacitydesc'] = 'Frontpage color opacity to slider';
// Almondbpage start !DO NOT DELETE !DO NOT CHANGE.
$string['almondbpagestart'] = 'Info Page Settings';
$string['almondbpagestartdesc'] = '';
$string['almondbpageend'] = '--*/*--';
$string['almondbpageenddesc'] = '';
// Almondbpage.
$string['almondbpage'] = 'Info Pages';
$string['almondbpageheading'] = ': Advanced Page Settings';
$string['almondbpageheadingdesc'] = 'This creates of up to six info page for you to promote important elements of your site.';
$string['almondbpageenabled'] = 'Enable almondbpage';
$string['almondbpageenableddesc'] = 'Enable a almondbpage at the top of your home page';
$string['almondbpagecount'] = 'Page count';
$string['almondbpagecountdesc'] = 'Select how many pages you want to add <strong>then click SAVE</strong> to load the input fields.';
$string['almondbpageno'] = '! Page-{$a->almondbpage}';
$string['almondbpagenodesc'] = 'Enter the settings for page {$a->almondbpage}. <b><i>PAGE LINK: www.yoursite/local/almondbpage/?id=a{$a->almondbpage}</i></b>';
$string['almondbpagedesign'] = 'Page design';
$string['almondbpagedesigndesc'] = 'Select the page design you want to add. You can quickly create your pages using a simple design.
                                In a simple design, use only the image and subtitle part.';
$string['almondbpageimage'] = 'Page picture';
$string['almondbpageimagedesc'] = 'Add an image for your page.';
$string['almondbpagetitle'] = 'Page title';
$string['almondbpagetitledesc'] = 'Add the page\'s title.';
$string['almondbpagecaption'] = 'Page caption';
$string['almondbpagecaptiondesc'] = 'Add a caption for your page';
$string['almondbpagecss'] = 'Page css';
$string['almondbpagecssdesc'] = 'Add a css for your page';
$string['almondbpagecsslink'] = 'Page css link';
$string['almondbpagecsslinkdesc'] = 'Add a css link for your page,
            Example : "https://www.exaple.com/abc.css"';
$string['almondbpageimglink'] = 'Page img folder link';
$string['almondbpageimglinkdesc'] = 'Add a img folder link for your page, Copy your images that you use in html to this folder.
            If you fill in the image folder field, do not give the image path in html,
            just write it as demo-1.png (or jpg).
            Example: http://www.exaple.com/img/ , (img src= demo-1.jpg)';
$string['almondbpagenavbar'] = 'Page navbar';
$string['almondbpagenavbardesc'] = 'Add navbar to info page';
$string['almondbpageheader'] = 'Page header';
$string['almondbpageheaderdesc'] = 'Add header to info page';
$string['almondbpagefooter'] = 'Page footer';
$string['almondbpagefooterdesc'] = 'Add footer to info page';
$string['almondbpagenotfound'] = 'Page not found, please check url';
// Almondbpage simple.
$string['almondbpageheadingsimple'] = '! Simple Page Settings';
$string['almondbpageheadingsimpledesc'] = 'This creates of up to six info page for you to promote important elements of your site.';
$string['almondbpageenabledsimple'] = 'Enable almondbpage';
$string['almondbpageenabledsimpledesc'] = 'Enable a almondbpage at the top of your home page';
$string['almondbpagecountsimple'] = 'Page count';
$string['almondbpagecountsimpledesc'] = 'Select how many pages you want to add <strong>then click SAVE</strong> to load the input fields.';
$string['almondbpagenosimple'] = '! Page-{$a->almondbpage}';
$string['almondbpagenosimpledesc'] = 'Enter the settings for page {$a->almondbpage}. <b><i>PAGE LINK: www.yoursite/local/almondbpage/?id=s{$a->almondbpage}</i></b>';
$string['almondbpagetitlesimple'] = 'Page title';
$string['almondbpagetitlesimpledesc'] = 'Add the page\'s title.';
$string['almondbpageimagesimple'] = 'Page picture';
$string['almondbpageimagesimpledesc'] = 'Add an image for your page.';
$string['almondbpageimgpositionsimple'] = 'Page picture position';
$string['almondbpageimgpositionsimpledesc'] = 'Where the uploaded image will be located on the page.';
$string['almondbpagecaptionsimple'] = 'Page caption';
$string['almondbpagecaptionsimpledesc'] = 'Add a caption for your page';
$string['almondbpageheadersimple'] = 'Page header';
$string['almondbpageheadersimpledesc'] = 'Add header to info page';
$string['almondbpagefootersimple'] = 'Page footer';
$string['almondbpagefootersimpledesc'] = 'Add footer to info page';
// Button settings.
$string['button'] = 'Button';
$string['buttonlink'] = 'https://themesalmond.com/';
// Theme almondb settings !DO NOT DELETE !DO NOT CHANGE.
$string['divdiv'] = '</div></div></div>';
$string['div'] = '</div>';
$string['frontpageend'] = '--*/*--';
$string['frontpageenddesc'] = '';
$string['frontpagealmondb'] = 'Front Page';
// Dashboard choice heading (nav).
$string['dashboardnavchoice'] = 'Dashboard page nav';
$string['dashboardnavchoicedesc'] = 'Select dashboard page nav to display';
// Frontpage choice heading (nav).
$string['frontpagenav'] = ': Front Page Header Choice';
$string['frontpagenavdesc'] = 'Select front page header to display';
$string['frontpagenavchoice'] = 'Front page nav';
$string['frontpagenavchoicedesc'] = 'Select front page nav to display';
$string['navbarcontainer'] = 'Container add';
$string['navbarcontainerdesc'] = 'You can throw the navigation bar inside the container';
$string['headerlogo'] = 'Select the navbar logo';
$string['headerlogodesc'] = 'Select front page nav logo display';
$string['frontpagenavlightdark'] = 'Front page light-dark';
$string['frontpagenavlightdarkdesc'] = 'If you chose dark color above, choose "navbar-dark".';
$string['frontpagenavlink'] = 'Front page nav link';
$string['frontpagenavlinkdesc'] = 'Enter front page navigation bar links';
$string['frontpagenavlinkdefault'] = 'Courses
-All courses|/course/
-Course search|/course/search.php|_blank
Smooth
-Title box|#block01
-Icon box|#block02
-Features|#block03
-Latest|#block04
-WHY we|#block05
-Working with us|#block06
-Course|#block07
-Teacher|#block08
-Category|#block09
-Testimonials|#block10|_self
-Blog posts|#block11|_self
-Block HTML|#block18|_self
-Brands|#block19
-Footer|#block20
Teachers|#block08
Blog|/blog/
Documentation|https://themesalmond.com/documents/|_blank';
$string['header3phone'] = 'Phone Number';
$string['header3phonedesc'] = 'Contact phone number to show in the navigation bar.';
// Frontpage choice HTML.
$string['frontpageheading'] = '! Front Page Choice';
$string['frontpagedesc'] = 'Select front page to display';
$string['frontpagechoice'] = 'Select Front Page';
$string['frontpagechoicedesc'] = 'Select front page to display';
$string['frontpagecolor'] = 'Select front page color default';
$string['frontpagecolordesc'] = '<div class="row pb-3">
                                    <div class="col p-1 text-center" style="background-color:#4272d7;"> 1-#4272d7</div>
                                    <div class="col p-1 text-center" style="background-color:#f98012;"> 2-#f98012</div>
                                    <div class="col p-1 text-center" style="background-color:#fa4251;"> 3-#fa4251</div>
                                    <div class="col p-1 text-center" style="background-color:#c45e28;"> 4-#c45e28</div>
                                    <div class="col p-1 text-center" style="background-color:#63c76a;"> 5-#63c76a</div>
                                    <div class="col p-1 text-center" style="background-color:#024E64;"> 6-#024E64</div>
                                </div> ';
$string['sitecolor'] = 'Select front fage color';
$string['sitecolor_desc'] = 'You can choose the color you want except the default';
// Site color default.
$string['sitecolor-1'] = '#4272d7';
$string['sitecolor-2'] = '#f98012';
$string['sitecolor-3'] = '#fa4251';
$string['sitecolor-4'] = '#c45e28';
$string['sitecolor-5'] = '#63c76a';
$string['sitecolor-6'] = '#024E64';
// Color end.
$string['frontpageheading1'] = '! Front page SECTION';
$string['frontpageheadingdesc1'] = 'front page section selection number one
<br><a href="./../theme/almondb/pix/almondb/slide_01.jpg" target="_blank">Click to see blocks</a>';
$string['frontpagesection1_1'] = 'Section 1';
$string['frontpagesectiondesc1_1'] = 'Front page section 1 ';
$string['frontpagesection1_2'] = 'Section 2';
$string['frontpagesectiondesc1_2'] = 'Front page section 2';
$string['frontpagesection1_3'] = 'Section 3';
$string['frontpagesectiondesc1_3'] = 'Front page section 3';
$string['frontpagesection1_4'] = 'Section 4';
$string['frontpagesectiondesc1_4'] = 'Front page section 4';
$string['frontpagesection1_5'] = 'Section 5';
$string['frontpagesectiondesc1_5'] = 'Front page section 5';
$string['frontpagesection1_6'] = 'Section 6';
$string['frontpagesectiondesc1_6'] = 'Front page section 6';
$string['frontpagesection1_7'] = 'Section 7';
$string['frontpagesectiondesc1_7'] = 'Front page section 7';
$string['frontpagesection1_8'] = 'Section 8';
$string['frontpagesectiondesc1_8'] = 'Front page section 8';
$string['frontpagesection1_9'] = 'Section 9';
$string['frontpagesectiondesc1_9'] = 'Front page section 9';
$string['frontpagesection1_10'] = 'Section 10';
$string['frontpagesectiondesc1_10'] = 'Front page section 10';
// Frontpage HTML block.
$string['theme_almondb_frontpageblock'] = 'Block';
$string['theme_almondb_frontpageblockheading'] = 'Front Page Blocks';
$string['theme_almondb_frontpageblockdesc'] = 'Front Page HTML blocks settings';
// Frontpage HTML block 1.
$string['block01info'] = ': Block-1 TITLE BOX';
$string['block01infodesc'] = 'TITLE BOX - Enter the settings for block 1';
$string['block01enabled'] = 'Enable block 1';
$string['block01enableddesc'] = 'Enable or disabled block 1 at the your home page';
$string['block01caption'] = 'Block 1 caption';
$string['block01captiondesc'] = 'Add a caption for your block 1';
$string['block01captiondefault'] = '<h2 class="white">Featured Premium Themes</h2><br>
<p class="white">Themes is built without disturbing the moodle layout, so it will make your work easier. Check out some of the main features of Themes.</p>';
$string['block01button'] = 'Block 1 button';
$string['block01buttondesc'] = 'Add a button for your block 1';
$string['block01buttonlink'] = 'Block 1 URL';
$string['block01buttonlinkdesc'] = 'Add a URL for your block 1';
$string['block01color'] = 'Block 1 background color';
$string['block01colordesc'] = 'Add a background color for your block 1';
// Frontpage HTML block 2.
$string['block02info'] = '! Block-2 ICON BOX';
$string['block02infodesc'] = 'ICON BOX - Enter the settings for block 2';
$string['block02enabled'] = 'Enable block 2';
$string['block02enableddesc'] = 'Enable or disabled block 2 at the your home page';
$string['block02count'] = 'Block-2 Count';
$string['block02countdesc'] = 'Select the number of boxes and press the save changes button';
$string['underline'] = '<div style="margin-bottom: 10px; border-bottom:3px solid blue;width:100%;"></div><br>';
// Frontpage HTML block 2.
$string['block02icon'] = 'Block icon {$a->block}';
$string['block02icondesc'] = '<a href="https://fontawesome.com/v4.7/icons/" target="_blank">Click to view icons</a>';
$string['block02icondefault'] = '';
$string['block02title'] = 'Block title {$a->block}';
$string['block02titledesc'] = 'Add a title for your block ';
$string['block02titledefault'] = 'Top Investment Advisors';
$string['block02caption'] = 'Block caption {$a->block}';
$string['block02captiondesc'] = 'Add a caption  for your block ';
$string['block02captiondefault'] = 'Enjoy our free online courses,
wherever you are and whenever you want. Access course content on mobile, tablet or desktop';
$string['block02button'] = 'Block button {$a->block}';
$string['block02buttondesc'] = 'Add a button for your block ';
$string['block02buttonlink'] = 'Block URL {$a->block}';
$string['block02buttonlinkdesc'] = 'Add a URL  for your block ';
$string['block02imgdesc'] = 'Add a image  for your block ';
$string['sliderimageblock02img'] = 'Block img {$a->block}';
// Default fa icons.
$string['block02icondefault1'] = 'core:i/report';
$string['block02icondefault2'] = 'core:i/settings';
$string['block02icondefault3'] = 'core:i/stats';
$string['block02icondefault4'] = 'core:i/notifications';
$string['block03icondefault1'] = 'core:t/download';
$string['block03icondefault2'] = 'core:a/setting';
$string['block03icondefault3'] = 'core:docs';
$string['block03icondefault4'] = 'core:i/duration';
$string['block03icondefault5'] = 'core:i/checked';
$string['block03icondefault6'] = 'core:e/visual_aid';
$string['block05icondefault1'] = 'core:i/settings';
$string['block05icondefault2'] = 'core:i/hide';
$string['block05icondefault3'] = 'core:i/bullhorn';
// Frontpage HTML block 3.
$string['block03info'] = '! Block-3 FEATURES';
$string['block03infodesc'] = 'FEATURES - Enter the settings for block 3';
$string['block03enabled'] = 'Enable block 3';
$string['block03enableddesc'] = 'Enable or disabled block 3 at the your home page';
$string['block03design'] = 'Block 3 design';
$string['block03designdesc'] = 'Select the block 3 design you want to add';
$string['block03header'] = 'Block 3 header';
$string['block03headerdesc'] = 'Block 3 header';
$string['block03headerdefault'] = 'WE ARE THEMES ALMOND';
// Frontpage HTML block 3.
$string['block03icon'] = 'Block 3 icon {$a->block}';
$string['block03icondesc'] = '<a href="https://fontawesome.com/v4.7/icons/" target="_blank">Click to view icons</a>';
$string['block03icondefault'] = 'core:i/categoryevent';
$string['block03title'] = 'Block 3 title {$a->block}';
$string['block03titledesc'] = 'Add a title  for your block 3';
$string['block03titledefault'] = 'Responsive Design';
$string['block03caption'] = 'Block 3 caption {$a->block}';
$string['block03captiondesc'] = 'Add a caption  for your block 3';
$string['block03captiondefault'] = 'Vestibulum non diam quis nisl dignissim posuere a vulputate urna nunc velit';
$string['block03link'] = 'Block 3 URL {$a->block}';
$string['block03linkdesc'] = 'Add a URL  for your block 3';
// Frontpage HTML block 4.
$string['block04info'] = '! Block-4 LATEST';
$string['block04infodesc'] = 'LATEST - Enter the settings for block 4';
$string['block04enabled'] = 'Enable block 4';
$string['block04enableddesc'] = 'Enable or disabled block 4 at the your home page';
$string['block04design'] = 'Block 4 design';
$string['block04designdesc'] = 'Select the block 4 design you want to add';
$string['block04header'] = 'Block 4 header';
$string['block04headerdesc'] = 'Block 4 header';
$string['block04headerdefault'] = 'LATEST PROJECTS';
$string['block04button'] = 'Block 4 button text';
$string['block04buttondesc'] = 'Block 4 button text';
$string['block04buttondefault'] = 'View All Courses';
$string['block04buttonlink'] = 'Block 4 button link';
$string['block04buttonlinkdesc'] = 'Block 4 button link';
$string['block04buttonlinkdefault'] = 'course/index.php';
$string['block04title'] = 'Block 4 title {$a->block}';
$string['block04titledesc'] = 'Add a title  for your block 4';
$string['block04caption'] = 'Block 4 caption {$a->block}';
$string['block04captiondesc'] = 'Add a caption  for your block 4';
$string['block04link'] = 'Block 4 URL {$a->block}';
$string['block04linkdesc'] = 'Add a URL  for your block 4';
$string['block04imgdesc'] = 'Add a image  for your block ';
$string['sliderimageblock04img'] = 'Block img {$a->block}';
// Frontpage HTML block 5.
$string['block05info'] = '! Block-5 WHY WE';
$string['block05infodesc'] = 'WHY WE - Enter the settings for block 5';
$string['block05enabled'] = 'Enable block 5';
$string['block05enableddesc'] = 'Enable or disabled block 5 at the your home page';
$string['block05design'] = 'Block 5 design';
$string['block05designdesc'] = 'Select the block 5 design you want to add';
$string['block05header'] = 'Block 5 header';
$string['block05headerdesc'] = 'Block 5 header';
$string['block05headerdefault'] = 'WHY CHOOSE US';
$string['sliderimageblock05img'] = 'Block imgage';
$string['block05imgdesc'] = 'Add a image  for your block ';
$string['block05icon'] = 'Block 5 icon {$a->block}';
$string['block05icondesc'] = '<a href="https://fontawesome.com/v4.7/icons/" target="_blank">Click to view icons</a>';
$string['block05icondefault'] = 'core:i/categoryevent';
$string['block05title'] = 'Block 5 title {$a->block}';
$string['block05titledesc'] = 'Add a title  for your block 5';
$string['block05caption'] = 'Block 5 caption {$a->block}';
$string['block05captiondesc'] = 'Add a caption  for your block 5';
$string['block05link'] = 'Block 5 URL {$a->block}';
$string['block05linkdesc'] = 'Add a URL  for your block 5';
// Frontpage HTML block 6.
$string['block06info'] = '! Block-6 WORKING WITH US';
$string['block06infodesc'] = 'WORKING WITH US - Enter the settings for block 6';
$string['block06enabled'] = 'Enable block 6';
$string['block06enableddesc'] = 'Enable or disabled block 6 at the your home page';
$string['block06design'] = 'Block 6 design';
$string['block06designdesc'] = 'Select the block 6 design you want to add';
$string['block06color'] = 'Block 6 background color';
$string['block06colordesc'] = 'Add a background color for your block 6';
$string['block06header'] = 'Block 6 header';
$string['block06headerdesc'] = 'Block 6 header';
$string['block06headerdefault'] = 'WORKİNG WİTH US';
$string['sliderimageblock06img'] = 'Block imgage';
$string['block06imgdesc'] = 'Add a image  for your block ';
$string['block06caption'] = 'Block 6 caption';
$string['block06captiondesc'] = 'Add a caption  for your block 6';
$string['block06captiondefault'] = 'Add a caption default for your block 6';
$string['block06button'] = 'Block 6 URL';
$string['block06buttondesc'] = 'Add a URL  for your block 6';
$string['block06buttonlink'] = 'Block 6 URL ';
$string['block06buttonlinkdesc'] = 'Add a URL  for your block 6';
// Frontpage HTML block 7.
$string['block07info'] = '! Block-7 AVAILABLE COURSES';
$string['block07infodesc'] = 'AVAILABLE COURSES - Enter the settings for block 7';
$string['block07enabled'] = 'Enable block 7';
$string['block07enableddesc'] = 'Enable or disabled block 7 at the your home page';
$string['block07design'] = 'Block 7 design';
$string['block07designdesc'] = 'Select the block 7 design you want to add';
$string['block07count'] = 'Block 7 count';
$string['block07countdesc'] = 'Number of courses to show';
$string['block07countdefault'] = '8';
$string['block07teacherrole'] = 'Block 7 teacher role';
$string['block07teacherroledesc'] = 'Select teacher role';
$string['block07studentrole'] = 'Block 7 student role';
$string['block07studentroledesc'] = 'Select student role';
$string['block07teacherenabled'] = 'Block 7 teacher enabled';
$string['block07teacherenableddesc'] = 'Show teacher?';
$string['block07priceshow'] = 'Show course enrol price';
$string['block07priceshowdesc'] = 'Course enrol price enable/disable';
$string['block07title'] = 'Block 7 title';
$string['block07titledesc'] = 'Course title type';
$string['block07titledefault'] = 'shortname';
$string['block07header'] = 'Block 7 header';
$string['block07headerdesc'] = 'Block 7 header';
$string['block07headerdefault'] = 'AVAILABLE COURSES';
$string['block07button'] = 'Block 7 URL';
$string['block07buttondesc'] = 'Add a URL  for your block 7';
$string['block07buttonlink'] = 'Block 7 URL ';
$string['block07buttonlinkdesc'] = 'Add a URL  for your block 7';
$string['block07tooltipcategory'] = 'Category';
$string['block07tooltipenrolled'] = 'Students Enrolled ';
$string['block07tooltiplastdate'] = 'Last Modified Date';
$string['block07enrol'] = 'Free';
// Frontpage HTML block 8.
$string['block08info'] = '! Block-8 TEACHER';
$string['block08infodesc'] = 'TEACHERS - Enter the settings for block 8';
$string['block08enabled'] = 'Enable block 8';
$string['block08enableddesc'] = 'Enable or disabled block 8 at the your home page';
$string['block08design'] = 'Block 8 design';
$string['block08designdesc'] = 'Select the block 8 design you want to add';
$string['block08total'] = 'Block 8 Total';
$string['block08totaldesc'] = 'Show total number of courses and students';
$string['block08description'] = 'Block 8 Description';
$string['block08descriptiondesc'] = 'Show user description to page.';
$string['block08showrole'] = 'Block 8 Show Role';
$string['block08showroledesc'] = 'User role to show in block 8';
$string['block08studentrole'] = 'Block 8 Student Role';
$string['block08studentroledesc'] = 'Student role';
$string['block08count'] = 'Block 8 count';
$string['block08countdesc'] = 'Number of teachers to show';
$string['block08countdefault'] = '8';
$string['block08header'] = 'Block 8 header';
$string['block08headerdesc'] = 'Block 8 header';
$string['block08headerdefault'] = 'TEACHERS';
$string['block08caption'] = 'Block 8 caption';
$string['block08captiondesc'] = 'Block 8 caption';
$string['block08captiondefault'] = 'We continue to serve with our distinguished teacher staff. Meet our teachers.';
$string['block08tooltipcourse'] = "Teacher's total number of courses";
$string['block08tooltipstudents'] = "Teacher's total number of students";
// Frontpage HTML block 9.
$string['block09info'] = '! Block-9 CATEGORIES';
$string['block09infodesc'] = 'CATEGORIES - Enter the settings for block 9';
$string['block09enabled'] = 'Enable block 9';
$string['block09enableddesc'] = 'Enable or disabled block 9 at the your home page';
$string['block09design'] = 'Block 9 design';
$string['block09designdesc'] = 'Select the block 9 design you want to add';
$string['block09background'] = 'Block 9 Background';
$string['block09backgrounddesc'] = 'Select the block 9 box background  color or picture';
$string['block09count'] = 'Block 9 count';
$string['block09countdesc'] = 'Number of categorys to show';
$string['block09countdefault'] = '8';
$string['block09boxshadow'] = 'Block 9 Box Shadow';
$string['block09boxshadowdesc'] = 'Select the block 9 box shadow enabled';
$string['block09header'] = 'Block 9 Header';
$string['block09headerdesc'] = 'Block 9 Header desciription';
$string['block09headerdefault'] = 'Available Categories';
$string['block09caption'] = 'Block 9 Caption';
$string['block09captiondesc'] = 'Block 9 captions';
$string['block09captiondefault'] = "List of registered categories";
$string['block09ctgid'] = 'Block 9 Category id';
$string['block09ctgiddesc'] = 'Block 9 Category id select (exp:  id = 1  or id = 2 or id = 3 ........), empty all category.';
// Frontpage HTML block 10.
$string['block10info'] = '! Block-10 TESTIMONIALS';
$string['block10infodesc'] = 'TESTIMONIALS - Enter the settings for block 10';
$string['block10enabled'] = 'Enable block 10';
$string['block10enableddesc'] = 'Enable or disabled block 10 at the your home page';
$string['block10design'] = 'Block 10 Design';
$string['block10designdesc'] = 'Select the block 10 design you want to add';
$string['block10count'] = 'Block-10 Count';
$string['block10countdesc'] = 'Select the number of boxes and press the save changes button';
$string['block10header'] = 'Block 10 header';
$string['block10headerdesc'] = 'Block 10 header';
$string['block10headerdefault'] = 'TESTIMONIALS';
$string['block10name'] = 'Block 10 name {$a->block}';
$string['block10namedesc'] = 'Block 10 name';
$string['block10job'] = 'Block 10 job {$a->block}';
$string['block10jobdesc'] = 'Block 10 job';
$string['block10caption'] = 'Block caption {$a->block}';
$string['block10captiondesc'] = 'Add a caption  for your block ';
$string['block10link'] = 'Block URL {$a->block}';
$string['block10linkdesc'] = 'Add a URL  for your block ';
$string['block10imgdesc'] = 'Add a image  for your block ';
$string['sliderimageblock10img'] = 'Block img {$a->block}';
// Frontpage HTML block 11.
$string['block11info'] = '! Block-11 BLOG POST';
$string['block11infodesc'] = 'BLOG POST - Enter the settings for block 11';
$string['block11enabled'] = 'Enable block 11';
$string['block11enableddesc'] = 'Enable or disabled block 11 at the your home page';
$string['block11design'] = 'Block 11 Design';
$string['block11designdesc'] = 'Select the block 11 design you want to add';
$string['block11count'] = 'Block-11 Count';
$string['block11countdesc'] = 'Select the number of blogs to display';
$string['block11header'] = 'Block 11 header';
$string['block11headerdesc'] = 'Block 11 header';
$string['block11headerdefault'] = 'ALMOND BLOG';
$string['block11caption'] = 'Block 11 caption';
$string['block11captiondesc'] = 'Block 11 caption';
$string['block11captiondefault'] = 'Welcome to Almondb blog posts.';
// Frontpage block 12.
$string['block12info'] = '! Block-12 Empty';
// Frontpage block 13.
$string['block13info'] = '! Block-13 Empty';
// Frontpage block 14.
$string['block14info'] = '! Block-14 Empty';
// Frontpage block 15.
$string['block15info'] = '! Block-15 Empty';
// Frontpage block 16.
$string['block16info'] = '! Block-16 Empty';
// Frontpage block 17.
$string['block17info'] = '! Block-17 Empty';
// Frontpage HTML block 18.
$string['block18info'] = '! Block-18 BLOCK HTML';
$string['block18infodesc'] = 'BLOCK HTML - Enter the settings for block 18';
$string['block18enabled'] = 'Enable block 18';
$string['block18enableddesc'] = 'Enable or disabled block 18 at the your home page';
$string['block18title'] = 'Block 18 Title';
$string['block18titledesc'] = 'Select the block 18 design you want to add';
$string['block18caption'] = 'Block 18 caption';
$string['block18captiondesc'] = 'Block 18 caption';
$string['block18csslink'] = 'Block 18 css link';
$string['block18csslinkdesc'] = 'Block 18 add a css link for your block';
$string['block18css'] = 'Block 18 css';
$string['block18cssdesc'] = 'Block 18 add a css for your block';
// Frontpage HTML block 19.
$string['block19info'] = '! Block-19 BRANDS';
$string['block19infodesc'] = 'BRANDS - Enter the settings for block 19';
$string['block19enabled'] = 'Enable block 19';
$string['block19enableddesc'] = 'Enable or disabled block 19 at the your home page';
$string['block19design'] = 'Block 19 design';
$string['block19designdesc'] = 'Select the block 19 design you want to add';
$string['block19headerenabled'] = 'Header enable block 19';
$string['block19headerenableddesc'] = 'Header enable/disabled block 19';
$string['block19header'] = 'Block 19 header';
$string['block19headerdesc'] = 'Block 19 header';
$string['block19headerdefault'] = 'OUR PARTNERS';
$string['block19caption'] = 'Block 19 caption';
$string['block19captiondesc'] = 'Block 19 caption';
$string['block19captiondefault'] = 'It is a long established fact that a reader will be distracted by
                                    the readable content of a page when looking at its layout. ';
$string['block19link'] = 'Block 19 img URL {$a->block}';
$string['block19linkdesc'] = 'Add a img URL for your block 19';
$string['block19imgdesc'] = 'Add a image for your block ';
$string['sliderimageblock19img'] = 'Block 19 img {$a->block}';
// Frontpage HTML block 20.
$string['block20info'] = '! Block-20 FOOTER';
$string['block20infodesc'] = 'FOOTER - Enter the settings for block 20';
$string['block20enabled'] = 'Enable block 20';
$string['block20enableddesc'] = 'Enable or disabled block 20 at the your home page';
$string['footerbackgroundcolor'] = 'Footer background color';
$string['footerbackgroundcolordesc'] = 'You can change the footer background color';
$string['block20logo'] = 'Select the Block 20 logo';
$string['block20logodesc'] = 'Block 20 logo selection';
$string['block20col1header'] = 'Block 20 col 1 header';
$string['block20col1headerdesc'] = 'Block 20 col 1 header';
$string['block20col1caption'] = 'Block 20 col 1 caption';
$string['block20col1captiondesc'] = 'Block 20 col 1 caption';
$string['block20col1captiondefault'] = 'It is a long established fact that a reader will be distracted by
                                    the readable content of a page when looking at its layout. ';
$string['block20col2header'] = 'Block 20 col 2 header';
$string['block20col2headerdesc'] = 'Block 20 column 2 enter header';
$string['block20col2link'] = 'Block 20 col 2 link';
$string['block20col2linkdesc'] = 'Block 20 col 2 link area';
$string['block20col2linkdefault'] = 'About Us|https://themesalmond.com
                                    Our Story|https://moodle.org/support
                                    Terms & Condition|https://moodle.org/development
                                    Privacy Policy|http://docs.moodle.org|Moodle Docs
                                    Site Map|http://docs.moodle.org/en|Documentation in English|en
                                    Moodle.com|http://moodle.com/ ';
$string['block20col3header'] = 'Block 20 col 3 header';
$string['block20col3headerdesc'] = 'Block 20 column 3 enter header';
$string['block20col3link'] = 'Block 20 col 3 link';
$string['block20col3linkdesc'] = 'Block 20 col 3 link area';
$string['block20col3linkdefault'] = 'About Us|https://themesalmond.com
                                    Our Story|https://moodle.org/support
                                    Terms & Condition|https://moodle.org/development
                                    Privacy Policy|http://docs.moodle.org|Moodle Docs
                                    Site Map|http://docs.moodle.org/tr|Documentation in Turkish|tr
                                    Moodle.com|http://moodle.com/ ';
$string['block20col4header'] = 'Block 20 col 4 header';
$string['block20col4headerdesc'] = 'Block 20 column 4 enter header';
$string['block20col4caption'] = 'Block 20 col 4 caption';
$string['block20col4captiondesc'] = 'Block 20 col 4 caption enter';
$string['block20col4captiondefault'] = '<p>Address<p>';
$string['block20social'] = 'Block 20 social links';
$string['block20socialdesc'] = 'Block 20 social links';
$string['block20socialdefault'] = '<ul>
<li><a href="#" target="_blank"><i class="fa fa-facebook-f"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-twitter"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-pinterest"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-linkedin"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-instagram"></i></a></li>
<li><a href="#" target="_blank"><i class="fa fa-youtube-play"></i></a></li>
</ul>';
$string['block20copyright'] = 'Block 20 Copyright';
$string['block20copyrightdesc'] = 'Block 20 Copyright';
$string['block20moodle'] = 'Enable frontpage button';
$string['block20moodledesc'] = 'Enable or disabled block 20 moodle original frontpage';
// Frontpage HTML block  !DO NOT DELETE !DO NOT CHANGE.
$string['theme_almondb_frontpageblockend'] = '--*/*--';
$string['theme_almondb_frontpageblockenddesc'] = '';
// Course single page.
$string['coursesummary'] = 'Course Summary';
// Flat navigation.
$string['coursesection'] = 'Course Sections';

// Deprecated since Moodle 4.0.
$string['totop'] = 'Go to top';
