define(['core/ajax', 'core/notification'], function(Ajax, Notification) {
    var polling = true;
    var POLL_INTERVAL = 2000;
    var MAX_ATTEMPTS = 150;
    var attempts = 0;

    return {
        init: function(sessionId, state, callbackUrl, loginUrl, timeoutMessage, failedMessage) {
            var poll = function() {
                if (!polling || attempts >= MAX_ATTEMPTS) {
                    if (attempts >= MAX_ATTEMPTS) {
                        Notification.alert('', timeoutMessage);
                        window.location.href = loginUrl;
                    }
                    return;
                }

                attempts++;

                Ajax.call([{
                    methodname: 'auth_kipmi_check_auth_status',
                    args: {sessionid: sessionId},
                    done: function(response) {
                        if (response.status === 'success') {
                            polling = false;
                            submitCallback(callbackUrl, state, sessionId);
                        } else if (response.status === 'failed') {
                            polling = false;
                            Notification.alert('', failedMessage);
                            window.location.href = loginUrl;
                        } else if (response.status === 'error') {
                            setTimeout(poll, POLL_INTERVAL);
                        } else {
                            setTimeout(poll, POLL_INTERVAL);
                        }
                    },
                    fail: function() {
                        setTimeout(poll, POLL_INTERVAL);
                    }
                }]);
            };

            var submitCallback = function(url, stateToken, sessId) {
                var form = document.createElement('form');
                form.method = 'POST';
                form.action = url;

                var stateInput = document.createElement('input');
                stateInput.type = 'hidden';
                stateInput.name = 'state';
                stateInput.value = stateToken;
                form.appendChild(stateInput);

                var sessionInput = document.createElement('input');
                sessionInput.type = 'hidden';
                sessionInput.name = 'sessionid';
                sessionInput.value = sessId;
                form.appendChild(sessionInput);

                var sessKeyInput = document.createElement('input');
                sessKeyInput.type = 'hidden';
                sessKeyInput.name = 'sesskey';
                sessKeyInput.value = M.cfg.sesskey;
                form.appendChild(sessKeyInput);

                document.body.appendChild(form);
                form.submit();
            };

            poll();
        }
    };
});
