/**
 * Implementation of the ace_gapfiller_ui user interface plugin. For overall details
 * of the UI plugin architecture, see userinterfacewrapper.js.
 *
 * This plugin uses the usual ace editor but only makes some portions of the text editable.
 * The pre-formatted text is supplied by the question author in either the
 * "globalextra" field or the testcode field of the first test case, according
 * to the ui parameter ui_source (default: globalextra).
 * Editable "gaps" are inserted into the ace editor at specified points.
 * It is intended primarily for use with coding questions where the answerbox presents
 * the students with code that has smallish bits missing.
 *
 * The locations within the globalextra text at which the gaps are
 * to be inserted are denoted by "tags" of the form
 *
 *     {[ size ]}
 *
 * or
 *
 *     {[ size-maxSize ]}
 *
 * where size and maxSize are integer literals. These respectively inject a "gap" into
 * the editor of the specified size and maxSize. If maxSize is not specified then the
 * "gap" has no maximum size and can grow without bound.
 *
 * The serialisation of the answer box contents, i.e. the text that
 * copied back into the textarea for submissions
 * as the answer, is simply a list of all the field values (strings), in order.
 *
 * As a special case of the serialisation, if the value list is empty, the
 * serialisation itself is the empty string.
 *
 * The delimiters for the gap tags are by default '{[' and
 * ']}'.
 *
 * @module qtype_coderunner/ui_ace_gapfiller
 * @copyright  Richard Lobb, 2019, The University of Canterbury
 * @copyright  Matthew Toohey, 2021, The University of Canterbury
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("qtype_coderunner/ui_ace_gapfiller",["jquery"],(function($){var Range;const validChars=/[ !"#$%&'()*+,`\-./0-9\p{L}:;<=>?@\[\]\\^_{}|~]/u;function AceGapfillerUi(textareaId,w,h,uiParams){this.textArea=$(document.getElementById(textareaId));var wrapper=$(document.getElementById(textareaId+"_wrapper")),focused=this.textArea[0]===document.activeElement,lang=uiParams.lang,t=this;let code="";this.uiParams=uiParams,this.gaps=[],this.source=uiParams.ui_source||"globalextra",this.nextGapIndex=0,"globalextra"!==this.source&&"test0"!==this.source&&(alert("Invalid source for code in ui_ace_gapfiller"),this.source="globalextra"),code="globalextra"==this.source?this.textArea.attr("data-globalextra"):this.textArea.attr("data-test0");try{window.ace.require("ace/ext/language_tools"),Range=window.ace.require("ace/range").Range,this.modelist=window.ace.require("ace/ext/modelist"),this.enabled=!1,this.contents_changed=!1,this.capturingTab=!1,this.clickInProgress=!1,this.editNode=$("<div></div>"),this.editNode.css({resize:"none",height:h,width:"100%"}),this.editor=window.ace.edit(this.editNode.get(0)),this.textArea.prop("readonly")&&this.editor.setReadOnly(!0),this.editor.setOptions({displayIndentGuides:!1,dragEnabled:!1,enableBasicAutocompletion:!0,newLineMode:"unix"}),this.editor.$blockScrolling=1/0,uiParams.theme?this.editor.setTheme("ace/theme/"+uiParams.theme):this.editor.setTheme("ace/theme/textmate"),this.setLanguage(lang),this.setEventHandlers(this.textArea),this.captureTab(),this.editor.renderer.on("afterRender",(function(){var gutter=wrapper.find(".ace_gutter");gutter.hasClass("moodle-has-zindex")||(gutter.addClass("moodle-has-zindex"),focused&&(t.editor.focus(),t.editor.navigateFileEnd()),t.aceLabel=wrapper.find(".answerprompt"),t.aceLabel.attr("for","ace_"+textareaId),t.aceTextarea=wrapper.find(".ace_text-input"),t.aceTextarea.attr("id","ace_"+textareaId))})),this.createGaps(code),this.editor.commands.on("exec",(function(e){let cursor=t.editor.selection.getCursor(),commandName=e.command.name,selectionRange=t.editor.getSelectionRange(),gap=t.findCursorGap(cursor);if(commandName.startsWith("go")){if(null===gap||"gotoright"!==commandName||cursor.column!==gap.range.start.column+gap.textSize)return;t.editor.moveCursorTo(cursor.row,gap.range.end.column+1)}if(null===gap)"selectall"===commandName&&t.editor.selection.selectAll();else if("indent"===commandName){let nextGap=t.gaps[(gap.index+1)%t.gaps.length];t.editor.moveCursorTo(nextGap.range.start.row,nextGap.range.start.column+nextGap.textSize),t.editor.selection.clearSelection()}else if("selectall"===commandName)t.editor.selection.setSelectionRange(new Range(gap.range.start.row,gap.range.start.column,gap.range.start.row,gap.range.end.column),!1);else if(t.editor.selection.isEmpty()){if("insertstring"===commandName){let char=e.args;validChars.test(char)&&gap.insertChar(t.gaps,cursor,char)}else"backspace"===commandName?cursor.column>gap.range.start.column&&gap.textSize>0&&gap.deleteChar(t.gaps,{row:cursor.row,column:cursor.column-1}):"del"===commandName&&cursor.column<gap.range.start.column+gap.textSize&&gap.textSize>0&&gap.deleteChar(t.gaps,cursor);t.editor.selection.clearSelection()}else if(!t.editor.selection.isEmpty()&&gap.cursorInGap(selectionRange.start)&&gap.cursorInGap(selectionRange.end)&&("insertstring"!==commandName&&"backspace"!==commandName&&"del"!==commandName&&"paste"!==commandName&&"cut"!==commandName||(gap.deleteRange(t.gaps,selectionRange.start.column,selectionRange.end.column),t.editor.selection.clearSelection()),"insertstring"===commandName)){let char=e.args;validChars.test(char)&&gap.insertChar(t.gaps,selectionRange.start,char)}null!==gap&&"paste"===commandName&&gap.insertText(t.gaps,selectionRange.start.column,e.args.text),e.preventDefault(),e.stopPropagation()})),t.editor.selection.on("changeCursor",(function(){let cursor=t.editor.selection.getCursor(),gap=t.findCursorGap(cursor);null!==gap&&cursor.column>gap.range.start.column+gap.textSize&&t.editor.moveCursorTo(gap.range.start.row,gap.range.start.column+gap.textSize)})),this.gapToSelect=null,this.editor.on("tripleclick",(function(e){let cursor=t.editor.selection.getCursor(),gap=t.findCursorGap(cursor);null!==gap&&(t.editor.selection.setSelectionRange(new Range(gap.range.start.row,gap.range.start.column,gap.range.start.row,gap.range.end.column),!1),t.gapToSelect=gap,e.preventDefault(),e.stopPropagation())})),this.editor.on("click",(function(e){t.gapToSelect&&(t.editor.moveCursorTo(t.gapToSelect.range.start.row,t.gapToSelect.range.start.column+t.gapToSelect.textSize),t.gapToSelect=null,e.preventDefault(),e.stopPropagation())})),this.fail=!1,this.reload()}catch(err){this.fail=!0}}function Gap(editor,row,column,minWidth){let maxWidth=arguments.length>4&&void 0!==arguments[4]?arguments[4]:1/0;this.editor=editor,this.minWidth=minWidth,this.maxWidth=maxWidth,this.range=new Range(row,column,row,column+minWidth),this.textSize=0,this.editor.session.addMarker(this.range,"ace-gap-outline","text",!0),this.editor.session.addMarker(this.range,"ace-gap-background","text",!1);const startPosition=this.range.start;this.editor.session.insert(startPosition,"\x3c!-- BEGIN CODE GAP --\x3e")}return AceGapfillerUi.prototype.createGaps=function(code){function reEscape(s){for(var c,result="",i=0;i<s.length;i++){c=s[i];for(var j=0;j<"{[(*+\\".length;j++)c==="{[(*+\\"[j]&&(c="\\"+c);result+=c}return result}this.gaps=[];let lines=code.split(/\r?\n/),sepLeft=reEscape("{["),sepRight=reEscape("]}"),splitter=new RegExp(sepLeft+" *((?:\\d+)|(?:\\d+- *\\d+)) *"+sepRight),editorContent="";for(let i=0;i<lines.length;i++){let bits=lines[i].split(splitter);editorContent+=bits[0];let columnPos=bits[0].length;for(let j=1;j<bits.length;j+=2){let values=bits[j].split("-"),minWidth=parseInt(values[0]),maxWidth=values.length>1?parseInt(values[1]):1/0,gap=new Gap(this.editor,i,columnPos,minWidth,maxWidth);gap.index=this.nextGapIndex,this.nextGapIndex+=1,this.gaps.push(gap),columnPos+=minWidth,editorContent+=" ".repeat(minWidth),j+1<bits.length&&(editorContent+=bits[j+1],columnPos+=bits[j+1].length)}i<lines.length-1&&(editorContent+="\n")}this.editor.session.setValue(editorContent)},AceGapfillerUi.prototype.findCursorGap=function(cursor){for(let i=0;i<this.gaps.length;i++){let gap=this.gaps[i];if(gap.cursorInGap(cursor))return gap}return null},AceGapfillerUi.prototype.failed=function(){return this.fail},AceGapfillerUi.prototype.failMessage=function(){return"ace_ui_notready"},AceGapfillerUi.prototype.sync=function(){if(this.fail)return;let serialisation=[],empty=!0;for(let i=0;i<this.gaps.length;i++){let value=this.gaps[i].getText();serialisation.push(value),""!==value&&(empty=!1)}empty?this.textArea.val(""):this.textArea.val(JSON.stringify(serialisation))},AceGapfillerUi.prototype.syncIntervalSecs=()=>2,AceGapfillerUi.prototype.reload=function(){let content=this.textArea.val();if(content)try{let values=JSON.parse(content);for(let i=0;i<this.gaps.length;i++){let value=i<values.length?values[i]:"???";this.gaps[i].insertText(this.gaps,this.gaps[i].range.start.column,value)}}catch(e){}},AceGapfillerUi.prototype.setLanguage=function(language){var session=this.editor.getSession(),mode=this.findMode(language);mode&&session.setMode(mode.mode)},AceGapfillerUi.prototype.getElement=function(){return this.editNode},AceGapfillerUi.prototype.captureTab=function(){this.capturingTab=!0,this.editor.commands.bindKeys({Tab:"indent","Shift-Tab":"outdent"})},AceGapfillerUi.prototype.releaseTab=function(){this.capturingTab=!1,this.editor.commands.bindKeys({Tab:null,"Shift-Tab":null})},AceGapfillerUi.prototype.setEventHandlers=function(){var t=this;this.editor.getSession().on("change",(function(){t.contents_changed=!0})),this.editor.on("blur",(function(){t.contents_changed&&t.textArea.trigger("change")})),this.editor.on("mousedown",(function(){t.clickInProgress=!0})),this.editor.on("focus",(function(){t.clickInProgress?t.captureTab():t.releaseTab()})),this.editor.on("click",(function(){t.clickInProgress=!1})),this.editor.container.addEventListener("keydown",(function(e){void 0!==e.which&&0===e.which||(77===e.keyCode&&e.ctrlKey&&!e.altKey?(t.capturingTab?t.releaseTab():t.captureTab(),e.preventDefault()):27===e.keyCode?t.releaseTab():e.shiftKey||e.ctrlKey||e.altKey||9==e.keyCode||t.captureTab())}),!0)},AceGapfillerUi.prototype.destroy=function(){var focused;this.sync(),this.fail||(focused=this.editor.isFocused(),this.editor.destroy(),$(this.editNode).remove(),focused&&(this.textArea.focus(),this.textArea[0].selectionStart=this.textArea[0].value.length))},AceGapfillerUi.prototype.hasFocus=function(){return this.editor.isFocused()},AceGapfillerUi.prototype.findMode=function(language){var candidate,filename,result,candidates,nameMap={octave:"matlab",nodejs:"javascript","c#":"cs"};if("string"==typeof language){language.toLowerCase()in nameMap&&(language=nameMap[language.toLowerCase()]),candidates=[language,language.replace(/\d+$/,"")];for(var i=0;i<candidates.length;i++)if(filename="input."+(candidate=candidates[i]),(result=this.modelist.modesByName[candidate]||this.modelist.modesByName[candidate.toLowerCase()]||this.modelist.getModeForPath(filename)||this.modelist.getModeForPath(filename.toLowerCase()))&&"text"!==result.name)return result}},AceGapfillerUi.prototype.resize=function(w,h){this.editNode.outerHeight(h),this.editNode.outerWidth(w),this.editor.resize()},AceGapfillerUi.prototype.allowFullScreen=function(){return!0},Gap.prototype.cursorInGap=function(cursor){return cursor.row>=this.range.start.row&&cursor.column>=this.range.start.column&&cursor.row<=this.range.end.row&&cursor.column<=this.range.end.column},Gap.prototype.getWidth=function(){return this.range.end.column-this.range.start.column},Gap.prototype.changeWidth=function(gaps,delta){this.range.end.column+=delta;for(let i=0;i<gaps.length;i++){let other=gaps[i];other.range.start.row===this.range.start.row&&other.range.start.column>this.range.start.column&&(other.range.start.column+=delta,other.range.end.column+=delta)}this.editor.$onChangeBackMarker(),this.editor.$onChangeFrontMarker()},Gap.prototype.insertChar=function(gaps,pos,char){this.textSize===this.getWidth()&&this.getWidth()<this.maxWidth?(this.changeWidth(gaps,1),this.textSize+=1,this.editor.session.insert(pos,char)):this.textSize<this.maxWidth&&(this.editor.session.remove(new Range(pos.row,this.range.end.column-1,pos.row,this.range.end.column)),this.textSize+=1,this.editor.session.insert(pos,char))},Gap.prototype.deleteChar=function(gaps,pos){this.textSize-=1,this.editor.session.remove(new Range(pos.row,pos.column,pos.row,pos.column+1)),this.textSize>=this.minWidth?this.changeWidth(gaps,-1):this.editor.session.insert({row:pos.row,column:this.range.end.column-1}," ")},Gap.prototype.deleteRange=function(gaps,start,end){for(let i=start;i<end;i++)start<this.range.start.column+this.textSize&&this.deleteChar(gaps,{row:this.range.start.row,column:start})},Gap.prototype.insertText=function(gaps,start,text){for(let i=0;i<text.length;i++)start+i<this.range.start.column+this.maxWidth&&this.insertChar(gaps,{row:this.range.start.row,column:start+i},text[i])},Gap.prototype.getText=function(){return this.editor.session.getTextRange(new Range(this.range.start.row,this.range.start.column,this.range.end.row,this.range.start.column+this.textSize))},{Constructor:AceGapfillerUi}}));

//# sourceMappingURL=ui_ace_gapfiller.min.js.map