/**
 * Implementation of the gapfiller_ui user interface plugin. For overall details
 * of the UI plugin architecture, see userinterfacewrapper.js.
 *
 * This plugin replaces the usual textarea answer box with a div
 * consisting of pre-formatted text supplied by the question author in either the
 * "globalextra" field or the testcode field of the first test case, according
 * to the ui parameter ui_source (default: globalextra).  HTML
 * entry or textarea elements are then inserted at
 * specified points. It is intended primarily for use with coding questions
 * where the answerbox presents the students with code that has smallish bits
 * missing.
 *
 * The locations within the globalextra text at which the input elements are
 * to be inserted are denoted by "tags" of the form
 *
 *     {[ size ]}
 *
 * for an HTML input element
 *
 * or
 *
 *     {[ rows, columns ]}
 *
 * for a textarea element
 *
 * where size, rows and column are integer literals. These respectively
 * inject an HTML input element or a textarea element of the
 * specified size.
 *
 * The serialisation of the answer box contents, i.e. the text that
 * copied back into the textarea for submissions
 * as the answer, is simply a list of all the field values (strings), in order.
 *
 * As a special case of the serialisation, if the value list is empty, the
 * serialisation itself is the empty string.
 *
 * The delimiters for the input element insertion tags are by default '{[' and
 * ']}', but can be changed by an optional ui parameter gap_filler_delimiters,
 * which must be a 2-element array of strings. For example:
 *
 *     {"gap_filler_delimiters": ["{{", "}}"]}
 *
 * Note that the double-brace delimiters in that example are the same as those
 * used by Twig, so using them instead of the default would prevent you from
 * ever adding Twig expansion (e.g. for randomisation) to the question.
 *
 * @module qtype_coderunner/ui_gapfiller
 * @copyright  Richard Lobb, 2019, The University of Canterbury
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("qtype_coderunner/ui_gapfiller",["jquery"],(function($){function GapfillerUi(textareaId,width,height,uiParams){var html;this.textArea=$(document.getElementById(textareaId)),this.readOnly=this.textArea.prop("readonly"),this.uiParams=uiParams,this.fail=!1,this.htmlDiv=null,this.source=uiParams.ui_source||"globalextra","globalextra"!==this.source&&"test0"!==this.source&&(alert("Invalid source for HTML in ui_gapfiller"),this.source="globalextra"),html="globalextra"==this.source?this.textArea.attr("data-globalextra"):this.textArea.attr("data-test0"),this.html=html.replace("<","&lt;"),this.reload()}return GapfillerUi.prototype.failed=function(){return this.fail},GapfillerUi.prototype.sync=function(){var serialisation=[],empty=!0;this.getFields().each((function(){var value;"cr_gapfiller_field"!==$(this).attr("name")?alert("Unexpected UI element found in answer box"):(value=$(this).val(),serialisation.push(value),""!==value&&(empty=!1))})),empty?this.textArea.val(""):this.textArea.val(JSON.stringify(serialisation))},GapfillerUi.prototype.getElement=function(){return this.htmlDiv},GapfillerUi.prototype.getFields=function(){return $(this.htmlDiv).find(".coderunner-ui-element")},GapfillerUi.prototype.setField=function(field,value){"checkbox"===field.attr("type")||"radio"===field.attr("type")?field.prop("checked",field.val()===value):field.val(value)},GapfillerUi.prototype.markedUpHtml=function(){function reEscape(s){for(var c,result="",i=0;i<s.length;i++){c=s[i];for(var j=0;j<"{[(*+\\".length;j++)c==="{[(*+\\"[j]&&(c="\\"+c);result+=c}return result}var i,sepLeft=reEscape("{["),sepRight=reEscape("]}"),splitter=new RegExp(sepLeft+" *((?:\\d+)|(?:\\d+, *\\d+)) *"+sepRight),bits=this.html.split(splitter),result="<pre>"+bits[0];for(i=1;i<bits.length;i+=2)result+=this.markUp(bits[i]),i+1<bits.length&&(result+=bits[i+1]);return result+="</pre>"},GapfillerUi.prototype.markUp=function(tagContents){var numbers,rows,cols,result="";return 1==(numbers=tagContents.split(",")).length?result='<input name="cr_gapfiller_field" class="coderunner-ui-element" size="'+parseInt(numbers[0])+'">':(rows=parseInt(numbers[0]),cols=parseInt(numbers[1]),result='<textarea name="cr_gapfiller_field" class ="coderunner-ui-element" rows="'+rows+'" cols="'+cols+'" style="width:auto;"></textarea>'),result},GapfillerUi.prototype.reload=function(){var value,values,i,fields,content=$(this.textArea).val();if(this.htmlDiv=$("<div style='height:fit-content' class='qtype-coderunner-html-outer-div'>"+this.markedUpHtml()+"</div>"),content)try{for(values=JSON.parse(content),fields=this.getFields(),i=0;i<fields.length;i++)value=i<values.length?values[i]:"???",this.setField($(fields[i]),value)}catch(e){}},GapfillerUi.prototype.resize=function(){},GapfillerUi.prototype.hasFocus=function(){var focused=!1;return this.getFields().each((function(){this===document.activeElement&&(focused=!0)})),focused},GapfillerUi.prototype.destroy=function(){this.sync(),$(this.htmlDiv).remove(),this.htmlDiv=null},{Constructor:GapfillerUi}}));

//# sourceMappingURL=ui_gapfiller.min.js.map