/**
 * JavaScript to interface to the Graph editor, which is used both in
 * the author editing page and by the student question submission page.
 *
 * @module qtype_coderunner/ui_graph
 * @copyright  Richard Lobb, 2015, The University of Canterbury
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("qtype_coderunner/ui_graph",["jquery","qtype_coderunner/graphutil","qtype_coderunner/graphelements"],(function($,util,elements){function GraphCanvas(parent,canvasId,w,h){this.HANDLE_SIZE=10,this.parent=parent,this.canvas=$(document.createElement("canvas")),this.canvas.attr({id:canvasId,class:"coderunner_graphcanvas",tabindex:1}),this.canvas.css({"background-color":"white"}),this.canvas.on("mousedown",(function(e){return parent.mousedown(e)})),this.canvas.on("mouseup",(function(e){return parent.mouseup(e)})),this.canvas.on("dblclick",(function(e){return parent.dblclick(e)})),this.canvas.on("keydown",(function(e){return parent.keydown(e)})),this.canvas.on("mousemove",(function(e){return parent.mousemove(e)})),this.canvas.on("keypress",(function(e){return parent.keypress(e)})),this.resize=function(w,h){this.canvas.attr("width",w),this.canvas.attr("height",h)},this.resize(w,h)}function Graph(textareaId,width,height,uiParams){var save_this=this;this.SNAP_TO_PADDING=6,this.DUPLICATE_LINK_OFFSET=16,this.HIT_TARGET_PADDING=6,this.DEFAULT_NODE_RADIUS=26,this.DEFAULT_FONT_SIZE=20,this.DEFAULT_TEXT_OFFSET=5,this.DEFAULT_LINK_LABEL_REL_DIST=.5,this.MAX_VERSIONS=30,this.canvasId="graphcanvas_"+textareaId,this.textArea=$(document.getElementById(textareaId)),this.helpText="",this.readOnly=this.textArea.prop("readonly"),this.uiParams=uiParams,this.graphCanvas=new GraphCanvas(this,this.canvasId,width,height),this.caretVisible=!0,this.caretTimer=0,this.originalClick=null,this.nodes=[],this.links=[],this.selectedObject=null,this.currentLink=null,this.movingObject=!1,this.fail=!1,this.failString=null,this.versions=[],this.versionIndex=-1,this.helpBox=new elements.HelpBox(this,0,0),this.clearButton=new elements.Button(this,60,0,"Clear"),this.clearButton.onClick=function(){confirm("Are you sure you want to clear the diagram?")&&this.parent.clear()},this.buttons=[this.helpBox,this.clearButton],"locknodes"in uiParams&&(uiParams.locknodepositions=uiParams.locknodes),"lockedges"in uiParams&&(uiParams.lockedgepositions=uiParams.lockedges),"helpmenutext"in uiParams?this.helpText=uiParams.helpmenutext:require(["core/str"],(function(str){var helpPresent=str.get_string("graphhelp","qtype_coderunner");$.when(helpPresent).done((function(graphhelp){save_this.helpText=graphhelp}))})),this.reload(),this.fail||this.draw()}return Graph.prototype.failed=function(){return this.fail},Graph.prototype.failMessage=function(){return this.failString},Graph.prototype.getElement=function(){return this.getCanvas()},Graph.prototype.hasFocus=function(){return document.activeElement==this.getCanvas()},Graph.prototype.getCanvas=function(){return this.graphCanvas.canvas[0]},Graph.prototype.nodeRadius=function(){return this.uiParams.noderadius?this.uiParams.noderadius:this.DEFAULT_NODE_RADIUS},Graph.prototype.fontSize=function(){return this.uiParams.fontsize?this.uiParams.fontsize:this.DEFAULT_FONT_SIZE},Graph.prototype.isFsm=function(){return void 0===this.uiParams.isfsm||this.uiParams.isfsm},Graph.prototype.textOffset=function(){return this.uiParams.textoffset?this.uiParams.textoffset:this.DEFAULT_TEXT_OFFSET},Graph.prototype.arrowIfReqd=function(c,x,y,angle){(void 0===this.uiParams.isdirected||this.uiParams.isdirected)&&util.drawArrow(c,x,y,angle)},Graph.prototype.sync=function(){},Graph.prototype.syncIntervalSecs=function(){return 0},Graph.prototype.keypress=function(e){var key=util.crossBrowserKey(e);if(!this.readOnly)return key>=32&&key<=126&&!e.metaKey&&!e.altKey&&!e.ctrlKey&&37!==key&&39!==key&&null!==this.selectedObject&&this.canEditText()?(this.selectedObject.justMoved&&this.saveVersion(),this.selectedObject.justMoved=!1,this.selectedObject.textBox.insertChar(String.fromCharCode(key)),this.resetCaret(),this.draw(),!1):8!==key&&32!==key&&9!==key&&void 0},Graph.prototype.mousedown=function(e){var mouse=util.crossBrowserRelativeMousePos(e);if(!this.readOnly){if(this.selectedObject=this.selectObject(mouse.x,mouse.y),this.movingObject=!1,this.movingGraph=!1,this.movingText=!1,this.originalClick=mouse,this.saveVersion(),this.selectedObject!==this.helpBox&&(this.helpBox.helpOpen=!1),null!==this.selectedObject){if(this.selectedObject instanceof elements.Button)this.selectedObject.onClick();else if(e.shiftKey&&this.selectedObject instanceof elements.Node)this.uiParams.lockedgeset||(this.currentLink=new elements.SelfLink(this,this.selectedObject,mouse));else if(e.altKey&&this.selectedObject instanceof elements.Node){if(!this.uiParams.locknodepositions){this.movingGraph=!0,this.movingNodes=this.selectedObject.traverseGraph(this.links,[]);for(var i=0;i<this.movingNodes.length;i++)this.movingNodes[i].setMouseStart(mouse.x,mouse.y)}}else this.selectedObject instanceof elements.TextBox?this.uiParams.lockedgelabels||(this.movingText=!0,this.selectedObject.setMouseStart(mouse.x,mouse.y),this.selectedObject=this.selectedObject.parent):this.uiParams.locknodepositions&&this.selectedObject instanceof elements.Node||this.uiParams.lockedgepositions&&this.selectedObject instanceof elements.Link||(this.movingObject=!0,this.selectedObject.setMouseStart&&this.selectedObject.setMouseStart(mouse.x,mouse.y));this.selectedObject.justMoved=!0,this.resetCaret()}else e.shiftKey&&this.isFsm()&&(this.currentLink=new elements.TemporaryLink(this,mouse,mouse));return this.draw(),!this.hasFocus()&&(this.resetCaret(),!0)}},Graph.prototype.canEditText=function(){var isNode=this.selectedObject instanceof elements.Node,isLink=this.selectedObject instanceof elements.Link||this.selectedObject instanceof elements.SelfLink;return"textBox"in this.selectedObject&&(isNode&&!this.uiParams.locknodelabels||isLink&&!this.uiParams.lockedgelabels)},Graph.prototype.keydown=function(e){var i,key=util.crossBrowserKey(e),nodeDeleted=!1;if(!this.readOnly){if(8===key)return null!==this.selectedObject&&this.canEditText()&&(this.selectedObject.textBox.deleteChar(),this.resetCaret(),this.draw()),!1;if(46===key&&null!==this.selectedObject){for(this.saveVersion(),i=0;i<this.nodes.length;i++)this.nodes[i]!==this.selectedObject||this.uiParams.locknodeset||(this.nodes.splice(i--,1),nodeDeleted=!0);for(i=0;i<this.links.length;i++)(this.links[i]===this.selectedObject&&!this.uiParams.lockedgeset||nodeDeleted&&(this.links[i].node===this.selectedObject||this.links[i].nodeA===this.selectedObject||this.links[i].nodeB===this.selectedObject))&&this.links.splice(i--,1);this.selectedObject=null,this.draw()}else 13===key?null!==this.selectedObject&&(this.selectedObject=null,this.draw()):37===key?null!==this.selectedObject&&this.canEditText()&&(this.selectedObject.textBox.caretLeft(),this.resetCaret(),this.draw()):39===key?null!==this.selectedObject&&this.canEditText()&&(this.selectedObject.textBox.caretRight(),this.resetCaret(),this.draw()):90==e.keyCode&&e.ctrlKey&&e.shiftKey||89==e.keyCode&&e.ctrlKey?this.redo():90==e.keyCode&&e.ctrlKey&&this.undo()}},Graph.prototype.dblclick=function(e){var mouse=util.crossBrowserRelativeMousePos(e);this.readOnly||this.uiParams.locknodeset||(this.selectedObject=this.selectObject(mouse.x,mouse.y),this.saveVersion(),null===this.selectedObject?(this.selectedObject=new elements.Node(this,mouse.x,mouse.y),this.nodes.push(this.selectedObject),this.selectedObject.justMoved=!0,this.resetCaret(),this.draw()):this.selectedObject instanceof elements.Node&&this.isFsm()&&(this.selectedObject.isAcceptState=!this.selectedObject.isAcceptState,this.draw()))},Graph.prototype.resize=function(w,h){this.graphCanvas.resize(w,h),this.draw()},Graph.prototype.mousemove=function(e){var closestPoint,mouse=util.crossBrowserRelativeMousePos(e);if(!this.readOnly){for(i=0;i<this.buttons.length;i++)this.buttons[i].containsPoint(mouse.x,mouse.y)?this.buttons[i].highLighted=!0:this.buttons[i].highLighted=!1,this.draw();if(null!==this.currentLink){var targetNode=this.selectObject(mouse.x,mouse.y);targetNode instanceof elements.Node||(targetNode=null),null===this.selectedObject?this.currentLink=null!==targetNode?new elements.StartLink(this,targetNode,this.originalClick):new elements.TemporaryLink(this,this.originalClick,mouse):targetNode===this.selectedObject?this.currentLink=new elements.SelfLink(this,this.selectedObject,mouse):null!==targetNode?this.currentLink=new elements.Link(this,this.selectedObject,targetNode):(closestPoint=this.selectedObject.closestPointOnCircle(mouse.x,mouse.y),this.currentLink=new elements.TemporaryLink(this,closestPoint,mouse)),this.draw()}if(this.movingGraph){for(var nodes=this.movingNodes,i=0;i<nodes.length;i++)nodes[i].trackMouse(mouse.x,mouse.y),this.snapNode(nodes[i]);this.draw()}else this.movingText?(this.selectedObject.textBox.setAnchorPoint(mouse.x,mouse.y),this.draw()):this.movingObject&&(this.selectedObject.setAnchorPoint(mouse.x,mouse.y),this.selectedObject instanceof elements.Node&&this.snapNode(this.selectedObject),this.draw())}},Graph.prototype.mouseup=function(){this.readOnly||(this.movingObject=!1,this.movingGraph=!1,this.movingText=!1,null!==this.currentLink&&(this.currentLink instanceof elements.TemporaryLink||(this.selectedObject=this.currentLink,this.addLink(this.currentLink),this.resetCaret()),this.currentLink=null,this.draw()))},Graph.prototype.selectObject=function(x,y){for(i=0;i<this.buttons.length;i++)if(this.buttons[i].containsPoint(x,y))return this.buttons[i];var i;for(i=0;i<this.nodes.length;i++)if(this.nodes[i].containsPoint(x,y))return this.nodes[i];for(i=0;i<this.links.length;i++){if(this.links[i].containsPoint(x,y))return this.links[i];if("textBox"in this.links[i]&&this.links[i].textBox.containsPoint(x,y))return this.links[i].textBox}return null},Graph.prototype.snapNode=function(node){for(var i=0;i<this.nodes.length;i++)this.nodes[i]!==node&&(Math.abs(node.x-this.nodes[i].x)<this.SNAP_TO_PADDING&&(node.x=this.nodes[i].x),Math.abs(node.y-this.nodes[i].y)<this.SNAP_TO_PADDING&&(node.y=this.nodes[i].y))},Graph.prototype.addLink=function(newLink){for(var maxPerpRHS=null,i=0;i<this.links.length;i++){var link=this.links[i];link.nodeA===newLink.nodeA&&link.nodeB===newLink.nodeB&&(null===maxPerpRHS||link.perpendicularPart>maxPerpRHS)&&(maxPerpRHS=link.perpendicularPart),link.nodeA===newLink.nodeB&&link.nodeB===newLink.nodeA&&(null===maxPerpRHS||-link.perpendicularPart>maxPerpRHS)&&(maxPerpRHS=-link.perpendicularPart)}null!==maxPerpRHS&&(newLink.perpendicularPart=maxPerpRHS+this.DUPLICATE_LINK_OFFSET),this.links.push(newLink)},Graph.prototype.reload=function(){var content=$(this.textArea).val();if(content)try{var i,backup=JSON.parse(content);for(i=0;i<backup.nodes.length;i++){var backupNode=backup.nodes[i],backupNodeLayout=backup.nodeGeometry[i],node=new elements.Node(this,backupNodeLayout[0],backupNodeLayout[1]);node.isAcceptState=backupNode[1],node.textBox=new elements.TextBox(backupNode[0].toString(),node),this.nodes.push(node)}for(i=0;i<backup.edges.length;i++){var backupLink=backup.edges[i],backupLinkLayout=backup.edgeGeometry[i],link=null;backupLink[0]===backupLink[1]?((link=new elements.SelfLink(this,this.nodes[backupLink[0]])).anchorAngle=backupLinkLayout.anchorAngle,link.textBox=new elements.TextBox(backupLink[2].toString(),link),backupLink.length>3&&link.textBox.setAnchorPoint(backupLink[3].x,backupLink[3].y)):-1===backupLink[0]?((link=new elements.StartLink(this,this.nodes[backupLink[1]])).deltaX=backupLinkLayout.deltaX,link.deltaY=backupLinkLayout.deltaY):((link=new elements.Link(this,this.nodes[backupLink[0]],this.nodes[backupLink[1]])).parallelPart=backupLinkLayout.parallelPart,link.perpendicularPart=backupLinkLayout.perpendicularPart,link.lineAngleAdjust=backupLinkLayout.lineAngleAdjust,link.textBox=new elements.TextBox(backupLink[2].toString(),link),backupLink.length>3&&link.textBox.setAnchorPoint(backupLink[3].x,backupLink[3].y)),null!==link&&this.links.push(link)}}catch(e){this.fail=!0,this.failString="graph_ui_invalidserialisation"}},Graph.prototype.save=function(){var i,backup={edgeGeometry:[],nodeGeometry:[],nodes:[],edges:[]};if(JSON&&(""!==this.textArea.val().trim()||0!==this.nodes.length)){for(i=0;i<this.nodes.length;i++){var node=this.nodes[i],nodeData=[node.textBox.text,node.isAcceptState],nodeLayout=[node.x,node.y];backup.nodeGeometry.push(nodeLayout),backup.nodes.push(nodeData)}for(i=0;i<this.links.length;i++){var link=this.links[i],linkData=null,linkLayout=null;link instanceof elements.SelfLink?(linkLayout={anchorAngle:link.anchorAngle},linkData=[this.nodes.indexOf(link.node),this.nodes.indexOf(link.node),link.textBox.text],link.textBox.dragged&&linkData.push(link.textBox.position)):link instanceof elements.StartLink?(linkLayout={deltaX:link.deltaX,deltaY:link.deltaY},linkData=[-1,this.nodes.indexOf(link.node),""]):link instanceof elements.Link&&(linkLayout={lineAngleAdjust:link.lineAngleAdjust,parallelPart:link.parallelPart,perpendicularPart:link.perpendicularPart},linkData=[this.nodes.indexOf(link.nodeA),this.nodes.indexOf(link.nodeB),link.textBox.text],link.textBox.dragged&&linkData.push(link.textBox.position)),null!==linkData&&null!==linkLayout&&(backup.edges.push(linkData),backup.edgeGeometry.push(linkLayout))}this.textArea.val(JSON.stringify(backup))}},Graph.prototype.saveVersion=function(){var curState=this.textArea.val();if(0==this.versions.length||0!=curState.localeCompare(this.versions[this.versionIndex])){for(this.versionIndex++;this.versionIndex<this.versions.length;)this.versions.pop();this.versions.push(curState),this.versions.length>this.MAX_VERSIONS&&(this.versions.shift(),this.versionIndex--)}},Graph.prototype.undo=function(){this.saveVersion(),this.versionIndex>0&&(this.versionIndex--,this.textArea.val(this.versions[this.versionIndex]),this.nodes=[],this.links=[],this.reload(),this.draw())},Graph.prototype.redo=function(){this.versionIndex<this.versions.length-1&&(this.versionIndex++,this.textArea.val(this.versions[this.versionIndex]),this.nodes=[],this.links=[],this.reload(),this.draw())},Graph.prototype.clear=function(){this.saveVersion(),this.nodes=[],this.links=[],this.save(),this.draw()},Graph.prototype.destroy=function(){clearInterval(this.caretTimer),this.graphCanvas.canvas.off(),this.graphCanvas.canvas.remove()},Graph.prototype.resetCaret=function(){var t=this;clearInterval(this.caretTimer),this.caretTimer=setInterval((function(){t.caretVisible=!t.caretVisible,t.draw()}),500),this.caretVisible=!0},Graph.prototype.draw=function(){var i,c=this.getCanvas().getContext("2d");for(c.clearRect(0,0,this.getCanvas().width,this.getCanvas().height),c.save(),c.translate(.5,.5),i=0;i<this.buttons.length;i++)this.buttons[i].draw(c);if(!this.helpBox.helpOpen){for(i=0;i<this.nodes.length;i++)c.lineWidth=1,c.fillStyle=c.strokeStyle=this.nodes[i]===this.selectedObject?"blue":"black",this.nodes[i].draw(c);for(i=0;i<this.links.length;i++)c.lineWidth=1,c.fillStyle=c.strokeStyle=this.links[i]===this.selectedObject||this.links[i].textBox===this.selectedObject?"blue":"black",this.links[i].draw(c);null!==this.currentLink&&(c.lineWidth=1,c.fillStyle=c.strokeStyle="black",this.currentLink.draw(c))}c.restore(),this.save()},Graph.prototype.allowFullScreen=function(){return!0},{Constructor:Graph}}));

//# sourceMappingURL=ui_graph.min.js.map