/**
 * Implementation of the table_ui user interface plugin. For overall details
 * of the UI plugin architecture, see userinterfacewrapper.js.
 *
 * This plugin replaces the usual textarea answer element with a div
 * containing an HTML table. The number of columns, and
 * the initial number of rows are specified by required UI parameters
 * num_columns and num_rows respectively.
 * Optional additional UI parameters are:
 *   1. column_headers: a list of strings that can be used to provide a
 *      fixed header row at the top.
 *   2. row_labels: a list of strings that can be used to provide a
 *      fixed row label column at the left.
 *   3. dynamic_rows, which, if true, allows the user to add rows.
 *   4. locked_cells: a list of [row, column] pairs, being the coordinates
 *      of table cells that cannot be changed by the user. row and column numbers
 *      are zero origin and do not include the header row or the row labels.
 *   5. width_percents: a list of the percentages of the width occupied
 *      by each column. This list must include a value for the row labels, if present.
 *
 * Individual cells are textareas except when the number of rows per cell is set to
 * 1, in which case input elements are used instead.
 *
 * The serialisation of the table, which is what is essentially copied back
 * into the original answer box textarea for submissions as the answer, is a JSON array. Each
 * element in the array is itself an array containing the values of one row
 * of the table. Empty cells are empty strings. The table header row and row
 * label columns are not provided in the serialisation.
 *
 * To preload the table with data, simply set the answer_preload of the question
 * to a json array of row values (each itself an array). If the number of rows
 * in the preload exceeds the number set by num_rows, extra rows are
 * added. If the number is less than num_rows, or if there is no
 * answer preload, undefined rows are simply left blank.
 *
 * As a special case of the serialisation, if all cells in the serialisation
 * are empty strings, the serialisation is itself the empty string.
 *
 * @module qtype_coderunner/ui_table
 * @copyright  Richard Lobb, 2018, The University of Canterbury
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("qtype_coderunner/ui_table",["jquery"],(function($){function TableUi(textareaId,width,height,uiParams){if(this.textArea=$(document.getElementById(textareaId)),this.readOnly=this.textArea.prop("readonly"),this.tableDiv=null,this.uiParams=uiParams,!uiParams.num_columns||!uiParams.num_rows)return this.fail=!0,void(this.failString="table_ui_missingparams");this.fail=!1,this.lockedCells=uiParams.locked_cells||[],this.hasHeader=!!(uiParams.column_headers&&uiParams.column_headers.length>0),this.hasRowLabels=!!(uiParams.row_labels&&uiParams.row_labels.length>0),this.numDataColumns=uiParams.num_columns,this.rowsPerCell=uiParams.lines_per_cell||2,this.totNumColumns=this.numDataColumns+(this.hasRowLabels?1:0),this.columnWidths=this.computeColumnWidths(),this.reload()}return TableUi.prototype.computeColumnWidths=function(){var defaultWidth=Math.trunc(100/this.totNumColumns),columnWidths=[];if(this.uiParams.column_width_percents&&this.uiParams.column_width_percents.length>0)return this.uiParams.column_width_percents;if(Array.prototype.fill)return new Array(this.totNumColumns).fill(defaultWidth);for(var i=0;i<this.totNumColumns;i++)columnWidths.push(defaultWidth);return columnWidths},TableUi.prototype.isLockedCell=function(row,col){for(var i=0;i<this.lockedCells.length;i++)if(this.lockedCells[i][0]==row&&this.lockedCells[i][1]==col)return!0;return!1},TableUi.prototype.getElement=function(){return this.tableDiv},TableUi.prototype.failed=function(){return this.fail},TableUi.prototype.failMessage=function(){return this.failString},TableUi.prototype.sync=function(){var serialisation=[],empty=!0;$(this.tableDiv).find("table tbody tr").each((function(){var rowValues=[];$(this).find(".table_ui_cell").each((function(){var cellVal=$(this).val();rowValues.push(cellVal),cellVal&&(empty=!1)})),serialisation.push(rowValues)})),empty?this.textArea.val(""):this.textArea.val(JSON.stringify(serialisation))},TableUi.prototype.tableRow=function(iRow,preload){const cellStyle="width:100%;padding:0;font-family:monospace;";let width,disabled,value,html="<tr>",widthIndex=0;this.hasRowLabels&&(width=this.columnWidths[0],widthIndex=1,html+="<th style='padding-top:8px;text-align:center;width:"+width+"%' scope='row'>",iRow<this.uiParams.row_labels.length&&(html+=this.uiParams.row_labels[iRow]),html+="</th>");for(let iCol=0;iCol<this.numDataColumns;iCol++)width=this.columnWidths[widthIndex++],disabled=this.isLockedCell(iRow,iCol)?" disabled":"",value=iRow<preload.length?preload[iRow][iCol]:"",iRow<preload.length&&(value=preload[iRow][iCol]),html+="<td style='padding:2px;margin:0,width:"+width+"'%>",1==this.rowsPerCell?html+='<input type="text" class="table_ui_cell" style="'.concat(cellStyle,'" value="').concat(value,'"').concat(disabled,">"):(html+='<textarea class="table_ui_cell" rows="'.concat(this.rowsPerCell,'"'),html+=' style="'.concat(cellStyle,'resize:vertical;"').concat(disabled,">").concat(value,"</textarea>")),html+="</td>";return html+="</tr>",html},TableUi.prototype.tableHeadSection=function(){let html="<thead>\n",colIndex=0;if(this.hasHeader){html+="<tr>",this.hasRowLabels&&(html+="<th style='width:"+this.columnWidths[0]+"%'></th>",colIndex+=1);for(let iCol=0;iCol<this.numDataColumns;iCol++)html+="<th style='width:"+this.columnWidths[colIndex]+"%'>",iCol<this.uiParams.column_headers.length&&(html+=this.uiParams.column_headers[iCol]),colIndex++,html+="</th>";html+="</tr>\n"}return html+="</thead>\n",html},TableUi.prototype.reload=function(){var preloadJson=$(this.textArea).val(),preload=[],divHtml="<div style='height:fit-content' class='qtype-coderunner-table-outer-div'>\n<table class='table table-bordered qtype-coderunner_table'>\n";if(preloadJson)try{preload=JSON.parse(preloadJson)}catch(error){return this.fail=!0,void(this.failString="table_ui_invalidjson")}try{divHtml+=this.tableHeadSection(),divHtml+="<tbody>\n";for(var num_rows_required=Math.max(this.uiParams.num_rows,preload.length),iRow=0;iRow<num_rows_required;iRow++)divHtml+=this.tableRow(iRow,preload);if(divHtml+="</tbody>\n</table>\n</div>",this.tableDiv=$(divHtml),this.uiParams.dynamic_rows&&this.addButtons(),1==this.rowsPerCell){const ENTER=13;$(this.tableDiv).find(".table_ui_cell").each((function(){$(this).on("keydown",(e=>{e.keyCode===ENTER&&e.preventDefault()}))}))}}catch(error){this.fail=!0,this.failString="table_ui_invalidserialisation"}},TableUi.prototype.addButtons=function(){var deleteButton=$('<button type="button"style="float:right;margin-right:6px" disabled>Delete row</button>'),t=this;this.tableDiv.append(deleteButton),deleteButton.click((function(){var numRows=t.tableDiv.find("table tbody tr").length,lastRow=t.tableDiv.find("tr:last");numRows>t.uiParams.num_rows&&lastRow.remove(),lastRow=t.tableDiv.find("tr:last"),numRows==t.uiParams.num_rows+1&&$(this).prop("disabled",!0)}));var addButton=$('<button type="button"style="float:right;margin-right:6px">Add row</button>');t.tableDiv.append(addButton),addButton.click((function(){var lastRow,newRow;(newRow=(lastRow=t.tableDiv.find("table tbody tr:last")).clone()).find(".table_ui_cell").each((function(){$(this).val("")})),lastRow.after(newRow),$(this).prev().prop("disabled",!1)}))},TableUi.prototype.resize=function(){},TableUi.prototype.hasFocus=function(){var focused=!1;return $(this.tableDiv).find(".table_ui_cell").each((function(){this===document.activeElement&&(focused=!0)})),focused},TableUi.prototype.destroy=function(){this.sync(),$(this.tableDiv).remove(),this.tableDiv=null},{Constructor:TableUi}}));

//# sourceMappingURL=ui_table.min.js.map