<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Defines backup_ubicast_activity_task class
 *
 * @package    mod_ubicast
 * @copyright  2013 UbiCast {@link https://www.ubicast.eu}
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die;

require_once($CFG->dirroot . '/mod/ubicast/backup/moodle2/backup_ubicast_stepslib.php');

/**
 * Provides all the settings and steps to perform one complete backup of the activity
 */
class backup_ubicast_activity_task extends backup_activity_task {

    /**
     * No specific settings for this activity
     */
    protected function define_my_settings() {
    }

    /**
     * Defines a backup step to store the instance data in the ubicast.xml file
     */
    protected function define_my_steps() {
        $this->add_step(new backup_ubicast_activity_structure_step('ubicast_structure', 'ubicast.xml'));
    }

    /**
     * Code the transformations to perform in the activity in
     * order to get transportable (encoded) links
     * @param string $content
     * @return string
     */
    public static function encode_content_links($content) {
        global $CFG;

        // Link to ubicast view by moduleid.
        $base = preg_quote($CFG->wwwroot, '/');
        $search = '/(' . $base . '\/mod\/ubicast\/view.php\?id\=)([0-9]+)/';
        $content = preg_replace($search, '$@UBICASTVIEWBYID*$2@$', $content);

        return $content;
    }
}
