<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

// Project implemented by the "Recovery, Transformation and Resilience Plan.
// Funded by the European Union - Next GenerationEU\".
//
// Produced by the UNIMOODLE University Group: Universities of
// Valladolid, Complutense de Madrid, UPV/EHU, León, Salamanca,
// Illes Balears, Valencia, Rey Juan Carlos, La Laguna, Zaragoza, Málaga,
// Córdoba, Extremadura, Vigo, Las Palmas de Gran Canaria y Burgos.

/**
 * Version details
 *
 * @package    local_notificationsagent
 * @copyright  2023 Proyecto UNIMOODLE
 * @author     UNIMOODLE Group (Coordinator) <direccion.area.estrategia.digital@uva.es>
 * @author     ISYC <soporte@isyc.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$capabilities = [
        'local/notificationsagent:managesiterule' => [
                'captype' => 'write',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => [
                        'guest' => CAP_PROHIBIT,
                        'editingteacher' => CAP_PROHIBIT,
                        'teacher' => CAP_PROHIBIT,
                        'student' => CAP_PROHIBIT,
                ],
        ],
        'local/notificationsagent:managecourserule' => [
                'captype' => 'write',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => [
                        'editingteacher' => CAP_ALLOW,
                        'student' => CAP_PROHIBIT,
                ],
        ],
        'local/notificationsagent:manageownrule' => [
                'captype' => 'write',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => [
                        'editingteacher' => CAP_ALLOW,
                        'teacher' => CAP_ALLOW,
                        'student' => CAP_ALLOW,
                ],
        ],
        'local/notificationsagent:viewcourserule' => [
                'captype' => 'write',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => [
                        'editingteacher' => CAP_ALLOW,
                        'teacher' => CAP_ALLOW,
                ],
        ],
        'local/notificationsagent:manageallrule' => [
                'captype' => 'write',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => [
                        'manager' => CAP_ALLOW,
                        'editingteacher' => CAP_PROHIBIT,
                        'teacher' => CAP_PROHIBIT,
                        'student' => CAP_PROHIBIT,
                ],
        ],
        'local/notificationsagent:createrule' => [
                'captype' => 'write',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => [
                        'manager' => CAP_ALLOW,
                        'editingteacher' => CAP_ALLOW,
                        'teacher' => CAP_ALLOW,
                        'student' => CAP_ALLOW,
                ],
        ],
        'local/notificationsagent:editrule' => [
                'captype' => 'write',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => [
                        'manager' => CAP_ALLOW,
                        'editingteacher' => CAP_ALLOW,
                        'teacher' => CAP_ALLOW,
                        'student' => CAP_ALLOW,
                ],
        ],
        'local/notificationsagent:checkrulecontext' => [
                'captype' => 'read',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => [
                        'manager' => CAP_ALLOW,
                        'editingteacher' => CAP_ALLOW,
                        'teacher' => CAP_ALLOW,
                        'student' => CAP_ALLOW,
                ],
        ],
        'local/notificationsagent:deleterule' => [
                'captype' => 'write',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => [
                        'manager' => CAP_ALLOW,
                        'editingteacher' => CAP_ALLOW,
                        'teacher' => CAP_ALLOW,
                        'student' => CAP_ALLOW,
                ],
        ],
        'local/notificationsagent:updaterulestatus' => [
                'captype' => 'write',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => [
                        'manager' => CAP_ALLOW,
                        'editingteacher' => CAP_ALLOW,
                        'teacher' => CAP_ALLOW,
                        'student' => CAP_ALLOW,
                ],
        ],
        'local/notificationsagent:exportrule' => [
                'captype' => 'write',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => [
                        'manager' => CAP_ALLOW,
                        'editingteacher' => CAP_ALLOW,
                        'teacher' => CAP_ALLOW,
                        'student' => CAP_PROHIBIT,
                ],
        ],
        'local/notificationsagent:importrule' => [
                'captype' => 'write',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => [
                        'manager' => CAP_ALLOW,
                        'editingteacher' => CAP_ALLOW,
                        'teacher' => CAP_ALLOW,
                        'student' => CAP_PROHIBIT,
                ],
        ],
        'local/notificationsagent:assignrule' => [
                'captype' => 'write',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => [
                        'manager' => CAP_ALLOW,
                        'teacher' => CAP_PROHIBIT,
                        'editingteacher' => CAP_PROHIBIT,
                        'student' => CAP_PROHIBIT,
                ],
        ],
        'local/notificationsagent:forcerule' => [
                'captype' => 'write',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => [
                        'manager' => CAP_ALLOW,
                        'teacher' => CAP_PROHIBIT,
                        'editingteacher' => CAP_PROHIBIT,
                        'student' => CAP_PROHIBIT,
                ],
        ],
        'local/notificationsagent:updateruleshare' => [
                'captype' => 'write',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => [
                        'manager' => CAP_ALLOW,
                        'teacher' => CAP_ALLOW,
                        'editingteacher' => CAP_ALLOW,
                        'student' => CAP_PROHIBIT,
                ],
        ],
        'local/notificationsagent:shareruleall' => [
                'captype' => 'write',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => [
                        'manager' => CAP_ALLOW,
                        'teacher' => CAP_PROHIBIT,
                        'editingteacher' => CAP_PROHIBIT,
                        'student' => CAP_PROHIBIT,
                ],
        ],
        'local/notificationsagent:unshareruleall' => [
                'captype' => 'write',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => [
                        'manager' => CAP_ALLOW,
                        'teacher' => CAP_PROHIBIT,
                        'editingteacher' => CAP_PROHIBIT,
                        'student' => CAP_PROHIBIT,
                ],
        ],
        'local/notificationsagent:viewassistantreport' => [
                'captype' => 'read',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => [
                        'manager' => CAP_ALLOW,
                        'editingteacher' => CAP_ALLOW,
                        'student' => CAP_ALLOW,
                ],
        ],
        'local/notificationsagent:managesessions' => [
                'captype' => 'write',
                'contextlevel' => CONTEXT_COURSE,
                'archetypes' => [
                        'manager' => CAP_ALLOW,
                        'editingteacher' => CAP_ALLOW,
                        'student' => CAP_ALLOW,
                ],
        ],
];
