define("mod_kuet/database",["exports"],(function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.initDb=_exports.default=void 0;let dbName,indexedDb=null;function Db(sid,userid){dbName="".concat(sid,"_").concat(userid),this.openDb()}Db.prototype.openDb=function(){let req=indexedDB.open(dbName,1);req.onsuccess=function(evt){indexedDb=evt.target.result},req.onerror=function(event){console.error("Database error: ".concat(event.target.errorCode))},req.onupgradeneeded=function(evt){evt.currentTarget.result.createObjectStore("questions",{keyPath:"kid"}).createIndex("kid","kid",{unique:!0}),evt.currentTarget.result.createObjectStore("statequestions",{keyPath:"state"}).createIndex("state","state",{unique:!0})}},Db.prototype.add=function(storeName,value){this.getObjectStore(storeName,"readwrite").add(value)},Db.prototype.update=function(storeName,value){this.getObjectStore(storeName,"readwrite").put(value)},Db.prototype.get=function(storeName,id){return this.getObjectStore(storeName,"readonly").get(id)},Db.prototype.delete=function(storeName,id){this.getObjectStore(storeName,"readwrite").delete(id)},Db.prototype.getObjectStore=function(storeName,mode){return indexedDb.transaction(storeName,mode).objectStore(storeName)},Db.prototype.clearObjectStore=function(storeName){let req=this.getObjectStore(storeName,"readwrite").clear();req.onsuccess=function(){console.log("clearObjectStore")},req.onerror=function(evt){console.error("clearObjectStore:",evt.target.errorCode)}},Db.prototype.deleteDatabase=function(){return indexedDb.close(),window.indexedDB.deleteDatabase(dbName)};const initDb=(sid,userid)=>new Db(sid,userid);_exports.initDb=initDb;var _default={initDb:initDb};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=database.min.js.map