/**
 *
 * @module    mod_kuet/testssl
 * @copyright  2023 Proyecto UNIMOODLE {@link https://unimoodle.github.io}
 * @author     UNIMOODLE Group (Coordinator) <direccion.area.estrategia.digital@uva.es>
 * @author     3IPUNT <contacte@tresipunt.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_kuet/testssl",["jquery","core/str","core/notification","mod_kuet/encryptor"],(function($,str,notification,Encryptor){let socketUrl="",portUrl="8080",secureProtocol=!1,concatenateOnClose=!1;TestSockets.prototype.root=null;let protocolCell=null,protocolExtraInfoCell=null,sslCell=null,sslExtraInfoCell=null,connectionCell=null,connectionExtraInfoCell=null,sendmessageCell=null,sendmessageExtraInfoCell=null,receivemessageCell=null,receivemessageExtraInfoCell=null;function TestSockets(region,socketurl,port){this.root=$(region),socketUrl=socketurl,portUrl=port,protocolCell=this.root.find("#protocol-test-result"),protocolExtraInfoCell=this.root.find("#protocol-test-extra-info"),sslCell=this.root.find("#ssl-test-result"),sslExtraInfoCell=this.root.find("#ssl-test-extra-info"),connectionCell=this.root.find("#open-connection-test-result"),connectionExtraInfoCell=this.root.find("#open-connection-test-extra-info"),sendmessageCell=this.root.find("#send-message-test-result"),sendmessageExtraInfoCell=this.root.find("#send-message-test-extra-info"),receivemessageCell=this.root.find("#receive-message-test-result"),receivemessageExtraInfoCell=this.root.find("#receive-message-test-extra-info"),this.initTestSockets()}return TestSockets.prototype.setValid=function(element){let clean=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];!0===clean&&TestSockets.prototype.cleanAllChilds(element),element.append('<i class="icon fa fa-check text-success fa-fw " aria-hidden="true"></i>')},TestSockets.prototype.setWarning=function(element){let clean=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];!0===clean&&TestSockets.prototype.cleanAllChilds(element),element.append('<i class="icon fa fa-warning text-warning fa-fw " aria-hidden="true"></i>')},TestSockets.prototype.setError=function(element){let clean=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];!0===clean&&TestSockets.prototype.cleanAllChilds(element),element.append('<i class="icon fa fa-times text-danger fa-fw " aria-hidden="true"></i>')},TestSockets.prototype.setExtraInfo=function(element,msg){let clean=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];!0===clean&&TestSockets.prototype.cleanAllChilds(element),element.append("<span>"+msg+"</span>")},TestSockets.prototype.cleanAllChilds=function(element){if(element&&1===element.length){let el=element[0];el.childNodes.forEach((child=>{el.removeChild(child)}))}},TestSockets.prototype.normalizeSocketUrl=function(socketUrl,port){let jsUrl=new URL(socketUrl);return"/"===jsUrl.pathname?jsUrl.pathname=jsUrl.pathname+"testkuet":jsUrl.pathname=jsUrl.pathname+"/testkuet",jsUrl.port=port,"https:"===jsUrl.protocol?(jsUrl.protocol="wss:",secureProtocol=!0,TestSockets.prototype.setValid(protocolCell),jsUrl.toString()):"http:"===jsUrl.protocol?(jsUrl.protocol="ws:",TestSockets.prototype.setWarning(protocolCell),str.get_strings([{key:"httpsrecommended",component:"mod_kuet"}]).done((function(strings){TestSockets.prototype.setExtraInfo(protocolExtraInfoCell,strings[0])})).fail(notification.exception),jsUrl.toString()):(TestSockets.prototype.setError(protocolCell),str.get_strings([{key:"protocolnotvalid",component:"mod_kuet"}]).done((function(strings){TestSockets.prototype.setExtraInfo(protocolExtraInfoCell,strings[0])})).fail(notification.exception),"")},TestSockets.prototype.initTestSockets=function(){let normalizeSocketUrl=TestSockets.prototype.normalizeSocketUrl(socketUrl,portUrl);TestSockets.prototype.webSocket=new WebSocket(normalizeSocketUrl),null!==TestSockets.prototype.webSocket&&(TestSockets.prototype.webSocket.onopen=function(){TestSockets.prototype.setValid(connectionCell),!0===secureProtocol?(TestSockets.prototype.setValid(sslCell),str.get_strings([{key:"validcertificates",component:"mod_kuet"},{key:"validopenconnection",component:"mod_kuet"}]).done((function(strings){TestSockets.prototype.setExtraInfo(sslExtraInfoCell,strings[0]),TestSockets.prototype.setExtraInfo(connectionExtraInfoCell,strings[1])})).fail(notification.exception)):(TestSockets.prototype.setWarning(sslCell),str.get_strings([{key:"userconnectionsonrisk",component:"mod_kuet"},{key:"validopenconnection",component:"mod_kuet"}]).done((function(strings){TestSockets.prototype.setExtraInfo(sslExtraInfoCell,strings[0]),TestSockets.prototype.setExtraInfo(connectionExtraInfoCell,strings[1])})).fail(notification.exception)),TestSockets.prototype.sendMessageSocket("ping")},TestSockets.prototype.webSocket.onerror=function(event){console.log(event),TestSockets.prototype.setError(sslCell),!0===secureProtocol?str.get_strings([{key:"invalidcertificates",component:"mod_kuet"}]).done((function(strings){TestSockets.prototype.setExtraInfo(sslExtraInfoCell,strings[0]+" "+event.reason),TestSockets.prototype.setExtraInfo(connectionExtraInfoCell,strings[0])})).fail(notification.exception):(str.get_strings([{key:"notusecertificates",component:"mod_kuet"},{key:"invalidconnection",component:"mod_kuet"},{key:"notmakeaconnection",component:"mod_kuet"}]).done((function(strings){TestSockets.prototype.setExtraInfo(sslExtraInfoCell,strings[0]);let messageError="";event&&event.target&&3===event.target.readyState&&(messageError+=" "+strings[2],concatenateOnClose=!0),TestSockets.prototype.setExtraInfo(connectionExtraInfoCell,strings[1]+messageError)})).fail(notification.exception),TestSockets.prototype.setError(sendmessageCell),TestSockets.prototype.setError(receivemessageCell),str.get_strings([{key:"generictesterror",component:"mod_kuet"}]).done((function(strings){TestSockets.prototype.setExtraInfo(sendmessageExtraInfoCell,strings[0]),TestSockets.prototype.setExtraInfo(receivemessageExtraInfoCell,strings[0])})).fail(notification.exception))},TestSockets.prototype.webSocket.onclose=function(event){TestSockets.prototype.setError(connectionCell),str.get_strings([{key:"connectionclosed",component:"mod_kuet"}]).done((function(strings){TestSockets.prototype.setExtraInfo(connectionExtraInfoCell,strings[0]+" "+event.reason,concatenateOnClose),!0===concatenateOnClose&&(concatenateOnClose=!1)})).fail(notification.exception)},TestSockets.prototype.webSocket.onmessage=function(event){if(event.data){TestSockets.prototype.setValid(receivemessageCell);let msgDecrypt=Encryptor.decrypt(event.data),response=JSON.parse(msgDecrypt),resAction=response.action,user=response.usersocketid;"connect"===resAction&&void 0!==user?str.get_strings([{key:"validreceivedtest",component:"mod_kuet"}]).done((function(strings){TestSockets.prototype.setExtraInfo(receivemessageExtraInfoCell,strings[0])})).fail(notification.exception):(TestSockets.prototype.setWarning(receivemessageCell),str.get_strings([{key:"invalidreceivedtest",component:"mod_kuet"}]).done((function(strings){let err=" Expected: Action => connect; user => value, and we received:  Action: "+resAction+" & user: "+user;TestSockets.prototype.setExtraInfo(receivemessageExtraInfoCell,strings[0]+err)})).fail(notification.exception))}else TestSockets.prototype.setError(receivemessageCell),str.get_strings([{key:"nodatareceivedtest",component:"mod_kuet"}]).done((function(strings){TestSockets.prototype.setExtraInfo(receivemessageExtraInfoCell,strings[0])})).fail(notification.exception)})},TestSockets.prototype.sendMessageSocket=function(msg){try{this.webSocket.send(msg),TestSockets.prototype.setValid(sendmessageCell),str.get_strings([{key:"validsendedtest",component:"mod_kuet"}]).done((function(strings){TestSockets.prototype.setExtraInfo(sendmessageExtraInfoCell,strings[0])})).fail(notification.exception)}catch(error){TestSockets.prototype.setError(sendmessageCell),str.get_strings([{key:"invalidsendedtest",component:"mod_kuet"}]).done((function(strings){TestSockets.prototype.setExtraInfo(sendmessageExtraInfoCell,strings[0])})).fail(notification.exception)}},{initTestSockets:function(region,socketurl,port){return new TestSockets(region,socketurl,port)}}}));

//# sourceMappingURL=testssl.min.js.map