<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

// Project implemented by the "Recovery, Transformation and Resilience Plan.
// Funded by the European Union - Next GenerationEU".
//
// Produced by the UNIMOODLE University Group: Universities of
// Valladolid, Complutense de Madrid, UPV/EHU, León, Salamanca,
// Illes Balears, Valencia, Rey Juan Carlos, La Laguna, Zaragoza, Málaga,
// Córdoba, Extremadura, Vigo, Las Palmas de Gran Canaria y Burgos..

/**
 * English language strings
 *
 * @package    mod_kuet
 * @copyright  2023 Proyecto UNIMOODLE {@link https://unimoodle.github.io}
 * @author     UNIMOODLE Group (Coordinator) <direccion.area.estrategia.digital@uva.es>
 * @author     3IPUNT <contacte@tresipunt.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
$string['abbreviationquestion'] = 'Q';
$string['accessrestrictions'] = 'Access restrictions';
$string['active_sessions'] = 'Active Sessions';
$string['activesessionmanagement'] = 'Active session management';
$string['add_questions'] = 'Add questions';
$string['addquestions'] = 'Add questions';
$string['addquestions_desc'] = 'Are you sure about adding {$a} questions to the session?';
$string['alreadyanswered'] = 'A member of your group has already answered!';
$string['alreadyteacher'] = 'There is already a teacher imparting this session, so you cannot connect. Please wait for the current session to end before you can enter.';
$string['anonymiseresponses'] = 'Anonymise student responses';
$string['anonymousanswer'] = 'Anonymous answers';
$string['anonymousanswer_help'] = 'Choose one option.';
$string['anonymousanswers'] = 'The answers to this questionnaire are anonymous.';
$string['automaticstart'] = 'Automatic start';
$string['automaticstart_help'] = 'The session will start and end automatically if dates are set for it, so that it does not have to be started manually.';
$string['backtopanelfromsession'] = 'Back to the sessions panel?';
$string['backtopanelfromsession_desc'] = 'If you come back, the session will not be initialised, and you can start it again at any time. Do you want to return to the session panel?';
$string['cachedef_grades'] = 'Cache for grades in Kuet';
$string['cachedef_groupimages'] = 'Cache for group images in Kuet';
$string['certificate'] = 'Certificate';
$string['certificate_desc'] = '.crt or .pem file of a valid SSL certificate for the server. This file may already be generated on the server, or you can create unique ones for this mod using tools such as <a href="https://zerossl.com" target="_blank">zerossl.com</a>.';
$string['changecategory'] = 'Change of category';
$string['changecategory_desc'] = 'You have selected questions that have not been added to the session. If you change category you will lose this selection. Do you wish to continue?';
$string['completed_sessions'] = 'Completed sessions';
$string['completionansweralldesc'] = 'Participate on a session answering questions.';
$string['completionansweralllabel'] = 'Participate on a session.';
$string['completiondetail:answerall'] = 'Participate on a session answering questions';
$string['configtitle'] = 'Kuet';
$string['configuration'] = 'Configuration';
$string['confirm'] = 'Confirm';
$string['connection_closed'] = 'Connection Closed {$a->reason} - {$a->code}';
$string['connectionclosed'] = 'Connection closed.';
$string['control'] = 'Control';
$string['controlpanel'] = 'Control panel';
$string['copy'] = 'Copy';
$string['copy_session'] = 'Copy session';
$string['copysession'] = 'Copy Session';
$string['copysession_desc'] = 'Are you sure you want to copy this session? If the session has automatic start or start and end dates, these will need to be reset.';
$string['copysessionerror'] = 'An error occurred while copying the session. Check that you have the capacity "mod/kuet:managesessions", or try again later.';
$string['correct'] = 'Correct';
$string['corrects'] = 'Corrects';
$string['countdown'] = 'Show questions countdown';
$string['countdown_help'] = 'Enable this option so that students can see the countdown in each question. (Only if the question has time)';
$string['create_session'] = 'Create session';
$string['delete_session'] = 'Delete session';
$string['deletequestion'] = 'Remove a question from the session';
$string['deletequestion_desc'] = 'Are you sure about removing this question from the session?';
$string['deletesession'] = 'Delete Session';
$string['deletesession_desc'] = 'Are you sure you want to delete this session?';
$string['deletesessionerror'] = 'An error occurred while deleting the session. Check that you have the capacity "mod/kuet:managesessions", or try again later.';
$string['downloadsocket'] = 'Download script to run on external server';
$string['downloadsocket_desc'] = 'Download from here the script to run it on an external server.<br>The administrator of the machine where this script is executed must provide a port and certificates to the script.<br>It is the responsibility of this administrator to ensure that the socket is functioning at all times.<br>';
$string['edit_session'] = 'Edit session';
$string['end'] = 'End';
$string['end_session'] = 'End Session';
$string['end_session_desc'] = 'Are you sure you want to end session?';
$string['end_session_error'] = 'The session could not be ended due to an error in communication with the server, please try again.';
$string['end_session_manual_desc'] = 'If you end the session, you will close the connection of all students and they will no longer be able to answer this questionnaire.<br><b>Are you sure you want to end session?</b>';
$string['enddate'] = 'Session end date';
$string['enddate_help'] = 'Session will end automatically at this date. End date only will be available with programmed sessions.';
$string['endsession'] = 'Session ended';
$string['endsession_info'] = 'You have reached the end of the session, and can now view the report with your results, or continue with the course.';
$string['error_delete_instance'] = 'Error deleting mod Kuet.';
$string['error_initsession'] = 'Error init session';
$string['error_initsession_desc'] = 'The session could not be started, either because a session has already been started or because of a specific error. Please refresh the page and try again.';
$string['erroreditsessionactive'] = 'It is not possible to edit an active session.';
$string['external'] = 'External';
$string['externalurl'] = 'External URL';
$string['externalurl_desc'] = 'URL where the socket is hosted. It can be an IP, but it must have HTTPS protocol.';
$string['extra_info'] = 'Additional information (if exists)';
$string['fakegroup'] = 'Kuet team {$a}';
$string['fakegroupdescription'] = 'Kuet activity has created this group because there are participants on this course
that are not part of the grouping selected.';
$string['feedback'] = 'Feedback';
$string['final_ranking'] = 'Final Ranking';
$string['finishquestion'] = 'Finish the question';
$string['firstsession'] = 'First session grade';
$string['generalsettings'] = 'General settings';
$string['generictesterror'] = 'This test ended with error because the previous test could not be executed or has ended with error.';
$string['go_questionbank'] = 'Go to the question bank';
$string['gocourse'] = 'Go back to your course';
$string['gradeaverage'] = 'Average of grade sessions';
$string['gradehighest'] = 'Session with highest grade';
$string['grademethod'] = 'Grade method';
$string['grademethod_help'] = 'Choose the way to grade this module. Grade will appear on Moodle\'s gradebook';
$string['gradesheader'] = 'Question grading';
$string['groupdisconnected'] = 'Group {$a} has been disconnected';
$string['groupingremoved'] = 'This activity grouping has been removed or it has no members. You can not continue with this session.';
$string['groupings'] = 'Groupings';
$string['groupmemberdisconnected'] = 'This group member {$a} has been disconnected';
$string['groupmode'] = 'Teams mode';
$string['groupremoved'] = 'Your group has been removed or it is not a member of this activity grouping. You can not continue with this session.';
$string['groupreport'] = 'Group session report';
$string['groupreport_info'] = 'The results of a session for a group are displayed.';
$string['groups'] = 'Teams';
$string['groupsessionrankingreport'] = 'Group Session Ranking Report';
$string['httpsrecommended'] = 'You use HTTP protocol. If you are not sure, it is highly recommended to use https protocol on PRODUCTION environments.';
$string['httpsrequired'] = 'It is mandatory to use https protocol on the platform to use Kuet.';
$string['improvise'] = 'Improvise';
$string['improvise_cloudtags'] = 'Improvise Cloud Tags';
$string['inactive_manual'] = 'Manual inactive';
$string['inactive_programmed'] = 'Programmed inactive';
$string['incompatible_question'] = 'Question not compatible';
$string['incorrect'] = 'Incorrect';
$string['incorrect_sessionmode'] = 'Incorrect session mode';
$string['incorrects'] = 'Incorrects';
$string['init_session'] = 'Init Session';
$string['init_session_desc'] = 'If you start a session manually, you can block scheduled sessions with automatic start. Make sure that there are no upcoming sessions before starting this session.<br>Are you sure you want to init session? ';
$string['introduction'] = 'Description';
$string['invalid'] = 'Invalid';
$string['invalidcertificates'] = 'Invalid certificates';
$string['invalidconnection'] = 'Your users cannot make a valid connection with your WebSocket server. Investigate if your url is valid or probe if your port is open and accept connections.';
$string['invalidreceivedtest'] = 'Message received incorrectly';
$string['invalidsendedtest'] = 'Message sent incorrectly';
$string['isevaluable'] = 'Is evaluable?';
$string['jump'] = 'Jump';
$string['jumpto_error'] = 'Must be a number between 1 and {$a}';
$string['kuet:addinstance'] = 'Add a new Kuet package';
$string['kuet:managesessions'] = 'Manage Sessions';
$string['kuet:startsession'] = 'Initialise Sessions';
$string['kuet:view'] = 'View Kuet';
$string['kuet:viewanonymousanswers'] = 'View anonymous answers';
$string['kuetnotexist'] = 'Unable to find kuet with id {$a}';
$string['lastsession'] = 'Last session grade';
$string['local'] = 'Local';
$string['lowspeed'] = 'Your internet connection seems slow or unstable ({$a->downlink} Mbps, {$a->effectiveType}). This may cause unexpected behaviour, or sudden closure of the session.<br>We recommend that you do not init session until you have a good internet connection.';
$string['modulename'] = 'Kuet';
$string['modulenameplural'] = 'Kuets';
$string['multiplesessionerror'] = 'This session is not active or does not exist.';
$string['name'] = 'Name';
$string['next'] = 'Next';
$string['nextsession'] = 'Next session:';
$string['no_time'] = 'No time';
$string['noanonymiseresponses'] = 'Do not anonymise student responses';
$string['nodatareceivedtest'] = 'There seems to be an error between the server connection and the client.';
$string['noevaluable'] = 'Not evaluable';
$string['nograde'] = 'No grades';
$string['nograding'] = 'Ignore correct answer and grading';
$string['nogroupingscreated'] = 'This activity is group mode type but no groupings are created on this course.
It is required that you create firstly a grouping on this course to be able to choose it on this activity.';
$string['noresponse'] = 'No response';
$string['nosession'] = 'No session initialised by the teacher';
$string['nosocket'] = 'Do not use socket';
$string['notactivesession'] = 'Oops, it looks like your teacher has not initialised a session yet...';
$string['notactivesessionawait'] = 'Wait for him to initiate it, or look at your latest reports.';
$string['notallowedspecialchars'] = 'No special characters allowed: ?!<>\\';
$string['notanswers'] = 'Unanswered';
$string['notimelimitenabled'] = 'The session is set without time limit.<br>If you want to add a time per question, you must specify the session mode to "Time per question", specify a default time, and then you can set a time for each question using this form.';
$string['notmakeaconnection'] = '+info: Your browser cannot make a connection with your websocket server, check URL or port.';
$string['notusecertificates'] = 'You not use SSL certificates. If you don\'t do it on purpose, we recommend its use.';
$string['number_select'] = 'Selected questions: ';
$string['openconnectiontest'] = 'Connection with WebSocket server';
$string['openconnectiontest_description'] = 'Check if your users can make a connection with WebSocket server';
$string['orderoftestsexecution'] = 'Order of tests execution';
$string['otheruserreport'] = 'You cannot view another student\'s report';
$string['partially'] = 'Partially';
$string['partially_correct'] = 'Partially correct';
$string['participant'] = 'Participant';
$string['participants'] = 'Participants';
$string['pause'] = 'Pause';
$string['pendingexecutiontest'] = 'Waiting for the previous test to finish';
$string['pendingtest'] = 'Pending test ...';
$string['percent_correct'] = '% Success';
$string['percent_incorrect'] = '% Incorrects';
$string['percent_noresponse'] = '% No response';
$string['percent_partially'] = '% Partially corrects';
$string['play'] = 'Play';
$string['pluginadministration'] = 'Kuet Administration';
$string['pluginname'] = 'Kuet';
$string['podium_manual'] = 'Manual podium';
$string['podium_programmed'] = 'Programmed Podium';
$string['points'] = 'Points';
$string['port'] = 'Port';
$string['port_desc'] = 'Port to make the connection. This port needs to be open, so you will need to check with your system administrator.';
$string['preview'] = 'Preview';
$string['previousstarterror'] = 'The start date cannot be less than the current date.';
$string['privatekey'] = 'Private Key';
$string['privatekey_desc'] = '.pem or .key file of a valid SSL Private Key for the server. This file may already be generated on the server, or you can create unique ones for this mod using tools such as <a href="https://zerossl.com" target="_blank">zerossl.com</a>.';
$string['protocolnotvalid'] = 'Must use HTTP or HTTPS, and HTTPS protocol is strongly recommended to use on the platform to run Kuet.';
$string['protocoltest'] = 'Protocol';
$string['protocoltest_description'] = 'Check if the protocol is http or https';
$string['provisional_ranking'] = 'Provisional Ranking';
$string['qstatus_0'] = 'Incorrect';
$string['qstatus_1'] = 'Success';
$string['qstatus_2'] = 'Partially';
$string['qstatus_3'] = 'No response';
$string['qstatus_4'] = 'Not evaluable';
$string['qstatus_5'] = 'Invalid';
$string['qtimelimit_help'] = 'Time to answer the question. Useful when session time is the sum of the questions time.';
$string['question'] = 'Question';
$string['question_actions'] = 'Actions';
$string['question_index_string'] = '{$a->num} of {$a->total}';
$string['question_isvalid'] = 'Is valid';
$string['question_name'] = 'Name';
$string['question_nosuitable'] = 'Not suitable with kuet plugin.';
$string['question_number'] = 'No. of question';
$string['question_position'] = 'Position';
$string['question_time'] = 'Time per question';
$string['question_time_help'] = 'A set time will be set for each question (you can do this after adding the question to the session). A default time will be set to allocate to those questions that do not have a defined time.';
$string['question_type'] = 'Type';
$string['question_version'] = 'Version';
$string['questionid'] = 'Id';
$string['questionidnotsent'] = 'questionidnotsent';
$string['questionreport'] = 'Question Report';
$string['questionreport_info'] = 'The report of a question in a session is displayed.';
$string['questions'] = 'Questions';
$string['questions_bank'] = 'Question Bank';
$string['questions_list'] = 'Selected questions';
$string['questions_number'] = 'No. of questions';
$string['questionsconfiguration'] = 'Question configuration';
$string['questionsconfiguration_info'] = 'Add the questions to the session';
$string['questiontime'] = 'Question time';
$string['questiontime_desc'] = 'Time for every question in seconds.';
$string['questiontime_help'] = 'HELP! Time for every question in seconds.';
$string['race_manual'] = 'Manual Race';
$string['race_programmed'] = 'Programmed Race';
$string['randomanswers'] = 'Random answers';
$string['randomanswers_help'] = 'Answers will appear in a random order for each student.';
$string['randomquestions'] = 'Random questions';
$string['randomquestions_help'] = 'Questions will appear in a random order for each student. Only valid for programmed session mode.';
$string['ranking'] = 'Ranking';
$string['ready_groups'] = 'Ready groups';
$string['ready_users'] = 'Ready participants';
$string['receivemessagetest'] = 'Receive message response';
$string['receivemessagetest_description'] = 'Receive message response from WebSocket server';
$string['reply_improvise'] = 'Response';
$string['reply_improvise_help'] = 'Be the first to add a word to the word cloud. (Optional)';
$string['reply_improvise_student_help'] = 'Try to answer the question with one word.';
$string['report'] = 'Report';
$string['reportlink'] = 'Report Link';
$string['reports'] = 'Reports';
$string['reports_info'] = 'All completed sessions are displayed to access the report.';
$string['resend'] = 'Resend';
$string['response'] = 'Response';
$string['responses'] = 'Answers';
$string['results'] = 'Results';
$string['runatport'] = 'Kuet is using port: ';
$string['score'] = 'Score';
$string['score_moment'] = 'Question score';
$string['score_obtained'] = 'Score obtained';
$string['scored_answers'] = 'Scored answers';
$string['scriptphp'] = 'Download Script PHP';
$string['select_category'] = 'Select a category';
$string['selectall'] = 'Select/unselect all';
$string['selectone'] = 'Select questions';
$string['selectone_desc'] = 'Select at least one question to add to the session.';
$string['selectvisibles'] = 'Select/unselect visibles';
$string['send_response'] = 'Send response';
$string['sendmessagetest'] = 'Send message';
$string['sendmessagetest_description'] = 'Send message to WebSocket server';
$string['serveroffline'] = 'WebSocket server offline. <a href="./testssl.php?action=start">Start local server</a>';
$string['serverpid'] = 'Local WebSocket server proc.';
$string['serverpid_desc'] = 'Server process {$a->pid} at {$a->server}';
$string['serverrunning'] = 'WebSocket server is running with pid {$a}  <a href="./testssl.php?action=stop">Kill local server</a>';
$string['serverstarted'] = 'WebSocket server started';
$string['serverstopped'] = 'WebSocket server with pid {$a} stopped';
$string['session'] = 'Session';
$string['session_actions'] = 'Actions';
$string['session_closed'] = 'The connection has been closed:';
$string['session_closed_info'] = 'This could be because the session has ended, because the teacher has ended the session, or because of a technical problem with the connection. Please log back into the session to reconnect, or contact your teacher.';
$string['session_date'] = 'Date';
$string['session_finishingdate'] = 'End date';
$string['session_groupings_error'] = 'This activity is set as group mode. Every session must have a grouping selected.';
$string['session_groupings_no_members'] = 'Grouping is empty. Please, select a grouping with participants.';
$string['session_groupings_same_user_in_groups'] = 'Participants must be part of just one group. Check this participants: {$a}';
$string['session_info'] = 'Session information';
$string['session_name'] = 'Session name';
$string['session_name_help'] = 'Write the session name';
$string['session_name_placeholder'] = 'Session name';
$string['session_time'] = 'Total session time';
$string['session_time_resume'] = 'Total session time: {$a}';
$string['sessionactivated'] = 'Session {$a->sessionid} activated for kuetid {$a->kuetid}';
$string['sessionalreadyexists'] = 'Session name already exists';
$string['sessionconfiguration'] = 'Session configuration';
$string['sessionconfiguration_info'] = 'Set up your own session';
$string['sessionconflict'] = 'This session has a date conflict with other sessions closer to it and will not start automatically until the conflict is resolved.';
$string['sessioncreating'] = 'You have not finished editing this session. You must reach step 3 of editing and click on finish.';
$string['sessionended'] = 'Session ended';
$string['sessionended_desc'] = 'When a user ends a session, an event is triggered to calculate the session grade.';
$string['sessionerror'] = 'An error has occurred in this session and cannot be continued (deletion of active groups or groupings, deletion of questions, modification of mod settings, etc.). Duplicate it and/or delete it, but check all the configuration involved.';
$string['sessionfinished'] = 'Session {$a->sessionid} finished for kuetid {$a->kuetid}';
$string['sessionfinishedformoreone'] = 'Session {$a->sessionid} finished for kuetid {$a->kuetid} because more than one session is active.';
$string['sessionlimittimebyquestionsenabled'] = 'This session has time limit of {$a}. The total time for each question shall be calculated by dividing the total time by the number of questions.<br>If you want to add a time per question, you must specify the session mode to "Time per question", specify a default time, and then you can set a time for each question using this form.';
$string['sessionmanualactivated'] = 'The session {$a->sessionid} is active in kuetid -> {$a->kuetid}. The remainder of the session is omitted until the end of this session.';
$string['sessionmode'] = 'Session mode';
$string['sessionmode_help'] = 'Session modes show different ways to use kuet sessions.';
$string['sessionnoquestions'] = 'No questions added to the session.';
$string['sessionquestionsreport'] = 'Session Questions Report';
$string['sessionrankingreport'] = 'Session Ranking Report';
$string['sessionreport'] = 'Session report';
$string['sessionreport_info'] = 'The report of the session is shown.';
$string['sessions'] = 'Sessions';
$string['sessions_info'] = 'All sessions are displayed';
$string['sessionsnum'] = 'Number of sessions';
$string['sessionstarted'] = 'Session started';
$string['sessionstarted_info'] = 'You have started the session, you need to keep track of the questions.';
$string['sessiontime'] = 'Session time';
$string['sessiontime_help'] = 'The set time shall be divided by the number of questions, and equal time shall be allocated to all questions.';
$string['sessionwarning'] = 'This session should have started, but there is currently an active session preventing it from doing so. It will start automatically as soon as the active session ends.';
$string['sgrade'] = 'Grade the session';
$string['sgrade_desc'] = 'If this settings is checked, the mark obtained will be part of the activity grade on the gradebook.';
$string['sgrade_help'] = 'Check this setting if you want that the grade obtained on this session will be part of the activity grade.';
$string['showfeedback'] = 'Show feedback';
$string['showfeedback_help'] = 'After answering each question, feedback will appear. In manual mode, the teacher can show or hide the feedback for each question (only if the question contains feedback).';
$string['showfinalgrade'] = 'Show final grade';
$string['showfinalgrade_help'] = 'Final grade will appear after finishing the session.';
$string['showgraderanking'] = 'Show ranking between questions';
$string['showgraderanking_help'] = 'Teacher will not see the ranking during a live session. Only available on podiums session modes.';
$string['showgraderankinghelp'] = 'SIN _Teacher will not see the ranking during a live session. Only available on podiums session modes.';
$string['showhide'] = 'Show / hide';
$string['socket'] = 'Socket';
$string['sockettype'] = 'Socket type';
$string['sockettype_desc'] = 'A socket server is needed to initiate manual sessions. This socket can be local or external: <ul><li><b>No socket: </b>Manual session modes shall not be used</li><li><b>Local socket: </b>The socket will be started on the same server as this platform (needs to have certificates).</li><li><b>External: </b>You can initiate the socket on an external server, providing the url and port to the platform for connection.</li></ul>';
$string['socketurl'] = 'The url of WebSocket\'s server is: ';
$string['ssltest'] = 'SSL certificate';
$string['ssltest_description'] = 'Check if the SSL certificate is valid';
$string['startdate'] = 'Session start date';
$string['startdate_help'] = 'Session will start automatically at this date. Start date only will be available with programmed sessions.';
$string['startminorend'] = 'The end date of the session cannot be equal to or less than the start date.';
$string['statement_improvise'] = 'Statement of the cloud of tags';
$string['statement_improvise_help'] = 'Remember that it should be a question that can preferably be answered in one word.';
$string['statement_improvising'] = 'Improvise question Cloud of Tags';
$string['statistics'] = 'Statistics';
$string['status'] = 'Status';
$string['student_number'] = 'No. of students';
$string['students'] = 'Students';
$string['submit'] = 'Submit';
$string['success'] = 'Success';
$string['summarysession'] = 'Summary of the session';
$string['summarysession_info'] = 'Review the session';
$string['system_error'] = 'An error has occurred and the connection has been closed.<br>It is not possible to continue with the session.';
$string['teacherimprovising'] = 'The teacher is improvising a "Cloud of Tags" question, where you have to answer a question with one word.<br>As soon as the teacher finishes, the question will appear and you will be able to answer it, to see the answers together with those of all your classmates.';
$string['test_description'] = 'Who checks';
$string['test_info'] = 'Testing information';
$string['tests'] = 'Test';
$string['testssl'] = 'Connection test';
$string['testssl_desc'] = 'Socket connection test with SSL certificates';
$string['time'] = 'Time';
$string['timecannotbezero'] = 'Time can not be zero';
$string['timelimit'] = 'Time limit';
$string['timelimit_help'] = 'Total time for the session';
$string['timemode'] = 'Time mode';
$string['timemode_help'] = 'It should be noted that the time for each question corresponds to the time allowed for "answering", as answering each question will stop the time until the user moves on to the next one.<br><br><b>No time:</b> No time to finish the session. Time can be set for each question, some or none (in the question panel).<br><b>Total session time:</b> The set time shall be divided by the number of questions, and equal time shall be allocated to all questions.<br><b>Time per question:</b> A set time will be set for each question (you can do this after adding the question to the session). A default time will be set to allocate to those questions that do not have a defined time.<br><br><b>Important:</b> if in a timed question the user closes the browser or refreshes the page, that question will be considered undelivered, as it will be understood as an attempt to gain time to answer.';
$string['timemodemustbeset'] = 'Total session time or question time must be set';
$string['timeperquestion'] = 'Time per question';
$string['timesettings'] = 'Time settings';
$string['total_score'] = 'Total score';
$string['unit'] = 'Unit';
$string['units'] = 'Units';
$string['userconnectionsonrisk'] = 'Your users are on risk because their connections are not encrypted.';
$string['userdisconnected'] = 'User {$a} has been disconnected.';
$string['userreport'] = 'User session report';
$string['userreport_info'] = 'The results of a session for a user are displayed.';
$string['validcertificates'] = 'Valid SSL Certificates and Port';
$string['validopenconnection'] = 'Valid connection with a WebSocket server.';
$string['validreceivedtest'] = 'The message has been received successfully.';
$string['validsendedtest'] = 'The message has been sent successfully.';
$string['verboselog'] = 'Verbose log';
$string['verboselog_desc'] = 'If enabled, the socket server will log a lot of information about messages and connections. Log file will be in tempdir/kuet/unimoodleserver.log This is useful for debugging, but it can generate a lot of information in the logs.';
$string['viewquestion_user'] = 'See answer';
$string['viewreport_group'] = 'Group report';
$string['viewreport_session'] = 'View report';
$string['viewreport_user'] = 'User report';
$string['vote'] = 'Vote';
$string['vote_tags'] = 'Vote tags';
$string['waitingroom'] = 'Waiting room';
$string['waitingroom_info'] = 'Check that everything is correct before starting the session.';
$string['waitingroom_message'] = 'Hold on, we\'re leaving in no time...';
$string['waitteacher'] = 'Waiting for the teacher';
$string['warningtest'] = 'This will attempt a connection to the socket with the current configuration. <b>Save the configuration before testing.</b>';
