/**
 * Version details
 *
 * @package    quizaccess_quiztimer
 * @copyright  2023 Proyecto UNIMOODLE
 * @author     UNIMOODLE Group (Coordinator) <direccion.area.estrategia.digital@uva.es>
 * @author     ISYC <soporte@isyc.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("quizaccess_quiztimer/time",["jquery","core/ajax","core/notification","core/str"],(function($,ajax,notification,str){const cmid=new URLSearchParams(window.location.search).get("cmid"),selectstrings=str.get_strings([{key:"sectiontime",component:"quizaccess_quiztimer"},{key:"questiontime",component:"quizaccess_quiztimer"},{key:"distributesectiontime",component:"quizaccess_quiztimer"},{key:"timelimitedit",component:"quizaccess_quiztimer"}]),unitsstrings=str.get_strings([{key:"seconds",component:"quizaccess_quiztimer"},{key:"minutes",component:"quizaccess_quiztimer"},{key:"hours",component:"quizaccess_quiztimer"}]),repaginatewarning=str.get_string("repaginatewarning","quizaccess_quiztimer"),questiontime=async function(e){const invalidsettedtime=await str.get_string("invalidsettedtime","quizaccess_quiztimer");let target=e.currentTarget;if("Enter"===e.key){let timevalue=target.value;target.value=timevalue.replace(/[^0-9].*$/,""),timevalue=target.value;let timedisplay=target.closest(".time").querySelector(".question-time");""==timevalue||0==timevalue?(notification.addNotification({message:invalidsettedtime,type:"error"}),window.scrollTo({top:0,behavior:"smooth"})):timedisplay.innerHTML=timevalue,timedisplay.removeAttribute("style");let timeid=timedisplay.getAttribute("id")+"-edit";$("#"+timeid).remove(),set_question_time_call(timedisplay)}else if("Escape"===e.key){target.closest(".time").querySelector(".question-time").removeAttribute("style"),this.remove()}},sectiontime=async function(e){const invalidsettedtime=await str.get_string("invalidsettedtime","quizaccess_quiztimer");let target=e.currentTarget;if("Enter"===e.key){target.value=target.value.replace(/[^0-9].*$/,"");let timevalue=target.value,timedisplay=target.closest(".section-heading").querySelector(".section-time");timedisplay.innerHTML=timevalue,""==timevalue?(timedisplay.innerHTML=0,notification.addNotification({message:invalidsettedtime,type:"error"}),window.scrollTo({top:0,behavior:"smooth"})):0==timevalue&&(notification.addNotification({message:invalidsettedtime,type:"error"}),window.scrollTo({top:0,behavior:"smooth"})),timedisplay.removeAttribute("style");let timeid=timedisplay.getAttribute("id")+"-edit";$("#"+timeid).remove();let timedata=get_section_time_from_slots(timedisplay.closest(".section-heading"));set_section_time_call(timedisplay.closest(".section.main.clearfix"),parseFloat(timedata.unit),parseFloat(timedata.value))}else if("Escape"===e.key){target.closest(".section-heading").querySelector(".section-time").removeAttribute("style"),this.remove()}},adjust_question_time_display=function(e){let selectedoption=e.currentTarget;selectedoption.value;let timedata=get_question_time(selectedoption.closest(".slot")),value=parseFloat(timedata.value);0===value||isNaN(value)||(selectedoption.options[0].setAttribute("disabled","true"),set_question_time_call(selectedoption))},adjust_section_time_display=function(e){let selectedoption=e.currentTarget,section=selectedoption.closest(".section.main.clearfix"),unit=selectedoption.value,value=parseFloat(section.querySelector(".section-time").innerHTML);0===value||isNaN(value)||"0"===unit||isNaN(unit)||(selectedoption.options[0].setAttribute("disabled","true"),unit=parseFloat(section.querySelector(".time-select").options[unit].value),set_section_time_call(section,unit,value))},get_question_time=function(question){let unit=question.querySelector(".time-select").value,timevalue=question.querySelector(".question-time").innerHTML;return timevalue=get_time_in_seconds(parseFloat(unit),parseFloat(timevalue)),{unit:unit,value:timevalue}},get_section_time_from_slots=function(section){return{unit:section.querySelector(".time-select").value,value:section.querySelector(".section-time").innerHTML}},get_section_id=function(section){let id=section.id;return{sectionid:id.substring(id.indexOf("-")+1)}},get_question_id=function(question){let id=question.id;return{questionid:id.substring(id.indexOf("-")+1)}},edit_question_time=function(e){let time=e.currentTarget.closest(".time"),timevalue=time.querySelector(".question-time"),timeid=timevalue.getAttribute("id")+"-edit";$("<input></input>").attr({type:"text",name:"time",id:timeid,size:"5",value:timevalue.innerHTML}).prependTo(time),timevalue.setAttribute("style","display:none"),$("#"+timeid).focus(),$("#"+timeid).on("keydown",this,questiontime),$("#"+timeid).on("blur",this,(function(){this.closest(".time").querySelector(".question-time").removeAttribute("style"),this.remove()}))},edit_section_time=function(e){let time=e.currentTarget.closest(".time"),timevalue=time.querySelector(".section-time"),timeid=timevalue.getAttribute("id")+"-edit";$("<input></input>").attr({type:"text",name:"time",id:timeid,size:"5",value:timevalue.innerHTML}).prependTo(time),timevalue.setAttribute("style","display:none"),$("#"+timeid).focus(),$("#"+timeid).on("keydown",this,sectiontime),$("#"+timeid).on("blur",this,(function(){this.closest(".section-heading").querySelector(".section-time").removeAttribute("style"),this.remove()}))},change_time_edit_method=function(e){$.when(repaginatewarning).done((repaginatestring=>{if(confirm(repaginatestring)){let editmethod=e.currentTarget.value,url=location.href,k=url.search("&edittype=");if(-1!=k){let editmethod2=url.substring(k).split("=")[1];url=url.replace(editmethod2,editmethod)}else url+="&edittype="+editmethod;url=url.replace("#",""),get_quiz_id(cmid).then((response=>{let quizid=JSON.parse(response).quizid;repaginate_slots(quizid,editmethod).done((()=>{window.location.href=url}))}))}}))},load_section_time=section=>{let questions=section.querySelectorAll(".slot"),totaltime=get_total_time_of_questions(questions);$.when(unitsstrings).done((unitsstrings=>{totaltime=format_pagetime(totaltime,unitsstrings[0],unitsstrings[1],unitsstrings[2])})),section.querySelector(".total-section-time").innerHTML=totaltime,0===parseFloat(section.querySelector(".time-select").value)&&(section.querySelector(".total-section-unit").value=1)},repaginate_slots=(quizid,editmethod)=>ajax.call([{methodname:"quizaccess_quiztimer_repaginate_slots",args:{quizid:quizid,editmethod:editmethod}}])[0].done((response=>response)).fail((err=>{console.log(err)})),set_section_time_call=(section,unit,value)=>{let timedata={unit:unit,value:value=get_time_in_seconds(unit,value)};get_quiz_id(cmid).then((response=>{let quizid=JSON.parse(response).quizid,sectionid=get_section_id(section).sectionid;set_section_time(quizid,sectionid,timedata).then((()=>{get_section_time_call(section),"equitative"==document.querySelector('input[name="timetype"]').value&&get_page_time_from_section(section)}))}))},get_section_time_call=async section=>{const warningtimestr=await str.get_string("warningtime","quizaccess_quiztimer");get_quiz_id(cmid).then((response=>{let quizid=JSON.parse(response).quizid,sectionid=get_section_id(section).sectionid;get_section_time(quizid,sectionid).then((response=>{let timedata=JSON.parse(response);timedata||(section.querySelector(".time-select").value=2,section.querySelector(".total-section-time").innerHTML="",section.querySelector(".total-section-unit").innerHTML="",section.querySelector(".section-time").innerHTML=0);let unit=timedata.timeunit,value=get_time_in_unit(parseFloat(unit),parseFloat(timedata.timevalue));if(0===value){if(section.querySelector(".time-select").value=2,!section.querySelector(".warningtime")){let warningtime=document.createElement("span");warningtime.setAttribute("class","text-danger warningtime"),warningtime.append(warningtimestr),section.querySelector(".section-heading").appendChild(warningtime)}}else section.querySelector(".time-select").value=unit,section.querySelector(".warningtime")&&section.querySelector(".section-heading").removeChild(section.querySelector(".warningtime"));section.querySelector(".total-section-time").innerHTML=value,section.querySelector(".total-section-unit").innerHTML=section.querySelector(".time-select").options[unit].text,section.querySelector(".section-time").innerHTML=value,display_quiz_time("section"),quiz_has_attemps()}))}))},get_total_time_of_questions=questions=>{let totaltime=0;for(let t=0;t<questions.length;t++){let timeunit=parseInt(questions[t].querySelector(".time-select").value),time=parseFloat(questions[t].querySelector(".question-time").innerHTML);totaltime+=get_time_in_seconds(timeunit,time)}return totaltime},load_page_time=page=>{if(page.querySelector(".pagetime")){let pagetime=page.querySelector(".pagetime"),time=pagetime.querySelector(".total-page-time"),unit=pagetime.querySelector(".total-page-unit"),question=$(page).nextUntil(".pagenumber.activity.timed"),totaltime=get_total_time_of_questions(question),pagetimeunit=parseFloat(question[0].querySelector(".time-select").value);totaltime=get_time_in_unit(pagetimeunit,totaltime),time.innerHTML=totaltime,unit.innerHTML=question[0].querySelector(".time-select").options[pagetimeunit].innerHTML}else create_timed_page_elements(page)},create_timed_page_elements=page=>{let id=page.getAttribute("id"),question=$("#"+id).nextUntil(".pagenumber.activity.timed"),totaltime=get_total_time_of_questions(question),pagetimeunit=parseFloat(question[0].querySelector(".time-select").value);totaltime=get_time_in_unit(pagetimeunit,totaltime);let pagetime=document.createElement("span");pagetime.setAttribute("class","pagetime"),page.append(pagetime);let pagevalue=document.createElement("span");pagevalue.setAttribute("class","total-page-time"),pagevalue.innerHTML=totaltime,pagetime.append(pagevalue);let pageunit=document.createElement("span");pageunit.setAttribute("class","total-page-unit"),pagetime.append(" "),pagetime.append(pageunit)},get_page_time_from_section=page=>{var pageloadedsections=[];let section=page.closest(".section.main.clearfix");if(!pageloadedsections.includes(section.id)){pageloadedsections.push(section.id);let sectionpages=section.querySelectorAll(".pagenumber"),sectionid=get_section_id(section).sectionid;get_quiz_id(cmid).then((response=>{let quizid=JSON.parse(response).quizid;get_section_time(quizid,sectionid).then((response=>{let pagetime=JSON.parse(response).timevalue/sectionpages.length;$.when(unitsstrings).done((unitsstrings=>{pagetime=format_pagetime(pagetime,unitsstrings[0],unitsstrings[1],unitsstrings[2]);for(let t=0;t<sectionpages.length;t++)sectionpages[t].querySelector(".total-page-time").innerHTML=pagetime}))}))}))}},format_pagetime=(time,seconds,minutes,hours)=>{let pagetime="";if(time/3600>=1){let h=Math.floor(time/3600);if(time%3600!=0){if(time%3600>=60){if(time%3600%60!=0){return pagetime=h+" "+hours+" "+Math.floor(time%3600/60)+" "+minutes+" "+time%3600%60+" "+seconds,pagetime}return pagetime=h+" "+hours+" "+time%3600/60+" "+minutes,pagetime}return pagetime=h+" "+hours+" "+time%3600+" "+seconds,pagetime}return pagetime=h+" "+hours,pagetime}if(time/60>=1){let m=Math.floor(time/60);if(time%60!=0){return pagetime=m+" "+minutes+" "+ +(time%60).toFixed(2)+" "+seconds,pagetime}return pagetime=m+" "+minutes,pagetime}return pagetime=+time.toFixed(2)+" "+seconds,pagetime},get_time_in_seconds=(timeunit,time)=>{let timeinseconds=0;switch(timeunit){case 1:timeinseconds=time;break;case 2:timeinseconds=60*time;break;case 3:timeinseconds=3600*time;break;default:timeinseconds=0}return timeinseconds},get_time_in_unit=(timeunit,time)=>{let sectiontimeinunit=0;switch(timeunit){case 1:sectiontimeinunit=time;break;case 2:sectiontimeinunit=time/60;break;case 3:sectiontimeinunit=time/3600;break;default:sectiontimeinunit=0}return parseFloat(sectiontimeinunit.toFixed(2))},display_quiz_time=timetype=>{let quiztimer=document.querySelector(".quiztimer-time");$.when(unitsstrings).done((unitsstrings=>{get_quiz_id(cmid).then((response=>{let quizid=JSON.parse(response).quizid;get_quiz_time(quizid,timetype).then((r=>{let time=format_pagetime(JSON.parse(r).time,unitsstrings[0],unitsstrings[1],unitsstrings[2]);""==quiztimer.innerHTML?quiztimer.append(" | "+time):quiztimer.innerHTML=" | "+time}))}))}))},get_quiz_time=(quizid,editmethod)=>ajax.call([{methodname:"quizaccess_quiztimer_get_quiz_time",args:{quizid:quizid,editmethod:editmethod}}])[0].done((response=>response)).fail((err=>{console.log(err)})),set_section_time=(quizid,sectionid,timedata)=>ajax.call([{methodname:"quizaccess_quiztimer_set_section_time",args:{quizid:quizid,sectionid:sectionid,timedata:JSON.stringify(timedata)}}])[0].done((response=>response)).fail((err=>{console.log(err)})),get_section_time=(quizid,sectionid)=>ajax.call([{methodname:"quizaccess_quiztimer_get_section_time",args:{quizid:quizid,sectionid:sectionid}}])[0].done((response=>response)).fail((err=>{console.log(err)})),set_question_time_call=async slot=>{let timedata=get_question_time(slot.closest(".slot"));if(0!=timedata.unit){let question=slot.closest('[id^="slot"]'),questionid=get_question_id(question);0!=timedata.value&&question.querySelector(".warningtime")&&question.querySelector(".activityinstance").removeChild(question.querySelector(".warningtime")),get_quiz_id(cmid).then((response=>{let quizid=JSON.parse(response);set_question_time(quizid.quizid,questionid.questionid,timedata).then((response=>{let page=get_page_from_slotid(JSON.parse(response).slot);load_page_time(page),load_section_time(question.closest(".section.main.clearfix")),display_quiz_time("slots")}))}))}},set_question_time=(quizid,questionid,timedata)=>ajax.call([{methodname:"quizaccess_quiztimer_set_question_time",args:{quizid:quizid,questionid:questionid,timedata:JSON.stringify(timedata)}}])[0].done((response=>response)).fail((err=>{console.log(err)})),get_quiz_id=cmid=>ajax.call([{methodname:"quizaccess_quiztimer_get_quiz_id",args:{cmid:cmid}}])[0].done((function(response){return response})).fail((function(err){console.log(err)})),load_question_time=questionid=>ajax.call([{methodname:"quizaccess_quiztimer_get_question_time",args:{questionid:questionid}}])[0].done((response=>response)).fail((err=>{console.log(err)})),get_page_from_slotid=slot=>$("#"+("slot-"+slot)).prev(".pagenumber.timed")[0],quiz_has_attemps=()=>{if(null!==document.querySelector(".statusdisplay")){document.querySelector("#id_quiztimer_quizmodeselector").setAttribute("disabled",!0);let mainquizslots=document.querySelector(".slots"),selectors=mainquizslots.querySelectorAll("select"),pencils=mainquizslots.querySelectorAll(".fa-pencil");selectors.forEach((selector=>{selector.setAttribute("disabled",!0)})),pencils.forEach((pencil=>{pencil.setAttribute("style","display:none;")}))}};return{init:async function(){let timetype=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"timelimit";const warningtimestr=await str.get_string("warningtime","quizaccess_quiztimer"),noquestions=await str.get_string("noquestions","mod_quiz"),selectatimetype=await str.get_string("selecttypetimes","quizaccess_quiztimer");$(document).ready((function(){let navitem=$(".activity-header")[0];$.when(selectstrings).done((selectstrings=>{let select=document.createElement("select");select.setAttribute("class","custom-select urlselect timeselect"),select.setAttribute("id","id_quiztimer_quizmodeselector"),select.add(new Option(selectstrings[3],"timelimit")),select.add(new Option(selectstrings[0],"section")),select.add(new Option(selectstrings[1],"slots")),select.add(new Option(selectstrings[2],"equitative")),navitem.append(select);let selectedoption=0;selectedoption=select.options[0].value==timetype?0:select.options[1].value==timetype?1:select.options[2].value==timetype?2:3,select.options[selectedoption].setAttribute("selected","true"),select.addEventListener("change",change_time_edit_method,!0)}));let quiztime=document.createElement("span");quiztime.setAttribute("class","quiztimer-time");let slotheader=document.querySelector(".mod-quiz-edit-content").querySelector("h2");slotheader.append(quiztime),display_quiz_time(timetype);let secrettimetype=document.createElement("input");if(secrettimetype.setAttribute("type","hidden"),secrettimetype.setAttribute("name","timetype"),secrettimetype.setAttribute("value",timetype),slotheader.append(secrettimetype),"timelimit"===timetype){let sections=$(".section.main.clearfix");for(let x=0;x<sections.length;x++){sections[x].setAttribute("style","display:none")}let selecttypewarning=document.createElement("h2");return selecttypewarning.append(selectatimetype),selecttypewarning.setAttribute("class","text text-info"),void document.querySelector(".statusbar").append(selecttypewarning)}let questions=$(".slot");if(0===questions.length){return $(".section.main.clearfix")[0].setAttribute("style","display:none"),void notification.addNotification({message:noquestions,type:"error"})}let pagesar=[];for(let x=0;x<questions.length;x++){let question=questions[x],select=question.querySelector(".time-select");select.addEventListener("change",adjust_question_time_display,!0),question.querySelector(".editing-question-time").addEventListener("click",edit_question_time,!0);let questionid=get_question_id(question),timeinput=question.querySelector(".question-time");load_question_time(questionid.questionid).then((response=>{if("section"===timetype)question.querySelector(".time").setAttribute("style","display:none"),select.setAttribute("style","display:none");else if("slots"===timetype){if(JSON.parse(response)||0==JSON.parse(response).timevalue){let timedata=JSON.parse(response);if(select.value=timedata.timeunit,timeinput.innerHTML=get_time_in_unit(parseFloat(timedata.timeunit),parseFloat(timedata.timevalue)),!question.querySelector(".warningtime")&&0==timedata.timevalue){let warningtime=document.createElement("span");warningtime.setAttribute("class","text-danger warningtime"),warningtime.append(warningtimestr),question.querySelector(".activityinstance").appendChild(warningtime)}}let pages=$(".pagenumber.activity.timed");for(let t=0;t<pages.length;t++){let page=pages[t];pagesar.includes(page.id)||pagesar.push(page.id),load_page_time(page)}let section=question.closest(".section.main.clearfix");section.querySelector(".time-select").options[2].setAttribute("selected",!0),section.querySelector(".time-select").setAttribute("style","display:none"),section.querySelector(".time").setAttribute("style","display:none"),load_section_time(section),section.querySelector(".section-time").innerHTML=section.querySelector(".total-section-time").innerHTML,display_quiz_time("slots"),quiz_has_attemps()}else if("equitative"===timetype){question.querySelector(".time").setAttribute("style","display:none"),select.setAttribute("style","display:none");let pages=$(".pagenumber.activity.timed");for(let t=0;t<pages.length;t++){let page=pages[t];pagesar.includes(page.id)||(pagesar.push(page.id),load_page_time(page),get_page_time_from_section(page))}}}))}let sections=$(".section.main.clearfix");for(let x=0;x<sections.length;x++){let section=sections[x];section.querySelector(".time-select").addEventListener("change",adjust_section_time_display,!0),section.querySelector(".editing-section-time").addEventListener("click",edit_section_time,!0),"slots"!==timetype&&get_section_time_call(section.closest(".section.main.clearfix")).then()}}))}}}));

//# sourceMappingURL=time.min.js.map