define("local_fullscreen/button",["exports","core/log","core/templates","core/notification","local_fullscreen/keyparser","core/str","core/pending","core_user/repository"],(function(_exports,_log,Templates,_notification,KeyParser,_str,_pending,_repository){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireWildcard(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}return newObj.default=obj,cache&&cache.set(obj,newObj),newObj}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * A javascript module that adds the fullscreen button to a page.
   *
   * @module     local_fullscreen/button
   * @copyright  2018 University of Nottingham
   * @author     Neill Magill <neill.magill@nottingham.ac.uk>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_log=_interopRequireDefault(_log),Templates=_interopRequireWildcard(Templates),_notification=_interopRequireDefault(_notification),KeyParser=_interopRequireWildcard(KeyParser),_pending=_interopRequireDefault(_pending);const SELECTORS_attach="#topofscroll",SELECTORS_attachSecondary="#region-main",SELECTORS_button=".local-fullscreen",SELECTORS_scrollBoost="#page",CLASSES_toggle="fullscreenmode",CLASSES_float="float",TEMPLATES_button="local_fullscreen/button";let TOGGLE,KEYPRESSED=!1,SCROLL=100;_exports.init=async(fullscreen,toggle)=>{const pendingPromise=new _pending.default("local_fullscreen/setup");_log.default.debug("Adding fullscreen button to the page (fullscreen="+fullscreen+")","local_fullscreen/button"),TOGGLE=toggle;let variables={fullscreen:!1,toggle:TOGGLE};1==fullscreen&&(document.querySelector("body").classList.add(CLASSES_toggle),variables.fullscreen=!0);let attachPoint=document.querySelector(SELECTORS_attach);if(attachPoint||(attachPoint=document.querySelector(SELECTORS_attachSecondary),SCROLL=205),!attachPoint)return _log.default.debug("The fullscreen button is not compatible with the current theme","local_fullscreen/button"),void pendingPromise.resolve();let bottonString=await Templates.render(TEMPLATES_button,variables),element=document.createRange().createContextualFragment(bottonString);attachPoint.prepend(element);let button=document.querySelector(SELECTORS_button);button.addEventListener("click",toggleFullscreen),button.addEventListener("keydown",spaceDownHandler),button.addEventListener("keyup",spaceUpHandler),document.addEventListener("keydown",keyDownHandler),document.addEventListener("keyup",keyUpHandler),document.addEventListener("scroll",scrollHandler,{capture:!0}),pendingPromise.resolve()};const spaceDownHandler=event=>{"Space"===event.code&&event.preventDefault()},spaceUpHandler=event=>{"Space"===event.code&&(event.preventDefault(),toggleFullscreen())},keyDownHandler=event=>{!0!==KEYPRESSED&&KeyParser.parse(event)===TOGGLE&&(KEYPRESSED=!0,toggleFullscreen())},keyUpHandler=event=>{!1!==KEYPRESSED&&KeyParser.parse(event)===TOGGLE&&(KEYPRESSED=!1)},scrollHandler=()=>{let button=document.querySelector(SELECTORS_button),boostArea=document.querySelector(SELECTORS_scrollBoost);window.scrollY>SCROLL||boostArea.scrollTop>SCROLL?button.classList.add(CLASSES_float):button.classList.remove(CLASSES_float)},toggleFullscreen=async()=>{const pendingPromise=new _pending.default("local_fullscreen/toggle");let turnon,turnoff,preference,bodyelement=document.querySelector("body"),button=document.querySelector(SELECTORS_button);[turnon,turnoff]=await(0,_str.getStrings)([{key:"turnon",component:"local_fullscreen",param:TOGGLE},{key:"turnoff",component:"local_fullscreen",param:TOGGLE}]),bodyelement.classList.contains(CLASSES_toggle)?(bodyelement.classList.remove(CLASSES_toggle),button.setAttribute("aria-checked","false"),button.setAttribute("title",turnon),preference=!1):(bodyelement.classList.add(CLASSES_toggle),button.setAttribute("aria-checked","true"),button.setAttribute("title",turnoff),preference=!0),updateUserPreference(preference),pendingPromise.resolve()},updateUserPreference=fullscreen=>(0,_repository.setUserPreference)("fullscreenmode",fullscreen).catch(_notification.default.exception)}));

//# sourceMappingURL=button.min.js.map