<?php
// This file is part of the Allocation form activity module for Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * File containing renderable for forms.
 *
 * @package    mod_allocationform
 * @author     Neill Magill <neill.magill@nottingham.ac.uk>
 * @copyright  2019 University of Nottingham
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace mod_allocationform\output;


/**
 * Renderable for Moodle forms in the allocation form activity.
 *
 * @package    mod_allocationform
 * @author     Neill Magill <neill.magill@nottingham.ac.uk>
 * @copyright  2019 University of Nottingham
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class form implements \renderable, \templatable {
    /** @var \moodleform */
    public $form;

    /** @var progress A progress renderable. */
    public $progress;

    /**
     * Constructor for the form object.
     *
     * @param \moodleform $form
     * @param int $state
     */
    public function __construct(\moodleform $form, int $state) {
        $this->form = $form;
        $this->progress = new progress($state);
    }

    /**
     * {@see \templatable::export_for_template}
     */
    public function export_for_template(\renderer_base $output) {
        $return = new \stdClass();
        ob_start();
        $this->form->display();
        $return->form = ob_get_clean();
        if (isset($this->progress)) {
            $return->progress = $this->progress->export_for_template($output);
        }
        return $return;
    }
}
