<?php
// This file is part of the Allocation form activity module for Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * File containing renderers for the allocationform module
 *
 * @package    mod_allocationform
 * @author     Neill Magill <neill.magill@nottingham.ac.uk>
 * @author     Barry Oosthuizen <barry.oosthuizen@nottingham.ac.uk>
 * @copyright  2012 onwards, University of Nottingham
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace mod_allocationform\output;
use html_writer;

/**
 * Defines the renderer for the allocationform module.
 *
 * @package    mod_allocationform
 * @author     Neill Magill <neill.magill@nottingham.ac.uk>
 * @author     Barry Oosthuizen <barry.oosthuizen@nottingham.ac.uk>
 * @copyright  2012 onwards, University of Nottingham
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class renderer extends \plugin_renderer_base {
    /**
     * Generate html for the course overview.
     *
     * @param \stdClass $allocation Allocation form instance generated by get_all_instances_in_courses()
     *                             {@see get_all_instances_in_courses}
     * @param string $message The message to be displayed to the user.
     * @return string
     */
    public function render_overview(\stdClass $allocation, $message) {
        $url = new \moodle_url('/mod/allocationform/view.php', ['id' => $allocation->coursemodule]);
        $link = html_writer::link($url, $allocation->name);
        $output = html_writer::div(get_string('overviewname', 'mod_allocationform', ['link' => $link]), 'name');
        $output .= html_writer::div($message, 'info');
        return html_writer::div($output, 'allocation overview');
    }
}
