define("mod_tutorialbooking/move",["exports","jquery","core/log","core/notification","core/ajax","core/sortable_list","core/str","core/templates"],(function(_exports,_jquery,_log,Notification,Ajax,_sortable_list,Str,Template){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireWildcard(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}return newObj.default=obj,cache&&cache.set(obj,newObj),newObj}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * A javascript module that allows tutorial booking slots to
   * be moved by dragging and dropping them.
   *
   * @module     mod_tutorialbooking/move
   * @copyright  2019 University of Nottingham
   * @author     Neill Magill <neill.magill@nottingham.ac.uk>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_jquery=_interopRequireDefault(_jquery),_log=_interopRequireDefault(_log),Notification=_interopRequireWildcard(Notification),Ajax=_interopRequireWildcard(Ajax),_sortable_list=_interopRequireDefault(_sortable_list),Str=_interopRequireWildcard(Str),Template=_interopRequireWildcard(Template);const SELECTORS_DRAGGABLE=".tutorial_session",SELECTORS_DRAGAREA=".tutorial_sessions",SELECTORS_HANDLEELEMENT=".tutorial_session .sectionname",SELECTORS_MOVEDOWNCONTROL=".tutorial_session .controls .movedown",SELECTORS_MOVEUPCONTROL=".tutorial_session .controls .moveup";let origOrder;const removeElement=element=>{element.parentNode.removeChild(element)};_exports.init=()=>{_log.default.debug("Setting up","mod_tutorialbooking/dragdrop"),Array.from(document.querySelectorAll(SELECTORS_MOVEUPCONTROL)).forEach(removeElement),Array.from(document.querySelectorAll(SELECTORS_MOVEDOWNCONTROL)).forEach(removeElement),createHandles(),new _sortable_list.default(SELECTORS_DRAGAREA).getElementName=getSlotName,(0,_jquery.default)(SELECTORS_DRAGAREA+" "+SELECTORS_DRAGGABLE).on(_sortable_list.default.EVENTS.DRAGSTART,startDrag).on(_sortable_list.default.EVENTS.DROP,drop),_log.default.debug("Setup completed","mod_tutorialbooking/dragdrop")};const getSlotName=element=>Promise.resolve(element.attr("data-name")),attachHandle=async element=>{let string=await Str.get_string("moveslot","mod_tutorialbooking",element.innerText),htmlString=await Template.render("core/drag_handle",{movetitle:string}),html=document.createRange().createContextualFragment(htmlString);element.prepend(html)},createHandles=async()=>{Array.from(document.querySelectorAll(SELECTORS_HANDLEELEMENT)).forEach(await attachHandle)},startDrag=(e,info)=>{_log.default.debug("Drag started","mod_tutorialbooking/move"),origOrder=info.sourceList.children()},drop=(e,info)=>{_log.default.debug("Dropped element","mod_tutorialbooking/move");let newIndex=info.targetList.children().index(info.element),tutorial=e.target.closest(SELECTORS_DRAGAREA),slot=info.element.attr("id"),target=origOrder.get(newIndex).getAttribute("id"),moveslot={methodname:"mod_tutorialbooking_moveslot",args:{tutorial:parseTutorialId(tutorial),slot:parseSlotId(slot),target:parseSlotId(target)}};Ajax.call([moveslot])[0].done((response=>{if(response.success)if("before"===response.where){let message="Slot "+slot+" moved before slot "+target;_log.default.debug(message,"mod_tutorialbooking/dragdrop")}else{let message2="Slot "+slot+" moved after slot "+target;_log.default.debug(message2,"mod_tutorialbooking/dragdrop")}})).fail(Notification.exception)},parseTutorialId=element=>element.getAttribute("id").slice(9),parseSlotId=id=>id.slice(5)}));

//# sourceMappingURL=move.min.js.map