<?php
// This file is part of the Tutorial Booking activity.
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Restore for the Tutorial booking activity.
 *
 * @package   mod_tutorialbooking
 * @category  backup
 * @copyright 2010 onwards Eloy Lafuente (stronk7) {@link http://stronk7.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot . '/mod/tutorialbooking/backup/moodle2/restore_tutorialbooking_stepslib.php'); // Because it exists.

/**
 * Restore task that provides all the settings and steps to perform one complete restore of a Tutorial booking.
 *
 * @author    Benjamin Ellis <benjamin.ellis@nottingham.ac.uk>
 * @copyright University of Nottingham, 2012
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class restore_tutorialbooking_activity_task extends restore_activity_task {

    /**
     * Define (add) particular settings this activity can have
     */
    protected function define_my_settings() {
        // No particular settings for this activity.
    }

    /**
     * Define (add) particular steps this activity can have
     */
    protected function define_my_steps() {
        // Choice only has one structure step.
        $this->add_step(new restore_tutorialbooking_activity_structure_step('tutorialbooking_structure', 'tutorialbooking.xml'));
    }

    /**
     * Define the contents in the activity that must be
     * processed by the link decoder
     */
    public static function define_decode_contents() {
        $contents = [];
        $contents[] = new restore_decode_content('tutorialbooking', ['intro'], 'tutorialbooking');
        $contents[] = new restore_decode_content('tutorialbooking_sessions', ['summary'], 'tutorialbooking_sessions');
        $contents[] = new restore_decode_content('tutorialbooking_messages', ['message'], 'tutorialbooking_messages');
        return $contents;
    }

    /**
     * Define the decoding rules for links belonging
     * to the activity to be executed by the link decoder
     */
    public static function define_decode_rules() {
        $rules = [];
        $rules[] = new restore_decode_rule('TUTORIALBOOKINGVIEWBYID', '/mod/tutorialbooking/view.php?id=$1', 'course_module');
        $rules[] = new restore_decode_rule('TUTORIALBOOKINGINDEX', '/mod/tutorialbooking/index.php?id=$1', 'course');
        return $rules;
    }

    /**
     * Define the restore log rules that will be applied
     * by the {@see restore_logs_processor} when restoring
     * tutorialbooking logs. It must return one array
     * of {@see restore_log_rule} objects
     */
    public static function define_restore_log_rules() {
        $rules = [];

        return $rules;
    }

    /**
     * Define the restore log rules that will be applied
     * by the {@see restore_logs_processor} when restoring
     * course logs. It must return one array
     * of {@see restore_log_rule} objects
     *
     * Note this rules are applied when restoring course logs
     * by the restore final task, but are defined here at
     * activity level. All them are rules not linked to any module instance (cmid = 0)
     */
    public static function define_restore_log_rules_for_course() {
        $rules = [];
        return $rules;
    }
}
