/**
 * Customized output for the attempt administration chart.
 *
 * The class overrides some definitions from core/chart_output_chartjs for custom output.
 *
 * @module     mod_adaptivequiz/attempt_administration_chart_output
 * @copyright  2024 Vitaly Potenko <potenkov@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_adaptivequiz/attempt_administration_chart_output",["core/chart_output_chartjs","core/chartjs","mod_adaptivequiz/attempt_administration_chart_dataset_config"],(function(Output,Chartjs,DatasetConfig){const tooltipItemsFilter=function(tooltipItem){return!(tooltipItem.datasetIndex===DatasetConfig.indices.STANDARD_ERROR_MAX||tooltipItem.datasetIndex===DatasetConfig.indices.STANDARD_ERROR_MIN)},afterTooltipItemLabel=function(tooltipItem){if(tooltipItem.datasetIndex!==DatasetConfig.indices.ABILITY_MEASURE&&tooltipItem.datasetIndex!==DatasetConfig.indices.ADMINISTERED_DIFFICULTY)return"";if(tooltipItem.datasetIndex===DatasetConfig.indices.ABILITY_MEASURE){const stdErrorSeries=this._chart.getSeries()[DatasetConfig.indices.STANDARD_ERROR_PERCENT],stdErrorValue=stdErrorSeries.getValues()[tooltipItem.dataIndex];return"".concat(stdErrorSeries.getLabel(),": ").concat(stdErrorValue)}const rightWrongSeries=this._chart.getSeries()[DatasetConfig.indices.CORRECT_WRONG_FLAG],rightWrongValue=rightWrongSeries.getValues()[tooltipItem.dataIndex];return"".concat(rightWrongSeries.getLabel(),": ").concat(rightWrongValue)},legendConfig=function(){return{labels:{generateLabels(chart){let labels=Chartjs.defaults.plugins.legend.labels.generateLabels(chart);const stdErrorLabelText=labels.find((label=>label.datasetIndex===DatasetConfig.indices.STANDARD_ERROR_PERCENT)).text;labels=labels.filter((label=>!label.hidden&&label.datasetIndex!==DatasetConfig.indices.STANDARD_ERROR_MIN)),labels.sort(((label1,label2)=>label1.datasetIndex-label2.datasetIndex));const stdErrorMaxIndex=labels.findIndex((label=>label.datasetIndex===DatasetConfig.indices.STANDARD_ERROR_MAX));return labels[stdErrorMaxIndex].text=stdErrorLabelText,labels[stdErrorMaxIndex].strokeStyle="#ffcce0",labels[stdErrorMaxIndex].fillStyle="#ffcce0",labels}},onClick:function(){return!1}}};function AttemptAdministrationChartOutput(){Output.apply(this,arguments)}return AttemptAdministrationChartOutput.prototype=Object.create(Output.prototype),AttemptAdministrationChartOutput.prototype._makeConfig=function(){let config=Output.prototype._makeConfig.apply(this,arguments);return config.data.datasets[DatasetConfig.indices.ABILITY_MEASURE].order=DatasetConfig.orderWeights.ABILITY_MEASURE,config.data.datasets[DatasetConfig.indices.TARGET_DIFFICULTY].order=DatasetConfig.orderWeights.TARGET_DIFFICULTY,config.data.datasets[DatasetConfig.indices.ADMINISTERED_DIFFICULTY].order=DatasetConfig.orderWeights.ADMINISTERED_DIFFICULTY,config.data.datasets[DatasetConfig.indices.STANDARD_ERROR_MAX].order=DatasetConfig.orderWeights.STANDARD_ERROR_BORDER,config.data.datasets[DatasetConfig.indices.STANDARD_ERROR_MIN].order=DatasetConfig.orderWeights.STANDARD_ERROR_BORDER,config.data.datasets[DatasetConfig.indices.STANDARD_ERROR_MAX].pointStyle=!1,config.data.datasets[DatasetConfig.indices.STANDARD_ERROR_MIN].pointStyle=!1,config.data.datasets[DatasetConfig.indices.STANDARD_ERROR_MAX].showLine=!1,config.data.datasets[DatasetConfig.indices.STANDARD_ERROR_MIN].showLine=!1,config.data.datasets[DatasetConfig.indices.STANDARD_ERROR_PERCENT].hidden=!0,config.data.datasets[DatasetConfig.indices.CORRECT_WRONG_FLAG].hidden=!0,config.options.plugins.tooltip.filter=tooltipItemsFilter,config.options.plugins.tooltip.callbacks.afterLabel=afterTooltipItemLabel.bind(this),config.options.plugins.tooltip.itemSort=function(tooltip1,tooltip2){return tooltip1.datasetIndex-tooltip2.datasetIndex},config.options.plugins.legend=legendConfig(),config},AttemptAdministrationChartOutput}));

//# sourceMappingURL=attempt_administration_chart_output.min.js.map