<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'graidy', language 'en'
 *
 * @package    local_graidy
 * @copyright  2025 We Envision AI <info@weenvisionai.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['assignroletouser'] = 'Assign role to user';
$string['assignroletouserdesc'] = 'Assign a role to the user created in the previous step. Download the role export file and upload it into the "Use role preset" area:';
$string['baseurl'] = 'Base URL';
$string['baseurl_desc'] = 'Enter the base URL of your GRAiDY instance. Example: https://portal.graidy.tech';
$string['baseurl_heading'] = 'GRAiDY Server Configuration';
$string['baseurl_heading_desc'] = 'Configure the GRAiDY server instance that this Moodle site will connect to.';
$string['createtokenforuser'] = 'Create a token for a user';
$string['createtokenforuserdesc'] = 'Create a token for the user created in the previous step. This token will be used by GRAiDY to authenticate with Moodle.';
$string['createuser'] = 'Create a specific user';
$string['createuserdesc'] = 'A web services user is required to represent the system controlling Moodle.';
$string['dashboard'] = 'GRAiDY Dashboard';
$string['enabledocumentation'] = 'Enable developer documentation';
$string['enabledocumentationdesc'] = 'Detailed web services documentation is available for enabled protocols.';
$string['enableprotocols'] = 'Enable protocols';
$string['enableprotocolsdesc'] = 'At least one protocol should be enabled. For security reasons, only protocols that are to be used should be enabled.';
$string['enablews'] = 'Enable web services';
$string['enablewsdesc'] = 'Web services must be enabled in Advanced features.';
$string['graidy:courseiframeview'] = 'View the GRAiDY course iframe';
$string['graidy:courseiframeview_desc'] = 'Allows users to view the iframe inside the GRAiDY course.';
$string['graidy:modiframeview'] = 'View the GRAiDY module iframe';
$string['graidy:modiframeview_desc'] = 'Allows users to view the iframe inside the GRAiDY module.';
$string['graidy_access_denied'] = 'You do not have permission to access GRAiDY';
$string['graidy_api_key'] = 'GRAiDY API Key';
$string['graidy_assignments'] = 'GRAiDY Assignment Grading';
$string['graidy_description'] = 'AI-Powered grading & analytics for Moodle';
$string['graidy_enable'] = 'Enable GRAiDY Integration';
$string['graidy_grading_button'] = 'GRAiDY Grading';
$string['graidy_iframe_desc'] = 'AI-Powered Grading and Feedback';
$string['graidy_missing_role'] = 'You need the "graidy_webservice" role to access this feature';
$string['graidy_no_data'] = 'No data available for this activity';
$string['graidy_portal'] = 'Graidy Portal';
$string['graidy_portal_privacy_description'] = 'The following user data is sent to GRAiDY for authentication and tracking:';
$string['graidy_quizzes'] = 'GRAiDY Quiz Analytics';
$string['graidy_settings'] = 'GRAiDY Settings';
$string['graidy_settings_desc'] = 'Configure GRAiDY integration settings for Moodle';
$string['graidy_sync_now'] = 'Sync with GRAiDY Now';
$string['graidy_tab'] = 'GRAiDY Grading';
$string['graidyaccesstomoodle'] = 'Allow GRAiDY access to Moodle';
$string['graidyaccesstomoodledesc'] = 'The following steps help you to set up the Moodle web services to allow GRAiDY to interact with Moodle. This includes setting up a token (security key) authentication method.';
$string['iframebaseurlerror'] = 'GRAiDY Base URL is not configured';
$string['iframeheading'] = 'GRAiDY Grading';
$string['iframesnotallowed'] = 'GRAiDY IFRAME NOT SUPPORTED';
$string['indexheading'] = 'GRAiDY Grading Interface';
$string['indexwelcome'] = 'Welcome to GRAiDY Grading';
$string['organizationtoken'] = 'Organization API Key:';
$string['organizationtoken_desc'] = 'Enter the organization API Key of your GRAiDY instance. Example: trxYh-xxxx-xxxx-xxxx';
$string['organizationtoken_heading'] = 'GRAiDY organization API Key';
$string['organizationtoken_heading_desc'] = 'Configure the GRAiDY organization instance that this Moodle site will connect to.';
$string['plugin_heading'] = 'GRAiDY Plugin';
$string['pluginname'] = 'GRAiDY';
$string['privacy:metadata'] = 'The GRAiDY plugin provides extended functionality to access Moodle data via Web Services. It does not store any personal data.';
$string['privacy_email'] = 'The user’s email address';
$string['privacy_firstname'] = 'The user’s Moodle firstname';
$string['privacy_lastname'] = 'The user’s Moodle lastname';
$string['privacy_role'] = 'The user’s role in Moodle';
$string['privacy_token'] = 'The user’s token for the webservice';
$string['privacy_userid'] = 'The Moodle user ID';
$string['privacy_username'] = 'The user’s Moodle username';
$string['registration_get_started'] = 'Steps to Get Started';
$string['registration_info'] = 'To connect your Moodle instance with GRAiDY, you need to register your organization.<br>
1. Register your organization by visiting <a href="https://portal.graidy.tech/register" target="_blank">https://portal.graidy.tech/register</a><br>
2. Log in to your GRAiDY portal and complete your organization registration. <br>
3. Update your Moodle URL under your "Preferences". <br> <strong>Use this Moodle URL:</strong> <code>{$a}</code><br>
4. Go to "API / Integrations" and copy your organization API key.<br>
5. Paste the API key in the field below to complete the setup.<br><br>
Need help? Contact <a href="mailto:info@graidy.tech">info@graidy.tech</a>.';
$string['reports'] = 'GRAiDY Reports';
$string['selectservice'] = 'Select a service';
$string['selectservicedesc'] = 'A service is a set of web service functions. You will allow the user to access to a new service. On the Add service page check \'Enable\' and \'Authorised users\' options.';
$string['selectspecificuser'] = 'Select a specific user';
$string['selectspecificuserdesc'] = 'Add the web services user as an authorised user.';
$string['settings'] = 'GRAiDY Settings';
$string['step'] = 'Step';
$string['tab_assign'] = 'Graidy Module Overview';
$string['tab_course'] = 'Graidy Course Overview';
$string['tab_quiz'] = 'Graidy Module Overview';
$string['webservicedesc'] = 'Description';
$string['webservicestatus'] = 'Status';
$string['welcome'] = 'Welcome to GRAiDY';
