define("local_shopping_cart/cart",["exports","core/ajax","core/templates","core/modal_factory","core/modal_events","local_shopping_cart/cashier","local_shopping_cart/notifications","core_form/dynamicform","core/str","./cashier"],(function(_exports,_ajax,_templates,_modal_factory,_modal_events,_cashier,_notifications,_dynamicform,_str,_cashier2){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.addCheckoutModalListener=addCheckoutModalListener,_exports.addItem=void 0,_exports.addItemShowNotification=addItemShowNotification,_exports.addZeroPriceListener=addZeroPriceListener,_exports.init=_exports.deleteItem=_exports.deleteAllItems=_exports.buttoninit=void 0,_exports.initPriceLabel=function(userid){userid<1&&(userid=0);const checkbox=document.querySelector(SELECTORS_PRICELABELCHECKBOX),installmentscheckbox=document.querySelector(SELECTORS_INSTALLMENTSCHECKBOX);checkbox&&!checkbox.initialized&&(checkbox.initialized=!0,checkbox.addEventListener("change",(event=>{var installementsvalue=!1;installmentscheckbox&&(installementsvalue=installmentscheckbox.checked),event.currentTarget.checked?updateTotalPrice(userid,!0,installementsvalue):updateTotalPrice(userid,!1,installementsvalue)})));installmentscheckbox&&!installmentscheckbox.initialized&&(installmentscheckbox.initialized=!0,console.log("add event listener to installment"),installmentscheckbox.addEventListener("change",(event=>{console.log(event.currentTarget,event.currentTarget.checked),console.log(checkbox);let checkboxchecked=null;checkbox&&(checkboxchecked=checkbox.checked),updateTotalPrice(userid,checkboxchecked,event.currentTarget.checked)})))},_exports.visbilityevent=_exports.updateTotalPrice=_exports.reinit=_exports.interval=void 0,_ajax=_interopRequireDefault(_ajax),_templates=_interopRequireDefault(_templates),_modal_factory=_interopRequireDefault(_modal_factory),_modal_events=_interopRequireDefault(_modal_events),_dynamicform=_interopRequireDefault(_dynamicform);var _systemImportTransformerGlobalIdentifier="undefined"!=typeof window?window:"undefined"!=typeof self?self:"undefined"!=typeof global?global:{};function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var interval=null;_exports.interval=interval;var visbilityevent=!1;_exports.visbilityevent=visbilityevent;const SELECTORS_NAVBARCONTAINER="#nav-shopping_cart-popover-container .shopping-cart-items-container",SELECTORS_TRASHCLASS="fa-trash-o",SELECTORS_DISCOUNTCLASS="shoppingcart-discount-icon",SELECTORS_MODIFYTIMECLASS="shoppingcart-modifytime-icon",SELECTORS_BADGECOUNT="#nav-shopping_cart-popover-container div.count-container",SELECTORS_COUNTDOWN="#nav-shopping_cart-popover-container span.expirationtime",SELECTORS_CASHIERSCART="div.shopping-cart-cashier-items-container",SELECTORS_CHECKOUTCART="div.shopping-cart-checkout-items-container",SELECTORS_PRICELABELCHECKBOX=".sc_price_label input.usecredit-checkbox",SELECTORS_INSTALLMENTSCHECKBOX=".sc_price_label input.useinstallments-checkbox",SELECTORS_PRICELABELAREA=".sc_price_label",SELECTORS_CHECKOUTBUTTON="#nav-shopping_cart-popover-container #shopping-cart-checkout-button",SELECTORS_PAYMENTREGIONBUTTON="div.shopping_cart_payment_region button",SELECTORS_ACCEPTTERMS="#accepttermsandconditions",SELECTORS_CHECKVATNRFORM="div.form_vatnrchecker";_exports.init=(expirationtime,nowdate)=>{initTimer(expirationtime,nowdate);let containers=[];containers=document.querySelectorAll(SELECTORS_NAVBARCONTAINER+","+SELECTORS_CASHIERSCART+","+SELECTORS_CHECKOUTCART),containers.forEach((container=>{container.addEventListener("click",(event=>{const element=event.target;if(element.classList.contains(SELECTORS_TRASHCLASS)){const userid=element.dataset.userid?element.dataset.userid:0,component=element.dataset.component,area=element.dataset.area,itemid=element.dataset.itemid;deleteItem(itemid,component,area,userid)}else element.classList.contains(SELECTORS_DISCOUNTCLASS)?(0,_cashier.discountModal)(event):element.classList.contains(SELECTORS_MODIFYTIMECLASS)&&(0,_cashier2.modifyTimeModal)(event)}))})),document.addEventListener("readystatechange",(()=>{"loading"!==document.readyState&&reinit()})),0==visbilityevent&&document.addEventListener("visibilitychange",(function(){_exports.visbilityevent=visbilityevent=!0,"visible"===document.visibilityState&&reinit()}));const paymentbutton=document.querySelector(SELECTORS_PAYMENTREGIONBUTTON);if(paymentbutton){addZeroPriceListener({price:paymentbutton.dataset.price,currency:paymentbutton.dataset.currency}),addCheckoutModalListener()}const accepttermsbutton=document.querySelector(SELECTORS_ACCEPTTERMS);accepttermsbutton&&paymentbutton&&function(accepttermsbutton,paymentbutton){accepttermsbutton.addEventListener("change",(event=>{event.currentTarget.checked?paymentbutton.disabled=!1:paymentbutton.disabled=!0}))}(accepttermsbutton,paymentbutton),initVATNRChecker()};const initVATNRChecker=()=>{const vatnrchecker=document.querySelector(SELECTORS_CHECKVATNRFORM);if(vatnrchecker){const vatnrcheckerform=new _dynamicform.default(vatnrchecker,"local_shopping_cart\\form\\dynamicvatnrchecker");vatnrcheckerform.addEventListener("change",(e=>{console.log(e.target.checked,e.target.name),e.target.name&&"usevatnr"==e.target.name&&!1===e.target.checked&&(console.log(e.target.value),vatnrcheckerform.submitFormAjax())})),vatnrcheckerform.addEventListener(vatnrcheckerform.events.FORM_SUBMITTED,(()=>{vatnrcheckerform.load(),console.log("form submitted"),reinit()}))}},buttoninit=(itemid,component,area,userid)=>{if(!itemid||!component||!area||void 0===userid){const selector='[data-objecttable="local_shopping_cart"';return void document.querySelectorAll(selector).forEach((button=>{var _button$dataset$useri;const itemid=button.dataset.itemid,area=button.dataset.area,component=button.dataset.component;let userid=null!==(_button$dataset$useri=button.dataset.userid)&&void 0!==_button$dataset$useri&&_button$dataset$useri.trim()?button.dataset.userid:0;buttoninit(itemid,component,area,userid)}))}document.querySelectorAll('div[data-itemid="'+itemid+'"][data-component="'+component+'"][data-area="'+area+'"][data-objecttable="local_shopping_cart"').forEach((addtocartbutton=>{toggleActiveButtonState(addtocartbutton),addtocartbutton&&"true"!==addtocartbutton.dataset.initialized&&(addtocartbutton.dataset.initialized="true",addtocartbutton.dataset.nojs||addtocartbutton.addEventListener("click",(event=>{"true"!=addtocartbutton.dataset.blocked&&(addtocartbutton.classList.contains("disabled")?(event.preventDefault(),event.stopPropagation()):addItem(itemid,component,area,userid))})))}))};_exports.buttoninit=buttoninit;const reinit=function(){let userid=arguments.length>0&&void 0!==arguments[0]?arguments[0]:0;_ajax.default.call([{methodname:"local_shopping_cart_get_shopping_cart_items",args:{userid:userid},done:function(data){const oncashier=window.location.href.indexOf("cashier.php");data.iscashier=oncashier>0;let containers=[];containers=0!=userid&&data.iscashier?document.querySelectorAll(SELECTORS_CASHIERSCART):document.querySelectorAll(SELECTORS_NAVBARCONTAINER+","+SELECTORS_CHECKOUTCART);let promises=[];convertPricesToNumberFormat(data),promises.push(_templates.default.renderForPromise("local_shopping_cart/shopping_cart_items",data).then((_ref=>{let{html:html,js:js}=_ref;return containers.forEach((container=>{_templates.default.replaceNodeContents(container,html,js)})),!0})).catch((e=>{console.log(e)}))),Promise.all(promises).then((()=>{0!=userid&&data.iscashier||(clearInterval(interval),initTimer(data.expirationtime,data.nowdate),updateBadge(data.count)),toggleActiveButtonState(),updateTotalPrice(userid),updateItemPrice(data)})).catch((e=>{console.log(e)}))},fail:ex=>{console.log("ex:"+ex)}}])};function updateItemPrice(data){data.items.forEach((item=>{document.querySelectorAll('[data-itemid="'+item.itemid+'"][data-component="'+item.componentname+'"][data-area="'+item.area+'"][data-objecttable="local_shopping_cart"]').forEach((element=>{element.closest(".pricecontainer").querySelector("span.pricecurrency").innerHTML=item.price+" "+item.currency}))}))}_exports.reinit=reinit;_exports.deleteAllItems=function(){let userid=arguments.length>0&&void 0!==arguments[0]?arguments[0]:0;_ajax.default.call([{methodname:"local_shopping_cart_delete_all_items_from_cart",args:{userid:userid},done:function(){reinit(0)},fail:function(ex){console.log(ex)}}])};const deleteItem=(itemid,component,area,userid)=>{_ajax.default.call([{methodname:"local_shopping_cart_delete_item",args:{itemid:itemid,component:component,area:area,userid:userid},done:function(data){(0,_str.get_string)("item_deleted","local_shopping_cart",data.itemname).then((message=>{(0,_notifications.showNotification)(message,"success")})).catch((e=>{console.log(e)})),reinit(userid),("function"==typeof _systemImportTransformerGlobalIdentifier.define&&_systemImportTransformerGlobalIdentifier.define.amd?new Promise((function(resolve,reject){_systemImportTransformerGlobalIdentifier.require(["local_wunderbyte_table/reload"],resolve,reject)})):"undefined"!=typeof module&&module.exports&&"undefined"!=typeof require||"undefined"!=typeof module&&module.component&&_systemImportTransformerGlobalIdentifier.require&&"component"===_systemImportTransformerGlobalIdentifier.require.loader?Promise.resolve(require("local_wunderbyte_table/reload")):Promise.resolve(_systemImportTransformerGlobalIdentifier["local_wunderbyte_table/reload"])).then((wbt=>{wbt.reloadAllTables()})).catch((err=>{console.log(err)}))},fail:function(){reinit(userid)}}])};_exports.deleteItem=deleteItem;const addItem=(itemid,component,area,userid)=>{Number.isInteger(userid)||(userid=parseInt(userid)),_ajax.default.call([{methodname:"local_shopping_cart_add_item",args:{area:area,component:component,itemid:itemid,userid:userid},done:function(data){data.component=component,data.area=area,data.itemid=itemid,data.userid=userid,addItemShowNotification(data)},fail:function(ex){console.log("error",ex)}}],!0)};_exports.addItem=addItem;const updateTotalPrice=function(){let userid=arguments.length>0&&void 0!==arguments[0]?arguments[0]:0,usecredit=!(arguments.length>1&&void 0!==arguments[1])||arguments[1],useinstallments=arguments.length>2&&void 0!==arguments[2]&&arguments[2];const oncashier=window.location.href.indexOf("cashier.php");oncashier>0&&(userid=-1),Number.isInteger(userid)||(userid=parseInt(userid));const checkboxes=document.querySelectorAll(SELECTORS_PRICELABELCHECKBOX);1==checkboxes.length?checkboxes.forEach((checkbox=>{usecredit=checkbox.checked?1:0})):usecredit=usecredit?1:0;const installmentcheckboxes=document.querySelectorAll(SELECTORS_INSTALLMENTSCHECKBOX);1==installmentcheckboxes.length?installmentcheckboxes.forEach((installmentcheckboxe=>{useinstallments=installmentcheckboxe.checked?1:0})):useinstallments=useinstallments?1:0,_ajax.default.call([{methodname:"local_shopping_cart_get_price",args:{userid:userid,usecredit:usecredit,useinstallments:useinstallments},done:function(data){1==data.usecredit?data.usecreditvalue="checked":data.usecreditvalue="",data.checkboxid=Math.random().toString(36).slice(2,5),data.installments.length>0&&(data.installmentscheckboxid="i"+data.checkboxid),data.userid=userid;const labelareas=document.querySelectorAll(SELECTORS_PRICELABELAREA);convertPricesToNumberFormat(data),_templates.default.renderForPromise("local_shopping_cart/price_label",data).then((_ref2=>{let{html:html,js:js}=_ref2;return labelareas.forEach((labelarea=>{labelarea.dataset.noupdate||(_templates.default.replaceNodeContents(labelarea,html,js),addZeroPriceListener(data))})),!0})).catch((e=>{console.log(e)}));const checkoutButton=document.querySelector(SELECTORS_CHECKOUTBUTTON),paymentbutton=document.querySelector(SELECTORS_PAYMENTREGIONBUTTON);0==data.count?(checkoutButton&&checkoutButton.classList.add("disabled"),paymentbutton&&(paymentbutton.style.display="none")):(checkoutButton&&checkoutButton.classList.remove("disabled"),paymentbutton&&(paymentbutton.style.display="inline"))},fail:function(ex){console.log("error",ex)}}],!0)};function addZeroPriceListener(data){let paymentbutton=document.querySelector(SELECTORS_PAYMENTREGIONBUTTON);if(paymentbutton){if(paymentbutton.classList.contains("disabled"))return void console.log("button disabled");const price=data.price,currency=data.currency;paymentbutton.dataset.cost=price+" "+currency,0==price?paymentbutton.addEventListener("click",dealWithZeroPrice):paymentbutton.removeEventListener("click",dealWithZeroPrice)}}function addCheckoutModalListener(){document.body.addEventListener("click",(function(event){const target=event.target,isModalBackground="modal-container"===target.dataset.region&&target.classList.contains("hide"),closestButton=target.closest("button[data-action='hide']"),isCloseAction=target.closest('[data-region="modal-container"]')&&(closestButton||"cancel"===target.dataset.action);(isModalBackground||isCloseAction)&&setTimeout((()=>{location.reload()}),300)}))}function addItemShowNotification(data){switch(data.success){case 0:return void reinit();case 1:return(0,_str.get_string)("addedtocart","local_shopping_cart",data.itemname).then((message=>{(0,_notifications.showNotification)(message,"success")})).catch((e=>{console.log(e)})),void reinit(data.userid);case 2:return void(0,_str.get_strings)([{key:"cartisfull",component:"local_shopping_cart"},{key:"ok",component:"core"}]).then((strings=>(_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL}).then((modal=>(modal.setBody(strings[0]),modal.setSaveButtonText(strings[1]),modal.show(),modal))).catch((e=>{console.log(e)})),!0))).catch((e=>{console.log(e)}));case 3:return void(0,_str.get_strings)([{key:"error:costcentertitle",component:"local_shopping_cart"},{key:"error:costcentersdonotmatch",component:"local_shopping_cart"},{key:"ok",component:"core"}]).then((strings=>(_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL}).then((modal=>(modal.setTitle(strings[0]),modal.setBody(strings[1]),modal.setSaveButtonText(strings[2]),modal.show(),modal))).catch((e=>{console.log(e)})),!0))).catch((e=>{console.log(e)}));case 4:return void(0,_str.get_strings)([{key:"error:fullybookedtitle",component:"local_shopping_cart"},{key:"error:fullybooked",component:"local_shopping_cart"},{key:"ok",component:"core"}]).then((strings=>(_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL}).then((modal=>(modal.setTitle(strings[0]),modal.setBody(strings[1]),modal.setSaveButtonText(strings[2]),modal.getRoot().on(_modal_events.default.save,(function(){window.location.reload()})),modal.show(),modal))).catch((e=>{console.log(e)})),!0))).catch((e=>{console.log(e)}));case 5:return void(0,_str.get_strings)([{key:"error:alreadybookedtitle",component:"local_shopping_cart"},{key:"error:alreadybooked",component:"local_shopping_cart"},{key:"ok",component:"core"}]).then((strings=>(_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL}).then((modal=>(modal.setTitle(strings[0]),modal.setBody(strings[1]),modal.setSaveButtonText(strings[2]),modal.getRoot().on(_modal_events.default.save,(function(){window.location.reload()})),modal.show(),modal))).catch((e=>{console.log(e)})),!0))).catch((e=>{console.log(e)}));case 6:return void(0,_str.get_strings)([{key:"error:paymentaccounttitle",component:"local_shopping_cart"},{key:"error:paymentaccountsdonotmatch",component:"local_shopping_cart"},{key:"ok",component:"core"}]).then((strings=>(_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL}).then((modal=>(modal.setTitle(strings[0]),modal.setBody(strings[1]),modal.setSaveButtonText(strings[2]),modal.show(),modal))).catch((e=>{console.log(e)})),!0))).catch((e=>{console.log(e)}));default:return void(0,_str.get_strings)([{key:"error:generalcarterror",component:"local_shopping_cart"},{key:"ok",component:"core"}]).then((strings=>(_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL}).then((modal=>(modal.setBody(strings[0]),modal.setSaveButtonText(strings[1]),modal.show(),modal))).catch((e=>{console.log(e)})),!0))).catch((e=>{console.log(e)}))}}async function dealWithZeroPrice(event){var element;event.stopPropagation(),event.preventDefault(),element=event.target,(0,_str.get_strings)([{key:"confirmzeropricecheckouttitle",component:"local_shopping_cart"},{key:"confirmzeropricecheckoutbody",component:"local_shopping_cart"},{key:"confirmzeropricecheckout",component:"local_shopping_cart"}]).then((strings=>(_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL}).then((modal=>(modal.setTitle(strings[0]),modal.setBody(strings[1]),modal.setSaveButtonText(strings[2]),modal.getRoot().on(_modal_events.default.save,(function(){const userid=element.dataset.userid;userid&&(0,_cashier.confirmPayment)(userid,2)})),modal.show(),modal))).catch((e=>{console.log(e)})),!0))).catch((e=>{console.log(e)}))}function startTimer(duration,display){var minutes,seconds,timer=duration;_exports.interval=interval=setInterval((function(){minutes=parseInt(timer/60,10),seconds=parseInt(timer%60,10),minutes=minutes<10?"0"+minutes:minutes,seconds=seconds<10?"0"+seconds:seconds,display.textContent=minutes+":"+seconds,--timer<0&&(setTimeout((()=>{reinit(0)}),2e3),clearInterval(interval))}),1e3)}function initTimer(){let expirationtime=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null,nowdate=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;const countdownelement=document.querySelector(SELECTORS_COUNTDOWN);if(!countdownelement||!nowdate)return;interval&&clearInterval(interval);let delta=0,now=nowdate;expirationtime&&(delta=expirationtime-now),delta<=0?(delta=0,countdownelement.classList.add("hidden")):delta>0&&(countdownelement.classList.remove("hidden"),startTimer(delta,countdownelement))}function updateBadge(count){const badge=document.querySelector(SELECTORS_BADGECOUNT);count>0?(badge.innerHTML=count,badge.classList.remove("hidden")):(badge.innerHTML=count,badge.classList.add("hidden"))}function toggleActiveButtonState(){let button=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null,selector="",component=null,area=null,itemid=null;button?(itemid=button.dataset.itemid,component=button.dataset.component,area=button.dataset.area,selector='div[data-itemid="'+itemid+'"][data-component="'+component+'"][data-area="'+area+'"][data-objecttable="local_shopping_cart"'):selector='div[data-objecttable="local_shopping_cart"';const buttons=document.querySelectorAll(selector);let shoppingcart=document.querySelector(SELECTORS_CASHIERSCART);shoppingcart||(shoppingcart=document.querySelector(SELECTORS_NAVBARCONTAINER)),buttons.forEach((addtocartbutton=>{component=addtocartbutton.dataset.component,area=addtocartbutton.dataset.area,itemid=addtocartbutton.dataset.itemid;shoppingcart.querySelector('[id="item-'+component+"-"+area+"-"+itemid+'"]')?addtocartbutton.classList.add("disabled"):addtocartbutton.classList.remove("disabled")}))}function convertPricesToNumberFormat(data){if(data.price&&(data.price=Number(data.price).toFixed(2)),data.initialtotal&&(data.initialtotal=Number(data.initialtotal).toFixed(2)),data.initialtotal_net&&(data.initialtotal_net=Number(data.initialtotal_net).toFixed(2)),data.discount&&(data.discount=Number(data.discount).toFixed(2)),data.deductible&&(data.deductible=Number(data.deductible).toFixed(2)),data.credit&&(data.credit=Number(data.credit).toFixed(2)),data.remainingcredit&&(data.remainingcredit=Number(data.remainingcredit).toFixed(2)),data.price_net&&(data.price_net=Number(data.price_net).toFixed(2)),data.price_gross&&(data.price_gross=Number(data.price_gross).toFixed(2)),data.items)for(var i=0;i<data.items.length;i++)data.items[i].price&&(data.items[i].price=Number(data.items[i].price).toFixed(2)),data.items[i].price_gross&&(data.items[i].price_gross=Number(data.items[i].price_gross).toFixed(2)),data.items[i].price_net&&(data.items[i].price_net=Number(data.items[i].price_net).toFixed(2))}_exports.updateTotalPrice=updateTotalPrice}));

//# sourceMappingURL=cart.min.js.map