define("local_shopping_cart/cashier",["exports","core/ajax","core/url","local_shopping_cart/notifications","core_form/modalform","core/modal_factory","local_shopping_cart/cart","core/str","core_form/dynamicform","./shistory"],(function(_exports,_ajax,_url,_notifications,_modalform,_modal_factory,_cart,_str,_dynamicform,_shistory){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/*
   * The Cashier module.
   *
   * @package    local_shopping_cart
   * @copyright  Wunderbyte GmbH <info@wunderbyte.at>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.confirmPayment=_exports.addPrintIdentifier=void 0,_exports.discountModal=function(event){const element=event.target.closest(".shopping-cart-item"),price=element.dataset.price,itemid=element.dataset.itemid,userid=element.dataset.userid,componentname=element.dataset.component,area=element.dataset.area,modalForm=new _modalform.default({formClass:"local_shopping_cart\\form\\modal_add_discount_to_item",args:{price:price,itemid:itemid,userid:userid,componentname:componentname,area:area},modalConfig:{title:(0,_str.get_string)("applydiscount","local_shopping_cart")},returnFocus:element});modalForm.addEventListener(modalForm.events.FORM_SUBMITTED,(()=>{(0,_cart.reinit)(-1)})),modalForm.show()},_exports.init=void 0,_exports.modifyTimeModal=function(event){const element=event.target.closest(".shopping-cart-item"),itemid=element.dataset.itemid,userid=element.dataset.userid,componentname=element.dataset.component,area=element.dataset.area,modalForm=new _modalform.default({formClass:"local_shopping_cart\\form\\modal_modify_time_of_deletion_task",args:{itemid:itemid,userid:userid,componentname:componentname,area:area},modalConfig:{title:(0,_str.get_string)("modifytimeofdeletiontask","local_shopping_cart")},returnFocus:element});modalForm.addEventListener(modalForm.events.FORM_SUBMITTED,(e=>{const response=e.detail;console.log(response);const formattedDate=new Date(1e3*response.taskdeletiontimestamp).toLocaleString(response.currentlang,{year:"numeric",month:"long",day:"numeric",hour:"2-digit",minute:"2-digit"});(0,_str.get_string)("modifytimeofdeletiontaskconfirmation","local_shopping_cart",formattedDate).then((localizedmessage=>{(0,_notifications.showNotification)(localizedmessage,"success")})).catch((e=>{(0,_notifications.showNotification)("Error: ".concat(e),"error")}))})),modalForm.show()},_exports.rebookOrderidModal=rebookOrderidModal,_exports.validateCart=void 0,_ajax=_interopRequireDefault(_ajax),_url=_interopRequireDefault(_url),_modalform=_interopRequireDefault(_modalform),_modal_factory=_interopRequireDefault(_modal_factory),_dynamicform=_interopRequireDefault(_dynamicform);const SELECTORS_USERSELECTORFORM='[data-id="sc-selectuserformcontainer"]';_exports.init=function(){let userid=arguments.length>0&&void 0!==arguments[0]?arguments[0]:0;console.log("run init",userid),document.getElementById("checkout-tab").classList.remove("success");const buybuttons=document.querySelectorAll(".buy-btn"),manualrebookbtn=document.querySelector("#cashiermanualrebook-btn"),cartcancelbtn=document.querySelector("#shoppingcart-cancel-btn");buybuttons&&buybuttons.forEach((buybutton=>{buybutton.addEventListener("click",(e=>confirmPayment(userid,e.target.dataset.paymenttype,"")))})),manualrebookbtn&&manualrebookbtn.addEventListener("click",(e=>rebookOrderidModal(userid,e.target.dataset.paymenttype))),cartcancelbtn&&cartcancelbtn.addEventListener("click",(()=>{(0,_cart.deleteAllItems)(userid);const newurl=_url.default.relativeUrl("/local/shopping_cart/cashier.php",[],!1);location.href=newurl}));const checkoutbutton=document.querySelector("#checkout-btn");console.log(checkoutbutton),checkoutbutton&&checkoutbutton.addEventListener("click",(function(){document.getElementById("checkout-tab").classList.add("success")})),initUserSelectorForm()};const confirmPayment=function(userid,paymenttype){let annotation=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"";_ajax.default.call([{methodname:"local_shopping_cart_confirm_cash_payment",args:{userid:userid,paymenttype:paymenttype,annotation:annotation},done:function(data){if(1===data.status){console.log("payment confirmed",data),(0,_shistory.reloadHistory)(userid);if(window.location.href.indexOf("cashier.php")<1){let params={success:1,identifier:data.identifier};const newurl=_url.default.relativeUrl("/local/shopping_cart/checkout.php",params,!1);location.href=newurl}else{addPrintIdentifier(data.identifier,userid);const successtab=document.getElementById("success-tab");successtab&&(successtab.classList.add("success"),displayPaymentMessage("paymentsuccessful"))}}else{console.log("payment denied"),console.log(data),displayErrorModal(data),displayPaymentMessage("paymentdenied",!1);const successtab=document.getElementById("success-tab");successtab&&successtab.classList.add("error")}},fail:function(ex){displayPaymentMessage("paymentdenied",!1),console.log(ex)}}])};_exports.confirmPayment=confirmPayment;_exports.validateCart=$userid=>{alert($userid)};const addPrintIdentifier=(identifier,userid)=>{let printbtn=document.getElementById("printbtn"),href=printbtn.getAttribute("href");printbtn.setAttribute("href",href+identifier+"&userid="+userid)};function displayPaymentMessage(message){let success=!(arguments.length>1&&void 0!==arguments[1])||arguments[1],displaymessage=document.querySelector(".payment_message_result");displaymessage&&(0,_str.get_string)(message,"local_shopping_cart").then((localizedmessage=>{displaymessage.innerText=localizedmessage,success?(0,_notifications.showNotification)(localizedmessage,"info"):(0,_notifications.showNotification)(localizedmessage,"error")})).catch((e=>{(0,_notifications.showNotification)("Error: ".concat(e),"error")}))}function displayErrorModal(data){if("string"!=typeof data.error)return;let modaltitle=(0,_str.get_string)("checkouterrormodaltitle","local_shopping_cart");_modal_factory.default.create({type:_modal_factory.default.types.ALERT,title:modaltitle,body:data.error,removeOnClose:!0}).then((modal=>(modal.show(),modal))).catch((e=>{console.log(e)}))}function rebookOrderidModal(userid,identifier){const modalForm=new _modalform.default({formClass:"local_shopping_cart\\form\\modal_cashier_manual_rebook",args:{userid:userid,identifier:identifier},modalConfig:{title:(0,_str.get_string)("annotation_rebook_desc","local_shopping_cart")}});modalForm.addEventListener(modalForm.events.FORM_SUBMITTED,(e=>{const response=e.detail;confirmPayment(userid,7,"".concat(response.annotation," ").concat(response.paidby))})),modalForm.show()}function initUserSelectorForm(){const element=document.querySelector(SELECTORS_USERSELECTORFORM),dynamicForm=new _dynamicform.default(element,"local_shopping_cart\\form\\dynamic_select_users");console.log(dynamicForm),dynamicForm.addEventListener(dynamicForm.events.FORM_SUBMITTED,(e=>{const response=e.detail;console.log(response),response.redirecturl?location.href=response.redirecturl:((0,_notifications.showNotification)("no user found","error"),dynamicForm.load())})),dynamicForm.load()}_exports.addPrintIdentifier=addPrintIdentifier}));

//# sourceMappingURL=cashier.min.js.map