define("local_shopping_cart/address",["exports","local_shopping_cart/notifications","core_form/modalform","core/str","core/templates"],(function(_exports,_notifications,_modalform,_str,_templates){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/*
   * @package    local_shopping_cart
   * @copyright  Wunderbyte GmbH <info@wunderbyte.at>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.handleAddressDeletion=handleAddressDeletion,_exports.init=void 0,_exports.newAddressModal=newAddressModal,_exports.setDeletionEventListeners=setDeletionEventListeners,_exports.setEditEventListeners=setEditEventListeners,_modalform=_interopRequireDefault(_modalform),_templates=_interopRequireDefault(_templates);const SELECTORS_ADDRESSRENDERCONTAINER="#addressestemplatespace",SELECTORS_NEWADDRESSBUTTON=".shopping-cart-new-address",SELECTORS_EDITADDRESSBUTTON=".shopping-cart-edit-selected-address",SELECTORS_DELETESELECTEDADDRESS=".shopping-cart-delete-selected-address";function setDeletionEventListeners(){const deleteAddressButtons=document.querySelectorAll(SELECTORS_DELETESELECTEDADDRESS);deleteAddressButtons&&deleteAddressButtons.forEach((deleteAddressButton=>{deleteAddressButton.addEventListener("click",(e=>{handleAddressDeletion(e,deleteAddressButton)}))}))}function setEditEventListeners(){const editAddressButtons=document.querySelectorAll(SELECTORS_EDITADDRESSBUTTON);editAddressButtons&&editAddressButtons.forEach((editAddressButton=>{editAddressButton.addEventListener("click",(e=>{let selectedRadio=document.querySelector('input[name^="selectedaddress_"]:checked');e.preventDefault(),editAddressButton.setAttribute("data-address-id",selectedRadio.value),newAddressModal(editAddressButton)}))}))}function handleAddressDeletion(event,deleteAddressButton){event.preventDefault();const selectedradio=document.querySelector('input[name^="selectedaddress_"]:checked');if(selectedradio){!function(addressId,button){const modalForm=new _modalform.default({formClass:"local_shopping_cart\\form\\delete_user_address",args:{addressid:addressId},modalConfig:{title:(0,_str.get_string)("addresses:delete:selected","local_shopping_cart")},returnFocus:button,saveButtonText:(0,_str.get_string)("addresses:delete:submit","local_shopping_cart")});modalForm.addEventListener(modalForm.events.FORM_SUBMITTED,(e=>{!function(addressType){const selectedRadio=document.querySelector(`input[name="selectedaddress_${addressType}"]:checked`);if(selectedRadio){selectedRadio.checked=!1;const event=new Event("change",{bubbles:!0});selectedRadio.dispatchEvent(event)}}(button.dataset.addresskey);!function(response){1==response?(0,_str.get_string)("addresses:delete:success","local_shopping_cart").then((successMessage=>{(0,_notifications.showNotification)(successMessage,"success")})).catch(console.error):(0,_str.get_string)("addresses:delete:error","local_shopping_cart").then((successMessage=>{(0,_notifications.showNotification)(successMessage,"error")})).catch(console.error)}(e.detail),redrawRenderedAddresses([])})),modalForm.show()}(selectedradio.value,deleteAddressButton)}else(0,_str.get_string)("addresses:delete:noaddressselected","local_shopping_cart").then((str=>{(0,_notifications.showNotification)(str,"warning")})).catch(console.error)}function newAddressModal(button){const id=button.dataset.addressId??0,saveButtonText=id>0?(0,_str.get_string)("addresses:saveaddress:submit","local_shopping_cart"):(0,_str.get_string)("addresses:newaddress:submit","local_shopping_cart"),modalForm=new _modalform.default({formClass:"local_shopping_cart\\form\\modal_new_address",args:{id:id},modalConfig:{title:(0,_str.get_string)("addresses:newaddress","local_shopping_cart")},returnFocus:button,saveButtonText:saveButtonText});modalForm.addEventListener(modalForm.events.FORM_SUBMITTED,(e=>{const response=e.detail,stringKey=response.isnew?"addresses:newaddress:saved":"addresses:newaddress:updated";(0,_str.get_string)(stringKey,"local_shopping_cart").then((str=>((0,_notifications.showNotification)(str,"info"),null))).catch((error=>{console.log(error)})),redrawRenderedAddresses(response.templatedata)})),modalForm.show()}function redrawRenderedAddresses(data){_templates.default.renderForPromise("local_shopping_cart/address",data).then((_ref=>{let{html:html,js:js}=_ref;_templates.default.replaceNodeContents(document.querySelector(SELECTORS_ADDRESSRENDERCONTAINER),html,js);const event=new CustomEvent("local_shopping_cart/addressesRedrawn",{});return document.dispatchEvent(event),null})).catch((e=>{console.log(e)}))}_exports.init=()=>{const buttons=document.querySelectorAll(SELECTORS_NEWADDRESSBUTTON);buttons&&buttons.forEach((newAddressButton=>{newAddressButton.addEventListener("click",(e=>{e.preventDefault(),newAddressModal(newAddressButton)}))})),setDeletionEventListeners(),setEditEventListeners()}}));

//# sourceMappingURL=address.min.js.map