<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * German plugin strings are defined here.
 *
 * @package     local_wunderbyte_table
 * @category    string
 * @copyright   2023 Wunderbyte GmbH <info@wunderbyte.at>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action_executed'] = 'Aktion ausgeführt';
$string['action_executed_desc'] = 'Die NutzerIn hat eine Aktion "{$a->methodname}" in der folgenden Tabelle ausgeführt: "{$a->tablename}"';
$string['addcheckboxes'] = 'Für jede Zeile eine Checkbox anzeigen';
$string['addwbtablefilter'] = 'Wunderbyte Table Filter hinzufügen';
$string['after'] = 'nach';
$string['alertentriessanitized'] = 'Achtung: Von Ihren Eingaben werden nur die Ziffern 0-9 für den Filter berücksichtigt.';
$string['allowedittable'] = 'Bearbeite Tabelleneinstellungen (zum Testen, nicht auf produktiven Websites verwenden) <span class="badge bg-danger text-light"><i class="fa fa-flask" aria-hidden="true"></i> Experimentell</span>';
$string['allowsearchincolumns'] = 'Erlaube Suche in Spalten mittels ":" <span class="badge bg-danger text-light"><i class="fa fa-flask" aria-hidden="true"></i> Experimentell</span>';
$string['apply_filter'] = 'Filter anwenden';
$string['applyfilterondownload'] = 'Filter auf Download anwenden';
$string['april'] = 'April';
$string['august'] = 'August';
$string['before'] = 'vor';
$string['cachedef_cachedfilters'] = 'Wunderbyte Table: Cache für Filter';
$string['cachedef_cachedfulltable'] = 'Wunderbyte Table: Cache für die ganze Tabelle';
$string['cachedef_cachedrawdata'] = 'Wunderbyte Table: Standard Cache';
$string['cachedef_encodedtables'] = 'Wunderbyte Table: Cache für enkodierte Tabellen';
$string['callback'] = 'Callback Filter';
$string['change'] = 'Ändere';
$string['changesortorder'] = 'Ändere die Sortierungsrichtung';
$string['checkallcheckbox'] = 'Alles auswählen';
$string['checkbox'] = 'Checkbox';
$string['columnemptyerror'] = 'Suchspalte ist leer';
$string['couldnotloaddata'] = 'Konnte keine Daten laden';
$string['countlabel'] = '{$a->filteredrecords} von {$a->totalrecords} Einträgen gefunden ';
$string['customizewbtable'] = 'Wunderbyte Table anpassen';
$string['datepicker'] = 'Datumsfilter mit Datumsbereich';
$string['datepickererrormandatory'] = 'Füllen Sie alle Pflichtfelder aus.';
$string['datepickererroroperations'] = 'Mindestens ein Operator muss ausgewählt werden.';
$string['datepickerheadingcheckboxlabel'] = 'Checkbox-Beschriftung:';
$string['datepickerheadingdefaultvalue'] = 'Standardwert:';
$string['datepickerheadingdefaultvalueend'] = 'Endwert:';
$string['datepickerheadingdefaultvaluestart'] = 'Startwert:';
$string['datepickerheadingname'] = 'Name:';
$string['datepickerheadingoperation'] = 'Operationen:';
$string['datepickerheadingpossibleoperations'] = 'Mögliche Operationen:';
$string['datepickermoodleexception'] = 'Jede Spalte kann nur einen Filter enthalten.';
$string['datepickerplaceholdercheckboxlabel'] = 'Geben Sie eine Checkbox-Beschriftung ein';
$string['datepickerplaceholdername'] = 'Geben Sie einen Filternamen ein';
$string['datepickertype'] = 'Wähle einen Zeitfilter-Typen';
$string['december'] = 'Dezember';
$string['deletedatabody'] = 'Sie sind dabei, diese Daten zu löschen: <br> "{$a->data}"';
$string['deletedatasubmit'] = 'Löschen';
$string['deletedatatitle'] = 'Möchten Sie diese Daten wirklich löschen?';
$string['displayrecords'] = 'Zeige Daten';
$string['downloadas'] = 'Tabelle laden als';
$string['editfiltername'] = 'Bearbeite den Filternamen';
$string['edittable'] = 'Editieren';
$string['enablefilter'] = 'Filter aktivieren';
$string['enablefilterdesc'] = 'Filter wird nur aktiviert, wenn das Häkchen gesetzt ist.';
$string['endvalue'] = 'Ende';
$string['february'] = 'Februar';
$string['filter'] = 'Tabelle filtern';
$string['filter_heading'] = 'Filter';
$string['filteraddnewkeyvaluepair'] = 'Neues "key-value"-Paar hinzufügen';
$string['filtercountmessage'] = ' {$a->filtersum} Filter auf: {$a->filtercolumns} ';
$string['filteremptynameerror'] = 'Name ist leer';
$string['filterenabledheader'] = 'Allgemeine Filter-Einstellungen';
$string['filterexistingkeyvaluepairs'] = 'Vorhandene "key-value"-Paare';
$string['filterinactive'] = 'Verberge den Filter';
$string['filternopairsexist'] = 'Keine "key-value"-Paare vorhanden';
$string['filteronloadinactive'] = 'Filter standardmäßig zugeklappt';
$string['flexoverlap'] = 'überlappend mit';
$string['friday'] = 'Fr';
$string['from'] = 'Von';
$string['from0to1'] = '00:00 - 01:00';
$string['from10to11'] = '10:00 - 11:00';
$string['from11to12'] = '11:00 - 12:00';
$string['from12to13'] = '12:00 - 13:00';
$string['from13to14'] = '13:00 - 14:00';
$string['from14to15'] = '14:00 - 15:00';
$string['from15to16'] = '15:00 - 16:00';
$string['from16to17'] = '16:00 - 17:00';
$string['from17to18'] = '17:00 - 18:00';
$string['from18to19'] = '18:00 - 19:00';
$string['from19to20'] = '19:00 - 20:00';
$string['from1to2'] = '01:00 - 02:00';
$string['from20to21'] = '20:00 - 21:00';
$string['from21to22'] = '21:00 - 22:00';
$string['from22to23'] = '22:00 - 23:00';
$string['from23to24'] = '23:00 - 24:00';
$string['from2to3'] = '02:00 - 03:00';
$string['from3to4'] = '03:00 - 04:00';
$string['from4to5'] = '04:00 - 05:00';
$string['from5to6'] = '05:00 - 06:00';
$string['from6to7'] = '06:00 - 07:00';
$string['from7to8'] = '07:00 - 08:00';
$string['from8to9'] = '08:00 - 09:00';
$string['from9to10'] = '09:00 - 10:00';
$string['functiondoesntexist'] = 'Funktion des Aktionsbuttons exisitert nicht.';
$string['genericbody'] = 'Sie sind dabei, diese Zeilen zu bearbeiten: <br> "{$a->data}"';
$string['genericsubmit'] = 'Bestätigen';
$string['generictitle'] = 'Möchten Sie wirklich diese Daten bearbeiten?';
$string['gotopage'] = 'Gehe zu Seite:';
$string['hierarchicalfilter'] = 'Hierachischer Filter';
$string['hourlastmodified'] = 'Stunde, zu der zuletzt aktualisiert wurde';
$string['hourlist'] = 'Stundenlistenfilter';
$string['id'] = 'ID';
$string['infinitescroll'] = 'Dynamisches Weiterscrollen aktivieren (infinite scrolling)';
$string['intrange'] = 'Integer Range Filter';
$string['january'] = 'Januar';
$string['july'] = 'Juli';
$string['june'] = 'Juni';
$string['loading'] = 'Laden...';
$string['logfiltercaches'] = 'Debug-Feature: Speichere Query-Hashes in der DB. Das hat negative Auswirkugen auf die Performance <span class="badge bg-danger text-light"><i class="fa fa-flask" aria-hidden="true"></i> Experimentell</span>';
$string['march'] = 'März';
$string['may'] = 'Mai';
$string['module'] = 'Modul';
$string['monday'] = 'Mo';
$string['newwbtablefiltername'] = 'Neuen Filternamen';
$string['nmmcns'] = 'Kein Modal, mehrere Requests, Keine Checkbox Auswahl';
$string['nmmcys'] = 'Kein Modal, mehrere Requests, Checkbox Auswahl';
$string['nmscns'] = 'Kein Modal, ein Request, keine Checkbox Auswahl';
$string['nmscys'] = 'Kein Modal, ein Request, Checkbox Auswahl';
$string['nocheckboxchecked'] = 'Keine checkbox ausgewählt';
$string['noentriesfound'] = 'Keine Einträge gefunden';
$string['norecords'] = 'Keine Daten gefunden.';
$string['november'] = 'November';
$string['october'] = 'October';
$string['orderdown'] = 'Von Z nach A sortiert';
$string['orderup'] = 'Von A nach Z sortiert';
$string['other'] = 'Andere';
$string['overlapboth'] = 'überlappend mit beiden Daten';
$string['overlapend'] = 'Ende überlappend';
$string['overlapstart'] = 'Beginn überlappend';
$string['pagelabel'] = 'Zeige {$a} Zeilen';
$string['pagesize'] = 'Anzahl der Einträge pro Seite';
$string['placebuttonandpageelementsontop'] = 'Buttons und Elemente oben statt unten anzeigen';
$string['pluginname'] = 'Wunderbyte Table';
$string['print'] = 'Tabelle herunterladen';
$string['reload'] = 'Tabelle neu laden';
$string['saturday'] = 'Sa';
$string['search'] = 'Suchen';
$string['searchcountmessage'] = 'Suche für "{$a}"';
$string['selectedtimespan'] = 'gewählter Zeitspanne';
$string['september'] = 'September';
$string['setwbtablefiltercolumn'] = 'Wähle eine Filterspalte';
$string['setwbtablefiltercolumnoption'] = 'Bitte wähle eine Filterspalte';
$string['setwbtablefiltertype'] = 'Wähle einen Filtertypen';
$string['setwbtablefiltertypeoption'] = 'Bitte wähle einen Filtertypen';
$string['showaddfilterbutton'] = 'Button "Benutzerdefinierte Filter hinzufügen" anzeigen';
$string['showallrecords'] = 'Alle Einträge anzeigen';
$string['showcountlabel'] = 'Anzahl der gefundenen Einträge anzeigen';
$string['showdownloadbutton'] = 'Download-Button anzeigen';
$string['showdownloadbuttonatbottom'] = 'Download-Button unter der Tabelle (statt oberhalb) anzeigen';
$string['showfilter'] = 'Zeige diesen Filter';
$string['showfilterontop'] = 'Filter über der Tabelle anzeigen';
$string['showgotopage'] = 'Zeige Gehe zu Seite dropdown';
$string['showreloadbutton'] = 'Reload-Button anzeigen';
$string['showrowcountselect'] = 'Dropdown für Anzahl der anzuzeigenden Zeilen anzeigen';
$string['somethingwentwrong'] = 'Etwas ist schiefgelaufen. Melden Sie den Fehler ihrem Admin';
$string['sortby'] = 'Sortieren nach...';
$string['standardfilter'] = 'Standardfilter';
$string['standardfiltergrouplabel'] = 'Key Value Paar (optional)';
$string['standardfilterkeylabel'] = 'Key ';
$string['standardfiltervaluekeyerror'] = 'Entweder beide Felder leer lassen oder beide Felder ausfüllen';
$string['standardfiltervaluelabel'] = 'Value ';
$string['startvalue'] = 'Anfang';
$string['stickyheader'] = 'Header fixieren (sticky header)';
$string['successaddedfilternotification'] = 'Filter wurde erfolgreich bearbeitet';
$string['sunday'] = 'So';
$string['table1name'] = 'Demo Tabelle 1';
$string['table2name'] = 'Demo Tabelle 2';
$string['table3name'] = 'Demo Tabelle 3';
$string['table4name'] = 'Demo Tabelle 4';
$string['table_viewed'] = 'Tabelle angesehen';
$string['table_viewed_desc'] = 'Die NutzerIn hat folgende Tabelle angesehen: "{$a}"';
$string['tableheadercheckbox'] = '<input type="checkbox" class="tableheadercheckbox">';
$string['tableheadersortableitem'] = '<i class="fa fa-arrows" aria-label="Sortieren"></i>';
$string['tableheight'] = 'Tabellen-Höhe';
$string['tableheight_help'] = 'Die Tabellenhöhe wird in Pixel angegeben, sinnvolle Werte beginnen daher bei ca. 300. Bei 0 wird die Höhe automatisch anhand der angezeigten Tabellen berechnet.';
$string['template_switched'] = 'Tabellenansicht gewechselt';
$string['template_switched_desc'] = 'Die NutzerIn hat die Tabellenansicht (Template) in der  Tabelle "{$a->tablename}" zu "{$a->template}" mit dem viewparam "{$a->viewparam}" gewechselt.';
$string['templateswitcherlabel'] = 'Ansicht';
$string['themennachkategorie'] = 'Themen nach Kategorie';
$string['thursday'] = 'Do';
$string['timespan'] = 'Zeitspanne';
$string['to'] = 'Bis';
$string['tuesday'] = 'Di';
$string['turnoffcaching'] = 'Keine Verwendung von Caching <span class="badge bg-danger text-light"><i class="fa fa-flask" aria-hidden="true"></i> Experimentell</span>';
$string['valuehastobeint'] = 'Wert muss eine Zahl sein';
$string['veranstaltungen'] = "Veranstaltungen";
$string['viewcards'] = 'Karten-Ansicht';
$string['viewlist'] = 'Listen-Ansicht';
$string['wbfilterclassemptyerror'] = 'Bitte wählen Sie einen Filtertypen aus';
$string['wbtablefiltersettingsheader'] = 'Filter anpassen';
$string['wbtabletablesettingsdemo'] = 'Demo Text';
$string['wbtabletablesettingsheader'] = 'Weitere Einstellungen';
$string['wednesday'] = 'Mi';
$string['weekdays'] = 'Wochentagefilter';
$string['within'] = 'innerhalb';
$string['wunderbyte_table:canaccess'] = 'Kann auf Wunderbyte Table zugreifen';
$string['wunderbyte_table:canedittable'] = 'Kann auf Wunderbyte Table editieren';
$string['ymmcns'] = 'Modal, mehrere Requests, keine Checkbox Auswahl';
$string['ymmcys'] = 'Modal, mehrere Requests, Checkbox Auswahl';
$string['ymscns'] = 'Modal, ein Request, keine Checkbox Auswahl';
$string['ymscys'] = 'Modal, ein Request, Checkbox Auswahl';
