define("local_wunderbyte_table/filter",["exports","local_wunderbyte_table/search","local_wunderbyte_table/sort","local_wunderbyte_table/init","core/templates","core/utils"],(function(_exports,_search,_sort,_init,_templates,_utils){var obj;
/**
   * @module    local_wunderbyte_table
   * @copyright  Wunderbyte GmbH <info@wunderbyte.at>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.getChecked=getChecked,_exports.getDateAndTimePickerDataAsUnix=getDateAndTimePickerDataAsUnix,_exports.getDates=getDates,_exports.getFilterObjects=getFilterObjects,_exports.getIntRange=getIntRange,_exports.initializeCheckboxes=initializeCheckboxes,_exports.initializeResetFilterButton=function(selector,idstring,encodedtable){const container=document.querySelector(selector);if(!container)return;let button=container.querySelector(".reset-filter-button");if(console.log(button),!button)return;button.addEventListener("click",(()=>{if(!container)return;const componentscontainer=container.querySelector(".wunderbyte_table_components");if(!componentscontainer)return;componentscontainer.remove(),resetCheckedObject(idstring);const sort=(0,_sort.getSortSelection)(idstring);(0,_init.callLoadData)(idstring,encodedtable,0,null,sort,null,null,null,"","")}))},_exports.initializeSearchInputListener=function(selector,idstring,encodedtable){const container=document.querySelector(selector);if(!container)return;const searchInput=container.querySelector(`#prefixsearch${idstring}`);searchInput&&searchInput.addEventListener("input",(0,_utils.debounce)((()=>{const searchValue=searchInput.value;checked[idstring].titleprefix=searchValue,triggerReload(idstring,encodedtable)}),300))},_exports.renderFilter=void 0,_exports.setDateAndTimePickerDataFromUnix=setDateAndTimePickerDataFromUnix,_exports.toggleFilterelement=toggleFilterelement,_exports.updateDownloadUrlWithFilterSearchSort=function(idstring,filterobjects,searchstring,sort,dir){let container=document.querySelector(".wunderbyte_table_container_"+idstring);if(!container)return;let url="",formelement=null;try{formelement=container.querySelector("form.wb-table-download-buttons"),url=new URL(formelement.getAttribute("action"))}catch(e){return void console.log(e)}let params=url.searchParams;params.delete("wbtfilter"),params.delete("wbtsearch"),params.delete("tsort"),params.delete("tdir"),filterobjects&&url.searchParams.append("wbtfilter",filterobjects);""!==searchstring&&null!==searchstring&&url.searchParams.append("wbtsearch",searchstring);""!==sort&&null!==sort&&url.searchParams.append("tsort",sort);null!==dir&&dir>0&&url.searchParams.append("tdir",dir);formelement.action=url.toString()},_exports.updateUrlWithFilterSearchSort=function(filterobjects,searchstring,sort,dir){const url=new URL(window.location.href);let params=url.searchParams;params.delete("wbtfilter"),params.delete("wbtsearch"),params.delete("tsort"),params.delete("tdir"),window.history.replaceState(null,"",url),filterobjects&&url.searchParams.append("wbtfilter",filterobjects);""!==searchstring&&null!==searchstring&&url.searchParams.append("wbtsearch",searchstring);""!==sort&&null!==sort&&url.searchParams.append("tsort",sort);null!==dir&&dir>0&&url.searchParams.append("tdir",dir);window.history.pushState(null,null,url.toString())},_templates=(obj=_templates)&&obj.__esModule?obj:{default:obj};var checked={};function initializeCheckboxes(selector,idstring,encodedtable){const filterContainer=document.querySelector(selector+_init.SELECTORS.FILTER);if(!filterContainer||filterContainer.dataset.initialized)return;const selects=filterContainer.querySelectorAll("select[id^='filteroperationselect']"),filterElements=filterContainer.querySelectorAll("input[class^='filterelement']"),hierarchcheckboxes=filterContainer.querySelectorAll(".hierarchycategory-checkbox");filterElements&&(checked.hasOwnProperty(idstring)||(checked[idstring]={}),filterElements.forEach((element=>{getChecked(element.name,selector,idstring)})),applyChangelistener(filterElements,selector,idstring,encodedtable),applyChangelistener(selects,selector,idstring,encodedtable),hierarchcheckboxes&&function(parentCheckboxes,filterElements,selector,idstring,encodedtable){parentCheckboxes.forEach((parentCheckbox=>{parentCheckbox.addEventListener("click",(function(){parentCheckbox.closest("ul").querySelectorAll(".form-check-input").forEach((childCheckbox=>{childCheckbox.checked!==parentCheckbox.checked&&(childCheckbox.checked=parentCheckbox.checked)})),filterElements.forEach((element=>{getChecked(element.name,selector,idstring)})),triggerReload(idstring,encodedtable)}))}))}(hierarchcheckboxes,filterElements,selector,idstring,encodedtable),filterContainer.dataset.initialized=!0)}function applyChangelistener(nodelist,selector,idstring,encodedtable){nodelist&&nodelist.forEach((el=>{el.dataset.idstring?el.dataset.idstring2=idstring:el.dataset.idstring=idstring,["change","keyup"].forEach((event=>{el.addEventListener(event,(e=>toggleFilterelement(e,selector,idstring,encodedtable)))}))}))}function toggleFilterelement(e,selector,idstring,encodedtable){e.stopPropagation(),e.preventDefault(),setTimeout((()=>{"checkbox"===e.target.type&&function(checkbox){const wrapper=checkbox.closest("ul.hierarchy");if(!wrapper)return;const parentCheckbox=wrapper.querySelector(".d-flex").querySelector(".hierarchycategory-checkbox");if(!parentCheckbox)return;const siblingCheckboxes=wrapper.querySelectorAll(".hierarchychild-checkbox");Array.from(siblingCheckboxes).every((cb=>cb.checked))?parentCheckbox.checked=!0:Array.from(siblingCheckboxes).some((cb=>!cb.checked))&&(parentCheckbox.checked=!1)}(e.target),"dateelement"==e.target.dataset.dateelement?getDates(e,selector,idstring):e.target.dataset.intrangeelement&&e.target.dataset.intrangeelement.includes("intrangeelement")?(getIntRange(e,selector,idstring),console.log("intrangeelement")):getChecked(e.target.name,selector,idstring),triggerReload(idstring,encodedtable)}),400)}function triggerReload(idstring,encodedtable){const filterobjects=getFilterObjects(idstring),searchstring=(0,_search.getSearchInput)(idstring),sort=(0,_sort.getSortSelection)(idstring);(0,_init.callLoadData)(idstring,encodedtable,0,null,sort,null,null,null,filterobjects,searchstring)}function getDates(e,selector,idstring){let name=e.target.dataset.columnname,filtercontainer=e.target.closest(".datepickerform"),filtername=e.target.dataset.filtername,filtercheckbox=filtercontainer.querySelector('input[type="checkbox"][id^="'+filtername+'"][name="'+name+'"]'),dates={};"true"===filtercheckbox.dataset.timespan&&function(e,filtercontainer){let startdate=getDateAndTimePickerDataAsUnix(filtercontainer,"startdate"),enddate=getDateAndTimePickerDataAsUnix(filtercontainer,"enddate");enddate/1e3>1577836800&&startdate>enddate&&setDateAndTimePickerDataFromUnix(filtercontainer,"startdate",enddate)}(0,filtercontainer),filtercheckbox.checked?"true"===filtercheckbox.dataset.timespan?function(filtercontainer,filtername,idstring,name){let operator=filtercontainer.querySelector('select[id^="filteroperationselect"][name="'+name+'"]').value,firstcolumn=filtercontainer.querySelector('input[id^="startdate"]').dataset.applytocolumn,firstoperator="",additionalFirstColumnValues={},valuefirstcolumn=getDateAndTimePickerDataAsUnix(filtercontainer,"startdate")/1e3,secondcolumn=filtercontainer.querySelector('input[id^="enddate"]').dataset.applytocolumn,secondoperator="",additionalSecondColumnValues={},valuesecondcolumn=getDateAndTimePickerDataAsUnix(filtercontainer,"enddate")/1e3;if(!Number.isInteger(valuefirstcolumn)||!Number.isInteger(valuefirstcolumn))return;switch(resetCheckedObject(idstring,firstcolumn,filtername),resetCheckedObject(idstring,secondcolumn,filtername),operator){case"within":firstoperator=">=",secondoperator="<=";break;case"overlapboth":firstoperator="<=",secondoperator=">=";break;case"overlapstart":firstoperator="<=",additionalSecondColumnValues[">="]=valuefirstcolumn,secondoperator="<=";break;case"overlapend":firstoperator=">=",secondoperator=">=",additionalFirstColumnValues["<="]=valuesecondcolumn;break;case"before":firstoperator="<",additionalSecondColumnValues["<="]=valuefirstcolumn,secondoperator="<";break;case"after":secondoperator=">=",additionalFirstColumnValues[">="]=valuesecondcolumn,firstoperator=">";break;case"flexoverlap":firstoperator="fo",secondoperator="fo"}secondcolumn||(secondcolumn=firstcolumn);applySpanfilter(firstcolumn,valuefirstcolumn,filtername,firstoperator,additionalFirstColumnValues,idstring),applySpanfilter(secondcolumn,valuesecondcolumn,filtername,secondoperator,additionalSecondColumnValues,idstring),firstcolumn&&filtername&&unsetEmptyFieldsInCheckedObject(firstcolumn,filtername,idstring);secondcolumn&&filtername&&unsetEmptyFieldsInCheckedObject(secondcolumn,filtername,idstring)}(filtercontainer,filtername,idstring,name):(dates[String(filtercheckbox.dataset.operator)]=getDateAndTimePickerDataAsUnix(filtercontainer,"datefilter")/1e3,name&&filtername&&(checked[idstring][name]||(checked[idstring][name]={}),checked[idstring][name][filtername]=dates),unsetEmptyFieldsInCheckedObject(name,filtername,idstring)):(resetCheckedObject(idstring,name,filtername),unsetEmptyFieldsInCheckedObject(name,null,idstring),Object.keys(checked[idstring]).forEach((function(key){Object.keys(checked[idstring][key]).forEach((function(okey){okey==filtername&&(resetCheckedObject(idstring,key,filtername),unsetEmptyFieldsInCheckedObject(key,null,idstring))}))}))),updateFilterCounter(name,selector,idstring)}function setDateAndTimePickerDataFromUnix(filtercontainer){let id=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"",timestamp=arguments.length>2?arguments[2]:void 0,dateobject=new Date(timestamp),datepicker=filtercontainer.querySelector('input[type="date"][id*="'+id+'"]');datepicker.value=dateobject.toISOString().split("T")[0];let timepicker=filtercontainer.querySelector('input[type="time"][id*="'+id+'"]');timepicker.value=dateobject.toLocaleTimeString().slice(0,5)}function resetCheckedObject(idstring){let column=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"",filtername=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"";0===column.length?Object.keys(checked[idstring]).forEach((col=>{checked[idstring][col]=[]})):checked[idstring].hasOwnProperty(column)&&(checked[idstring][column].hasOwnProperty(filtername)&&delete checked[idstring][column][filtername],checked[idstring][column].hasOwnProperty(filtername+"a")&&delete checked[idstring][column][filtername+"a"],Array.isArray(checked[idstring][column])&&1===checked[idstring][column].length&&"datecheckbox"===checked[idstring][column][0]&&delete checked[idstring][column])}function applySpanfilter(column,value,filtername,operator,additionalvaluesObject,idstring){operator.length>=1&&column&&filtername&&(checked[idstring][column]||(checked[idstring][column]={}),checked[idstring][column][filtername]||(checked[idstring][column][filtername]={}),checked[idstring][column][filtername][operator]=value,Object.keys(additionalvaluesObject).length>0&&(checked[idstring][column][filtername+"a"]=additionalvaluesObject))}function unsetEmptyFieldsInCheckedObject(key1,key2,idstring){checked[idstring][key1]&&checked[idstring][key1][key2]&&Object.keys(checked[idstring][key1][key2]).length<1&&delete checked[idstring][key1][key2],checked[idstring][key1]&&Object.keys(checked[idstring][key1]).length<1&&delete checked[idstring][key1]}function getDateAndTimePickerDataAsUnix(filtercontainer){let id=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"",datepicker=filtercontainer.querySelector('input[type="date"][id*="'+id+'"]'),date=datepicker.value,timepicker=filtercontainer.querySelector('input[type="time"][id*="'+id+'"]'),time=timepicker.value,unixTimestamp=Date.parse(date+" "+time);return unixTimestamp}function getChecked(name,selector,idstring){const wbTable=document.querySelector(selector);checked[idstring][name]=Array.from(wbTable.querySelectorAll("input[name="+name+"]")).filter((function(el){return el.checked})).map((function(el){return el.value})),checked[idstring][name].length<1&&delete checked[idstring][name],updateFilterCounter(name,selector,idstring)}function getIntRange(e,selector,idstring){let filtercontainer=e.target.closest(".intrangeform"),fromvalue=filtercontainer.querySelector('input[id*="intrangefilter_intrange-start"]').value,tovalue=filtercontainer.querySelector('input[id*="intrangefilter_intrange-end"]').value,colname=e.target.dataset.columnname;const isInt=str=>!isNaN(parseInt(str))&&isFinite(str)||""===str.trim()||null===str,alertelement=filtercontainer.querySelector('div[id*="intrangefilter_alert"]');isInt(fromvalue)&&isInt(tovalue)?(alertelement.setAttribute("hidden","true"),fromvalue=parseInt(fromvalue,10),fromvalue=fromvalue.toString(),tovalue=parseInt(tovalue,10),tovalue=tovalue.toString()):alertelement.removeAttribute("hidden"),(fromvalue.length>0||tovalue.length>0)&&(checked[idstring][colname]=fromvalue+","+tovalue),filtercontainer.querySelector('input[data-intrangeelement="intrangeelement-checkbox"]').checked||delete checked[idstring][colname],updateFilterCounter(colname,selector,idstring)}function getFilterObjects(idstring){if(!(idstring in checked))return"";let hasvalues=!1;for(const[,value]of Object.entries(checked[idstring]))(value.length>0||Object.keys(value).length>0)&&(hasvalues=!0);return hasvalues?JSON.stringify(checked[idstring]):""}function updateFilterCounter(name,selector,idstring){const wbTable=document.querySelector(selector);let counter=checked[idstring][name]?checked[idstring][name].length:0;(counter>0&&"string"==typeof checked[idstring][name]||"object"==typeof checked[idstring][name]&&!Array.isArray(checked[idstring][name]))&&(counter=1);const labelElement=wbTable.querySelector("[data-ident="+name+"] span.filtercounter");labelElement&&(counter>0?labelElement.classList.remove("hidden"):labelElement.classList.add("hidden"),labelElement.textContent=counter);const totalfiltercounter=checked[idstring]?Object.keys(checked[idstring]).length:0,resetElement=wbTable.querySelector(".reset-filter-button");resetElement&&(totalfiltercounter>0?resetElement.classList.remove("hidden"):resetElement.classList.add("hidden"))}_exports.renderFilter=(filterjson,idstring,encodedtable)=>{const selector=_init.SELECTORS.CONTAINER+idstring,container=document.querySelector(selector);container.querySelector(_init.SELECTORS.FILTER)||_templates.default.renderForPromise("local_wunderbyte_table/filter",filterjson).then((_ref=>{let{html:html}=_ref;container.insertAdjacentHTML("afterbegin",html),initializeCheckboxes(selector,idstring,encodedtable)})).catch((e=>{console.log(e)}))}}));

//# sourceMappingURL=filter.min.js.map