/**
 * AJAX helper for the inline editing a value.
 *
 * This script is automatically included from template core/inplace_editable
 * It registers a click-listener on [data-inplaceeditablelink] link (the "inplace edit" icon),
 * then replaces the displayed value with an input field. On "Enter" it sends a request
 * to web service core_update_inplace_editable, which invokes the specified callback.
 * Any exception thrown by the web service (or callback) is displayed as an error popup.
 *
 * @module     mod_booking/edit_note
 * @copyright  2018 David Bogner
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.3
 */
define("mod_booking/edit_note",["jquery","core/ajax","core/templates","core/notification","core/str","core/config","core/url"],(function($,ajax,templates,notification,str,cfg,url){return $("body").on("click keypress","[data-inplaceeditable]",(function(e){if("keypress"!==e.type||13===e.keyCode){e.stopImmediatePropagation(),e.preventDefault();var mainelement=$(this).closest("[data-inplaceeditable]"),updateValue=function(mainelement,value){var pendingId=[mainelement.attr("data-baid"),"pending"].join("-");M.util.js_pending(pendingId),function(element){element.addClass("updating");var spinner=element.find("img.spinner");spinner.length?spinner.show():(spinner=$("<img/>").attr("src",url.imageUrl("i/loading_small")).addClass("spinner").addClass("smallicon"),element.append(spinner))}(mainelement),ajax.call([{methodname:"mod_booking_update_bookingnotes",args:{baid:mainelement.attr("data-baid"),note:value},done:function(data){var oldvalue=mainelement.attr("data-value");templates.render("mod_booking/edit_bookingnotes",data).done((function(html,js){var newelement=$(html);templates.replaceNode(mainelement,newelement,js),newelement.find("[data-note]").focus(),newelement.trigger({type:"updated",ajaxreturn:data,oldvalue:oldvalue}),M.util.js_complete(pendingId)}))},fail:function(ex){var element,e=$.Event("updatefailed",{exception:ex,newvalue:value});(element=mainelement).removeClass("updating"),element.find("img.spinner").hide(),M.util.js_complete(pendingId),mainelement.trigger(e),e.isDefaultPrevented()||notification.exception(ex)}}],!0)},turnEditingOff=function(el){el.find("textarea").off(),el.html(el.attr("data-oldcontent")),el.removeAttr("data-oldcontent"),el.removeClass("inplaceeditingon"),el.find("[data-note]").focus()};!function(el){el.attr("data-oldcontent",el.html());var uniqueId=function(prefix,idlength){var i,uniqid=prefix;for(i=0;i<idlength;i++)uniqid+=String(Math.floor(10*Math.random()));return 0===$("#"+uniqid).length?uniqid:uniqueId(prefix,idlength)};str.get_string("edittitleinstructions").done((function(s){var instr=$('<span class="editinstructions">'+s+"</span>").attr("id",uniqueId("id_editinstructions_",20)),inputelement=$('<textarea rows="4" cols="50"></textarea>').attr("id",uniqueId("id_inplacevalue_",20)).val(el.find(".bookingnote").text()).attr("aria-describedby",instr.attr("id")).addClass("ignoredirty").addClass("form-control"),lbl=$('<label class="accesshide">'+mainelement.attr("data-editlabel")+"</label>").attr("for",inputelement.attr("id"));el.html("").append(instr).append(lbl).append(inputelement),inputelement.focus(),inputelement.select(),inputelement.on("keyup keypress focusout",(function(e){if(!cfg.behatsiterunning||"focusout"!==e.type){if("keypress"===e.type&&13===e.keyCode){var val=inputelement.val();turnEditingOff(el),updateValue(el,val)}("keyup"===e.type&&27===e.keyCode||"focusout"===e.type)&&turnEditingOff(el)}}))}))}(mainelement)}})),{}}));

//# sourceMappingURL=edit_note.min.js.map