@mod @mod_booking @booking_cashier_shortcode_checkout
Feature: As a cashier I brough booking options for user using list generated by shortcode on the cashier page

  Background:
    Given the following "custom profile fields" exist:
      | datatype | shortname     | name         |
      | text     | userpricecat  | userpricecat |
    And I clean booking cache
    And the following "mod_booking > pricecategories" exist:
      | ordernum | identifier | name  | defaultvalue | disabled | pricecatsortorder |
      | 1        | default    | Price | 55           | 0        | 1                 |
      | 2        | discount1  | Disc1 | 44           | 0        | 2                 |
    And the following "users" exist:
      | username | firstname | lastname | email                | idnumber | profile_field_userpricecat |
      | teacher1 | Teacher   | 1        | teacher1@example.com | T1       |                            |
      | student1 | Student   | 1        | student1@example.com | S1       |                            |
      | student2 | Student   | 2        | student2@example.com | S2       |                            |
      | student3 | Student   | 3        | student3@example.com | S3       | discount1                  |
    And the following "courses" exist:
      | fullname | shortname | category | enablecompletion |
      | Course 1 | C1        | 0        | 1                |
    And the following "course enrolments" exist:
      | user     | course | role           |
      | teacher1 | C1     | editingteacher |
      | teacher1 | C1     | manager        |
      | student1 | C1     | student        |
      | student2 | C1     | student        |
      | student3 | C1     | student        |
    And the following "core_payment > payment accounts" exist:
      | name           |
      | Account1       |
    And the following "local_shopping_cart > payment gateways" exist:
      | account  | gateway | enabled | config                                                                                |
      | Account1 | paypal  | 1       | {"brandname":"Test paypal","clientid":"Test","secret":"Test","environment":"sandbox"} |
    And the following "local_shopping_cart > plugin setup" exist:
      | account  | cancelationfee |
      | Account1 | 0              |
    And the following "local_shopping_cart > user credits" exist:
      | user     | credit | currency |
      | student2 | 150    | EUR      |
      | student3 | 200    | EUR      |
    And the following "activities" exist:
      | activity | course | name       | intro                  | bookingmanager | eventtype | cancancelbook |
      | booking  | C1     | My booking | My booking description | teacher1       | Webinar   | 1             |
    And I change viewport size to "1366x10000"

  @javascript
  Scenario: Booking option: cashier use list generated by shortcode to brough option for user
    Given the following config values are set as admin:
      | config                  | value                                                                       | plugin              |
      | pricecategoryfield      | userpricecat                                                                | booking             |
      | additonalcashiersection | [userinfo fields="firstname,lastname" urlparamforuserid=userid][allbookingoptions search=1 perpage=3 all=true urlparamforuserid=userid] | local_shopping_cart |
    And the following "mod_booking > options" exist:
      | booking    | text       | course | description | teachersforoption | importing | useprice | maxanswers | maxoverbooking | datesmarker | optiondateid_0 | daystonotify_0 | coursestarttime_0 | courseendtime_0 |
      | My booking | Opt_1      | C1     | noprice1    | teacher1          | 1         | 0        | 3          | 3              | 1           | 0              | 0              | ## tomorrow ##    | ## +2 days ##   |
      | My booking | Opt_2      | C1     | noprice2    | teacher1          | 1         | 0        | 4          | 4              | 1           | 0              | 0              | ## +2 days ##     | ## +3 days ##   |
      | My booking | Opt_3      | C1     | noprice3    | teacher1          | 1         | 0        | 3          | 3              | 1           | 0              | 0              | ## +3 days ##     | ## +4 days ##   |
      | My booking | Opt_price4 | C1     | price4      | teacher1          | 1         | 1        | 4          | 4              | 1           | 0              | 0              | ## +4 days ##     | ## +5 days ##   |
      | My booking | Opt_price5 | C1     | price5      | teacher1          | 1         | 1        | 3          | 3              | 1           | 0              | 0              | ## +5 days ##     | ## +6 days ##   |
      | My booking | Opt_price6 | C1     | price6      | teacher1          | 1         | 1        | 4          | 4              | 1           | 0              | 0              | ## +6 days ##     | ## +7 days ##   |
      | My booking | Opt_price7 | C1     | price7      | teacher1          | 1         | 1        | 3          | 3              | 1           | 0              | 0              | ## +7 days ##     | ## +8 days ##   |
      | My booking | Opt_price8 | C1     | price1      | teacher1          | 1         | 1        | 4          | 4              | 1           | 0              | 0              | ## +8 days ##     | ## +9 days ##   |
      | My booking | Opt_price9 | C1     | price9      | teacher1          | 1         | 1        | 3          | 3              | 1           | 0              | 0              | ## +9 days ##     | ## +10 days ##  |
    And I log in as "admin"
    And I visit "/local/shopping_cart/cashier.php"
    And I set the field "Select a user..." to "student1"
    And I click on "Continue" "button"
    ## Validate "userinfo" shortcode output
    And I should see "student1@example.com" in the "#cart .userinfocard.userinformation" "css_element"
    ## Validate "allbookingoptions" shortcode output
    And I should see "Opt_1" in the "#cart .wunderbyte_table_container" "css_element"
    And I should see "Opt_3" in the "#cart .wunderbyte_table_container" "css_element"
    And I should not see "55.00 EUR" in the "#cart .wunderbyte_table_container" "css_element"
    ## Validate pagination and proceed to page 2
    And "//nav[@aria-label='Page']" "xpath_element" should exist
    And I click on "2" "text" in the "ul.pagination" "css_element"
    ## Validate "allbookingoptions" shortcode output
    And I should see "Opt_price4" in the "#cart .wunderbyte_table_container" "css_element"
    And I should see "Opt_price6" in the "#cart .wunderbyte_table_container" "css_element"
    And I should see "55.00 EUR" in the "#cart .wunderbyte_table_container" "css_element"
    ## Brought option 5 for user
    And I click on "Add to cart" "text" in the "//div[contains(@class, 'mod-booking-row') and contains(@class, '_r2')]" "xpath_element"
    And I click on "Proceed to checkout" "text" in the ".card-body" "css_element"
    ## Verify that user info and options list are not shown on the checkout page
    And I should not see "student1@example.com" in the "#cart .userinfocard.userinformation" "css_element"
    And I should not see "Opt_price5" in the "#cart .wunderbyte_table_container" "css_element"
    ## Finalize payment using cash and validate it
    And I click on "Confirm cash payment" "text" in the ".card-body" "css_element"
    And I should see "Payment successful!"
    And I should see "Opt_price5" in the "div.history ul.cashier-history-items li.list-group-item" "css_element"
    And I should see "Paid with cash at cashier's office" in the "div.history ul.cashier-history-items li.list-group-item" "css_element"
    And I should see "55 EUR" in the "div.history ul.cashier-history-items li.list-group-item .shopping-cart-price.item-price" "css_element"
    ## Byy for the student3
    ##And I click on "#user-tab" "link" in the "#cashiertabs" "css_element"
    And I click on "[aria-controls=\"user-tab\"]" "css_element"
    And I set the field "Select a user..." to "student3"
    And I click on "Continue" "button"
    ## Validate "userinfo" shortcode output
    And I should see "student3@example.com" in the "#cart .userinfocard.userinformation" "css_element"
    ## Pagination: proceed to page 3
    And I click on "3" "text" in the "ul.pagination" "css_element"
    ## Validate "allbookingoptions" shortcode output
    And I should see "Opt_price7" in the "#cart .wunderbyte_table_container" "css_element"
    And I should see "Opt_price8" in the "#cart .wunderbyte_table_container" "css_element"
    And I should see "44.00 EUR" in the "#cart .wunderbyte_table_container" "css_element"
    ## Brought option 9 for user
    And I click on "Add to cart" "text" in the "//div[contains(@class, 'mod-booking-row') and contains(@class, '_r3')]" "xpath_element"
    And I click on "Proceed to checkout" "text" in the ".card-body" "css_element"
    ## Verify that user info and options list are not shown on the checkout page
    And I should not see "student3@example.com" in the "#cart .userinfocard.userinformation" "css_element"
    And I should not see "Opt_price9" in the "#cart .wunderbyte_table_container" "css_element"
    ## Finalize payment using credits and validate it
    And I should see "No costcenter" in the ".costcenterlabel" "css_element"
    And I should see "200.00" in the ".shopping_cart_history_paidback .costcenterlabel .credit_total" "css_element"
    And I should see "44.00 EUR" in the ".sc_price_label .sc_initialtotal" "css_element"
    And I should see "Use credit: 200.00 EUR" in the ".sc_price_label .sc_credit" "css_element"
    And I should see "44.00 EUR" in the ".sc_price_label .sc_deductible" "css_element"
    And I should see "156.00 EUR" in the ".sc_price_label .sc_remainingcredit" "css_element"
    And I should see "0 EUR" in the ".sc_totalprice" "css_element"
    And I click on "Confirm cash payment" "text" in the ".card-body" "css_element"
    And I should see "Payment successful!"
    And I should see "Opt_price9" in the "div.history ul.cashier-history-items" "css_element"
    And I should see "Paid with cash at cashier's office" in the "div.history ul.cashier-history-items" "css_element"
    And I should see "44 EUR" in the "div.history ul.cashier-history-items .shopping-cart-price.item-price" "css_element"
    And I should see "156.00" in the ".shopping_cart_history_paidback .costcenterlabel .credit_total" "css_element"
