<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_ascend_rewards', language 'en'
 *
 * @package   local_ascend_rewards
 * @copyright 2026 Elantis (Pty) LTD
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

// phpcs:disable moodle.Files.LangFilesOrdering.UnexpectedComment,moodle.Files.LangFilesOrdering.IncorrectOrder
// Note: Removed unused legacy strings: allow_repeat_same_badge, allow_repeat_same_badge_desc,
// coins (use coins_label), filtercourse, filternone, leaderboard (use leaderboard_top10_label),
// noleaderdata, norecent, recentbadges, totalassets.
$string['achievement_details_label'] = 'Achievement Details';
$string['activate_label'] = 'Activate';
$string['activation_error_label'] = 'Could not activate item';
$string['activation_processing_error_label'] = 'Error activating item';
$string['activities_completed_label'] = 'activities completed';
$string['admin_dashboard'] = 'Admin Dashboard';
$string['adopted_label'] = 'adopted';
$string['ajax_config_missing'] = 'Moodle configuration not available.';
$string['ajax_invalid_json'] = 'Invalid server response.';
$string['ajax_network_error'] = 'Network error. Please check your connection.';
$string['ajax_request_failed'] = 'Request failed. Please try again.';
$string['alert_title'] = 'Notice';
$string['all_courses_label'] = 'All courses';
$string['and_label'] = 'and';
$string['apply_label'] = 'Apply';
$string['ascend_rewards:manage'] = 'Manage Ascend Rewards';
$string['ascend_rewards:view'] = 'View Ascend Rewards';
$string['ascend_rewards:viewaudit'] = 'View Ascend Rewards audit trail';
$string['ascend_universe_label'] = 'Ascend Universe';
$string['assets_label'] = 'Ascend Assets';
$string['audit_trail'] = 'Badge Audit Trail';
$string['available_label'] = 'available';
$string['avatar_alt_label'] = 'Avatar';
$string['award_number_label_prefix'] = 'Award #';
$string['award_number_label_suffix'] = ':';
$string['awardbadges'] = 'Award badges (Ascend Auto Badger)';
$string['badge_category_default'] = 'General';
$string['badge_category_mastery'] = 'Course Mastery';
$string['badge_category_other'] = 'Other';
$string['badge_category_progress'] = 'Progress-Based';
$string['badge_category_quality'] = 'Quality & Growth';
$string['badge_category_timeliness'] = 'Timeliness & Discipline';
$string['badge_code_label'] = 'Code';
$string['badge_current_id_label'] = 'Current badgeid';
$string['badge_desc_default'] = 'See badge rules.';
$string['badge_desc_feedback_follower'] = 'Improve your grade in an activity = 200';
$string['badge_desc_getting_started'] = 'Awarded after completing the first activity in a course = 250';
$string['badge_desc_glory_guide'] = 'Gold Badge - Obtain any 2 badges in the Quality-Based & Growth/Improvement '
    . 'Badges Category = 600';
$string['badge_desc_halfway_hero'] = 'Completed 50% of course activities = 550';
$string['badge_desc_master_navigator'] = 'Gold Badge - obtain 2 x badges in the Progress Based Badges Category = 700';
$string['badge_desc_steady_improver'] = 'Fail and then pass an activity = 300';
$string['badge_desc_tenacious_tiger'] = 'Improve your grade in 2 activities = 350';
$string['badge_description_label'] = 'Badge Description';
$string['badge_earned_on'] = 'Earned on {$a}';
$string['badge_earned_subtitle'] = 'Congratulations on your achievement';
$string['badge_earned_times'] = 'Earned {$a} times';
$string['badge_earned_title'] = 'Badge Earned!';
$string['badge_idnumber_label'] = 'idnumber';
$string['badge_label'] = 'Badge';
$string['badge_map_label'] = 'Map to badge';
$string['badge_name_feedback_follower'] = 'Feedback Follower';
$string['badge_name_getting_started'] = 'Getting Started';
$string['badge_name_glory_guide'] = 'Glory Guide';
$string['badge_name_halfway_hero'] = 'Halfway Hero';
$string['badge_name_label'] = 'Badge Name';
$string['badge_name_master_navigator'] = 'Master Navigator';
$string['badge_name_steady_improver'] = 'Steady Improver';
$string['badge_name_tenacious_tiger'] = 'Tenacious Tiger';
$string['badge_not_mapped_label'] = '- Not mapped -';
$string['badges_earned_label'] = 'Badges Earned';
$string['badgescreated'] = 'Badges created/ensured successfully.';
$string['balance_label'] = 'Balance:';
$string['banner_icon_text'] = 'ID';
$string['box_label_1'] = 'Box 1';
$string['box_label_2'] = 'Box 2';
$string['box_label_3'] = 'Box 3';
$string['box_label_4'] = 'Box 4';
$string['cachedef_performance'] = 'Ascend Rewards performance cache';
$string['cancel_label'] = 'Cancel';
$string['close_label'] = 'Close';
$string['coaching_header_personal'] = 'Personal Coach';
$string['coaching_header_progress'] = 'Your Progress';
$string['coaching_message_course_complete'] = 'Course Complete! You have finished all activities.';
$string['coaching_message_final_stretch'] = 'Final stretch! Just {$a} activities left.';
$string['coaching_message_halfway'] = 'Halfway there! Keep up the momentum!';
$string['coaching_message_progress'] = 'You are making progress! Keep going!';
$string['coins_available_label'] = 'coins available';
$string['coins_default_display'] = '+0 Coins';
$string['coins_earned_label'] = 'Coins Earned';
$string['coins_label'] = 'Coins';
$string['coins_reward_prefix'] = 'You received coins instead:';
$string['coins_settings'] = 'Default Coin Rewards';
$string['coins_settings_desc'] = 'These values are used when the plugin is first installed. You can change them '
    . 'anytime.';
$string['collection_label'] = 'Collection';
$string['confirm_title'] = 'Confirm';
$string['congrats_subtext'] = 'Keep up the momentum - more Ascend Assets are on the way.';
$string['congrats_title_levelup'] = 'Level Up! You reached Level {$a}!';
$string['congrats_title_newbadge'] = 'New badge earned this week! The Gameboard has been unlocked!';
$string['continue_label'] = 'Continue';
$string['contributing_badges_label'] = 'Contributing Badges';
$string['course_journey_label'] = 'Course Journey';
$string['course_label'] = 'Course';
$string['createbadges'] = 'Create default badges';
$string['current_balance_label'] = 'Your current balance';
$string['current_rank_label'] = 'Your current rank';
$string['default_coins_desc'] = 'Default Ascend Assets awarded for this badge (used on install; can be changed '
    . 'anytime).';
$string['default_coins_label'] = '{$a} - default coins';
$string['earned_on_label'] = 'Earned On';
$string['empty_state_icon'] = '🎁';
$string['epic_level_label'] = 'Epic Level';
$string['error_directory_not_found'] = 'Directory not found: {$a}';
$string['error_prefix'] = 'Error: ';
$string['error_title'] = 'Error';
$string['experience_points_label'] = 'Experience Points';
$string['expired_label'] = 'Expired';
$string['filter_by_course_label'] = 'Filter by course';
$string['fullscreen_label'] = 'Fullscreen';
$string['gameboard_could_not_make_pick'] = 'Could not make pick';
$string['gameboard_error_prefix'] = 'Error: ';
$string['gameboard_generic_error'] = 'Error making pick';
$string['gameboard_invalid_position'] = 'Invalid position.';
$string['gameboard_locked_label'] = 'Complete activities and earn badges to unlock the gameboard!';
$string['gameboard_processing_error_prefix'] = 'Error processing pick: ';
$string['gameboard_success_text'] = 'You earned {coins} coins.';
$string['hero_label'] = 'hero';
$string['hero_reward_prefix'] = 'You unlocked';
$string['hero_reward_suffix'] = 'Your new hero is now available in Ascend Universe.';
$string['heroes_label'] = 'Heroes';
$string['in_this_course_label'] = 'In this course';
$string['instructions_text'] = 'Instructions: click here to see how Ascend works';
$string['instructions_page_title'] = 'Ascend Rewards Instructions';
$string['instructions_page_heading'] = 'How Ascend Rewards Works';
$string['instructions_intro'] = 'Ascend Rewards uses badges, coins, and XP to recognize progress and achievement in your courses.';
$string['instructions_categories_heading'] = 'Badge categories';
$string['instructions_category_progress'] = 'Progress badges reward steady completion of activities.';
$string['instructions_category_timeliness'] = 'Timeliness badges reward meeting deadlines or completing work early.';
$string['instructions_category_quality'] = 'Quality badges reward strong results and improvement.';
$string['instructions_category_mastery'] = 'Mastery badges reward completing major course milestones.';
$string['instructions_category_progress_title'] = 'Progress badges';
$string['instructions_category_progress_desc'] = 'Earned by completing activities and building momentum.';
$string['instructions_category_timeliness_title'] = 'Timeliness badges';
$string['instructions_category_timeliness_desc'] = 'Earned by meeting deadlines or completing work early.';
$string['instructions_category_quality_title'] = 'Quality badges';
$string['instructions_category_quality_desc'] = 'Earned for strong results and consistent improvement.';
$string['instructions_category_mastery_title'] = 'Mastery badges';
$string['instructions_category_mastery_desc'] = 'Earned for completing major course milestones.';
$string['instructions_rewards_heading'] = 'Rewards you receive';
$string['instructions_rewards_coins'] = 'Badges award Ascend Coins based on difficulty and category.';
$string['instructions_rewards_xp'] = 'XP increases your rank and unlocks new content.';
$string['instructions_rewards_store'] = 'Coins can be spent in the Ascend Store.';
$string['instructions_earn_heading'] = 'How to earn badges';
$string['instructions_earn_step1'] = 'Complete course activities to trigger badges automatically.';
$string['instructions_earn_step2'] = 'Badges award coins and XP based on difficulty and category.';
$string['instructions_earn_step3'] = 'Coins and XP unlock store items and rank progression.';
$string['instructions_features_heading'] = 'Explore the rewards experience';
$string['instructions_feature_badges_title'] = 'Badges earned';
$string['instructions_feature_badges_desc'] = 'Review badges earned in your course and see recent awards.';
$string['instructions_feature_leaderboard_title'] = 'Leaderboard';
$string['instructions_feature_leaderboard_desc'] = 'Compare progress with classmates and track your rank.';
$string['instructions_feature_journey_title'] = 'Course journey';
$string['instructions_feature_journey_desc'] = 'Follow your progress across activities and milestones.';
$string['instructions_feature_gameboard_title'] = 'Gameboard';
$string['instructions_feature_gameboard_desc'] = 'Unlock rewards, tokens, and hidden surprises.';
$string['instructions_feature_universe_title'] = 'Ascend Universe';
$string['instructions_feature_universe_desc'] = 'Collect avatars and customize your experience.';
$string['instructions_feature_store_title'] = 'Ascend Store';
$string['instructions_feature_store_desc'] = 'Spend coins on rewards and boosters.';
$string['instructions_back_label'] = 'Back to Ascend Rewards';
$string['instructions_badge_groups_heading'] = 'Badge groups and default coin values';
$string['instructions_badge_group_progress'] = 'Progress badges';
$string['instructions_badge_group_progress_desc'] = 'Getting Started and Halfway Hero reward steady progress.';
$string['instructions_badge_group_quality'] = 'Quality & Growth badges';
$string['instructions_badge_group_quality_desc'] = 'Rewards improvement and consistency, not just perfection.';
$string['instructions_badge_group_meta'] = 'Meta badges';
$string['instructions_badge_group_meta_desc'] = 'Top-level achievements earned after other milestones.';
$string['instructions_badge_desc_getting_started'] = 'First activity completed.';
$string['instructions_badge_desc_halfway_hero'] = '50% of course activities completed.';
$string['instructions_badge_desc_master_navigator'] = 'Earn 2+ badges in the Progress group.';
$string['instructions_badge_desc_feedback_follower'] = 'Improved grade in an activity.';
$string['instructions_badge_desc_steady_improver'] = 'Pass after an initial fail.';
$string['instructions_badge_desc_tenacious_tiger'] = 'Improved grade in 2 activities.';
$string['instructions_badge_desc_glory_guide'] = 'Earn 2+ badges in the Quality & Growth group.';
$string['leaderboard'] = 'Leaderboard';
$string['leaderboard_context_error_label'] = 'Error loading leaderboard context.';
$string['leaderboard_context_sitewide'] = 'Sitewide';
$string['leaderboard_context_view_error_label'] = 'Error loading context view.';
$string['leaderboard_empty_label'] = 'No leaderboard data yet.';
$string['leaderboard_loading_label'] = 'Loading your position...';
$string['leaderboard_range_label'] = '(Ranks {start}-{end} of {total})';
$string['leaderboard_top10_course_label'] = 'Top 10 - {$a}';
$string['leaderboard_top10_label'] = 'Top 10';
$string['learners_label'] = 'learners';
$string['level_label'] = 'Level';
$string['levelup_modal_subtitle'] = 'Keep climbing to the top!';
$string['levelup_modal_title'] = 'Level Up!';
$string['linked_hero_label'] = 'Linked Hero:';
$string['linked_pet_label'] = 'Linked Pet:';
$string['local/ascend_rewards:manage'] = 'Manage Ascend Rewards';
$string['local/ascend_rewards:view'] = 'View Ascend Rewards';
$string['local/ascend_rewards:viewaudit'] = 'View Ascend Rewards audit trail';
$string['locked_until_label'] = 'Locked until Level';
$string['managebadges'] = 'Manage Ascend Rewards Badges';
$string['mappingsaved'] = 'Mappings saved.';
$string['medal_label'] = 'Medal';
$string['meta_badges_label'] = 'Meta Badges';
$string['meta_picks_label'] = '2 picks -';
$string['modal_avatar_pet_revealed_text'] = 'Check the Pets section below to adopt your new pet';
$string['modal_avatar_pet_revealed_title'] = 'The {$a->name}\'s Pet is Revealed!';
$string['modal_avatar_unlocked_title'] = '{$a->name} Unlocked!';
$string['modal_avatar_use_profile_note'] = 'Use this image in your profile!';
$string['modal_download_avatar_label'] = 'Download Avatar Image';
$string['modal_download_pet_label'] = 'Download Pet Image';
$string['modal_download_villain_label'] = 'Download Villain Image';
$string['modal_error_unlock_avatar'] = 'Could not unlock avatar';
$string['modal_error_unlock_pet'] = 'Could not adopt pet';
$string['modal_error_unlock_villain'] = 'Could not unlock villain';
$string['modal_insufficient_coins_label'] = 'Insufficient coins (need {$a->price})';
$string['modal_new_balance_label'] = 'New balance: {$a->balance} {$a->coinsLabel}';
$string['modal_no_tokens_available'] = 'No tokens available! Level up to get more unlock tokens.';
$string['modal_not_loaded_label'] = 'Error: unlock system not loaded';
$string['modal_pay_button_label'] = 'Pay {$a->price}';
$string['modal_pay_coins_label'] = 'Pay {$a->price} Coins (Balance: {$a->balance})';
$string['modal_pet_adopted_title'] = 'Pet Adopted!';
$string['modal_pet_villain_revealed_text'] = 'Check the Villain section below to unleash your new villain.';
$string['modal_pet_villain_revealed_title'] = 'The Villain is Revealed!';
$string['modal_pet_unlock_title'] = 'Adopt Pet';
$string['modal_token_available_label'] = 'Use Token ({$a->count} available)';
$string['modal_unlock_avatar_button'] = 'Unlock Avatar';
$string['modal_unlock_avatar_level_note'] = 'Level {$a->level} Avatar Costs 1 Token';
$string['modal_unlock_avatar_note'] = 'Once unlocked, click to view video & download';
$string['modal_unlock_avatar_title'] = 'Unlock {$a->name}?';
$string['modal_unlock_method_label'] = 'Choose unlock method:';
$string['modal_unlocked_with_label'] = 'Unlocked with: {$a->method}';
$string['modal_use_token_button'] = 'Use Token';
$string['modal_villain_unlock_title'] = 'Unlock Villain';
$string['modal_villain_storybook_unlocked_text'] = 'Check the Story Book section below to view the story.';
$string['modal_villain_storybook_unlocked_title'] = 'Your Story Book is Unlocked!';
$string['modal_villain_unlocked_title'] = 'Villain Unlocked!';
$string['more_activities_label'] = '...and {$a} more activities';
$string['my_position_label'] = 'My Position';
$string['mystery_box_description'] = 'Unwrap a random surprise reward!';
$string['mystery_box_label'] = 'Mystery Box';
$string['mystery_box_open_label'] = 'Open Mystery Box for {$a} Coins';
$string['mystery_error_could_not_open'] = 'Could not open mystery box';
$string['mystery_error_label'] = 'Could not open mystery box';
$string['mystery_error_logged'] = 'Error opening mystery box. The error has been logged.';
$string['mystery_error_network'] = 'Network error. Please check your connection and try again.';
$string['mystery_error_processing'] = 'Error opening mystery box. Please try again.';
$string['mystery_generic_error_label'] = 'Error opening mystery box';
$string['mystery_not_enough_coins'] = 'Not enough coins! You need {$a} coins.';
$string['mystery_opening_label'] = 'Opening...';
$string['mystery_processing_error_label'] = 'Error processing mystery box';
$string['mystery_reason_purchase'] = 'Mystery Box Purchase';
$string['mystery_reason_reward_coins'] = 'Mystery Box Reward - Coins';
$string['mystery_reason_reward_duplicate_avatar'] = 'Mystery Box Reward - Duplicate Avatar (Coins)';
$string['mystery_reason_reward_locked_level'] = 'Mystery Box Reward - Locked Level Avatar (Coins)';
$string['mystery_reward_coins_message'] = 'YOU FOUND COINS! +{$a->amount} {$a->coinlabel}!';
$string['mystery_reward_duplicate_avatar_message'] = 'You already have this avatar! You received coins: +{$a->amount} '
    . '{$a->coinlabel}!';
$string['mystery_reward_locked_level_message'] = 'That hero belongs to a future level. You received coins instead: '
    . '+{$a->amount} {$a->coinlabel}!';
$string['mystery_reward_new_avatar_message'] = 'YOU UNLOCKED A NEW HERO! Your new hero has been added to your '
    . 'collection!';
$string['mystery_reward_nothing_message'] = 'BETTER LUCK NEXT TIME! You got nothing, but the mystery continues...';
$string['mystery_reward_tokens_message'] = 'YOU EARNED TOKENS! +{$a->count} unlock {$a->tokenlabel}!';
$string['nav_rewards'] = 'Ascend Rewards';
$string['new_balance_label'] = 'New balance:';
$string['no_badges_label'] = 'No badges earned yet.';
$string['no_journeys_label'] = 'No course journeys available.';
$string['no_pets_description'] = 'To unlock pets, you must first unlock an avatar on your current level. Once you '
    . 'unlock a hero, their'
    . 'companion pet becomes available for adoption!';
$string['no_pets_tip'] = 'Tip: Head to the Ascend Universe section above to unlock your first hero, then '
    . 'their pet will be'
    . 'ready to adopt.';
$string['no_pets_title'] = 'No Pets Available for Adoption';
$string['no_reward_label'] = 'No reward this time.';
$string['no_villains_description'] = 'To unlock villains, you must first unlock a pet. Once you adopt a pet, its '
    . 'arch-nemesis villain'
    . 'becomes available for unleashing!';
$string['no_villains_tip'] = 'Tip: Head to the Pets section above to adopt your first companion, then their '
    . 'villain will be ready'
    . 'to unleash.';
$string['no_villains_title'] = 'No Villains Available to be Unleashed';
$string['normal_badges_label'] = 'Normal Badges';
$string['normal_picks_label'] = '1 pick -';
$string['not_enough_coins_label'] = 'Not Enough Coins';
$string['of_label'] = 'of';
$string['pet_aria_label'] = 'Adopt {$a->name} for {$a->price} coins';
$string['pet_buy_label'] = 'Adopt for {$a} Coins';
$string['pet_label'] = 'pet';
$string['pets_label'] = 'Pets';
$string['picks_available_label'] = 'Picks Available';
$string['pluginname'] = 'Ascend Rewards';
$string['powerups_title_label'] = 'Power-Ups & Mystery Items';
$string['pro_version_only_message'] = 'This feature is only available in the PRO version.';
$string['processing_label'] = 'Processing...';
$string['progress_label'] = 'progress';
$string['purchase_button_prefix'] = 'Purchase for ';
$string['purchase_confirm_action_label'] = 'Purchase';
$string['purchase_confirm_mid'] = ' for ';
$string['purchase_confirm_prefix'] = 'Purchase ';
$string['purchase_confirm_suffix'] = ' coins?';
$string['purchase_error_label'] = 'Could not complete purchase';
$string['purchase_processing_error_label'] = 'Error processing purchase';
$string['purchase_success_label'] = 'Purchase successful!';
$string['qualifying_activities_label'] = 'Qualifying Activities';
$string['rank_display'] = '#{$a->rank} of {$a->total} learners';
$string['rank_label'] = 'Rank:';
$string['rank_not_ranked'] = 'Not ranked';
$string['ranking_label'] = 'Ranking';
$string['remaining_balance_label'] = 'Remaining balance:';
$string['reset_label'] = 'Reset';
$string['savemappings'] = 'Save mappings';
$string['store_activate_xp_multiplier_message'] = 'XP Multiplier activated! You\'re now earning 2x XP.';
$string['store_error_invalid_item'] = 'Invalid item';
$string['store_error_item_not_in_inventory'] = 'Item not in inventory';
$string['store_error_not_enough_coins'] = 'Not enough coins';
$string['store_error_unknown_item_type'] = 'Unknown item type';
$string['store_label'] = 'Ascend Store';
$string['task_rebuild_badge_cache'] = 'Rebuild badge activity cache';
$string['tokens_available_badge_text'] = '{$a} token(s) available!';
$string['tokens_available_text'] = 'You have <strong>{$a}</strong> unlock token(s)!';
$string['tokens_balance_label'] = 'Tokens balance:';
$string['tokens_label'] = 'tokens';
$string['tokens_reward_prefix'] = 'You received tokens instead:';
$string['unknown_course_label'] = 'Unknown Course';
$string['unlock_avatar_already_unlocked'] = 'Avatar already unlocked';
$string['unlock_avatar_success'] = 'Avatar unlocked successfully';
$string['unlock_invalid_type'] = 'Invalid unlock type';
$string['unlock_level_locked'] = 'You have not unlocked level {$a} yet';
$string['unlock_no_token_record'] = 'No token record found';
$string['unlock_no_tokens_available'] = 'No tokens available';
$string['unlock_pet_already_adopted'] = 'Pet already adopted';
$string['unlock_pet_avatar_required'] = 'Avatar not unlocked. You must unlock the {$a} avatar first.';
$string['unlock_pet_insufficient_coins'] = 'Insufficient coins. Need {$a->need}, have {$a->have}';
$string['unlock_pet_invalid_id'] = 'Invalid pet ID';
$string['unlock_pet_success'] = 'Pet adopted successfully!';
$string['unlock_user_not_logged_in'] = 'User not logged in';
$string['unlock_villain_already_unlocked'] = 'Villain already unlocked';
$string['unlock_villain_insufficient_coins'] = 'Insufficient coins. Need {$a->need}, have {$a->have}';
$string['unlock_villain_invalid_id'] = 'Invalid villain ID';
$string['unlock_villain_pet_required'] = 'Pet not adopted. You must adopt the matching pet first.';
$string['unlock_villain_success'] = 'Villain unlocked successfully!';
$string['unlocked_label'] = 'unlocked';
$string['unlocking_label'] = 'Unlocking...';
$string['user_id_badge_label'] = 'ID:';
$string['user_number_prefix'] = 'User #';
$string['view_my_progress_label'] = 'View My Progress';
$string['villain_aria_label'] = 'Unleash {$a->name} for {$a->price} coins';
$string['villain_buy_label'] = 'Unleash for {$a} Coins';
$string['villain_label'] = 'villain';
$string['villains_label'] = 'Villains';
$string['watch_story_label'] = 'Watch Story';
$string['weekly_gameboard_label'] = 'Weekly Gameboard';
$string['xp_default_display'] = '+0 XP';
$string['xp_item_buy_label'] = 'Purchase for {$a} Coins';
$string['xp_item_description'] = 'Double your XP gains for 24 hours! Activate after purchase.';
$string['xp_item_name'] = 'XP Multiplier (24h)';
$string['xp_item_short_name'] = 'XP Multiplier';
$string['xp_label'] = 'XP';
$string['xp_multiplier_active_label'] = 'XP Multiplier Active!';
$string['xp_multiplier_expires_label'] = 'You are earning 2x XP! Expires in:';
$string['you_are_level_label'] = 'You are level';
$string['you_have_label'] = 'You have';
$string['you_label'] = 'You';
$string['your_id_label'] = 'Your ID:';

// Admin and audit strings.
$string['ajax_method_not_allowed'] = 'Method not allowed';
$string['ajax_server_error'] = 'Server error';
$string['ajax_server_error_detail'] = 'Server error: {$a}';
$string['admin_dashboard_title'] = 'Ascend Rewards Admin Dashboard';
$string['admin_congrats_title'] = 'New badge earned this week!';
$string['admin_congrats_subtext'] = 'Keep up the momentum - more Ascend Assets are on the way.';
$string['admin_tab_metrics'] = 'Key Metrics';
$string['admin_tab_users'] = 'User Badges';
$string['admin_tab_award'] = 'Award Badges';
$string['admin_tab_gifts'] = 'Gift Rewards';
$string['admin_tab_cleanup'] = 'Cleanup Tools';
$string['admin_tab_debug'] = 'Debug Tools';
$string['admin_tab_audit'] = 'Audit Trail';
$string['admin_search_by_user'] = 'Search by User';
$string['admin_search_by_badge'] = 'Search by Badge';
$string['admin_error_invalid_user_amount'] = 'Invalid user or amount.';
$string['coin_label_singular'] = 'coin';
$string['coin_label_plural'] = 'coins';
$string['admin_error_gift_coins_save'] = 'Failed to save gift coins to database.';
$string['admin_log_gift_coins'] = 'Awarded {$a->amount} {$a->coinlabel}';
$string['admin_gift_awarded_coins'] = '<strong>Gift Awarded!</strong><br>Gifted <strong>{$a->amount} '
    . '{$a->coinlabel}</strong> to'
    . '<strong>{$a->username}</strong>';
$string['admin_error_gift_coins'] = 'Error gifting coins: {$a}';
$string['token_label_singular'] = 'token';
$string['token_label_plural'] = 'tokens';
$string['token_label'] = 'Token';
$string['admin_log_gift_tokens'] = 'Awarded {$a->amount} {$a->tokenlabel}';
$string['admin_gift_awarded_tokens'] = '<strong>Gift Awarded!</strong><br>Gifted <strong>{$a->amount} '
    . '{$a->tokenlabel}</strong> to'
    . '<strong>{$a->username}</strong>';
$string['admin_error_gift_tokens'] = 'Error gifting tokens: {$a}';
$string['admin_error_invalid_selection'] = 'Invalid selection. Please select from the dropdown.';
$string['admin_error_invalid_course'] = 'Please select a valid course (must not be the site home).';
$string['admin_error_badge_inactive'] = 'This badge is inactive and cannot be awarded in the demo set.';
$string['admin_error_badge_already_awarded'] = 'Badge already awarded for this user/course.';
$string['admin_award_success'] = '<strong>Badge Awarded!</strong><br>Awarded <strong>{$a->badgename}</strong> to '
    . '<strong>{$a->username}</strong>';
$string['admin_error_award_no_record'] = 'Award attempt completed but no database record was created. '
    . 'Please verify the badge is active, the course ID is greater than 1, and check plugin logs.';
$string['admin_log_badge_revoked'] = 'Badge manually revoked by admin';
$string['admin_revoke_success'] = '<strong>Badge Revoked!</strong><br>Revoked <strong>{$a->badgename}</strong> from '
    . '<strong>{$a->username}</strong>';
$string['admin_error_no_status_message'] = 'Award request processed but no status message was returned. '
    . 'Please re-check the input and database records.';
$string['admin_metrics_heading'] = 'Key Metrics';
$string['not_applicable_label'] = 'N/A';
$string['admin_total_badges_awarded'] = 'Total Badges Awarded';
$string['admin_users_with_badges'] = 'Users with Badges';
$string['admin_most_awarded_badge'] = 'Most Awarded Badge';
$string['admin_awards_count'] = '{$a} awards';
$string['admin_badges_awarded_by_type'] = 'Badges Awarded by Type';
$string['awards_label'] = 'Awards';
$string['admin_user_leaderboard_by_xp'] = 'User Leaderboard (by XP)';
$string['rank_heading'] = 'Rank';
$string['total_xp_label'] = 'Total XP';
$string['admin_badge_distribution'] = 'Badge Distribution';
$string['admin_test_badge_popup'] = 'Test Badge Popup Animation';
$string['admin_test_badge_popup_desc'] = 'Select a badge to preview its award modal:';
$string['admin_show_modal_button'] = 'Show Modal';
$string['admin_badge_name_placeholder'] = 'Badge Name Placeholder';
$string['category_label'] = 'Category';
$string['admin_badge_category_progress'] = 'Progress';
$string['admin_badge_category_timeliness'] = 'Timeliness';
$string['admin_badge_category_quality'] = 'Quality & Growth';
$string['admin_badge_category_mastery'] = 'Mastery';
$string['assets_default_display'] = '+0 Ascend Assets';
$string['assets_earned_label'] = 'Assets Earned';
$string['achieved_on_label'] = 'Achieved On';
$string['admin_badge_why_heading'] = 'Why You Earned This Badge';
$string['admin_badge_preview_fallback'] = 'Badge modal preview';
$string['admin_congrats_earned_badge'] = 'New badge earned: {$a}';
$string['admin_sample_course_label'] = 'Sample Course';
$string['admin_select_badge_alert'] = 'Please select a badge first.';
$string['name_id_display'] = '{$a->name} (ID: {$a->id})';
$string['admin_user_search_placeholder'] = 'Start typing user name...';
$string['admin_badge_search_placeholder'] = 'Start typing badge name...';
$string['admin_course_search_placeholder'] = 'Start typing course name...';
$string['view_label'] = 'View';
$string['admin_badges_for_user_heading'] = 'Badges for {$a}';
$string['course_name_label'] = 'Course Name';
$string['date_awarded_label'] = 'Date Awarded';
$string['admin_no_badges_for_user'] = 'No badges found for this user.';
$string['unknown_badge_label'] = 'Unknown Badge';
$string['user_label_singular'] = 'user';
$string['user_label_plural'] = 'users';
$string['admin_badge_recipients_heading'] = 'Recipients of "{$a->badge}" ({$a->count} {$a->userlabel})';
$string['email_label'] = 'Email';
$string['admin_no_recipients_for_badge'] = 'No recipients found for this badge.';
$string['admin_award_revoke_heading'] = 'Award/Revoke Badge';
$string['award_button_label'] = 'Award';
$string['revoke_button_label'] = 'Revoke';
$string['admin_award_select_course_error'] = 'Please select a valid course from the dropdown';
$string['admin_award_select_badge_error'] = 'Please select a valid badge from the dropdown';
$string['admin_gift_rewards_heading'] = 'Gift Rewards';
$string['admin_gift_coins_heading'] = 'Gift Coins';
$string['admin_select_user_label'] = 'Select User';
$string['admin_select_user_placeholder'] = 'Type user name and select from list...';
$string['admin_coin_amount_label'] = 'Coin Amount';
$string['admin_enter_amount_placeholder'] = 'Enter amount...';
$string['admin_gift_coins_button'] = 'Gift Coins';
$string['admin_gift_tokens_heading'] = 'Gift Tokens';
$string['admin_token_amount_label'] = 'Token Amount';
$string['admin_gift_tokens_button'] = 'Gift Tokens';
$string['admin_award_audit_heading'] = 'Award Audit Log';
$string['admin_award_audit_desc'] = 'Recent gifts and awards with tracking of who gave them.';
$string['admin_no_gift_awards'] = 'No gift awards yet.';
$string['when_label'] = 'When';
$string['recipient_label'] = 'Recipient';
$string['award_type_label'] = 'Award Type';
$string['awarded_by_label'] = 'Awarded By';
$string['system_label'] = 'System';
$string['admin_cleanup_heading'] = 'Cleanup Tools';
$string['admin_cleanup_orphaned_success'] = 'Cleaned up {$a} orphaned badge records.';
$string['admin_cleanup_orphaned_none'] = 'No orphaned badges found.';
$string['admin_cleanup_deleted_users_success'] = 'Cleaned up {$a} badge records for deleted users.';
$string['admin_cleanup_deleted_users_none'] = 'No badge records found for deleted users.';
$string['admin_cleanup_orphaned_label'] = 'Cleanup Orphaned Badges';
$string['admin_cleanup_orphaned_desc'] = 'This tool removes badge award records that are linked to courses '
    . 'which no longer exist in the system. Orphaned badges can occur when courses '
    . 'are deleted after badges have been awarded. Running this cleanup ensures the database '
    . 'remains clean and prevents issues with reports or statistics.';
$string['admin_cleanup_deleted_users_label'] = 'Cleanup Deleted Users';
$string['admin_cleanup_deleted_users_desc'] = 'This tool removes all badge award records for users who have been '
    . 'deleted from the system. Deleted users should not have any plugin data remaining.';
$string['note_label'] = 'Note';
$string['admin_cleanup_note'] = 'Suspended users are automatically excluded from all plugin functionality '
    . '(leaderboards, debug info,'
    . 'XP rewards, etc.) and do not appear in any results.';
$string['admin_cleanup_orphaned_button'] = 'Cleanup Orphaned Badges';
$string['admin_cleanup_deleted_users_button'] = 'Cleanup Deleted Users';
$string['admin_debug_heading'] = 'Debug Tools';
$string['admin_global_course_option'] = 'Global (ID: {$a})';
$string['debug_button_label'] = 'Debug';
$string['admin_invalid_badge_id'] = 'Invalid badge ID';
$string['admin_all_courses_global'] = 'All Courses (Global)';
$string['admin_badge_deep_dive_heading'] = 'Badge Deep Dive: {$a}';
$string['admin_badge_awarded_times'] = 'Badge Awarded {$a} Time(s)';
$string['admin_award_coins_on'] = '{$a->coins} coins on {$a->date}';
$string['admin_badge_not_awarded_heading'] = 'Badge NOT Awarded';
$string['admin_badge_not_awarded_desc'] = 'This badge has not been awarded yet.';
$string['admin_debug_step1_heading'] = 'STEP 1: Retrieve Course Activity Data';
$string['admin_debug_found_activities_all'] = 'Found <strong>{$a}</strong> activities with completion tracking '
    . 'across all courses.';
$string['admin_debug_found_activities_course'] = 'Found <strong>{$a}</strong> activities with completion tracking '
    . 'in this course.';
$string['activity_label'] = 'Activity';
$string['type_label'] = 'Type';
$string['completed_label'] = 'Completed';
$string['grade_label'] = 'Grade';
$string['pass_grade_label'] = 'Pass Grade';
$string['passed_label'] = 'Passed';
$string['failed_label'] = 'Failed';
$string['due_date_label'] = 'Due Date';
$string['before_deadline_label'] = 'Before Deadline';
$string['early_label'] = 'Early (24hrs)';
$string['no_deadline_label'] = 'No deadline';
$string['pass_label'] = 'Pass';
$string['yes_label'] = 'Yes';
$string['no_label'] = 'No';
$string['dash_label'] = '-';
$string['admin_debug_step2_heading'] = 'STEP 2: Apply Badge Logic for "{$a}"';
$string['admin_requirement_label'] = 'Requirement';
$string['admin_detection_method_label'] = 'Detection Method';
$string['admin_debug_reason_max_consecutive'] = 'Max consecutive completions: <strong>{$a->count}</strong> '
    . '(need {$a->required})';
$string['admin_debug_reason_completed_activities'] = 'Completed activities: <strong>{$a->count}</strong> '
    . '(need {$a->required})';
$string['admin_debug_reason_completion_percent'] = 'Completion: <strong>{$a->percent}%</strong> '
    . '(need {$a->required}%)';
$string['admin_debug_reason_early_completions'] = 'Early completions (24hrs+): <strong>{$a->count}</strong> '
    . '(need {$a->required})';
$string['admin_debug_reason_max_consecutive_deadline'] = 'Max consecutive before deadline: '
    . '<strong>{$a->count}</strong> (need {$a->required})';
$string['admin_debug_reason_before_deadline'] = 'Before deadline: <strong>{$a->count} / {$a->total}</strong> '
    . '(need all)';
$string['admin_debug_reason_max_consecutive_passes'] = 'Max consecutive passes: <strong>{$a->count}</strong> '
    . '(need {$a->required})';
$string['admin_debug_reason_passed_first_attempt'] = 'Passed first attempt: '
    . '<strong>{$a->passed} / {$a->total}</strong> (need all)';
$string['admin_debug_reason_completed_all'] = 'Completed: <strong>{$a->completed} / {$a->total}</strong> '
    . '(need all)';
$string['admin_debug_reason_progress_badges'] = 'Progress badges earned: <strong>{$a->earned} / {$a->total}</strong> '
    . '(need {$a->required})<br>Earned: {$a->list}';
$string['admin_debug_reason_timeliness_badges'] = 'Timeliness badges earned: '
    . '<strong>{$a->earned} / {$a->total}</strong> (need {$a->required})<br>Earned: {$a->list}';
$string['admin_debug_reason_quality_badges'] = 'Quality & Growth badges earned: '
    . '<strong>{$a->earned} / {$a->total}</strong> (need {$a->required})<br>Earned: {$a->list}';
$string['admin_debug_reason_mastery_badges'] = 'Mastery badges earned: <strong>{$a->earned} / {$a->total}</strong> '
    . '(need {$a->required})<br>Earned: {$a->list}';
$string['admin_qualification_pass'] = 'QUALIFICATION CHECK: PASS';
$string['admin_qualification_pass_desc'] = 'User meets all requirements for "{$a}"';
$string['admin_award_this_badge_button'] = 'Award This Badge';
$string['admin_qualification_fail'] = 'QUALIFICATION CHECK: FAIL';
$string['admin_qualification_fail_desc'] = 'User does NOT meet requirements for "{$a}"';
$string['admin_debug_select_prompt'] = 'Please select a user, course, and badge to debug.';
$string['admin_audit_records_heading'] = 'Audit Records';
$string['record_id_label'] = 'Record ID';
$string['user_name_label'] = 'User Name';
$string['badge_id_label'] = 'Badge ID';
$string['time_created_label'] = 'Time Created';
$string['unknown_user_label'] = 'Unknown';
$string['search_label'] = 'Search';
$string['badge_number_label'] = 'Badge #{$a}';
$string['user_number_label'] = 'User #{$a}';
$string['filters_heading'] = 'Filters';
$string['user_id_label'] = 'User ID';
$string['all_badges_label'] = 'All Badges';
$string['status_label'] = 'Status';
$string['all_label'] = 'All';
$string['date_from_label'] = 'Date From:';
$string['date_to_label'] = 'Date To:';
$string['apply_filters_label'] = 'Apply Filters';
$string['clear_filters_label'] = 'Clear Filters';
$string['total_records_label'] = 'Total Records:';
$string['audit_showing_limit'] = '(showing up to {$a} most recent)';
$string['id_label'] = 'ID';
$string['date_time_label'] = 'Date/Time';
$string['user_label'] = 'User';
$string['message_label'] = 'Message';
$string['no_audit_records_label'] = 'No audit records found.';
$string['statistics_heading'] = 'Statistics';
$string['status_success'] = 'Success';
$string['status_revoked'] = 'Revoked';
$string['status_debug'] = 'Debug';
$string['status_error'] = 'Error';
$string['badge_name_on_a_roll'] = 'On a Roll';
$string['badge_name_early_bird'] = 'Early Bird';
$string['badge_name_sharp_shooter'] = 'Sharp Shooter';
$string['badge_name_deadline_burner'] = 'Deadline Burner';
$string['badge_name_time_tamer'] = 'Time Tamer';
$string['badge_name_high_flyer'] = 'High Flyer';
$string['badge_name_activity_ace'] = 'Activity Ace';
$string['badge_name_mission_complete'] = 'Mission Complete';
$string['badge_name_learning_legend'] = 'Learning Legend';
$string['admin_badge_desc_getting_started'] = 'First activity completed';
$string['admin_badge_desc_on_a_roll'] = '3 consecutive activities completed';
$string['admin_badge_desc_halfway_hero'] = '50% of course activities completed';
$string['admin_badge_desc_master_navigator'] = 'Earn 2+ badges in Progress category';
$string['admin_badge_desc_early_bird'] = 'Complete activity 48hrs before deadline';
$string['admin_badge_desc_sharp_shooter'] = '3 consecutive activities before deadline';
$string['admin_badge_desc_deadline_burner'] = 'All activities before deadline';
$string['admin_badge_desc_time_tamer'] = 'Earn 2+ badges in Timeliness category';
$string['admin_badge_desc_feedback_follower'] = 'Improved grade in an activity';
$string['admin_badge_desc_steady_improver'] = 'Pass after initial fail';
$string['admin_badge_desc_tenacious_tiger'] = 'Improved grade in 3 activities';
$string['admin_badge_desc_glory_guide'] = 'Earn 2+ badges in Quality & Growth category';
$string['admin_badge_desc_high_flyer'] = 'Pass 2 consecutive activities';
$string['admin_badge_desc_activity_ace'] = 'Pass all activities first attempt';
$string['admin_badge_desc_mission_complete'] = 'All course activities completed';
$string['admin_badge_desc_learning_legend'] = 'Earn 2+ badges in Mastery category';
$string['admin_debug_badge_desc_on_a_roll'] = '2 consecutive activities completed';
$string['admin_debug_badge_desc_getting_started'] = 'First activity completed';
$string['admin_debug_badge_desc_halfway_hero'] = '50% of course activities completed';
$string['admin_debug_badge_desc_master_navigator'] = 'Earn 2+ badges in Progress category';
$string['admin_debug_badge_desc_early_bird'] = 'Complete activity 24hrs before deadline';
$string['admin_debug_badge_desc_sharp_shooter'] = '2 consecutive activities before deadline';
$string['admin_debug_badge_desc_deadline_burner'] = 'All activities before deadline';
$string['admin_debug_badge_desc_time_tamer'] = 'Earn 2+ badges in Timeliness category';
$string['admin_debug_badge_desc_feedback_follower'] = 'Improved grade in an activity';
$string['admin_debug_badge_desc_steady_improver'] = 'Pass after initial fail';
$string['admin_debug_badge_desc_tenacious_tiger'] = 'Improved grade in 2 activities';
$string['admin_debug_badge_desc_glory_guide'] = 'Earn 2+ badges in Quality & Growth category';
$string['admin_debug_badge_desc_high_flyer'] = 'Pass 2 consecutive activities';
$string['admin_debug_badge_desc_activity_ace'] = 'Pass all activities first attempt';
$string['admin_debug_badge_desc_mission_complete'] = 'All course activities completed';
$string['admin_debug_badge_desc_learning_legend'] = 'Earn 2+ badges in Mastery category';

// Privacy API strings.
$string['privacy:metadata:local_ascend_rewards_coins'] = 'Stores user coin and XP transactions for badge awards';
$string['privacy:metadata:userid'] = 'The ID of the user';
$string['privacy:metadata:badgeid'] = 'The ID of the badge awarded';
$string['privacy:metadata:coins'] = 'Number of coins awarded';
$string['privacy:metadata:courseid'] = 'The course where the badge was earned';
$string['privacy:metadata:timecreated'] = 'Time when the record was created';

$string['privacy:metadata:local_ascend_rewards_badgerlog'] = 'Audit log of badge awarding attempts';
$string['privacy:metadata:status'] = 'Status of the badge award (success/failure)';
$string['privacy:metadata:message'] = 'Message describing the badge award';
